;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                   PUTSTR.ASM                    
;                                                 
;                   Put String                    
;

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

CodeNum		equ	5

Main:		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		mov	ax, 0040h
		mov	es, ax
		mov	ax, es:[001Ch]
		mov	OrigBufTail, ax
		mov	si, 0081h
		cld
@01:		lodsb
		cmp	al, ' '
		je	@01
		cmp	al, 9
		je	@01
		cmp	al, '-'
		je	@02
		cmp	al, '/'
		jne	@03
@02:		lodsb
		call	UpCase
		cmp	al, '?'
		je	@04
		cmp	al, 'H'
		jne	@03
@04:		mov	dx, Offset Usage
		jmp	@06
@03:		cmp	al, 13
		je	@04
		mov	ah, ' '
		cmp	al, ''''
		je	@07
		cmp	al, '"'
		jne	@08
@07:		mov	ah, al
		lodsb
@08:		mov	QuoteMark, ah
		cli
@10:		xor	ah, ah
		cmp	al, QuoteMark
		je	@09
		cmp	al, '\'
		jne	@12
		lodsb
		cmp	al, 'x'
		je	@13
		cmp	al, '\'
		je	@12
		cmp	al, ''''
		je	@12
		cmp	al, '"'
		je	@12
		call	ReadCode
		jnc	@12
		mov	dx, Offset InvalidCode
		jmp	@06
@13:		call	ReadHexa
		jnc	@12
		mov	dx, Offset InvalidHexa
		jmp	@06
@12:		call	PutChar
		jc	@11
		lodsb
		cmp	al, 13
		jne	@10
@09:		mov	dx, Offset Successful
		mov	ah, 9
		int	21h
		jmp	@05
@11:		mov	dx, Offset BufferOverflow
@06:		mov	ah, 9
		int	21h
		mov	ax, OrigBufTail
		mov	es:[001Ch], ax
@05:		sti
		mov	ax, 4C00h
		int	21h

ReadCode:	call	UpCase
		mov	cx, CodeNum
		xor	bx, bx
@02_ReadCode:	cmp	al, CodeTable[bx]
		je	@01_ReadCode
		inc	bx
		loop	@02_ReadCode
		stc
		jc	@03_ReadCode
@01_ReadCode:	shl	bx, 1
		mov	ax, ScanTable[bx]
		clc
@03_ReadCode:	retn

ReadHexa:	xor	al, al
		call	@01_ReadHexa
		jc	@02_ReadHexa
		mov	cl, 4
		shl	al, cl
@01_ReadHexa:	mov	ah, [si]
		cmp	ah, 13
		je	@02_ReadHexa
		cmp	ah, QuoteMark
		je	@02_ReadHexa
		inc	si
		cmp	ah, 'a'
		jb	@03_ReadHexa
		sub	ah, 32
@03_ReadHexa:	sub	ah, '0' + 10
		add	ah, 10
		jc	@04_ReadHexa
		sub	ah, 7 + 16
		add	ah, 6
		cmc
		jc	@02_ReadHexa
		add	ah, 10
@04_ReadHexa:	or	al, ah
		clc
@02_ReadHexa:	retn

PutChar:	mov	bx, es:[001Ch]
		mov	cx, bx
		add	bx, 2
		cmp	bx, 003Eh
		jb	@02_PutChar
		mov	bx, 001Eh
@02_PutChar:	cmp	bx, es:[001Ah]
		stc
		je	@01_PutChar
		mov	es:[001Ch], bx
		mov	bx, cx
		mov	es:[bx], ax
		clc
@01_PutChar:	retn

UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

Hello		db	'Put String by Joe Forster/STA', 13, 10, 13, 10, '$'
Usage		db	'This program puts a string into the keyboard buffer. You can enter  hexadecimal', 13, 10
		db	'codes with ''\x##'' or use the following C-style codes:  ''\b''  (BackSpace),  ''\n''', 13, 10
		db	'''\n'' (Ctrl-Enter), ''\r'' (Enter), ''\s'' (Space), ''\t''  (Tab),  ''\\''  (BackSlash),', 13, 10
		db	'''\'''' (apostrophe) and ''\"'' (quotation mark).', 13, 10, '$'
BufferOverflow	db	'Keyboard buffer overflow', 13, 10, '$'
Successful	db	'String successfully written', 13, 10, '$'
InvalidHexa	db	'Invalid hexadecimal value', 13, 10, '$'
InvalidCode	db	'Invalid C-style code', 13, 10, '$'

CodeTable	db	'BNRST'
ScanTable	dw	0E08h, 1C0Ah, 1C0Dh, 3920h, 0F09h

QuoteMark	db	0
OrigBufTail	dw	0

CSeg		ends

		end	Main
