;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                     FOI.ASM                     
;                                                 
;            File Operation Interceptor           
;

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

RecordLen	equ	70
RecordNum	equ	256
ScreenBufLen	equ	80 * 2 * 2
TextColor	equ	7

Main:		jmp	Start

SaveRegs:	mov	cs:TempDS, ds
		push	cs
		pop	ds
		mov	TempES, es
		mov	TempSI, si
		mov	TempDI, di
		mov	TempBP, bp
		mov	TempAX, ax
		mov	TempBX, bx
		mov	TempCX, cx
		mov	TempDX, dx
		retn

LoadRegs:	mov	es, TempES
		mov	si, TempSI
		mov	di, TempDI
		mov	bp, TempBP
		mov	ax, TempAX
		mov	bx, TempBX
		mov	cx, TempCX
		mov	dx, TempDX
		mov	ds, TempDS
		retn

SaveScreen:	mov	ah, 0Fh
		int	10h
		mov	bx, 0B800h
		cmp	al, 7
		jne	@01_SaveScreen
		mov	bx, 0B000h
@01_SaveScreen:	mov	ScreenSeg, bx
		push	ds
		mov	ds, bx
		push	cs
		pop	es
		xor	si, si
		mov	di, Offset ScreenBuffer
		mov	cx, ScreenBufLen
		cld
		rep	movsb
		push	ds
		pop	es
		xor	di, di
		mov	ax, 20h + TextColor * 256
		mov	cx, ScreenBufLen / 2
		rep	stosw
		pop	ds
		retn

LoadScreen:	mov	es, ScreenSeg
		mov	si, Offset ScreenBuffer
		xor	di, di
		mov	cx, ScreenBufLen
		cld
		rep	movsb
		retn

ExecInt21:	mov	RunOldInt21, 0
		call	LoadRegs
		pushf
		call	cs:[OldInt21]
		pushf
		call	SaveRegs
		popf
		retn

MakeOffset:	mov	ax, Handle
		cmp	ax, RecordNum
		jb	@01_MakeOffset
		xor	ax, ax
@01_MakeOffset:	mov	bx, RecordLen
		mul	bx
		mov	bx, ax
		add	bx, Offset DataBuffer
		retn

SaveName:	call	MakeOffset
		push	ds
		mov	si, TempDX
		mov	ds, TempDS
		push	cs
		pop	es
		mov	di, bx
		add	di, 4
		call	CopyName
		pop	ds
		retn

PrintHex:	push	es
		push	cx
		mov	es, ScreenSeg
		shl	di, 1
		mov	cx, 4
		xchg	al, ah
		ror	al, cl
		ror	ah, cl
		cld
@02_PrintHex:	push	ax
		and	al, 0Fh
		add	al, '0'
		cmp	al, '9'
		jbe	@01_PrintHex
		add	al, 'A' - '0' - 10
@01_PrintHex:	mov	ah, 7
		stosw
		pop	ax
		shr	ax, 1
		shr	ax, 1
		shr	ax, 1
		shr	ax, 1
		loop	@02_PrintHex
		pop	cx
		pop	es
		retn

PrintStr:	push	es
		mov	es, ScreenSeg
		shl	di, 1
		mov	ah, TextColor
		cld
@02_PrintStr:	lodsb
		or	al, al
		je	@01_PrintStr
		stosw
		jmp	@02_PrintStr
@01_PrintStr:	pop	es
		retn

UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

CopyName:	push	bx
		push	cx
		push	dx
		push	di
		mov	dx, si
		xor	bx, bx
		mov	cx, 128
		cld
@04_CopyName:	lodsb
		or	al, al
		je	@03_CopyName
		inc	bx
		loop	@04_CopyName
@03_CopyName:	push	es
		push	cs
		pop	es
		mov	di, Offset ForgetExt
@06_CopyName:	push	di
		xor	al, al
		mov	cx, 128
		cld
		repne	scasb
		dec	di
		mov	cx, di
		pop	di
		sub	cx, di
		je	@05_CopyName
		push	di
		mov	si, dx
		add	si, bx
		sub	si, cx
		inc	cx
		push	cx
		cld
@08_CopyName:	lodsb
		call	UpCase
		cmp	al, es:[di]
		jne	@07_CopyName
		inc	di
		loop	@08_CopyName
		xor	al, al
@07_CopyName:	pop	cx
		pop	di
		pushf
		add	di, cx
		popf
		jne	@06_CopyName
		pop	es
		pop	di
		xor	al, al
		stosb
		jmp	@01_CopyName
@05_CopyName:	pop	es
		pop	di
		mov	si, dx
		mov	cx, 64
		cld
@02_CopyName:	lodsb
		call	UpCase
		stosb
		or	al, al
		je	@01_CopyName
		loop	@02_CopyName
@01_CopyName:	pop	dx
		pop	cx
		pop	bx
		retn

PrintCommand:	xor	di, di
		jmp	PrintStr

PrintName:	call	MakeOffset
		mov	si, bx
		add	si, 4
		mov	di, 80
		jmp	PrintStr

PrintNewOfs:	mov	si, Offset NewOfsStr
		mov	di, 60
		jmp	@01_PrintOfs

PrintOfs:	mov	si, Offset OffsetStr
		mov	di, 40
@01_PrintOfs:	push	di
		call	PrintStr
		call	MakeOffset
		mov	ax, [bx][2]
		pop	di
		add	di, 10
		push	di
		call	PrintHex
		mov	ax, [bx]
		pop	di
		add	di, 4
		call	PrintHex
		retn

CreateFunc:	mov	ax, TempCX
		mov	Mode, ax
		mov	si, Offset CreateStr
		jmp	@01_OpenFunc

OpenFunc:	mov	ax, TempAX
		xor	ah, ah
		mov	Mode, ax
		mov	si, Offset OpenStr
@01_OpenFunc:	call	PrintCommand
		call	ExecInt21
		jc	@02_OpenFunc
		pushf
		mov	ax, TempAX
		mov	Handle, ax
		mov	si, Offset ModeStr
		mov	di, 60
		call	PrintStr
		mov	ax, Mode
		mov	di, 70
		call	PrintHex
		call	MakeOffset
		xor	ax, ax
		mov	[bx], ax
		mov	[bx][2], ax
		call	SaveName
		call	PrintName
		popf
@02_OpenFunc:	retn

CloseFunc:	mov	si, Offset CloseStr
		call	PrintCommand
		call	PrintName
		call	MakeOffset
		push	cs
		pop	es
		mov	di, bx
		add	di, 4
		cmp	byte ptr es:[di], 0
		je	@01_CloseFunc
		mov	ForcePause, 1
@01_CloseFunc:	mov	byte ptr es:[di], 0
		clc
		retn

ReadFunc:	mov	si, Offset ReadStr
		jmp	XferFunc

WriteFunc:	mov	si, Offset WriteStr

XferFunc:	call	PrintCommand
		call	PrintOfs
		call	ExecInt21
		jc	@01_XferFunc
		pushf
		call	MakeOffset
		mov	si, Offset LengthStr
		mov	di, 20
		call	PrintStr
		mov	ax, TempAX
		mov	di, 30
		call	PrintHex
		mov	ax, TempAX
		add	[bx], ax
		adc	word ptr [bx][2], 0
		call	PrintNewOfs
		call	PrintName
		popf
@01_XferFunc:	retn

SeekFunc:	mov	si, Offset SeekStr
		call	PrintCommand
		call	PrintOfs
		call	ExecInt21
		jc	@01_SeekFunc
		pushf
		call	MakeOffset
		mov	ax, TempAX
		mov	[bx], ax
		mov	ax, TempDX
		mov	[bx][2], ax
		call	PrintNewOfs
		call	PrintName
		popf
@01_SeekFunc:	retn

PrintFunc:	mov	bx, TempBX
		mov	Handle, bx
		mov	ax, TempAX
		mov	Command, ah
		mov	RunOldInt21, 1
		mov	ForcePause, 0
		mov	si, Offset CreateFunc
		cmp	ah, 3Ch
		je	@01_PrintFunc
		mov	si, Offset OpenFunc
		cmp	ah, 3Dh
		je	@01_PrintFunc
		mov	si, Offset CloseFunc
		cmp	ah, 3Eh
		je	@01_PrintFunc
		mov	si, Offset ReadFunc
		cmp	ah, 3Fh
		je	@01_PrintFunc
		mov	si, Offset WriteFunc
		cmp	ah, 40h
		je	@01_PrintFunc
		mov	si, Offset SeekFunc
@01_PrintFunc:	call	si
		jc	@02_PrintFunc
		pushf
		cmp	Int21Active, 0
		je	@03_PrintFunc
		cmp	ForcePause, 0
		jne	@04_PrintFunc
		call	MakeOffset
		add	bx, 4
		cmp	byte ptr [bx], 0
		je	@03_PrintFunc
@04_PrintFunc:	xor	ah, ah
		int	16h
@03_PrintFunc:	popf
@02_PrintFunc:	retn

NewInt09:	push	ax
		push	ds
		mov	ax, 0040h
		mov	ds, ax
		mov	al, ds:[0017h]
		and	al, 0Ch
		cmp	al, 0Ch
		pop	ds
		jne	@01_NewInt09
		in	al, 60h
		xor	ah, ah
		cmp	al, 58h
		je	@02_NewInt09
		inc	ah
		cmp	al, 57h
		jne	@01_NewInt09
@02_NewInt09:	mov	cs:[Int21Active], ah
@01_NewInt09:	pop	ax
		jmp	cs:[OldInt09]

NewInt21:	cmp	ah, 42h
		je	@01_NewInt21
		cmp	ah, 3Ch
		jb	@02_NewInt21
		cmp	ah, 40h
		ja	@02_NewInt21
@01_NewInt21:	cmp	bx, 5
		jb	@02_NewInt21
		call	SaveRegs
		call	SaveScreen
		call	PrintFunc
		pushf
		call	LoadScreen
		call	LoadRegs
		cmp	cs:RunOldInt21, 0
		jne	@03_NewInt21
		popf
		retf	2
@03_NewInt21:	popf
@02_NewInt21:	jmp	cs:[OldInt21]

NewInt2F:	cmp	ax, 0
		jne	@01_NewInt2F
		cmp	bx, 'IN'
		jne	@01_NewInt2F
		cmp	cx, 'TC'
		jne	@01_NewInt2F
		mov	al, 0FFh
		mov	bx, cs
		mov	cx, 'OK'
		iret
@01_NewInt2F:	jmp	cs:OldInt2F

GoResident:	push	cs
		pop	es
		mov	di, Offset DataStart
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset ResidentEnd[1]
		int	27h

CreateStr	db	'Create:', 0
OpenStr		db	'Open:', 0
CloseStr	db	'Close:', 0
ReadStr		db	'Read:', 0
WriteStr	db	'Write:', 0
SeekStr		db	'Seek:', 0
ModeStr		db	'Mode:', 0
OffsetStr	db	'Offset:', 0
LengthStr	db	'Length:', 0
NewOfsStr	db	'NewOfs:', 0
ForgetExt	db	0

OldInt09	dd	0
OldInt21	dd	0
OldInt2F	dd	0

DataStart:

TempDS		dw	?
TempES		dw	?
TempSI		dw	?
TempDI		dw	?
TempBP		dw	?
TempAX		dw	?
TempBX		dw	?
TempCX		dw	?
TempDX		dw	?
Command		db	?
Handle		dw	?
Mode		dw	?
DataLength	dw	?
ScreenSeg	dw	?
Int21Active	db	?
RunOldInt21	db	?
ForcePause	db	?
ScreenBuffer	db	ScreenBufLen dup (?)
DataBuffer	db	RecordLen * RecordNum dup (?)

DataEnd:

ResidentEnd:

		org	DataStart

Hello		db	'File Operation Interceptor by Joe Forster/STA', 13, 10, 13, 10, '$'
BeginSentence	db	'Interceptor $'
CannotUninstall	db	'cannot be uninstalled - you''ve installed some programs after it.', 13, 10, '$'
Installed	db	'is installed.', 13, 10, '$'
Uninstalled	db	'is uninstalled.', 13, 10, '$'

WriteSentence:	push	dx
		mov	dx, Offset BeginSentence
		mov	ah, 9
		int	21h
		pop	dx
		mov	ah, 9
		int	21h
		retn

CheckInt:	push	es
		mov	ah, 35h
		int	21h
		mov	bx, es
		pop	es
		mov	dx, es
		cmp	dx, bx
		retn

Start:		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		xor	ax, ax
		mov	es, ax
		mov	bx, 'IN'
		mov	cx, 'TC'
		int	2Fh
		push	cs
		pop	ds
		cmp	cx, 'OK'
		jne	@02
		mov	es, bx
		mov	al, 09h
		call	CheckInt
		jne	@03
		mov	al, 21h
		call	CheckInt
		jne	@03
		mov	al, 2Fh
		call	CheckInt
		je	@04
@03:		mov	dx, Offset CannotUninstall
		jmp	@01
@04:		mov	dx, word ptr es:OldInt09[0]
		mov	ds, word ptr es:OldInt09[2]
		mov	ax, 2509h
		int	21h
		mov	dx, word ptr es:OldInt21[0]
		mov	ds, word ptr es:OldInt21[2]
		mov	ax, 2521h
		int	21h
		mov	dx, word ptr es:OldInt2F[0]
		mov	ds, word ptr es:OldInt2F[2]
		mov	ax, 252Fh
		int	21h
		mov	ah, 49h
		int	21h
		push	cs
		pop	ds
		mov	dx, Offset Uninstalled
		jmp	@01
@02:		mov	es, word ptr cs:[002Ch]
		mov	ah, 49h
		int	21h
		push	cs
		pop	ds
		mov	ax, 3509h
		int	21h
		mov	word ptr OldInt09[0], bx
		mov	word ptr OldInt09[2], es
		mov	ax, 3521h
		int	21h
		mov	word ptr OldInt21[0], bx
		mov	word ptr OldInt21[2], es
		mov	ax, 352Fh
		int	21h
		mov	word ptr OldInt2F[0], bx
		mov	word ptr OldInt2F[2], es
		mov	dx, Offset NewInt09
		mov	ax, 2509h
		int	21h
		mov	dx, Offset NewInt21
		mov	ax, 2521h
		int	21h
		mov	dx, Offset NewInt2F
		mov	ax, 252Fh
		int	21h
		mov	dx, Offset Installed
		call	WriteSentence
		mov	Int21Active, 1
		jmp 	GoResident
@01:		call	WriteSentence
		mov	ax, 4C00h
		int	21h

CSeg		ends

		end	Main
