// This program switches a VGA card back to color display when
// it initialized in monochrome mode. Useful for buggy VGA BIOSes,
// incompatible monitor plugs or when you forgot to plug in the 
// monitor once again.

// For Open Watcom 1.8.

#include <i86.h>
#include <string.h>

static char far* const control = (char far*) 0x487;
static char far* const options = (char far*) 0x489;

int main(int argc, const char** val) {
	union REGPACK regs;
	int cursor_pos;
	memset( &regs, 0, sizeof(union REGPACK) );

	// set color monitor dcc
	regs.w.ax=0x1a01;
	regs.h.bl=8;
	intr(0x10, &regs);

	// disable gray-scale summing
	regs.w.ax=0x1201;
	regs.h.bl=0x33;
	intr(0x10, &regs);

	// set color monitor in BDA
	*control &= ~2;
	*options &= ~4;

	// save cursor position
	regs.w.ax=0x300;
	regs.h.bh=0;
	intr(0x10, &regs);
	cursor_pos = regs.w.dx;

	// set video mode
	regs.w.ax=0x83;
	intr(0x10, &regs);

	// restore cursor position
	regs.w.ax=0x200;
	regs.h.bh=0;
	regs.w.dx = cursor_pos;
	intr(0x10, &regs);

	return 0;
}
