uses A2replay;

var
  f: File;
  temp: Word;
  buf: Pointer;

function keypressed: Boolean; assembler;
asm
        mov     ah,01h
        int     16h
        mov     al,TRUE
        jnz     @@1
        mov     al,FALSE
@@1:
end;

procedure delay(ms: Word); assembler;
asm
        mov     ax,1000
        mul     ms
        mov     cx,dx
        mov     dx,ax
        mov     ah,86h
        int     15h
end;

procedure terminate;
begin
  MEMW[0:$041c] := MEMW[0:$041a];
  WriteLn;
  FreeMem(buf,65535);
  HALT;
end;

begin
  GetMem(buf,65535);
  If (ParamCount = 0) then
    begin
      WriteLn('syntax: ',ParamStr(0),' a2t_module_name');
      terminate;
    end;

  Assign(f,ParamStr(1));
  Reset(f,1);
  BlockRead(f,buf^,65535,temp);
  Close(f);

  opl2port := $388; { OPL-2 port base address }
  start_playing(buf^,temp); { play buffer pointer is BUF^ }
                            { size of data is TEMP }

  If (error_code <> 0) then
    begin
      Case error_code of
        -1: WriteLn('Incorrect module data!');
        else
            WriteLn('XMS allocation error!');
      end;
      FreeMem(buf,65535);
      EXIT;
    end;

  WriteLn(' IRQ MODE');
  WriteLn('  Press ESC to quit,'+#13#10+
          '  any other key to continue in POLL MODE.');
  Repeat
    Write('Order ',current_order:3,', ',
          'Pattern ',current_pattern:2,', ',
          'Row ',current_line:2,#13);
  until keypressed;

  asm
        xor     ah,ah
        int     16h
        cmp     ax,011bh
        jnz     @@1
        call    terminate
  @@1:
  end;

  MEMW[0:$041c] := MEMW[0:$041a];
  WriteLn;

  irq_mode := FALSE; { disable IRQ mode -> POLL mode }
  WriteLn(' POLL MODE');
  WriteLn('  Press a key to quit.');

  Repeat
    Write('Order ',current_order:3,', ',
          'Pattern ',current_pattern:2,', ',
          'Row ',current_line:2,#13);
    delay(Round(1000/timer_freq)); { that's a shitty way to do timing }
    poll_proc; { execute polling proc }
  until keypressed;

  terminate;
end.
