{                             }
{ /DLiBR/CK3R  REPLAY ROUTiNE }
{                              }
{                                  }
{ Last updated: 11-24-2000; 2.0.27 }

{compiler directives}
{$A-,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,Y-}

(* This unit replays /DLiB TR/CK3R ][ tiny modules packed
   with SixPack algorithm (FFver 1) *)

unit A2replay;
interface

const
  opl2port: Word = $388;
  error_code: Integer = 0;
  current_order: Byte = 0;
  current_pattern: Byte = 0;
  current_line: Byte = 0;
  irq_mode: Boolean = FALSE;
  timer_freq: Byte = 50;
  tempo: Byte = 6;

procedure start_playing(var data; size: Word);
procedure poll_proc;
procedure stop_playing;

implementation
uses DOS;

type
  tADTRACK2_INS = Record
                    fm_data: array[0..10] of Byte;
                    misc: Byte;
                    pre_slide: Shortint;
                  end;
type
  tADTRACK2_EVENT = Record
                      note,
                      instr_def: Byte;
                      effect_def,
                      effect: Byte;
                    end;
type
  pFIXED_SONGDATA = ^tFIXED_SONGDATA;
  tFIXED_SONGDATA = Record
                      instr_table: array[1..250] of tADTRACK2_INS;
                      pattern_order: array[0..$7f] of Byte;
                      timer_freq: Byte;
                      tempo: Byte;
                      reserved: array[0..999] of Byte;
                    end;
type
  tPLAY_STATUS = (isPlaying,isPaused,isStopped);

type
  pVARIABLE_DATA = ^tVARIABLE_DATA;
  tVARIABLE_DATA = array[0..$0f] of
                   array[0..$3f] of array[1..9] of tADTRACK2_EVENT;
type
  pDUMMY_BUFF = ^tDUMMY_BUFF;
  tDUMMY_BUFF = array[0..MaxInt*SizeOf(WORD)] of Byte;

type
  tXMS_MOVE_STRUCTURE = Record
                          size: Longint;
                          handle1: Word;
                          offset1: Longint;
                          handle2: Word;
                          offset2: Longint;
                        end;
const
  _instr: array[0..11] of Byte = ($20,$20,$40,$40,$60,$60,
                                  $80,$80,$e0,$e0,$c0,$bd);

  _chan_m: array[1..9] of Byte = ($00,$01,$02,$08,$09,$0a,$10,$11,$12);
  _chan_c: array[1..9] of Byte = ($03,$04,$05,$0b,$0c,$0d,$13,$14,$15);

const
  ef_Arpeggio          = $00;
  ef_FSlideUp          = $01;
  ef_FSlideDown        = $02;
  ef_FSlideUpFine      = $03;
  ef_FSlideDownFine    = $04;
  ef_TonePortamento    = $05;
  ef_TPortamVolSlide   = $06;
  ef_Vibrato           = $07;
  ef_VibratoVolSlide   = $08;
  ef_SetOpIntensity    = $09;
  ef_SetInsVolume      = $0a;
  ef_PatternBreak      = $0b;
  ef_PatternJump       = $0c;
  ef_SetTempo          = $0d;
  ef_SetTimer          = $0e;
  ef_Extended          = $0f;
  ef_ex_DefAMdepth     = $00;
  ef_ex_DefVibDepth    = $01;
  ef_ex_DefWaveform    = $02;
  ef_ex_ManSlideUp     = $03;
  ef_ex_ManSlideDown   = $04;
  ef_ex_VSlideUp       = $05;
  ef_ex_VSlideDown     = $06;
  ef_ex_VSlideUpFine   = $07;
  ef_ex_VSlideDownFine = $08;
  ef_ex_RetrigNote     = $09;
  ef_ex_SetAttckRate   = $0a;
  ef_ex_SetDecayRate   = $0b;
  ef_ex_SetSustnLevel  = $0c;
  ef_ex_SetReleaseRate = $0d;
  ef_ex_SetFeedback    = $0e;
  ef_ex_ExtendedCmd    = $0f;

const
  NULL = $0ff;

const
  irq_freq: Byte = 50;
  irq_initialized: Boolean = FALSE;
  pattern_break: Boolean = FALSE;
  next_line: Byte = 0;
  play_status: tPLAY_STATUS = isStopped;

var
  event_table:   array[1..9] of tADTRACK2_EVENT;
  voice_table:   array[1..9] of Byte;
  adsr_carrier:  array[1..9] of Boolean;
  adsr_tab_car:  array[1..9] of Record attck,dec,sustn,rel: Byte; end;
  adsr_tab_mod:  array[1..9] of Record attck,dec,sustn,rel: Byte; end;
  volume_lock:   array[1..9] of Boolean;
  volume_table:  array[1..9] of Word;
  kscale_table:  array[1..9] of Word;
  peak_lock:     array[1..9] of Boolean;
  freq_table:    array[1..9] of Word;
  effect_table:  array[1..9] of Word;
  porta_table:   array[1..9] of Record freq: Word; speed: Byte; end;
  arpgg_table:   array[1..9] of Record state,note: Byte; end;
  vibr_table:    array[1..9] of Record pos,speed,depth: Byte; end;
  retrig_table:  array[1..9] of Byte;
  last_effect:   array[1..9] of Word;
  volslide_type: array[1..9] of Byte;

var
  XMS_control: Pointer;
  XMS_error: Byte;

var
  pattdata: array[0..3] of Word;
  songdata: pFIXED_SONGDATA;
  current_block: Byte;
  hash_buffer: pVARIABLE_DATA;
  hash_struct: tXMS_MOVE_STRUCTURE;
  CRC32_table: array[Byte] of Longint;

var
  oldint08: procedure;
  ticks: Longint;
  tick0: Longint;

function nul_data(var data; size: Word): Boolean; assembler;
asm
        push    ds
        lds     si,data
        mov     cx,size
        cld
@@1:    lodsb
        cmp     al,0
        jnz     @@2
        loop    @@1
        mov     al,TRUE
        jmp     @@3
@@2:    mov     al,FALSE
@@3:    pop     ds
end;

procedure opl2out(data: Word); assembler;
asm
        mov     ax,data
        mov     dx,word ptr [opl2port]
        out     dx,al
        mov     cx,6
@@1:    in      al,dx
        loop    @@1
        inc     dl
        mov     al,ah
        out     dx,al
        dec     dl
        mov     cx,24
@@2:    in      al,dx
        loop    @@2
end;

function nFreq(note: Byte): Word; assembler;
asm
        mov     al,note
        xor     ah,ah
        cmp     ax,12*8
        jae     @@1
        push    ax
        mov     bl,12
        div     bl
        mov     bl,ah
        xor     bh,bh
        shl     bx,1
        pop     ax
        mov     cl,12
        div     cl
        xor     ah,ah
        shl     ax,10
        add     ax,word ptr [@Fnum+bx]
        jmp     @@2
@@1:    mov     ax,$1ed9
        jmp     @@2

@Fnum:  dw  $156,$16b,$181,$198,$1b0,$1ca,$1e5
        dw  $202,$220,$241,$263,$287,$2ae
@@2:
end;

const
  FreqStart = $156;
  FreqEnd   = $2ae;
  FreqRange = FreqEnd-FreqStart;

function calc_freq_shift_up(freq,shift: Word): Word; assembler;
asm
        mov     cx,freq
        mov     ax,shift
        mov     dx,cx
        mov     di,cx
        and     dx,0011110000000000b
        and     cx,$3ff
        add     cx,ax
        cmp     cx,FreqEnd
        jl      @@3
        mov     ax,di
@@1:    and     ax,0001110000000000b
        cmp     ax,0001110000000000b
        jne     @@2
        mov     cx,di
        jmp     @@3
@@2:    sar     cx,1
        add     ax,0000010000000000b
        and     di,0010000000000000b
        or      ax,di
        mov     dx,ax
        cmp     cx,FreqEnd
        jg      @@1
@@3:    or      cx,dx
        mov     ax,cx
end;

function calc_freq_shift_down(freq,shift: Word): Word; assembler;
asm
        mov     cx,freq
        mov     ax,shift
        mov     dx,cx
        mov     di,cx
        and     dx,0011110000000000b
        and     cx,$3ff
        sub     cx,ax
        cmp     cx,FreqStart
        jg      @@3
        mov     ax,di
@@1:    and     ax,0001110000000000b
        cmp     ax,0
        jne     @@2
        mov     cx,di
        jmp     @@3
@@2:    sal     cx,1
        sar     ah,2
        dec     ah
        sal     ah,2
        and     di,0010000000000000b
        or      ax,di
        mov     dx,ax
        cmp     cx,FreqStart
        jl      @@1
@@3:    or      cx,dx
        mov     ax,cx
end;

function calc_vibrato_shift(depth,position: Byte;
                             var direction: Byte): Word; assembler;
asm
       mov     al,depth
       xor     ah,ah
       mov     bl,position
       xor     bh,bh
       mov     dh,bl
       and     bx,1fh
       mov     dl,byte ptr [@vibr+bx]
       mul     dl
       rol     ax,1
       xchg    ah,al
       and     ah,1
       les     bx,direction
       mov     cl,1
       mov     es:[bx],cl
       test    dh,32
       jne     @@1
       mov     cl,0
       mov     es:[bx],cl
       jmp     @@1

@vibr: db 0,24,49,74,97,120,141,161,180,197,212,224,235,244,250,253,255
       db 253,250,244,235,224,212,197,180,161,141,120,97,74,49,24
@@1:
end;

procedure change_frequency(chan: Byte; freq: Word); assembler;
asm
        mov     bl,chan
        dec     bl
        xor     bh,bh
        shl     bx,1
        mov     ax,freq
        and     ax,1fffh
        mov     cx,word ptr [freq_table+bx]
        and     cx,NOT 1fffh
        add     ax,cx
        mov     word ptr [freq_table+bx],ax
        mov     bl,chan
        dec     bl
        xor     bh,bh
        add     bx,0a0h
        mov     ch,al
        xor     cl,cl
        add     bx,cx
        push    bx
        mov     bl,chan
        dec     bl
        xor     bh,bh
        add     bx,0b0h
        mov     ch,ah
        xor     cl,cl
        add     bx,cx
        push    bx
        call    opl2out
        call    opl2out
end;

function ins_parameter(ins,param: Byte): Byte; assembler;
asm
        push    es
        les     bx,songdata
        mov     cl,ins
        dec     cl
        mov     al,13
        mul     cl
        add     bx,ax
        add     bx,WORD(param)
        mov     al,es:[bx]
        pop     es
end;

function _word(Lo,Hi: Byte): Word; assembler;
asm
        mov     al,Lo
        mov     ah,Hi
end;

procedure set_clock_rate(clock_rate: Word); assembler;
asm
        cmp     irq_mode,FALSE
        jz      @@1
        mov     al,36h
        out     43h,al
        mov     ax,clock_rate
        out     40h,al
        mov     al,ah
        out     40h,al
@@1:
end;

procedure update_timer(Hz: Byte);
begin
  If (Hz = 0) then begin set_clock_rate(0); EXIT end
  else timer_freq := Hz;
  If (timer_freq >= 32) then irq_freq := timer_freq
  else If (timer_freq >= 8) then irq_freq := timer_freq*4
       else irq_freq := timer_freq*32;
  set_clock_rate(1193180 DIV irq_freq);
end;

procedure key_off(chan: Byte);
begin
  freq_table[chan] := LO(freq_table[chan])+
                     (HI(freq_table[chan]) AND NOT $20) SHL 8;
  change_frequency(chan,freq_table[chan]);
  event_table[chan].note := event_table[chan].note OR $80;
end;

procedure release_sustaining_sound(chan: Byte);
begin
  FillChar(adsr_tab_car[chan],SizeOf(adsr_tab_car[chan]),$0f);
  FillChar(adsr_tab_mod[chan],SizeOf(adsr_tab_mod[chan]),$0f);
  opl2out($0b0+PRED(chan));
  opl2out(_instr[04]+_chan_m[chan]+$0ff00);
  opl2out(_instr[05]+_chan_c[chan]+$0ff00);
  opl2out(_instr[06]+_chan_m[chan]+$0ff00);
  opl2out(_instr[07]+_chan_c[chan]+$0ff00);
  key_off(chan);
  event_table[chan].instr_def := NULL;
end;

procedure set_ins_volume(modulator,carrier,chan: Byte);
begin
  If (modulator <> NULL) then
    begin
      opl2out(_word(_instr[02]+_chan_m[chan],
                    modulator+LO(kscale_table[chan])));
      volume_table[chan] := _word(modulator,HI(volume_table[chan]));
    end;

  If (carrier <> NULL) then
    begin
      opl2out(_word(_instr[03]+_chan_c[chan],
                    carrier+HI(kscale_table[chan])));
      volume_table[chan] := _word(LO(volume_table[chan]),carrier);
    end;
end;

procedure set_ins_data(ins,chan: Byte);

var
  cLo,cHi,cNm: Byte;
  old_ins: Byte;

begin
  If (ins <> event_table[chan].instr_def) then
    begin
      cLo := _chan_m[chan];
      cHi := _chan_c[chan];
      cNm := PRED(chan);

      opl2out(_word(_instr[00]+cLo,ins_parameter(ins,0)));
      opl2out(_word(_instr[01]+cHi,ins_parameter(ins,1)));
      opl2out(_word(_instr[04]+cLo,ins_parameter(ins,4)));
      opl2out(_word(_instr[05]+cHi,ins_parameter(ins,5)));
      opl2out(_word(_instr[06]+cLo,ins_parameter(ins,6)));
      opl2out(_word(_instr[07]+cHi,ins_parameter(ins,7)));
      opl2out(_word(_instr[08]+cLo,ins_parameter(ins,8)));
      opl2out(_word(_instr[09]+cHi,ins_parameter(ins,9)));
      opl2out(_word(_instr[10]+cNm,ins_parameter(ins,10)));

      adsr_tab_car[chan].attck := ins_parameter(ins,5) SHR 4;
      adsr_tab_mod[chan].attck := ins_parameter(ins,4) SHR 4;
      adsr_tab_car[chan].dec   := ins_parameter(ins,5) AND $0f;
      adsr_tab_mod[chan].dec   := ins_parameter(ins,4) AND $0f;
      adsr_tab_car[chan].sustn := ins_parameter(ins,7) SHR 4;
      adsr_tab_mod[chan].sustn := ins_parameter(ins,6) SHR 4;
      adsr_tab_car[chan].rel   := ins_parameter(ins,7) AND $0f;
      adsr_tab_mod[chan].rel   := ins_parameter(ins,6) AND $0f;
    end;

  kscale_table[chan] := _word(ins_parameter(ins,2) AND $c0,
                              ins_parameter(ins,3) AND $c0);
  voice_table[chan] := ins;
  old_ins := event_table[chan].instr_def;
  event_table[chan].instr_def := ins;

  If NOT volume_lock[chan] or (ins <> old_ins) then
    set_ins_volume(ins_parameter(ins,2) AND $3f,
                   ins_parameter(ins,3) AND $3f,chan);
end;

procedure update_adsr(chan: Byte);
begin
  If adsr_carrier[chan] then opl2out(_word(_instr[05]+_chan_c[chan],
                                           adsr_tab_car[chan].attck SHL 4+
                                           adsr_tab_car[chan].dec))
  else opl2out(_word(_instr[04]+_chan_m[chan],
                     adsr_tab_mod[chan].attck SHL 4+
                     adsr_tab_mod[chan].dec));

  If adsr_carrier[chan] then opl2out(_word(_instr[07]+_chan_c[chan],
                                           adsr_tab_car[chan].sustn SHL 4+
                                           adsr_tab_car[chan].rel))
  else opl2out(_word(_instr[06]+_chan_m[chan],
                     adsr_tab_mod[chan].sustn SHL 4+
                     adsr_tab_mod[chan].rel));
end;

procedure output_note(note,ins,chan: Byte; slide: Shortint);

var
  freq: Word;

begin
  If (note = 0) and (slide = 0) then EXIT;
  If NOT (note in [1..12*8+1]) then freq := freq_table[chan]
  else begin
         freq := nFreq(note-1)+SHORTINT(ins_parameter(ins,12));
         opl2out($0b0+PRED(chan));
         freq_table[chan] := _word(LO(freq_table[chan]),
                                   HI(freq_table[chan]) OR $20);
       end;

  freq := freq+slide;
  change_frequency(chan,freq);
  If (note <> 0) then event_table[chan].note := note;
end;

procedure read_patterns(block: Byte); forward;
procedure play_line;

var
  chan: Byte;
  fslide: Shortint;
  temp: Word;
  event: tADTRACK2_EVENT;
  eLo,eHi: Byte;

begin
  For chan := 1 to 9 do
    begin
      read_patterns(current_pattern DIV 16);
      event := hash_buffer^[current_pattern MOD 16][current_line][chan];
      If (effect_table[chan] <> 0) then last_effect[chan] := effect_table[chan];
      effect_table[chan] := effect_table[chan] AND $0ff00;
      fslide := 0;

      If (event.note = NULL) then
        event.note := event_table[chan].note OR $80;

      If (event.note <> 0) or
         (event.instr_def <> 0) then
        begin
          event_table[chan].effect_def := event.effect_def;
          event_table[chan].effect := event.effect;
        end;

      If (event.instr_def <> 0) and
         NOT nul_data(songdata^.instr_table[event.instr_def],
                      SizeOf(songdata^.instr_table[event.instr_def])) then
        set_ins_data(event.instr_def,chan);

      If NOT (event.effect_def in [ef_Vibrato,ef_VibratoVolSlide]) then
        FillChar(vibr_table[chan],SizeOf(vibr_table[chan]),0);

      eLo := LO(last_effect[chan]);
      eHi := HI(last_effect[chan]);

      If (eLo <> ef_Arpeggio) and
         (arpgg_table[chan].state <> 1) then
        begin
          arpgg_table[chan].state := 1;
          change_frequency(chan,nFreq(arpgg_table[chan].note-1)+
            SHORTINT(ins_parameter(event_table[chan].instr_def,12)));
        end;

      Case event.effect_def of
        ef_Arpeggio:
          If (event.effect <> 0) then
            begin
              effect_table[chan] := _word(ef_Arpeggio+$10,event.effect);
              If (event.note AND $7f in [1..12*8+1]) then
                begin
                  arpgg_table[chan].state := 0;
                  arpgg_table[chan].note := event.note AND $7f;
                end
              else If (event.note = 0) and
                      (event_table[chan].note AND $7f in [1..12*8+1]) then
                     begin
                       arpgg_table[chan].state := 0;
                       arpgg_table[chan].note := event_table[chan].note AND $7f;
                     end
                   else effect_table[chan] := 0;
            end;

        ef_FSlideUp:
          effect_table[chan] := _word(ef_FSlideUp,event.effect);

        ef_FSlideDown:
          effect_table[chan] := _word(ef_FSlideDown,event.effect);

        ef_FSlideUpFine:
          effect_table[chan] := _word(ef_FSlideUpFine,event.effect);

        ef_FSlideDownFine:
          effect_table[chan] := _word(ef_FSlideDownFine,event.effect);

        ef_TonePortamento:
          If (event.note in [1..12*8+1]) then
            begin
              If (event.effect <> 0) then
                effect_table[chan] := _word(ef_TonePortamento,event.effect)
              else If (eLo = ef_TonePortamento) and
                      (eHi <> 0) then
                     effect_table[chan] := _word(ef_TonePortamento,eHi)
                   else effect_table[chan] := ef_TonePortamento;

              porta_table[chan].speed := HI(effect_table[chan]);
              porta_table[chan].freq := nFreq(event.note-1)+
                SHORTINT(ins_parameter(event_table[chan].instr_def,12));
            end
          else If (eLo = ef_TonePortamento) then
                 begin
                   If (event.effect <> 0) then
                     effect_table[chan] := _word(ef_TonePortamento,event.effect)
                   else If (eLo = ef_TonePortamento) and
                           (eHi <> 0) then
                          effect_table[chan] := _word(ef_TonePortamento,eHi)
                        else effect_table[chan] := ef_TonePortamento;
                   porta_table[chan].speed := HI(effect_table[chan]);
                 end;

        ef_TPortamVolSlide:
          If (event.effect <> 0) then
            effect_table[chan] := _word(ef_TPortamVolSlide,event.effect)
          else If (eLo = ef_TPortamVolSlide) and
                  (eHi <> 0) then
                 effect_table[chan] := _word(ef_TPortamVolSlide,eHi)
               else effect_table[chan] := effect_table[chan] AND $0ff00;

        ef_Vibrato:
          begin
            If (event.effect <> 0) then
              effect_table[chan] := _word(ef_Vibrato,event.effect)
            else If (eLo = ef_Vibrato) and
                    (eHi <> 0) then
                   effect_table[chan] := _word(ef_Vibrato,eHi)
                 else effect_table[chan] := ef_Vibrato;

            vibr_table[chan].speed := HI(effect_table[chan]) DIV 16;
            vibr_table[chan].depth := HI(effect_table[chan]) MOD 16;
          end;

        ef_VibratoVolSlide:
          If (event.effect <> 0) then
            effect_table[chan] := _word(ef_VibratoVolSlide,event.effect)
          else If (eLo = ef_VibratoVolSlide) and
                  (HI(effect_table[chan]) <> 0) then
                 effect_table[chan] := _word(ef_VibratoVolSlide,HI(effect_table[chan]))
               else effect_table[chan] := effect_table[chan] AND $0ff00;

        ef_SetOpIntensity:
          begin
            If (event.effect DIV 16 > 0) then
              set_ins_volume(NULL,(15-event.effect DIV 16)*4,chan)
            else If (event.effect MOD 16 > 0) then
                   set_ins_volume((15-event.effect MOD 16)*4,NULL,chan);
          end;

        ef_SetInsVolume:
          If (ins_parameter(voice_table[chan],10) AND 1 = 0) then
            set_ins_volume(NULL,63-event.effect,chan)
          else set_ins_volume(63-event.effect,63-event.effect,chan);

        ef_PatternJump:
          begin
            pattern_break := TRUE;
            next_line := $0f0+chan;
          end;

        ef_PatternBreak:
          begin
            pattern_break := TRUE;
            next_line := event.effect;
          end;

        ef_SetTempo:
          tempo := event.effect;

        ef_SetTimer:
          update_timer(event.effect);

        ef_Extended:
          Case (event.effect DIV 16) of
            ef_ex_DefAMdepth:
              Case (event.effect MOD 16) of
                0: opl2out(_word(_instr[11]+PRED(chan),ins_parameter(
                           event_table[chan].instr_def,11) AND $7f));
                1: opl2out(_word(_instr[11]+PRED(chan),$80+ins_parameter(
                           event_table[chan].instr_def,11) AND $7f));
              end;

            ef_ex_DefVibDepth:
              Case (event.effect MOD 16) of
                0: opl2out(_word(_instr[11]+PRED(chan),ins_parameter(
                           event_table[chan].instr_def,11) AND $bf));
                1: opl2out(_word(_instr[11]+PRED(chan),$40+ins_parameter(
                           event_table[chan].instr_def,11) AND $bf));
              end;

            ef_ex_DefWaveform:
              Case event.effect MOD 16 of
                0..3: opl2out(_word(_instr[09]+_chan_c[chan],
                              event.effect MOD 16));
                4..7: opl2out(_word(_instr[08]+_chan_m[chan],
                              event.effect MOD 16));
              end;

            ef_ex_VSlideUp:
              effect_table[chan] := _word(ef_Extended+ef_ex_VSlideUp,
                                          event.effect MOD 16);
            ef_ex_VSlideDown:
              effect_table[chan] := _word(ef_Extended+ef_ex_VSlideDown,
                                          event.effect MOD 16);
            ef_ex_VSlideUpFine:
              effect_table[chan] := _word(ef_Extended+ef_ex_VSlideUpFine,
                                          event.effect MOD 16);
            ef_ex_VSlideDownFine:
              effect_table[chan] := _word(ef_Extended+ef_ex_VSlideDownFine,
                                          event.effect MOD 16);
            ef_ex_ManSlideUp:
              fslide := +(event.effect MOD 16);

            ef_ex_ManSlideDown:
              fslide := -(event.effect MOD 16);

            ef_ex_RetrigNote:
              begin
                retrig_table[chan] := 0;
                effect_table[chan] := _word(ef_Extended+ef_ex_RetrigNote,
                                            event.effect MOD 16);
              end;

            ef_ex_SetAttckRate:
              begin
                If adsr_carrier[chan] then adsr_tab_car[chan].attck := event.effect MOD 16
                else adsr_tab_mod[chan].attck := event.effect MOD 16;
                update_adsr(chan);
              end;

            ef_ex_SetDecayRate:
              begin
                If adsr_carrier[chan] then adsr_tab_car[chan].dec := event.effect MOD 16
                else adsr_tab_mod[chan].dec := event.effect MOD 16;
                update_adsr(chan);
              end;

            ef_ex_SetSustnLevel:
              begin
                If adsr_carrier[chan] then adsr_tab_car[chan].sustn := event.effect MOD 16
                else adsr_tab_mod[chan].sustn := event.effect MOD 16;
                update_adsr(chan);
              end;

            ef_ex_SetReleaseRate:
              begin
                If adsr_carrier[chan] then adsr_tab_car[chan].rel := event.effect MOD 16
                else adsr_tab_mod[chan].rel := event.effect MOD 16;
                update_adsr(chan);
              end;

            ef_ex_SetFeedback:
              opl2out(_word(_instr[10]+PRED(chan),
                            event.effect MOD 16 SHL 1+
                            ins_parameter(event_table[chan].instr_def,10) AND 1));

            ef_ex_ExtendedCmd:
              Case (event.effect MOD 16) of
                0: release_sustaining_sound(chan);
                1: volume_lock[chan]   := TRUE;
                2: volume_lock[chan]   := FALSE;
                3: peak_lock[chan]     := TRUE;
                4: peak_lock[chan]     := FALSE;
                5: adsr_carrier[chan]  := TRUE;
                6: adsr_carrier[chan]  := FALSE;
                7: volslide_type[chan] := 1;
                8: volslide_type[chan] := 2;
                9: volslide_type[chan] := 0;
              end;
          end;
      end;

      If (event.effect_def+event.effect = 0) then effect_table[chan] := 0
      else begin
             event_table[chan].effect_def := event.effect_def;
             event_table[chan].effect := event.effect;
           end;

      If (event.note = event.note OR $80) then key_off(chan)
      else If (LO(effect_table[chan]) <> ef_TonePortamento) then
             output_note(event.note,voice_table[chan],chan,fslide)
          else If (event.note <> 0) then
                 event_table[chan].note := event.note;
    end;
end;

procedure portamento_up(chan,slide: Byte; limit: Word);

var
  freq: Word;

begin
  freq := calc_freq_shift_up(freq_table[chan] AND $1fff,slide);
  If (freq <= limit) then change_frequency(chan,freq)
  else change_frequency(chan,limit);
end;

procedure portamento_down(chan,slide: Byte; limit: Word);

var
  freq: Word;

begin
  freq := calc_freq_shift_down(freq_table[chan] AND $1fff,slide);
  If (freq >= limit) then change_frequency(chan,freq)
  else change_frequency(chan,limit);
end;

procedure tone_portamento(chan: Byte);
begin
  If (freq_table[chan] AND $1fff > porta_table[chan].freq) then
    portamento_down(chan,porta_table[chan].speed,porta_table[chan].freq)
  else If (freq_table[chan] AND $1fff < porta_table[chan].freq) then
         portamento_up(chan,porta_table[chan].speed,porta_table[chan].freq);
end;

procedure slide_volume_up(chan,slide: Byte);

var
  temp: Word;
  limit1,limit2,vLo,vHi: Byte;

procedure slide_carrier_volume_up;
begin
  vLo := LO(temp);
  vHi := HI(temp);
  If (vHi-slide >= limit1) then temp := _word(vLo,vHi-slide)
  else temp := _word(vLo,limit1);
  set_ins_volume(NULL,HI(temp),chan);
  volume_table[chan] := temp;
end;

procedure slide_modulator_volume_up;
begin
  vLo := LO(temp);
  vHi := HI(temp);
  If (vLo-slide >= limit2) then temp := _word(vLo-slide,vHi)
  else temp := _word(limit2,vHi);
  set_ins_volume(LO(temp),NULL,chan);
  volume_table[chan] := temp;
end;

begin
  If NOT peak_lock[chan] then limit1 := 0
  else limit1 := ins_parameter(event_table[chan].instr_def,3) AND $3f;

  If NOT peak_lock[chan] then limit2 := 0
  else limit2 := ins_parameter(event_table[chan].instr_def,2) AND $3f;
  temp := volume_table[chan];

  Case volslide_type[chan] of
    0: begin
         slide_carrier_volume_up;
         If (ins_parameter(voice_table[chan],10) AND 1 = 1) then
           slide_modulator_volume_up;
       end;
    1: slide_carrier_volume_up;
    2: slide_modulator_volume_up;
  end;
end;

procedure slide_volume_down(chan,slide: Byte);

var
  temp: Word;
  vLo,vHi: Byte;

procedure slide_carrier_volume_down;
begin
  vLo := LO(temp);
  vHi := HI(temp);
  If (vHi+slide <= 63) then temp := _word(vLo,vHi+slide)
  else temp := _word(vLo,63);
  set_ins_volume(NULL,HI(temp),chan);
  volume_table[chan] := temp;
end;

procedure slide_modulator_volume_down;
begin
  vLo := LO(temp);
  vHi := HI(temp);
  If (vLo+slide <= 63) then temp := _word(vLo+slide,vHi)
  else temp := _word(63,vHi);
  set_ins_volume(LO(temp),NULL,chan);
  volume_table[chan] := temp;
end;

begin
  temp := volume_table[chan];
  Case volslide_type[chan] of
    0: begin
         slide_carrier_volume_down;
         If (ins_parameter(voice_table[chan],10) AND 1 = 1) then
           slide_modulator_volume_down;
       end;
    1: slide_carrier_volume_down;
    2: slide_modulator_volume_down;
  end;
end;

procedure volume_slide(chan,up_speed,down_speed: Byte);
begin
  If (up_speed <> 0) then
    slide_volume_up(chan,HI(effect_table[chan]) DIV 16)
  else If (down_speed <> 0) then
         slide_volume_down(chan,HI(effect_table[chan]) MOD 16);
end;

procedure vibrato(chan: Byte);

var
  freq,old_freq: Word;
  direction: Byte;

begin
  Inc(vibr_table[chan].pos,vibr_table[chan].speed);
  freq := calc_vibrato_shift(vibr_table[chan].depth,
                             vibr_table[chan].pos,direction);
  old_freq := freq_table[chan];
  If (direction = 0) then portamento_down(chan,freq,nFreq(0))
  else portamento_up(chan,freq,nFreq(12*8+1));
  freq_table[chan] := old_freq;
end;

procedure update_effects;

const
  arpgg_state: array[0..2] of Byte = (1,2,0);

var
  chan,eLo,eHi: Byte;
  freq: Word;

begin
  For chan := 1 to 9 do
    begin
      eLo := LO(effect_table[chan]);
      eHi := HI(effect_table[chan]);

      Case eLo of
        ef_Arpeggio+$10:
          begin
            Case arpgg_table[chan].state of
              0: freq := nFreq(arpgg_table[chan].note-1);
              1: freq := nFreq(arpgg_table[chan].note-1 +eHi DIV 16);
              2: freq := nFreq(arpgg_table[chan].note-1 +eHi MOD 16);
            end;

            arpgg_table[chan].state := arpgg_state[arpgg_table[chan].state];
            change_frequency(chan,freq+
              SHORTINT(ins_parameter(event_table[chan].instr_def,12)));
          end;

        ef_FSlideUp:
          portamento_up(chan,eHi,nFreq(12*8+1));

        ef_FSlideDown:
          portamento_down(chan,eHi,nFreq(0));

        ef_FSlideUpFine:
          If (ticks-tick0+1 >= tempo) then
            portamento_up(chan,eHi,nFreq(12*8+1));

        ef_FSlideDownFine:
          If (ticks-tick0+1 >= tempo) then
            portamento_down(chan,eHi,nFreq(0));

        ef_TonePortamento:
          tone_portamento(chan);

        ef_TPortamVolSlide:
          begin
            volume_slide(chan,eHi DIV 16,eHi MOD 16);
            tone_portamento(chan);
          end;

        ef_Vibrato:
          vibrato(chan);

        ef_VibratoVolSlide:
          begin
            volume_slide(chan,eHi DIV 16,eHi MOD 16);
            vibrato(chan);
          end;

        ef_Extended+
        ef_ex_VSlideUp:
          slide_volume_up(chan,eHi);

        ef_Extended+
        ef_ex_VSlideDown:
          slide_volume_down(chan,eHi);

        ef_Extended+
        ef_ex_VSlideUpFine:
          If (ticks-tick0+1 >= tempo) then slide_volume_up(chan,eHi);

        ef_Extended+
        ef_ex_VSlideDownFine:
          If (ticks-tick0+1 >= tempo) then slide_volume_down(chan,eHi);

        ef_Extended+
        ef_ex_RetrigNote:
          If (retrig_table[chan] >= eHi) then
            begin
              retrig_table[chan] := 0;
              output_note(event_table[chan].note,
                          event_table[chan].instr_def,chan,0);
            end
          else Inc(retrig_table[chan]);
      end;
    end;
end;

function calc_order_jump: Integer;

var
  temp: Byte;
  result: Integer;

begin
  result := 0; temp := 0;

  Repeat
    Inc(temp);
    If (songdata^.pattern_order[current_order] > $7f) then
      current_order := songdata^.pattern_order[current_order] -$80;
  until (temp > $7f) or (songdata^.pattern_order[current_order] < $80);

  If (temp > $7f) then begin stop_playing; result := -1; end;
  calc_order_jump := result;
end;

procedure update_song_position;
begin
  If (current_line < $3f) and NOT pattern_break then Inc(current_line)
  else begin
         If (current_order < $7f) then
           Inc(current_order);

         If pattern_break and (next_line > $0f0) then
           begin
             current_order := event_table[next_line-$0f0].effect;
             pattern_break := FALSE;
           end
         else If (current_order >= $7f) then
                current_order := 0;

         If (songdata^.pattern_order[current_order] > $7f) then
           If (calc_order_jump = -1) then EXIT;

         current_pattern := songdata^.pattern_order[current_order];
         If NOT pattern_break then current_line := 0
         else begin
                pattern_break := FALSE;
                current_line := next_line;
              end;
       end;
end;

procedure poll_proc;
begin
  If (ticks-tick0+1 >= tempo) then
    begin
      If (songdata^.pattern_order[current_order] > $7f) then
        If (calc_order_jump = -1) then EXIT;

      current_pattern := songdata^.pattern_order[current_order];
      play_line;
      update_effects;
      update_song_position;
      tick0 := ticks;
    end
  else
    begin
      update_effects;
      Inc(ticks);
    end;
end;

var
  ticklooper: Real;

procedure newint08; interrupt;
begin
  If (ticklooper > 0) then asm mov al,20h; out 20h,al end
  else begin
         asm pushf end;
         oldint08;
         If irq_mode then poll_proc;
       end;

  ticklooper := ticklooper+timer_freq/irq_freq;
  If (ticklooper >= 1) then ticklooper := 0;
end;

procedure init_irq;
begin
  If irq_initialized then EXIT;
  irq_initialized := TRUE;
  GetIntVec($08,@oldint08);
  SetIntVec($08,@newint08);
  update_timer(50);
end;

procedure restore_CMOS_datetime;
var
  year: Word;
  month,day: Byte;
  hours,minutes,seconds: Byte;

function xconv(hex: Word): Word;

var
  temp1,temp2,
  temp3,temp4: Byte;
  temp: Word;
  errcode: Integer;
  temps: String;

begin
  temp1 := (hex SHR 8) SHR 4;
  temp2 := (hex SHR 8)-(temp1 SHL 4);
  temp3 := (hex AND $0ff) SHR 4;
  temp4 := (hex AND $0ff)-(temp3 SHL 4);
  temps := CHR(48+temp1)+CHR(48+temp2)+CHR(48+temp3)+CHR(48+temp4);
  Val(temps,temp,errcode);
  xconv := temp;
end;

begin
  asm
        mov     ah,02h
        int     1ah
        mov     hours,ch
        mov     minutes,cl
        mov     seconds,dh
        mov     ah,04h
        int     1ah
        mov     year,cx
        mov     month,dh
        mov     day,dl
  end;

  year    := xconv(year);
  month   := xconv(month);
  day     := xconv(day);
  hours   := xconv(hours);
  minutes := xconv(minutes);
  seconds := xconv(seconds);

  SetDate(year,month,day);
  SetTime(hours,minutes,seconds,0);
end;

procedure done_irq;
begin
  If NOT irq_initialized then EXIT;
  irq_initialized := FALSE;
  irq_mode := TRUE;
  update_timer(0);
  SetIntVec($08,@oldint08);
  irq_mode := FALSE;
  restore_CMOS_datetime;
end;

function calc_pattern_pos(pattern: Byte): Byte;

var
  temp: Byte;
  pattern_pos: Byte;

begin
  pattern_pos := NULL;
  For temp := 0 to $7f do
    If (songdata^.pattern_order[temp] = pattern) then
      begin
        pattern_pos := temp;
        BREAK;
      end;
  calc_pattern_pos := pattern_pos;
end;

procedure init_player;

var
  temp: Byte;

begin
  opl2out($0001);

  For temp := $0b0 to $0b8 do opl2out(temp);
  For temp := $080 to $08d do opl2out(temp+$0ff00);
  For temp := $090 to $095 do opl2out(temp+$0ff00);

  opl2out($2001);
  opl2out($4008);
  opl2out($00bd);

  FillChar(adsr_carrier,SizeOf(adsr_carrier),FALSE);
  FillChar(adsr_tab_car,SizeOf(adsr_tab_car),0);
  FillChar(adsr_tab_mod,SizeOf(adsr_tab_mod),0);
  FillChar(peak_lock,SizeOf(peak_lock),FALSE);
  FillChar(volume_lock,SizeOf(volume_lock),FALSE);
  FillChar(volume_table,SizeOf(volume_table),0);
  FillChar(kscale_table,SizeOf(kscale_table),0);
  FillChar(event_table,SizeOf(event_table),0);
  FillChar(freq_table,SizeOf(freq_table),0);
  FillChar(effect_table,SizeOf(effect_table),0);
  FillChar(porta_table,SizeOf(porta_table),0);
  FillChar(arpgg_table,SizeOf(arpgg_table),0);
  FillChar(vibr_table,SizeOf(vibr_table),0);
  FillChar(retrig_table,SizeOf(retrig_table),0);
  FillChar(last_effect,SizeOf(last_effect),0);
  FillChar(volslide_type,SizeOf(volslide_type),0);

  For temp := 1 to 9 do
    begin
      arpgg_table[temp].state := 1;
      event_table[temp].instr_def := NULL;
      voice_table[temp] := temp;
    end;
end;

procedure a2t_data_import(var data; size: Word); forward;
procedure start_playing;
begin
  stop_playing;
  a2t_data_import(data,size);

  If (error_code <> 0) then EXIT
  else init_player;

  current_order := 0;
  If (songdata^.pattern_order[current_order] > $7f) then
    If (calc_order_jump = -1) then EXIT;

  current_pattern := songdata^.pattern_order[current_order];
  current_line := 0;
  pattern_break := FALSE;
  next_line := 0;
  irq_mode := TRUE;
  play_status := isPlaying;

  ticklooper := 0;
  tempo := songdata^.tempo;
  update_timer(songdata^.timer_freq);
end;

procedure stop_playing;

var
  temp: Byte;

begin
  irq_mode := FALSE;
  play_status := isStopped;
  pattern_break := FALSE;
  current_order := 0;
  current_pattern := 0;
  current_line := 0;

  For temp := 1 to 9 do release_sustaining_sound(temp);
  tempo := songdata^.tempo;
  update_timer(songdata^.timer_freq);
end;

function XMS_driver_installed: Boolean; assembler;
asm
        mov     ax,4300h
        int     2fh
        cmp     al,80h
        jz      @@1
        mov     al,FALSE
        jmp     @@2
@@1:    mov     ax,4310h
        int     2fh
        mov     XMS_control.WORD[0],bx
        mov     XMS_control.WORD[2],es
        mov     al,TRUE
@@2:
end;

function allocate_XMS(blocks: Word): Word; assembler;
asm
        push    dx
        push    bx
        mov     XMS_error,0
        mov     ah,09h
        mov     dx,blocks
        call    [XMS_control]
        mov     XMS_error,bl
        mov     ax,dx
        pop     bx
        pop     dx
end;

procedure deallocate_XMS(handle: Word); assembler;
asm
        push    dx
        push    bx
        mov     XMS_error,0
        mov     ah,0ah
        mov     dx,handle
        call    [XMS_control]
        mov     XMS_error,bl
        pop     bx
        pop     dx
end;

procedure hash_XMS(var struct: tXMS_MOVE_STRUCTURE); assembler;
asm
        push    ds
        push    si
        push    bx
        mov     XMS_error,0
        lds     si,struct
        mov     ah,0bh
        call    [XMS_control]
        mov     XMS_error,bl
        pop     bx
        pop     si
        pop     ds
end;

procedure read_patterns(block: Byte);
begin
  If (block = current_block) then EXIT
  else current_block := block;

  hash_struct.size := SizeOf(hash_buffer^);
  hash_struct.handle1 := pattdata[block];
  hash_struct.offset1 := 0;
  hash_struct.handle2 := 0;
  hash_struct.offset2 := LONGINT(hash_buffer);
  hash_XMS(hash_struct);
end;

procedure write_patterns(block: Byte);
begin
  hash_struct.size := SizeOf(hash_buffer^);
  hash_struct.handle1 := 0;
  hash_struct.offset1 := LONGINT(hash_buffer);
  hash_struct.handle2 := pattdata[block];
  hash_struct.offset2 := 0;
  hash_XMS(hash_struct);
  current_block := block;
end;

procedure init_songdata;
begin
  stop_playing;
  FillChar(songdata^,SizeOf(songdata^),0);
  FillChar(songdata^.pattern_order,SizeOf(songdata^.pattern_order),$80);
  FillChar(songdata^.instr_table,SizeOf(songdata^.instr_table),0);

  FillChar(hash_buffer^,SizeOf(hash_buffer^),0);
  write_patterns(3);
  write_patterns(2);
  write_patterns(1);
  write_patterns(0);

  timer_freq := 50;
  tempo := 6;
  songdata^.timer_freq := Round(timer_freq);
  songdata^.tempo := tempo;
end;

const
  MAXFREQ    = 2000;
  MINCOPY    =    3;
  MAXCOPY    =  255;
  COPYRANGES =    6;

  bitValue: array[1..14] of Word = (1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192);
  CopyBits: array[0..PRED(COPYRANGES)] of Integer = (4,6,8,10,12,14);
  CODESPERRANGE = (MAXCOPY - MINCOPY + 1);

  TERMINATE = 256;
  FIRSTCODE = 257;
  MAXCHAR   = (FIRSTCODE + COPYRANGES * CODESPERRANGE - 1);
  SUCCMAX   = (MAXCHAR + 1);
  TWICEMAX  = (2 * MAXCHAR + 1);
  ROOT      = 1;
  MAXBUF    = 42 * 1024;

type
  tCOPY = array[0..PRED(COPYRANGES)] of Integer;

const
  CopyMin: tCOPY = (0,16,80,336,1360,5456);
  MAXDISTANCE = 21389;
  MAXSIZE     = 21389 + MAXCOPY;

type
  tTREE_TYP1 = array[0..MAXCHAR]            of Word;
  tTREE_TYP2 = array[0..TWICEMAX]           of Word;
  tBUFF_TYPE = array[0..MAXSIZE]            of Byte;
  tIO_BUFFER = array[0..PRED(MAXBUF)]       of Byte;
  tWD_BUFFER = array[0..PRED(MAXBUF) DIV 2] of Word;

var
  ibitCount:  Word;
  ibitBuffer: Word;
  ibufCount:  Word;
  obufCount:  Word;

var
  leftC,
  rghtC:  tTREE_TYP1;
  dad,
  freq:   tTREE_TYP2;
  obuf:  ^tIO_BUFFER;
  wdbuf: ^tWD_BUFFER;
  buf:   ^tBUFF_TYPE;

  input_size,output_size: Word;
  heap_pos: Pointer;

procedure InitTree; assembler;
asm
        mov     di,2
        mov     bx,2
        mov     cx,1
@@1:    xor     dx,dx
        mov     ax,di
        div     bx
        push    di
        shl     di,1
        mov     word ptr dad[di],ax
        mov     word ptr freq[di],cx
        pop     di
        inc     di
        cmp     di,TWICEMAX
        jbe     @@1
        mov     di,1
@@2:    xor     dx,dx
        mov     ax,di
        mul     bx
        push    di
        shl     di,1
        mov     word ptr leftC[di],ax
        inc     ax
        mov     word ptr rghtC[di],ax
        pop     di
        inc     di
        cmp     di,MAXCHAR
        jbe     @@2
end;

(* PASCAL ORIGINAL
procedure InitTree;

var
  index: Word;

begin
  For index := 2 to TWICEMAX do
    begin
      dad[index] := index DIV 2;
      freq[index] := 1;
    end;

  For index := 1 to MAXCHAR do
    begin
      leftC[index] := 2*index;
      rghtC[index] := 2*index+1;
    end;
end; *)

procedure UpdateFreq(a,b: Word); assembler;
asm
        push    ds
@@1:    mov     di,a
        shl     di,1
        mov     bx,word ptr freq[di]
        mov     di,b
        shl     di,1
        add     bx,word ptr freq[di]
        mov     di,a
        shl     di,1
        mov     dx,word ptr dad[di]
        mov     di,dx
        shl     di,1
        mov     word ptr freq[di],bx
        mov     a,dx
        cmp     a,ROOT
        jz      @@3
        mov     di,a
        shl     di,1
        mov     di,word ptr dad[di]
        mov     ax,di
        shl     di,1
        mov     bx,word ptr leftC[di]
        cmp     a,bx
        jnz     @@2
        mov     di,ax
        shl     di,1
        mov     bx,word ptr rghtC[di]
        mov     b,bx
        jmp     @@3
@@2:    mov     di,ax
        shl     di,1
        mov     bx,word ptr leftC[di]
        mov     b,bx
@@3:    cmp     a,ROOT
        jnz     @@1
        mov     bx,MAXFREQ
        mov     di,ROOT
        shl     di,1
        cmp     word ptr freq[di],bx
        jnz     @@5
        mov     si,offset freq
        mov     di,si
        mov     cx,TWICEMAX
        movsw
@@4:    lodsw
        shr     ax,1
        stosw
        loop    @@4
@@5:    pop     ds
end;

(* PASCAL ORIGINAL
procedure UpdateFreq(a,b: Word);
begin
  Repeat
    freq[dad[a]] := freq[a]+freq[b];
    a := dad[a];
    If (a <> ROOT) then
      If (leftC[dad[a]] = a) then b := rghtC[dad[a]]
      else b := leftC[dad[a]];
  until (a = ROOT);

  If (freq[ROOT] = MAXFREQ) then
    For a := 1 to TWICEMAX do freq[a] := freq[a] SHR 1;
end; *)

procedure UpdateModel(code: Word); assembler;
asm
        mov     bx,code
        add     bx,SUCCMAX
        mov     di,bx
        shl     di,1
        mov     ax,di
        mov     cx,word ptr freq[di]
        inc     cx
        mov     word ptr freq[di],cx
        mov     di,ax
        mov     cx,ROOT
        cmp     word ptr dad[di],cx
        jz      @@10
        mov     dx,word ptr dad[di]
        mov     di,seg leftC
        mov     es,di
        mov     di,offset leftC
        mov     cx,dx
        shl     cx,1
        add     di,cx
        mov     si,es:[di]
        cmp     si,bx
        jnz     @@1
        mov     di,dx
        shl     di,1
        mov     si,word ptr rghtC[di]
@@1:    push    bx
        push    dx
        push    bx
        push    si
        call    UpdateFreq
        pop     dx
        pop     bx
@@2:    mov     di,dx
        shl     di,1
        mov     ax,word ptr dad[di]
        mov     di,ax
        shl     di,1
        mov     cx,di
        cmp     word ptr leftC[di],dx
        jnz     @@3
        mov     di,cx
        mov     si,word ptr rghtC[di]
        jmp     @@4
@@3:    mov     si,word ptr leftC[di]
@@4:    mov     di,bx
        shl     di,1
        push    ax
        mov     ax,word ptr freq[di]
        mov     di,si
        shl     di,1
        mov     cx,ax
        pop     ax
        cmp     cx,word ptr freq[di]
        jbe     @@9
        mov     di,ax
        shl     di,1
        mov     cx,di
        cmp     word ptr leftC[di],dx
        jnz     @@5
        mov     di,cx
        mov     word ptr rghtC[di],bx
        jmp     @@6
@@5:    mov     di,cx
        mov     word ptr leftC[di],bx
@@6:    mov     di,seg leftC
        mov     es,di
        mov     di,offset leftC
        mov     cx,dx
        shl     cx,1
        add     di,cx
        cmp     es:[di],bx
        jnz     @@7
        mov     es:[di],si
        mov     di,cx
        mov     cx,word ptr rghtC[di]
        jmp     @@8
@@7:    mov     di,cx
        mov     word ptr rghtC[di],si
        mov     di,cx
        mov     cx,word ptr leftC[di]
@@8:    mov     di,si
        shl     di,1
        mov     word ptr dad[di],dx
        mov     di,bx
        shl     di,1
        mov     word ptr dad[di],ax
        push    si
        push    si
        push    cx
        call    UpdateFreq
        pop     bx
@@9:    mov     di,bx
        shl     di,1
        mov     bx,word ptr dad[di]
        mov     di,bx
        shl     di,1
        mov     dx,word ptr dad[di]
        cmp     dx,ROOT
        jnz     @@2
@@10:
end;

(* PASCAL ORIGINAL
procedure UpdateModel(code: Word);

var
  a,b,c,
  code1,code2: Word;

begin
  a := code+SUCCMAX;
  Inc(freq[a]);

  If (dad[a] <> ROOT) then
    begin
      code1 := dad[a];
      If (leftC[code1] = a) then UpdateFreq(a,rghtC[code1])
      else UpdateFreq(a,leftC[code1]);

      Repeat
        code2 := dad[code1];
        If (leftC[code2] = code1) then b := rghtC[code2]
        else b := leftC[code2];

        If (freq[a] > freq[b]) then
          begin
            If (leftC[code2] = code1) then rghtC[code2] := a
            else leftC[code2] := a;

            If (leftC[code1] = a) then
              begin
                leftC[code1] := b;
                c := rghtC[code1];
              end
            else begin
                   rghtC[code1] := b;
                   c := leftC[code1];
                 end;

            dad[b] := code1;
            dad[a] := code2;
            UpdateFreq(b,c);
            a := b;
          end;

        a := dad[a];
        code1 := dad[a];
      until (code1 = ROOT);
    end;
end; *)

var
  index,count: Word;

function InputCode(bits: Word): Word; assembler;
asm
        xor     bx,bx
        mov     cx,1
@@1:    cmp     ibitCount,0
        jnz     @@3
        cmp     ibufCount,MAXBUF
        jnz     @@2
        mov     ibufCount,0
@@2:    les     di,wdbuf
        mov     di,ibufCount
        shl     di,1
        mov     ax,es:[di]
        mov     ibitBuffer,ax
        inc     ibufCount
        mov     ibitCount,$0f
        jmp     @@4
@@3:    dec     ibitCount
@@4:    cmp     ibitBuffer,$7fff
        jbe     @@5
        mov     di,cx
        dec     di
        shl     di,1
        mov     ax,word ptr bitValue[di]
        or      bx,ax
@@5:    shl     ibitBuffer,1
        inc     cx
        cmp     cx,bits
        jbe     @@1
        mov     ax,bx
end;

(* PASCAL ORIGINAL
function InputCode(bits: Word): Word;

var
  index,code: Word;

begin
  code := 0;
  For index := 1 to bits do
    begin
      If (ibitCount = 0) then
        begin
          If (ibufCount = MAXBUF) then ibufCount := 0;
          ibitBuffer := wdbuf^[ibufCount];
          Inc(ibufCount);
          ibitCount := 15;
        end
      else Dec(ibitCount);

      If (ibitBuffer > $7fff) then code := code OR bitValue[index];
      ibitBuffer := ibitBuffer SHL 1;
    end;

  InputCode := code;
end; *)

function Uncompress: Word; assembler;
asm
        mov     bx,1
        mov     dx,ibitCount
        mov     cx,ibitBuffer
        mov     ax,ibufCount
@@1:    or      dx,dx
        jnz     @@3
        cmp     ax,MAXBUF
        jnz     @@2
        xor     ax,ax
@@2:    shl     ax,1
        les     di,wdbuf
        add     di,ax
        shr     ax,1
        mov     cx,es:[di]
        inc     ax
        mov     dx,$0f
        jmp     @@4
@@3:    dec     dx
@@4:    cmp     cx,$7fff
        jbe     @@5
        mov     di,bx
        shl     di,1
        mov     bx,word ptr rghtC[di]
        jmp     @@6
@@5:    mov     di,bx
        shl     di,1
        mov     bx,word ptr leftC[di]
@@6:    shl     cx,1
        cmp     bx,MAXCHAR
        jle     @@1
        sub     bx,SUCCMAX
        mov     ibitCount,dx
        mov     ibitBuffer,cx
        mov     ibufCount,ax
        push    bx
        push    bx
        call    UpdateModel
        pop     ax
end;

(* PASCAL ORIGINAL
function Uncompress: Word;

var
  a: Word;

begin
  a := 1;
  Repeat
    If (ibitCount = 0) then
      begin
        If (ibufCount = MAXBUF) then ibufCount := 0;
        ibitBuffer := wdbuf^[ibufCount];
        Inc(ibufCount);
        ibitCount := 15;
      end
    else Dec(ibitCount);

    If (ibitBuffer > $7fff) then a := rghtC[a]
    else a := leftC[a];
    ibitBuffer := ibitBuffer SHL 1;
  until (a > MAXCHAR);

  Dec(a,SUCCMAX);
  UpdateModel(a);
  Uncompress := a;
end; *)

procedure Decode; assembler;
asm
        mov     count,0
        call    InitTree
        call    Uncompress
@@1:    cmp     ax,TERMINATE
        jz      @@10
        cmp     ax,$100
        jae     @@3
        les     di,obuf
        add     di,obufCount
        stosb
        inc     obufCount
        mov     bx,MAXBUF
        cmp     obufCount,bx
        jnz     @@2
        mov     obufCount,0
@@2:    les     di,buf
        add     di,count
        stosb
        inc     count
        cmp     count,MAXSIZE
        jnz     @@9
        mov     count,0
        jmp     @@9
@@3:    sub     ax,FIRSTCODE
        mov     cx,ax
        xor     dx,dx
        mov     bx,CODESPERRANGE
        div     bx
        mov     index,ax
        xor     dx,dx
        mul     bx
        mov     bx,cx
        add     bx,MINCOPY
        sub     bx,ax
        mov     si,bx
        mov     di,index
        shl     di,1
        mov     bx,word ptr CopyBits[di]
        push    bx
        call    InputCode
        add     ax,si
        mov     di,index
        shl     di,1
        add     ax,word ptr CopyMin[di]
        mov     bx,count
        mov     dx,bx
        sub     dx,ax
        mov     cx,dx
        cmp     count,ax
        jae     @@4
        add     cx,MAXSIZE
@@4:    xor     dx,dx
@@5:    les     di,buf
        add     di,cx
        mov     al,es:[di]
        les     di,obuf
        add     di,obufCount
        mov     es:[di],al
        inc     obufCount
        mov     ax,MAXBUF
        cmp     obufCount,ax
        jnz     @@6
        mov     obufCount,0
@@6:    les     di,buf
        push    di
        add     di,cx
        mov     al,es:[di]
        pop     di
        add     di,bx
        mov     es:[di],al
        inc     bx
        cmp     bx,MAXSIZE
        jnz     @@7
        xor     bx,bx
@@7:    inc     cx
        cmp     cx,MAXSIZE
        jnz     @@8
        xor     cx,cx
@@8:    inc     dx
        cmp     dx,si
        jb      @@5
        mov     ax,si
        add     count,ax
        cmp     count,MAXSIZE
        jb      @@9
        sub     count,MAXSIZE
@@9:    call    Uncompress
        jmp     @@1
@@10:   mov     bx,obufCount
        mov     output_size,bx
end;

(* PASCAL ORIGINAL
procedure Decode;

var
  i,j,k,t,c,
  count,dist,len,index: Word;

begin
  count := 0;
  InitTree;
  c := Uncompress;

  While (c <> TERMINATE) do
    begin
      If (c < 256) then
        begin
          obuf^[obufCount] := c;
          Inc(obufCount);
          If (obufCount = MAXBUF) then
            begin
              output_size := MAXBUF;
              obufCount := 0;
            end;

          buf^[count] := c;
          Inc(count);
          If (count = MAXSIZE) then count := 0;
        end
      else begin
             t := c-FIRSTCODE;
             index := t DIV CODESPERRANGE;
             len := t+MINCOPY-index*CODESPERRANGE;
             dist := InputCode(CopyBits[index])+len+CopyMin[index];

             j := count;
             k := count-dist;
             If (count < dist) then Inc(k,MAXSIZE);

             For i := 0 to PRED(len) do
               begin
                 obuf^[obufCount] := buf^[k];
                 Inc(obufCount);
                 If (obufCount = MAXBUF) then
                   begin
                     output_size := MAXBUF;
                     obufCount := 0;
                   end;

                 buf^[j] := buf^[k];
                 Inc(j);
                 Inc(k);
                 If (j = MAXSIZE) then j := 0;
                 If (k = MAXSIZE) then k := 0;
               end;

             Inc(count,len);
             If (count >= MAXSIZE) then Dec(count,MAXSIZE);
           end;

      c := Uncompress;
    end;

  output_size := obufCount;
end; *)

function _6depak(var source,dest; size: Word): Word;
begin
  _6depak := 0;
  Mark(heap_pos);

  GetMem(obuf,MAXBUF);
  If (obuf = NIL) then
    begin Release(heap_pos); EXIT; end;

  GetMem(wdbuf,MAXBUF);
  If (wdbuf = NIL) then
    begin Release(heap_pos); EXIT; end;

  GetMem(buf,MAXSIZE);
  If (buf = NIL) then
    begin Release(heap_pos); EXIT; end;

  input_size := size;
  ibitCount  := 0;
  ibitBuffer := 0;
  obufCount  := 0;
  ibufCount  := 0;

  Move(source,wdbuf^,size);
  Decode;
  Move(obuf^,dest,output_size);
  _6depak := output_size;
  Release(heap_pos);
end;

procedure make_CRC32_table;

var
  crc: Longint;
  n,index: Byte;

begin
  For index := 0 to 255 do
    begin
      crc := index;
      For n := 1 to 8 do
        If Odd(crc) then crc := crc SHR 1 XOR $0edb88320
        else crc := crc SHR 1;
      CRC32_table[index] := crc;
    end;
end;

function update_CRC32(var buf; size: Word; crc: Longint): Longint; assembler;
asm
        push    ds
        lds     si,buf
        les     ax,crc
        mov     dx,es
        mov     cx,size
        or      cx,cx
        jz      @@2
@@1:    xor     bh,bh
        mov     bl,al
        lodsb
        xor     bl,al
        mov     al,ah
        mov     ah,dl
        mov     dl,dh
        xor     dh,dh
        shl     bx,1
        shl     bx,1
        push    ax
        mov     ax,seg CRC32_table
        mov     es,ax
        mov     ax,word ptr es:[CRC32_table+bx+2]
        mov     bx,word ptr es:[CRC32_table+bx]
        mov     es,ax
        pop     ax
        xor     ax,bx
        mov     bx,es
        xor     dx,bx
        loop    @@1
@@2:    pop     ds
end;

procedure a2t_data_import(var data; size: Word);

type
  tHEADER = Record
              ident: array[1..15] of Char;
              crc32: Longint;
              ffver: Byte;
              patts: Byte;
              timer: Byte;
              tempo: Byte;
              b0len: Word;
              b1len: Word;
              b2len: Word;
              b3len: Word;
              b4len: Word;
              b5len: Word;
            end;
const
  id = '_A2tiny_module_';

var
  temp: Word;
  crc: Longint;

begin
  If (error_code = -2) then EXIT;
  error_code := -1;
  If NOT ((size >= SizeOf(tHEADER)+tHEADER(data).b0len
                                  +tHEADER(data).b1len) and
     (tHEADER(data).ident = id) and
     (tHEADER(data).ffver = 1)) then EXIT;

  crc := NOT 0;
  crc := update_CRC32(tDUMMY_BUFF(data)[SizeOf(tHEADER)],
                      size-SizeOf(tHEADER),crc);

  crc := update_CRC32(tHEADER(data).b0len,2,crc);
  crc := update_CRC32(tHEADER(data).b1len,2,crc);
  crc := update_CRC32(tHEADER(data).b2len,2,crc);
  crc := update_CRC32(tHEADER(data).b3len,2,crc);
  crc := update_CRC32(tHEADER(data).b4len,2,crc);
  crc := update_CRC32(tHEADER(data).b5len,2,crc);

  If (crc <> tHEADER(data).crc32) then EXIT;
  init_songdata;
  songdata^.timer_freq := tHEADER(data).timer;
  songdata^.tempo := tHEADER(data).tempo;

  temp := _6depak(tDUMMY_BUFF(data)[SizeOf(tHEADER)],
                  songdata^.instr_table,tHEADER(data).b0len);
  If (temp = 0) then EXIT;

  temp := _6depak(tDUMMY_BUFF(data)[SizeOf(tHEADER)+tHEADER(data).b0len],
                  songdata^.pattern_order,tHEADER(data).b1len);
  If (temp = 0) then EXIT;

  temp := _6depak(tDUMMY_BUFF(data)[SizeOf(tHEADER)+tHEADER(data).b0len
                                                   +tHEADER(data).b1len],
                  hash_buffer^,tHEADER(data).b2len);
  If (temp <> 0) then write_patterns(0)
  else EXIT;

  If ((tHEADER(data).patts-1) DIV 16 > 0) then
    begin
      FillChar(hash_buffer^,SizeOf(hash_buffer^),0);
      temp := _6depak(tDUMMY_BUFF(data)[SizeOf(tHEADER)+tHEADER(data).b0len
                                                       +tHEADER(data).b1len
                                                       +tHEADER(data).b2len],
                      hash_buffer^,tHEADER(data).b3len);
      If (temp <> 0) then write_patterns(1)
      else EXIT;
    end;

  If ((tHEADER(data).patts-1) DIV 16 > 1) then
    begin
      FillChar(hash_buffer^,SizeOf(hash_buffer^),0);
      temp := _6depak(tDUMMY_BUFF(data)[SizeOf(tHEADER)+tHEADER(data).b0len
                                                       +tHEADER(data).b1len
                                                       +tHEADER(data).b2len
                                                       +tHEADER(data).b3len],
                      hash_buffer^,tHEADER(data).b4len);
      If (temp <> 0) then write_patterns(2)
      else EXIT;
    end;

  If ((tHEADER(data).patts-1) DIV 16 > 2) then
    begin
      FillChar(hash_buffer^,SizeOf(hash_buffer^),0);
      temp := _6depak(tDUMMY_BUFF(data)[SizeOf(tHEADER)+tHEADER(data).b0len
                                                       +tHEADER(data).b1len
                                                       +tHEADER(data).b2len
                                                       +tHEADER(data).b3len
                                                       +tHEADER(data).b4len],
                      hash_buffer^,tHEADER(data).b5len);
      If (temp <> 0) then write_patterns(3)
      else EXIT;
    end;

  error_code := 0;
  tempo := songdata^.tempo;
  timer_freq := songdata^.timer_freq;
end;

var
  old_exit_proc: Pointer;

procedure new_exit_proc; far;
begin
  stop_playing;
  done_irq;

  Dispose(hash_buffer);
  Dispose(songdata);

  If (error_code <> -2) then
    begin
      deallocate_XMS(pattdata[0]);
      deallocate_XMS(pattdata[1]);
      deallocate_XMS(pattdata[2]);
      deallocate_XMS(pattdata[3]);
    end;
end;

const
  PATTERN_SIZE = Round(SizeOf(tVARIABLE_DATA)/1000);

begin
  old_exit_proc := ExitProc;
  ExitProc := @new_exit_proc;

  New(songdata);
  New(hash_buffer);

  If NOT XMS_driver_installed then begin error_code := -2; EXIT; end;

  pattdata[0] := allocate_XMS(PATTERN_SIZE);
  pattdata[1] := allocate_XMS(PATTERN_SIZE);
  pattdata[2] := allocate_XMS(PATTERN_SIZE);
  pattdata[3] := allocate_XMS(PATTERN_SIZE);

  If (XMS_error <> 0) then begin error_code := -2; EXIT; end;
  play_status := isStopped;
  init_songdata;
  init_irq;
  make_CRC32_table;
end.
