#ifndef	__vga_h
	#define __vga_h
#include<string.h>
#include<strstrea.h>
#include"pci.h"
/*	CHIPS header file				v0.93	09/07/97
 *
 *	Some major changes since v0.84...
 *	I removed most <stdio.h> functions (sprintf, fprintf, etc.), and
 *	(finally) replaced them with the more appropriate C++ stream methods.
 *	.............
 *	This header contains the necessary class structure VGA for my MCLK
 *	program to manipulate.  Chipset specific classes (S3, Cirrus, etc.)
 *	are defined in other header files, and are not necessary for MCLK.CPP
 *
 *	(If you wish to recompile the chips.lib file, you must compile
 *	 chips.cpp with chips.h.)
 */

#define INITMSG(x) ostrstream msgout( x, sizeof( x ) )
	// macro to quickly setup "msgout" method, printing-to-string

#define 	TRUE		1
#define 	FALSE	0

#define	_CRindex	0x3D4	//	CRindex port-io address, color
#define	_CRIO	0x3D5	//	CRIO port-io address, color
#define	_SRindex	0x3C4	//	SRindex port-io address, color
#define	_SRIO	0x3C5	//	SRIO port-io address, color
#define	_GRindex	0x3CE	//	GRindex port-io address, color
#define	_GRIO	0x3CF	//	GRIO port-io address, color
#define	_DACmask	0x3C6	//	RS[1:0]=10 RAMDAC MASK port-io address
#define _DACindexR	0x3C7	//	RS=11 RAMDAC read-index
#define _DACindexW	0x3C8	//	RS=00 RAMDAC write-index
#define	_DACIO	0x3C9	//	RS=01 read/write data port of RAMDAC
#define	_OSC		14.31818	//	Reference oscillator frequency

#define _MAXOPTIONS	5
	//	Maximum # of user-selectable choices


#ifndef uchar
typedef unsigned char uchar;
typedef unsigned long ulong;
typedef unsigned short uint;
#endif

//	A structure for exchanging information about video hardware
//	between the program and the underlying data structures
typedef struct {
	char make[ 80 ];		//	Examples... S3, Cirrus Logic, etc.
	char chipset[ 80 ];		//	Examples... Trio64, GD-5428, etc.
	char revision[ 80 ];	//	Examples... 01, 0A, etc.
} vga_info;

#define _TEXTLENGTH 512

typedef struct	{
	char text[ _TEXTLENGTH ];
	char temp[ _TEXTLENGTH ];	//temporary work space
}	message;


#define _SET		1
#define _GET		2
#define _HELP		3
#define _QUERY		4
	//	Query will cause xxx::_fxnX( _QUERY ) to put a text-line
	//	describing its operation (eg. "2 IO RDY wait state control")
	//	into msg.text

class vga		{
protected:
	int parse_param( int index, uchar *parsed ); // Acquire 1 parameter
	uchar shift( uchar in );	//	remaps shift(2) -> 3, and shift(3) -> 2
	vga_info id;			// Video chipset identification
	virtual void _mclk( int cmd );	//	Allow MCLK reprogramming
	virtual void _fxn1( int cmd );
	virtual void _fxn2( int cmd );	//	cmd = _GET, _SET, _HELP
	virtual void _fxn3( int cmd );
	virtual void _fxn4( int cmd );
	virtual void _fxn5( int cmd );
	char * bitstat( uchar bit );	//	Returns "ENABLE or DISABLE"

	/* Quick function for printing hex-numbers in "XX" format */
	void hexout( ostrstream &deststr, int value );

public:
	int num_param;		//	Number of parameters in input list
	char **param;		//	List of parameters

	virtual message _info( void );	//	return SVGA information
	vga( vga_info info );	// Constructor prototype,
		//	set-up identification "info" structure -> vga_info id;
	virtual ~vga() { ; } ;	// Destructor
	message get_settings( void );	//	List user-changeable settings
	vga_info get_info( void )	//	Inquire information of video chipset
		{	return( id );	};
		//	Returns information, like VGA name, chipset, revision
	message get_vgahelp( void );	//	Returns general help message
	message msg;		//	Text-buffer for return messages

	int status;		//	EXIT_FAILURE or EXIT_SUCCESS
	void go( int fxn, int cmd );	//	Execute command,
		//	where cmd == _SET, _GET, _HELP
	char * version( void )	//	Returns software_revision in text-string
		{	return "v094A 08/06/00" ;	};

	uchar read_SR( uchar index ); // Reads VGA _SR register index,
	void write_SR ( uchar index, uchar data );	// Writes VGA _SR register
	uchar read_CR( uchar index );	// Reads VGA _CR register index
	void write_CR ( uchar index, uchar data );	// Writes VGA _CR register
	uchar read_bit ( int port, uchar index, uchar bit );
		// Read single bit, bit = #bits from RIGHT -> 7654 3210
          // intended for VGA indirect indexed registers
	void write_bit( int port, uchar index, uchar bit, uchar data );
		// Write single bit, bit = #bits from RIGHT -> 7654 3210
          // intended for VGA indirect indexed registers
     uchar read_bit ( int port, uchar bit );
     	// Read single bit from any standard port-io
     void write_bit( int port, uchar bit, uchar data );
     	// Write single bit to any standard port-io
};

//	Force auto-detection to check only these graphics controllers
#define _AUTO		-1
#define _FCIRRUS	1
#define _FS3		2
#define _FTSENG	3
#define _FTRIDENT	4
#define _FMATROX	5
	//	for forcing auto-detection of _W32P...
     //	Note, _FMATROX does not do anything so far...

class detect	{
protected:
	vga_info id;
	vga *hardware;

     //  Added PCI-stuff v0.93
	pci_bios_type *pci_bios;
	pci_device_handle_type pci_vga;

	message msg;	//	char buffer for returning messages to caller
public:
	detect( void )
		{ hardware = NULL;	};		//	Constructor
	message _help( int mode = _AUTO );	//	Help menu lists chipsets
	vga * _find( int chipset = _AUTO, int family = _AUTO );
		//	Detection routine, default is auto-detection
	vga * _debug( int mode = _AUTO );	//	DEBUGGING purposes only!
	vga * detect_cirrus( int mode = _AUTO );
	vga * detect_s3( int mode = _AUTO );
	vga * detect_tseng( int mode = _AUTO );		//	v0.93 added ET6000
	vga * detect_trident( int mode = _AUTO );

	vga * detect_pci( int mode = _AUTO );	// v0.93 added PCI-detection
     	// So far, only Tseng Labs ET6000 and Cirrus GD5462/64 chipsets
          // autodetected
};

// Added word & dword structures v0.93
#endif
#ifndef	__dword_struct
	#define __dword_struct
union dword
{
public:
	ulong dw;
	struct	{
          word w0;
          word w1;
     } w;

     struct	{
     	uchar b0;
          uchar b1;
          uchar b2;
          uchar b3;
     } b;

     // Constructors
     dword( void )
   	 	{	dw = 0;	};
	dword( ulong init_value )
     	{	dw = init_value;	};
     dword( long init_value )
     	{	dw = (ulong)init_value;	};
     dword( dword &init_dword )
     	{	dw = init_dword.dw;	};

     dword&
	operator =( ulong value )
	{
		dw = value;
		return *this;
	};
};

#endif

#ifndef   __word_struct
	#define	__word_struct

union word
{
public:
	uint w;

     struct	{
     	uchar b0;
          uchar b1;
     } b;

     // Constructors
     word( void )
   	 	{	w = 0;	};
	word( uint init_value )
     	{	w = init_value;	};
     word( unsigned init_value )
     	{	w = (uint)init_value;	};
     word( word &init_word )
     	{	w = init_word.w;	};

     word&
	operator =( uint value )
	{
		w = value;
		return *this;
	};
};
#endif