/*	trident.cpp		08/31/97	0.93
 *
 *	Includes class definitions for Trident Microsystems
 *	v0.85b First public release, completely non-functional
 *	v0.91b working MCLK code for 96XX (haven't tested 9440)
 *	v0.92b noticed bug under Win95-OSR2 where screen-corruption can happen
 *		  can't seem to fix it
 *	v0.93b added RAM-type detection for Trident 966x chipsets
 *	v0.94b added comments to 9750MCLK for Trident Blade3D
 *
 *	source-code based on information compiled in VGADOC4B.ZIP
 */

#include "trident.h"

#include<dos.h>
#include<string.h>
#include<stdio.h>
#include<stdlib.h>
#include<iostreams.h>
#include<math.h>

message
_TR9440::_info( void )
{
	sprintf( msg.text, "" );
	return msg;
}

/*
void
_TR9440::setmode(uchar mode)
{
	switch ( mode )	{
		case _NEW:	// Set Trident _SR registers to "NEW" mode
			outportb( _SRindex, 0x0B );	// Reading forces NEW mode
			inportb( _SRIO );
			inportb( _SRIO );		// Two 8-bit reads = 16-bit read
			break;
		case _OLD:	// Set Trident _SR registers to "OLD" mode
			outportb( _SRindex, 0x0B );	// Writing forces OLD mode
			outportb( _SRIO, 0 );	// Two 8-bit writes = 16-bit write
			outportb( _SRIO, 0 );
			break;
		default:
			fprintf( stderr, "\n_TR9440::setmode( mode ) error!" );
			exit( EXIT_FAILURE );
	}
}
*/

int
_TR9440::read_mclk( void )	// Reads MCLK bytes into one int
{
	// Trident MCLK-word is at port 0x43C6 and 0x43C7 (16-bits total)
	int _43C6 = inportb( 0x43C6 );
	int _43C7 = inportb( 0x43C7 );

	// No, you can't just do int mclk = inport( 0x43C6 )... doesn't work!

	return ( _43C7 << 8 ) | _43C6 ;
}


double
_TR9440::get_mclkfreq()
{
	double freq;
	int mclk = read_mclk();  // Read MCLK word
	uchar mult2 = (mclk & 0x0200) ? 0 : 1;	// Multiply by 2?
	uchar divisor = mclk & 0x0007 ; //  lowest three bits 0000 0000 0000 0XXX
	uchar scale = ( mclk & 0x01F8 ) >> 3; // 0000 000X XXXX X000

	freq = _OSC * (scale + 4.0 ) / ( divisor + 2.0 );
	//
	// v0.91b
	// I don't know if this is 100% accurate--I reverse-engineered the
	// dram-clock formula
	//
	//  _OSC = 14.31818 MHz (reference frequency)
	//                      ( B + 4 ) * ( _A )
	//  DCLK (MHz) = _OSC * ------------------
	//                           ( C + 2 )
	//
	//
	// port 0x43C6 and 0x43C7 form 16-bit binary MCLK "word" (Intel-style)
	// MCLK( 15:0 ) = ???? ??AB  BBBB BCCC <- 16-bit word
	//                5432 1098  7654 3210 <- bit#
	//
	// "A" single-bit flag ( 0 = scale up by 2, 1 = no effect )
	// "B" 6-bit "scale" factor
	// "C" 3-bit "divisor" factor
	// "?" don't really know

	if ( mult2 )
		freq *= 2.0 ; // if mult2 is set, double freq

	return freq;
}


void		//	MCLK programming for Trident 9440/96xx
_TR9440::_mclk( int cmd )
{
	int mclk;
     uchar _SR0E;	//	Register _SR0E, temp-holding place

	if ( cmd == _QUERY )	{
		strcpy( msg.text, "0  9440/96xx MCLK programming\n" );
		return;
	}

     mclk = read_mclk();	// New MCLK 16-bit value
	uchar mult2 = (mclk & 0x0200) ? 0 : 1;	// Multiply by 2?
	uchar divisor = mclk & 0x0007 ; // lowest three bits 0000 0000 0000 0XXX
	uchar scale = ( mclk & 0x01F8 ) >> 3; // 0000 000X XXXX X000
     sprintf( msg.text, "Trident 9440/96xx MCLK programming" );
	sprintf( msg.temp, "\nOld MCLK = %.2fMHz (%04X)", get_mclkfreq(),
		read_mclk() );
	strcat( msg.text, msg.temp );
	sprintf( msg.temp, "\nscale = %d (dec), divisor = %X, mult2 = %d (dec)",
		scale, divisor, mult2 );
	strcat( msg.text, msg.temp );

	if ( num_param < 3 && cmd == _SET )	{
		strcat( msg.text, "\nError!  THREE parameters required!");
		cmd = _HELP; }
	else	if ( num_param >= 3 ) {
		mult2 = ( (uchar)atoi( param[ 2 ] ) ) & 0x01;
		divisor = ( (uchar)atoi( param[ 1 ] ) ) & 0x07;
		scale = ( (uchar)atoi( param[ 0 ] ) ) & 0x3F;
	}

	if ( param[ 0 ] != NULL ) // Only the 1st parameter is used
		if ( sscanf( param[ 0 ], " %x", &mclk ) == 0 )
			cmd = _HELP;	//	Error, no value scanned

	switch ( cmd )	{
		case _SET	:
			uchar mhigh = inportb( 0x43C7 ) & 0xFC;	// preserve top 6 bits
			uchar mlow = ( scale << 3 ) | divisor;
			mhigh = mhigh | ( mult2 ? 0 : 0x02 ) | ( scale >> 5 ) ;
			_SR0E = read_SR( 0x0E );	// XX00 0000
			write_SR( 0x0E, _SR0E | 0x82 );	// 1XXX XX1X
				// To update MCLK, bits 1 & 7 must be SET
			outportb( 0x43C6,  mlow );
			outportb( 0x43C7, mhigh );
			write_SR( 0x0E, _SR0E );	// Restore _SR0E to original value!

			mclk = read_mclk();
			sprintf( msg.temp, "\n\nNew MCLK = %.2fMHz (%04X) ",
				get_mclkfreq(), mclk );
			mult2 = (mclk & 0x0200) ? 0 : 1;
			divisor = mclk & 0x0007 ;
			scale = ( mclk & 0x01F8 ) >> 3;
			strcat( msg.text, msg.temp );
			sprintf( msg.temp,
				"\nscale = %d (dec), divisor = %X, mult2 = %d (dec)",
				scale, divisor, mult2 );
			strcat( msg.text, msg.temp );
			break;
		case _GET :	case _HELP:	sprintf( msg.temp, "%s%s%s%s%s",
			 "\n  Note:  Trident 9440/96xx MCLK max = 80MHz",
			 "\n\t mclk = 14.31818MHz * ( scale+4 ) / ( divisor+2 )",
			 ", (if mult2=1, * 2 )",
			 "\n\t Input: mclk /0 SCALE DIVISOR MULT2 (3 parameters)",
			 "\n\t        scale = 0-63, divisor = 0-7, mult2 = 0 or 1" );
			strcat( msg.text, msg.temp );
			break;
/*	--CODE TAKEN FROM VGADOC4B.ZIP
43C6h W(R/W):  Memory Clock                                             (9440)
bit 0-15  Selects the memory clock. 2C6h = 50MHz, 307h = 58MHz, 87h = 64MHz
		  8Eh = 75MHz
Note: 3C4h index Eh (new) bits 1 & 7 must be set to update this register
*/

		default:
			sprintf( msg.text, "_TR9440::_mclk(cmd)  UNRECOGNIZED cmd.");
			status = EXIT_FAILURE;
	}
}


message
_TR9660::_info( void )
{
//  the following data structure is declared in the object definition
//	union	// Interface select register, 3D4.2A (CR register $2A)
//	{
//		uchar byte;	// 8-bit byte representation of register
//
//          struct
//		{
//			unsigned reserved1 : 2;	// reserved bits
//	          unsigned ramtype : 2;	// framebuffer ram type
//	          unsigned other : 4;		// other, irrelevant bits
//          } name;	// Named bit fields in register
//
//	} intsel;

     intsel.byte = read_CR( 0x2A );	// read interface-select register

     switch ( intsel.name.ramtype )
     {
     	case 1 : sprintf( msg.text, "EDO DRAM" );
          	break;
          case 3 : sprintf( msg.text, "FPM DRAM" );
          	break;
          default :
          	sprintf( msg.text, "UNKNOWN" );
     }

     return msg;
}


void		//	framebuffer type (EDO/FPM) selection
_TR9660::_fxn1( int cmd )
{
     int temp; // scratch variable
	if ( cmd == _QUERY )	{
		strcpy( msg.text, "1  96xx framebuffer RAM-type (not UMA)\n" );
		return;
	}

     sprintf( msg.text, "Old RAM-type = %d ", intsel.name.ramtype );

	if ( num_param >= 1 ) {
		intsel.name.ramtype = ( (uchar)atoi( param[ 0 ] ) ) & 0x03;
	}

	if ( param[ 0 ] != NULL ) // Only the 1st parameter is used
		if ( sscanf( param[ 0 ], " %x", &temp ) == 0 )
			cmd = _HELP;	//	Error, no value scanned

	switch ( cmd )	{
		case _SET	:	// write interface-select register back to CR0x2A
			write_CR( 0x2A, intsel.byte );
			sprintf( msg.temp, "\n\nNew RAM-type = %d",
               	intsel.name.ramtype );
			strcat( msg.text, msg.temp );
			break;
		case _GET :	case _HELP:	sprintf( msg.temp, "%s%s%s",
			 "\n\nFramebuffer RAM type (not applicable for UMA systems)",
			 "\n\t0 RESERVED (SDRAM)\n\t1 EDO timing mode\n\t2 RESERVED",
			 "\n\t3 FPM timing mode\n\n(enter a single value from 0-3)");
			strcat( msg.text, msg.temp );
			break;
		default:
			sprintf( msg.text, "_TR9660::_fxn1(cmd)  UNRECOGNIZED cmd.");
			status = EXIT_FAILURE;
	}
}


void		// Single cycle memory prefetch ( Providia 9685 ), CR register 0x64
_TR9660::_fxn2( int cmd )
{
	int temp;

	if ( cmd == _QUERY )	{
		strcpy(msg.text,"2  9685 EDO mode control (Providia9685 only)\n");
		return;
	}

	union	// New EDO register
	{
		uchar byte;	// 8-bit byte representation of register

          struct
		{
			unsigned casi : 3;	// single cycle CASI adjustment
	          unsigned cas : 3;	// single cycle CAS adjustment
	          unsigned latch : 1;		// enable EDO memory data latch
               unsigned newedo : 1;	// enable single cycle FIFO prefetch
          } name;	// Named bit fields in register

	} _CR64; // CR register 0x64

     _CR64.byte = read_CR( 0x64 );  // load _CR64 with register value

     sprintf( msg.text, "Currently, single cycle EDO prefetch is %sd",
		bitstat( _CR64.name.newedo ) );  // print "enable" or "disable"

	if ( num_param >= 1 ) {
		_CR64.name.newedo = ( (uchar)atoi( param[ 0 ] ) ) & 0x01;
	}

	if ( param[ 0 ] != NULL ) // Only the 1st parameter is used
		if ( sscanf( param[ 0 ], " %x", &temp ) == 0 )
			cmd = _HELP;	//	Error, no value scanned

	switch ( cmd )	{
		case _SET	:	// write interface-select register back to CR0x2A
			write_CR( 0x64, _CR64.byte );
               _CR64.byte = read_CR( 0x64 );  // re-read CR64 register
			sprintf( msg.temp, "\nSingle cycle timing is now %sd!",
               	bitstat( _CR64.name.newedo ) );
			strcat( msg.text, msg.temp );
			break;
		case _GET :	case _HELP:	sprintf( msg.temp, "%s%s%s",
			"\n\n\t1 = ENABLE single-cycle EDO timing for prefetch",
			"\n\t0 = DISABLE single-cycle EDO timing (use 2-cycle EDO)",
			"\n\n(This setting only applies to Providia9685 in EDO mode)");
			strcat( msg.text, msg.temp );
			break;
		default:
			sprintf( msg.text, "_TR9660::_fxn2(cmd)  UNRECOGNIZED cmd.");
			status = EXIT_FAILURE;
	}
}



void		//	MCLK programming for Trident 3D-975/985
_TR9750::_mclk( int cmd )
{
	int mclk;
     uchar _SR0E;	//	Register _SR0E, temp-holding place
     unsigned char new_N, new_M, new_P;

     union clockreg {

          unsigned int word;  // 16-bit access

     	struct { // 8-bit access
          	uchar b0;	//	Byte 0, SR16
               uchar b1;	//	Byte 1, SR17
          } b;

          struct {
               unsigned _N : 8;	// "N" = bits7:0 of 1st byte
               unsigned _M : 6;	// "M" = bits5:0 of 2nd byte
               unsigned _P : 2;	// "P" = bits7:6 of 2nd byte

		double freq( void )	// Returns calculated PLL frequency
               {
               	return ( ( _N + 8.0 ) * _OSC ) /
					( ( _M + 2.0 ) * pow(2.0, _P) );
	/*	Calculates MCLK frequency from N, M, P values
	 *	returns double value MHz, works for Trident 9750/9850
      *	( N + 8 )
	 *   --------- * _FREF ... _FREF = 14.31818 MHz
	 *   (M+2)*2^P
	 *
	 *	constraint:	0 < M < 127, 0 < N < 31, 0 < R < 3
	 *		and...	N >= 1
	 */
               };
          } name;	// Named registers
     };

     union clockreg dclk;
     union clockreg vclk;
           // DRAM Clock data structure, 16-bits total (2 bytes)


	if ( cmd == _QUERY )	{
		strcpy( msg.text, "0  3D-9750 MCLK programming\n" );
		return;
	}

     dclk.b.b0 = read_SR( 0x16 );	// Read DCLK registers
     dclk.b.b1 = read_SR( 0x17 );	// Read DCLK registers

     vclk.b.b0 = read_SR( 0x18 );	// Read DCLK registers
     vclk.b.b1 = read_SR( 0x19 );	// Read DCLK registers


     sprintf( msg.text, "Trident 3D-975 MCLK programming" );
	sprintf( msg.temp, "\nOld MCLK = %.2fMHz (%04X)", dclk.name.freq(),
	         dclk.word );
	strcat( msg.text, msg.temp );
	sprintf( msg.temp, "\nscale = %d (dec), divisor = %X, pdiv = %d (dec)",
		dclk.name._N, dclk.name._M, dclk.name._P );
	strcat( msg.text, msg.temp );

     sprintf( msg.temp, "\nOld VCLK = %.2fMHz (%04X)", vclk.name.freq(),
	         vclk.word );
	strcat( msg.text, msg.temp );
	sprintf( msg.temp, "\nscale = %d (dec), divisor = %X, pdiv = %d (dec)",
		vclk.name._N, vclk.name._M, vclk.name._P );
	strcat( msg.text, msg.temp );


	if ( num_param < 3 && cmd == _SET )	{
		strcat( msg.text, "\nError!  THREE parameters required!");
		cmd = _HELP; }
	else	if ( num_param >= 3 ) {
	     new_N = ( (uchar)atoi( param[ 0 ] ) ) & 0xFF;
		new_M = ( (uchar)atoi( param[ 1 ] ) ) & 0x3F;
		new_P = ( (uchar)atoi( param[ 2 ] ) ) & 0x03;
	}

	if ( param[ 0 ] != NULL ) // Only the 1st parameter is used
		if ( sscanf( param[ 0 ], " %x", &mclk ) == 0 )
			cmd = _HELP;	//	Error, no value scanned

	switch ( cmd )	{
		case _SET	:
               dclk.name._N = new_N;
               dclk.name._M = new_M;
               dclk.name._P = new_P;

               _SR0E = read_SR( 0x0E );	// remember SR0E's old value
			write_SR( 0x0E, _SR0E | 0x82 );	// 1XXX XX1X
				// To update MCLK, bits 1 & 7 must be SET
               write_SR( 0x16, dclk.b.b0 ); // write dclk byte0
               write_SR( 0x17, dclk.b.b1 ); // write dclk byte1
			write_SR( 0x0E, _SR0E );	// Restore _SR0E to original value!


               dclk.b.b0 = read_SR( 0x16 );	// Re-Read DCLK registers
               dclk.b.b1 = read_SR( 0x17 );	// Re-Read DCLK registers

               sprintf( msg.temp, "\nNew MCLK = %.2fMHz (%04X)",
                        dclk.name.freq(), dclk.word );
			strcat( msg.text, msg.temp );
			break;
		case _GET :	case _HELP:	sprintf( msg.temp, "%s%s%s%s%s%s",
			 "\n  Note:  Trident 9750/9850 MCLK max = 83MHz",
			 "\n         Trident 9880/9880T MCLK max = 110MHz/135MHz",
			 "\n\t mclk = 14.31818MHz * ( scale+8 ) / ( ( divisor+2 )",
			 " * ( 2 ^ pdiv ) )",
			 "\n\t Input: mclk /0 SCALE DIVISOR PDIV (3 parameters)",
			 "\n\t        scale = 0-127, divisor = 0-64, pdiv = 0-3" );
			strcat( msg.text, msg.temp );
			break;

		default:
			sprintf( msg.text, "_TR9750::_mclk(cmd)  UNRECOGNIZED cmd.");
			status = EXIT_FAILURE;
	}
}
