//	Matrox Graphics header file matrox.h
//
//	Contains class definitions for Matrox Mystique (1064SG) chipsets
//
//

//	The following line denies outside code access to certain
//	member functions of class vga.
#define __matrox_h
#include "vga.h"

class _Mystique : public vga	{		// Matrox 1064SG
	// Note, all Mystique (1064SG) are PCI-only devices
protected:
     uchar read_base0( uint offset );	// Read byte from { BA0 + offset }
	void write_base0( uint offset, uchar value ); // Write byte to ...
     uchar read_cbyte( const uchar index );
     	// Read PCI-configuration register, index 0-255
     uchar write_cbyte( const uchar index, const uchar value );
     	// Write value -> PCI-config(index)
     uchar read_indirect( const uint index );
     	// Read Matrox MMIO (indirect) registers,
		// "index" = byte address offset ($0000 - $3FFF) from MGABASE1
     uchar write_indirect( const uint index, const uchar value );
     	// Write value -> MMIO (MGABASE1 + index ),
          // again, "index" = byte address ($0000 -$3FFF) from MGABASE1
     uchar read_x( const uchar index );
     	// Read Matrox "X"-indexed registers, through the port at
		// MMIO location : MGABASE1 + $3C0A
     uchar write_x( const uchar index, const uchar value );
     	// Write value -> X-DATAreg ),

     union {
     	struct
          {
          	uchar b0;
               uchar b1;
          } b;	// data byte values

          struct
          {
			unsigned reserved1:2;
               unsigned index:12;
               unsigned reserved2:2;
          } name;	// Named bitfields
     } mga_index;	// 16-bit register

     void mga_index_load( void )	// Load MGA registers into object data bytes
     {
		mga_index.b.b0 = read_cbyte( 0x44 );	// Read bits 7-0
		mga_index.b.b1 = read_cbyte( 0x45 );	// Read bits 15-8
     };

     void mga_index_store( void )	// Store object contents to MGA register
     {
		write_cbyte( 0x44, mga_index.b.b0 );	// Write bits 7-0
		write_cbyte( 0x45, mga_index.b.b1 );	// Write bits 15-8
     };

     void set_sysclkdis( uchar bit );	// Disable system-clock output
     	// 1 = DISABLE OUTPUT, 0 = ENABLE OUTPUT
     void set_sysclksl( uchar bits );	// Select system-clock source

     double fvco( uchar n, uchar m )	// Calculate FVCO frequency
		{	return ( _OSC * ( n + 1.0 ) ) / ( m + 1.0 );	};

public:
	message _info( void );		//	Return silicon Revision#
	void _mclk( int cmd );		//	MCLK programming function
	void _fxn1( int cmd );		//	Memory control wait-state
	void _fxn2( int cmd );		//	GCLK/MCLK divider control
	pci_bios_type *pci_bios;		//  Needed for PCI autodetect routine
	pci_device_handle_type pci_vga;	// Needed for PCI autodetect

     _Mystique( vga_info info );//	Constructor
     ~_Mystique();	// Destructor

};
