/* ------------------------ */
/* SAMPLE CLOCK DISPLAY TSR */
/* ------------------------ */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

extern int _argc;
extern char **_argv;

#define  TSR_ID          0xF0                   /* TSR's MULTIPLEX ID   */
#define  INSTALLED       0x00                   /* Installed state req. */
#define  UNLOAD_THYSELF  0x01                   /* Unload request...    */


/* -------------------------------------------------------------------- */
/* The following combines a character and attribute into a 16-bit word  */
/* which can be poked into video memory...                              */
/* -------------------------------------------------------------------- */
#define MK_INT(ch, at) ((ch & 0xFF ) | ( at << 8 ))



/* ----------------------- [ EMIT DEFINITION ] ------------------------ */
/* This example uses the BIOS INT 1A to retrieve the time from the Real */
/* Time Clock.  Function 2 of the interrupt returns the current time in */
/* BCD format.. The following converts the BCD value in AL to is ascii  */
/* representation and stores the result in the buffer pointed to by     */
/* ES:DI.                                                               */
/* -------------------------------------------------------------------- */
#define _BCD2ASCII   __emit__( 0x8A,0xE0,0xC0,0xEC,0x04,0x24,     \
                               0x0F,0x0D,0x30,0x30,0x86,0xC4,0xAB )
#define _CLD         __emit__( 0xFC )       /* Clr Direction Flag Opcode*/



#ifdef __cplusplus                      
typedef void interrupt (*intFunc)(...);
#else
typedef void interrupt (*intFunc)();
#endif

intFunc old10Vector, old2FVector;



static  unsigned int mode13subst =0x163;
static  unsigned  far ProcessToBeTerminated;



/* ----------------------[ HANDLER FOR INT 10h ]----------------------- */
/* This following is the Handler for Interrupt 1Ch.  The latter is      */
/* asynchronously from INT 8h - We ( nicely ) chain to the prior Handler*/
/* prior to update our Time Display( if necessary ).                    */
/* -------------------------------------------------------------------- */
void interrupt new10Vector(unsigned bp, unsigned di, unsigned si,
					  unsigned ds, unsigned es, unsigned dx,
                           unsigned cx, unsigned bx, unsigned ax, 
					  unsigned ip, unsigned cs, unsigned flags)
{
	_BX  =   bx;                             /* Restore value of BX  */
	_CX  =   ax;                             /* Save AX in CX        */
	ax  =   FP_SEG((void far *)old10Vector);/* Place Addr of OldISR */
	bx  =   FP_OFF((void far *)old10Vector);/*      on the stack... */
	_AX  =  _CX  ;                           /* Restore AX           */
	__emit__(0x5D);          /* asm  POP BP   -> Restore BP           */
	__emit__(0x5F);          /* asm  POP DI   -> Restore DI           */
	__emit__(0x5E);          /* asm  POP SI   -> Restore SI           */
	__emit__(0x1F);          /* asm  POP DS   -> Restore DS           */
	__emit__(0x07);          /* asm  POP ES   -> Restore ES           */
	__emit__(0x5A);          /* asm  POP DX   -> Restore DX           */
	__emit__(0x59);          /* asm  POP CX   -> Restore CX           */

    if ( _AX == 0x0013 )	/* is incoming call set mode13h?	*/
    {
	_AX = 0x4F02;	/* VESA VBE function 0x02, set Super VGA Display Mode */
	_BX = 0x163;	  /* Substitute for VGA mode 13h */
    }
	__emit__(0xCB);          /* asm  RETF     -> Indirect Far         */
						 /*                  Jmp to OldISR        */

/*    ( *old10Vector )();                          Chain to old Handler */
}


#pragma option -w-par                           
/* ----------------------[ HANDLER FOR INT 2Fh ]----------------------- */
/* The following is our Multiplex Handler...  It enables a second copy  */
/* of the TSR to communicate with a resident copy...                    */
/* -------------------------------------------------------------------- */
void interrupt new2FVector(unsigned bp, unsigned di, unsigned si, 
                           unsigned ds, unsigned es, unsigned dx, 
                           unsigned cx, unsigned bx, unsigned ax, 
                           unsigned ip, unsigned cs, unsigned flags)
{
    if ( _AH != TSR_ID )                        /* Our ID ?             */
    {                                           /* Nope,  we're chaining*/
       _BX  =   bx;                             /* Restore value of BX  */
       _CX  =   ax;                             /* Save AX in CX        */
        ax  =   FP_SEG((void far *)old2FVector);/* Place Addr of OldISR */
	   bx  =   FP_OFF((void far *)old2FVector);/*      on the stack... */
       _AX  =  _CX  ;                           /* Restore AX           */
      __emit__(0x5D);          /* asm  POP BP   -> Restore BP           */
      __emit__(0x5F);          /* asm  POP DI   -> Restore DI           */
      __emit__(0x5E);          /* asm  POP SI   -> Restore SI           */
      __emit__(0x1F);          /* asm  POP DS   -> Restore DS           */
      __emit__(0x07);          /* asm  POP ES   -> Restore ES           */
      __emit__(0x5A);          /* asm  POP DX   -> Restore DX           */
      __emit__(0x59);          /* asm  POP CX   -> Restore CX           */
      __emit__(0xCB);          /* asm  RETF     -> Indirect Far         */
                               /*                  Jmp to OldISR        */
    }
    if ( _AL == INSTALLED )                     /* Presence Request !   */
    {
         ax  = ( TSR_ID << 8 ) | 0xFF;          /* Respond Positively.. */
         bx  =  _psp;                           /* Send back our PSP    */
    }
    if ( _AL == UNLOAD_THYSELF )                /* Unload   Request !   */
    {
	   if ( (getvect( 0x10 )== ( intFunc )new10Vector) &&
		   (getvect( 0x2F )== ( intFunc )new2FVector ))
	   {
		  setvect( 0x10, old10Vector );       /* Unhook vectors if we */
            setvect( 0x2F, old2FVector );       /* still *own* 'em      */
            ax = 0x00;                          /* Flag success...      */
        }
        else
            ax =  -1 ;                          /* Flag Failure...      */
    }
}
#pragma option -wpar.

    

#pragma option -k-
/* -------------------[ ALLOCATE SOME CODE SEGMENT SPACE ]------------- */
/* The following function is just a way to reserve some space ( for     */
/* storage purposes ) in the Code Segment...  The function should       */
/* therefore NEVER be called ( no matter how hard the need to do so may */
/* be )                                                                 */
/* -------------------------------------------------------------------- */
static void CodeSegmentBuffer( void )
{
    __emit__( 0x9090, 0x9090, 0x9090, 0x9090, 0x9090, 0x9090 );
}


/* --------[ CONTROL RETURNS HERE WHEN TERMINATING RESIDENT COPY ]----- */
/* This function is where ( hopefully ) control should return once we   */
/* terminate the resident copy of our TSR...  It merely restores the    */
/* value of some registers ( since earlier versions of DOS may not      */
/* preserve them ) and returns                                          */
/* -------------------------------------------------------------------- */
static int LandingField( void )
{
    _BX  = FP_OFF( CodeSegmentBuffer );
    _SS  = *(( unsigned _cs * )( _BX ));
    _SP  = *(( unsigned _cs * )( _BX + 2 ));
    _DS  = *(( unsigned _cs * )( _BX + 4 ));
    return( 0 );
}


/* ------------------------- [ TERMINATE A PROCESS ] ---------------------- */
/* This function terminates the process whose PSP is saved in the variable  */
/* ProcessToBeTerminated -  This function should never really terminate -   */
/* Control should return to our application at the LandingField().          */
/* ------------------------------------------------------------------------ */
int TerminateProcess( void )
{
    _BX  = FP_OFF( CodeSegmentBuffer );
    *(( unsigned _cs * )( _BX ))     = _SS;
    *(( unsigned _cs * )( _BX + 2 )) = _SP;
    *(( unsigned _cs * )( _BX + 4 )) = _DS;
    
    _ES  = ProcessToBeTerminated;
    *(( unsigned _es * )( 0x16)) = _psp;
    *(( unsigned _es * )( 0x0C)) = _CS;
    *(( unsigned _es * )( 0x0A)) = FP_OFF( LandingField );

    _BX  = ProcessToBeTerminated ;
    _AH  = 0x50;
     geninterrupt( 0x21 );

    _AX  = 0x4C00;
     geninterrupt( 0x21 );

    /* ------------------------------------------------- */
    /* If all's OK, we should never execute the following*/
    /* piece of code... but should plop on the           */
    /* LandingField().. ( What a trip ! )                */
    /* ------------------------------------------------- */
     return( -1 );
}
#pragma option -k.    




#if defined(__TINY__) || defined(__SMALL__)  || defined(__MEDIUM__)
unsigned _heaplen = 512;
unsigned _stklen  = 1024;
#define  _keepSize  (( _SS - _psp ) + ( (_SP+15) >> 4 ))
#else
#define  _keepSize  (( _SS - _psp ) + 1 )
#endif



/* --------------------[ TSR INITIALIZATION ROUTINE ]---------------------- */
/* This is the TSR initialization routine...  It merely hooks the relevant  */
/* vectors and initializes the address of video memory where output will be */
/* performed..                                                              */
/* ------------------------------------------------------------------------ */
void init()
{
    old10Vector = getvect( 0x10 );
    old2FVector = getvect( 0x2F );
    setvect( 0x10, ( intFunc )new10Vector );
    setvect( 0x2F, ( intFunc )new2FVector );
}



int main( void )
{

   unsigned int new_mode13;
   _AX = ( TSR_ID << 8 )|INSTALLED;
    geninterrupt( 0x2F );

    if ( _AX == ((TSR_ID << 8)|0xFF ))
    {
	   ProcessToBeTerminated = _BX;
	  _AX = ( TSR_ID << 8 )|UNLOAD_THYSELF;
	   geninterrupt( 0x2F );
	   if ( _AX == 0 && ( TerminateProcess() == 0x00 ))
		  puts( ">M13SPEED: Now unloaded!\n" );
	   else
		  puts( ">M13SPEED: Unable to Unload!\n" );
    }
    else
    {
//	   if ( _argc == 1 && sscanf( _argv[ 1 ], "%X", &new_mode13 ) == 1 )
//		mode13subst = new_mode13;
	   init();
	   puts( ">M13SPEED: TSR loaded with 0x163 as mode13 substitute!\n" );
	   keep( 0, _keepSize );
    }
    return( 0 );
}