/*
 * 08/07/96	v0.1
 *
 * ------------------------
 * M13SPEED by Royce Liao (liaor@uci.edu)

 <<<<<< THERE ARE TWO VERSIONS OF M13SPEED
 <<<<<< PRIMARY VERSION USES MODE VESA 0x100 (640x400x8) >>>>>>>>
 <<<<<< ALTERNATE VERSION USES MODE VESA 0x101 (640x480x8) >>>>>>>

 * ------------------------
 *
 * core TSR code (c) Borland corporation
 *
 * NOTICE----------------------------------------------------------------
 * This program is based on sample-code provided by Borland corporation.
 * http://www.borland.com
 * ----------------------------------------------------------------------
 *
 * m13speed is a DOS TSR which intercepts all VGA mode13h setvideomode
 * requests (int10)  When m13speed processes such a request, the resident
 * portion substitutes VESAsetmode (0x4F02) mode 0x100 (640x400x8).
 *
 * Finally, the resident code re-programs the VGA CRTC and SR registers
 * to emulate a 320x200 display field.  NOT COMPATIBLE WITH ALL VIDEO BOARDS.
 * Even though m13speed does not access any SVGA (proprietary) registers,
 * many chipsets don't react kindly to the dotclock/2 register bit being set.
 *
 * The comments are intended to help out amateur programmers, i.e.
 * novices (people like myself) without prior DOS/TSR programming experience.
 *
 * Compilation information
 * -----------------------
 *
 * Borland's Turbo C++ 3.0 DOS,
 * compiled with command-line compiler TCC.EXE
 *
 * TCC.EXE -mt m13speed.c
 *
 * I find the command-line compiler produces more compact executables than
 * the IDE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>


/* The following two macros are shortcuts for me...
 * from an assembly standpoint, the macros aren't 100% efficient
 * In this program, all VGA CRTC registers are accessed sequentially
 * (one after the other.)  The arrangement of the resident-code could
 * be made more efficient by manually issuing the assembly "out" (outport)
 * statements.  The macros offer superior code readability.
 *
 * WRITE_CR( X, Y ),
 *  where "X" = the CRTC register "index#"
 *        "Y" = data value to be loaded into CRTC register index#X
 */
#define WRITE_CR( X, Y )	outportb( 0x3D4, X ); outportb( 0x3D5, Y );
#define WRITE_SR( X, Y )	outportb( 0x3C4, X ); outportb( 0x3C5, Y );



extern int _argc;	/* DOS environment variable, # of command line params */
extern char **_argv; /* string table of the entered command-line params */

#define  TSR_ID          0xF0                   /* TSR's MULTIPLEX ID   */
#define  INSTALLED       0x00                   /* Installed state req. */
#define  UNLOAD_THYSELF  0x01                   /* Unload request...    */


/* -------------------------------------------------------------------- */
/* The following combines a character and attribute into a 16-bit word  */
/* which can be poked into video memory...                              */
/* -------------------------------------------------------------------- */
#define MK_INT(ch, at) ((ch & 0xFF ) | ( at << 8 ))



/* ----------------------- [ EMIT DEFINITION ] ------------------------ */
/* This example uses the BIOS INT 1A to retrieve the time from the Real */
/* Time Clock.  Function 2 of the interrupt returns the current time in */
/* BCD format.. The following converts the BCD value in AL to is ascii  */
/* representation and stores the result in the buffer pointed to by     */
/* ES:DI.                                                               */
/* -------------------------------------------------------------------- */
#define _BCD2ASCII   __emit__( 0x8A,0xE0,0xC0,0xEC,0x04,0x24,     \
						 0x0F,0x0D,0x30,0x30,0x86,0xC4,0xAB )
#define _CLD         __emit__( 0xFC )       /* Clr Direction Flag Opcode*/



#ifdef __cplusplus
typedef void interrupt (*intFunc)(...);
#else
typedef void interrupt (*intFunc)();
#endif

intFunc old10Vector, old2FVector;

static  unsigned  far ProcessToBeTerminated;


/* ----------------------[ HANDLER FOR INT 10h ]----------------------- */
/* This following is the Handler for Interrupt 10h.  Do not remove the
/* formal parameter list.  The presence of the list happens to implicitly
/* tell the Turbo C++ compiler the proper size of the calling stack.
/* -------------------------------------------------------------------- */
void interrupt new10Vector(unsigned bp, unsigned di, unsigned si,
					  unsigned ds, unsigned es, unsigned dx,
					  unsigned cx, unsigned bx, unsigned ax,
					  unsigned ip, unsigned cs, unsigned flags)
{
	if ( _AX == 0x0013 )	/* is incoming call set mode13h? */
    {
		_AX = 0x4F02;	/* SetVESAmode function */
		_BX = 0x101;	/* VESA 0x100, 640x400x8bit */
                         /* VESA 0x101, 640x480x8bit */

		( *old10Vector )();	/* Chain to old int10h (video) Handler */
		ax = _AX;	/* Place new register(s) ax & bx values in stack */
		bx = _BX;	/* so registers ax & bx are properly preserved */

		/* Unprotect CR registers, just in case video BIOS locked them */
		WRITE_CR( 0x11, 0xE )

		/* Set HORIZONTAL DISPLAY TOTAL */
          WRITE_CR( 0, 0x2D )

          /* Set HORIZONTAL DISPLAY END */
		WRITE_CR( 1, 0x27 )

          /* Set HORIZONTAL BLANK START */
		WRITE_CR( 2, 0x28 )

          /* Set HORIXONTAL BLANK END */
		WRITE_CR( 3,  0x80 )

          /* Set HORIZONTAL SYNC START (RETRACE START) */
		WRITE_CR( 4, 0x2B)

          /* Set HORIZONTAL SYNC END (RETRACE END), and SYNC DELAY */
		WRITE_CR( 5, 1 )

          /* Set CRTC Scan Double, each data-line will be repeated once */
		WRITE_CR( 9, 0xC0 )

          /* Set the "display pitch" or CRTC OFFSET */
		WRITE_CR( 0x13, 0x28 )

          /* Set dotclock DIV 2 register, cut dot-clock input by half */
    		WRITE_SR( 1, 9 )

          return;	/* our mode13h routine ends HERE...*/
     }
    else
    {	/* If _AX != 0x0013, that is if int10h were called for some other
             reason, just pass the call to the original (old10Vector) int10h
		   handler. */
	     _BX  =   bx;   /* Restore value of BX  */
		_CX  =   ax;   /* Save AX in CX        */

		ax  =   FP_SEG((void far *)old10Vector);/* Place Addr of OldISR */
		bx  =   FP_OFF((void far *)old10Vector);/*      on the stack... */
    }
	_AX  =  _CX  ;                           /* Restore AX           */
     /* Since we're popping values from the stack...you may be wondering
        where did we ever "push" them onto the stack in the first place.
        Turbo C++ pushes all processor data registers onto the stack at
        the BEGINNING of any interrupt service routine...which is what
        this routine is.  So now we need to pop them.  Otherwise, each
        time int10h is accessed, the stack will increase in size until
        an overflow occurs...and we don't want that to happen.
     */

	__emit__(0x5D);          /* asm  POP BP   -> Restore BP           */
	__emit__(0x5F);          /* asm  POP DI   -> Restore DI           */
	__emit__(0x5E);          /* asm  POP SI   -> Restore SI           */
	__emit__(0x1F);          /* asm  POP DS   -> Restore DS           */
	__emit__(0x07);          /* asm  POP ES   -> Restore ES           */
	__emit__(0x5A);          /* asm  POP DX   -> Restore DX           */
	__emit__(0x59);          /* asm  POP CX   -> Restore CX           */

	__emit__(0xCB);          /* asm  RETF     -> Indirect Far         */
						 /*                  Jmp to OldISR        */

}


#pragma option -w-par
/* ----------------------[ HANDLER FOR INT 2Fh ]----------------------- */
/* The following is our Multiplex Handler...  It enables a second copy  */
/* of the TSR to communicate with a resident copy...                    */
/* -------------------------------------------------------------------- */
void interrupt new2FVector(unsigned bp, unsigned di, unsigned si, 
                           unsigned ds, unsigned es, unsigned dx, 
                           unsigned cx, unsigned bx, unsigned ax, 
                           unsigned ip, unsigned cs, unsigned flags)
{
    if ( _AH != TSR_ID )                        /* Our ID ?             */
    {                                           /* Nope,  we're chaining*/
       _BX  =   bx;                             /* Restore value of BX  */
       _CX  =   ax;                             /* Save AX in CX        */
        ax  =   FP_SEG((void far *)old2FVector);/* Place Addr of OldISR */
	   bx  =   FP_OFF((void far *)old2FVector);/*      on the stack... */
       _AX  =  _CX  ;                           /* Restore AX           */
      __emit__(0x5D);          /* asm  POP BP   -> Restore BP           */
	 __emit__(0x5F);          /* asm  POP DI   -> Restore DI           */
      __emit__(0x5E);          /* asm  POP SI   -> Restore SI           */
      __emit__(0x1F);          /* asm  POP DS   -> Restore DS           */
      __emit__(0x07);          /* asm  POP ES   -> Restore ES           */
      __emit__(0x5A);          /* asm  POP DX   -> Restore DX           */
      __emit__(0x59);          /* asm  POP CX   -> Restore CX           */
      __emit__(0xCB);          /* asm  RETF     -> Indirect Far         */
                               /*                  Jmp to OldISR        */
    }
    if ( _AL == INSTALLED )                     /* Presence Request !   */
    {
         ax  = ( TSR_ID << 8 ) | 0xFF;          /* Respond Positively.. */
         bx  =  _psp;                           /* Send back our PSP    */
    }
    if ( _AL == UNLOAD_THYSELF )                /* Unload   Request !   */
    {
	   if ( (getvect( 0x10 )== ( intFunc )new10Vector) &&
		   (getvect( 0x2F )== ( intFunc )new2FVector ))
	   {
		  setvect( 0x10, old10Vector );       /* Unhook vectors if we */
		  setvect( 0x2F, old2FVector );       /* still *own* 'em      */
            ax = 0x00;                          /* Flag success...      */
        }
        else
            ax =  -1 ;                          /* Flag Failure...      */
    }
}
#pragma option -wpar.

    

#pragma option -k-
/* -------------------[ ALLOCATE SOME CODE SEGMENT SPACE ]------------- */
/* The following function is just a way to reserve some space ( for     */
/* storage purposes ) in the Code Segment...  The function should       */
/* therefore NEVER be called ( no matter how hard the need to do so may */
/* be )                                                                 */
/* -------------------------------------------------------------------- */
static void CodeSegmentBuffer( void )
{
    __emit__( 0x9090, 0x9090, 0x9090 );
    /* Don't shorten the dummy bytes' length...otherwise m13speed will
       crash! */
}


/* --------[ CONTROL RETURNS HERE WHEN TERMINATING RESIDENT COPY ]----- */
/* This function is where ( hopefully ) control should return once we   */
/* terminate the resident copy of our TSR...  It merely restores the    */
/* value of some registers ( since earlier versions of DOS may not      */
/* preserve them ) and returns                                          */
/* -------------------------------------------------------------------- */
static int LandingField( void )
{
    _BX  = FP_OFF( CodeSegmentBuffer );
    _SS  = *(( unsigned _cs * )( _BX ));
    _SP  = *(( unsigned _cs * )( _BX + 2 ));
    _DS  = *(( unsigned _cs * )( _BX + 4 ));
    return( 0 );
}


/* ------------------------- [ TERMINATE A PROCESS ] ---------------------- */
/* This function terminates the process whose PSP is saved in the variable  */
/* ProcessToBeTerminated -  This function should never really terminate -   */
/* Control should return to our application at the LandingField().          */
/* ------------------------------------------------------------------------ */
int TerminateProcess( void )
{
    _BX  = FP_OFF( CodeSegmentBuffer );
    *(( unsigned _cs * )( _BX ))     = _SS;
    *(( unsigned _cs * )( _BX + 2 )) = _SP;
    *(( unsigned _cs * )( _BX + 4 )) = _DS;
    
    _ES  = ProcessToBeTerminated;
    *(( unsigned _es * )( 0x16)) = _psp;
    *(( unsigned _es * )( 0x0C)) = _CS;
    *(( unsigned _es * )( 0x0A)) = FP_OFF( LandingField );

    _BX  = ProcessToBeTerminated ;
    _AH  = 0x50;
     geninterrupt( 0x21 );

    _AX  = 0x4C00;
     geninterrupt( 0x21 );

    /* ------------------------------------------------- */
    /* If all's OK, we should never execute the following*/
    /* piece of code... but should plop on the           */
    /* LandingField().. ( What a trip ! )                */
    /* ------------------------------------------------- */
     return( -1 );
}
#pragma option -k.    




#if defined(__TINY__) || defined(__SMALL__)  || defined(__MEDIUM__)
unsigned _heaplen = 512;
unsigned _stklen  = 1024;
#define  _keepSize  (( _SS - _psp ) + ( (_SP+15) >> 4 ))
#else
#define  _keepSize  (( _SS - _psp ) + 1 )
#endif



/* --------------------[ TSR INITIALIZATION ROUTINE ]---------------------- */
/* This is the TSR initialization routine...  It merely hooks the relevant  */
/* vectors and initializes the address of video memory where output will be */
/* performed..                                                              */
/* ------------------------------------------------------------------------ */
void init()
{
    old10Vector = getvect( 0x10 ); /* get old video interrupt vector */
    old2FVector = getvect( 0x2F ); /* get old 0x2F interrupt vector */

    /* The following statement adds m13speed's ISR routine to int0x10 */
    setvect( 0x10, ( intFunc )new10Vector );

    /* The following statement adds m13speed's 0x2F routine to int0x2f,
	  I think it's for identification and unloading purposes.*/
    setvect( 0x2F, ( intFunc )new2FVector );
}



int main( void )
{

   _AX = ( TSR_ID << 8 )|INSTALLED;
    geninterrupt( 0x2F );

    /* Is m13speed already installed? */
    if ( _AX == ((TSR_ID << 8)|0xFF ))
    {
	   ProcessToBeTerminated = _BX;
	  _AX = ( TSR_ID << 8 )|UNLOAD_THYSELF;
	   geninterrupt( 0x2F );
	   if ( _AX == 0 && ( TerminateProcess() == 0x00 ))
		  puts( ">M13SPEED: TSR now unloaded!\n" );
	   else
		  puts( ">M13SPEED: TSR Unable to Unload!\n" );
    }
    else
    {
	   init();
	   puts( ">M13SPEED: TSR loaded! Using VESA 101h as MCGA 13h substitute!\n" );
	   keep( 0, _keepSize );
    }
    return( 0 );

    /* Why use puts() instead of printf() ? Library-code for puts() is
       smaller.  Since the entire program must remain resident, and not just
	  our small int10 routine, we want to minimize the program's overall
	  size.

       If you were to rewrite m13speed in assembly, you could arrange the
       code so that the init() routine could "toss out" the nonessential
       parts of m13speed.  As it is, invoking m13speed causes the ENTIRE
	  program to go resident.  Kinda inefficent, but oh well...

       Furthermore, this program has NO stack...so using printf(), scanf(),
       and too many local variables would cause unpredictable behavior.
       Another reason to avoid printf()...
    */
}