.286
;-SET-VECTORS-MACRO-----
SET_VEC		MACRO	INT_NUM,HANDLER,OLD
		MOV	AX,3500H+INT_NUM
		INT	21H
		MOV	WORD PTR OLD,BX
		MOV	WORD PTR OLD+2,ES
		MOV	AX,2500H+INT_NUM
		MOV	DX,OFFSET HANDLER
		INT	21H
		ENDM
;-EQUALS----------------
CR		EQU	0DH
LF		EQU	0AH
BUF_LENR	EQU	08H		; Default buffer length
BUF_LEN		EQU	20H
KB_FLAG		EQU	17H
KB_MASK		EQU	00000001B	; RIGHT_SHIFT
INC_KEY		EQU	4EH		; GREY_PLUS
DEC_KEY		EQU	4AH		; GREY_MINUS
P_DATA		EQU	278H		; Address of any free port
P_STAT		EQU	P_DATA+1
P_CONT		EQU	P_DATA+2
P_DAC		EQU	378H		; Address of DAC port
P_SDAC		EQU	P_DAC+2
P_NEST		EQU	40AH		; 408H - Lpt1  40CH - Lpt3
					; 40AH - Lpt2  40EH - Lpt4
TUNE_ATTR	EQU	0AH		; Green on black
RTC_SPEED	EQU	0100011B; 1111 - 2 Hz   1010 - 64 Hz   0101 - 2048 Hz
		;Divisor^^^^^^	; 1110 - 4 Hz   1001 - 128 Hz  0100 - 4096 Hz
		;Counter---	; 1101 - 8 Hz   1000 - 256 Hz  0011 - 8192 Hz
				; 1100 - 16 Hz  0111 - 512 Hz  0010&0001 - N/A
				; 1011 - 32 Hz  0110 - 1024 Hz 0000 - None
CSEG		SEGMENT
		ORG 100H
		ASSUME CS:CSEG,DS:CSEG
START:
		JMP	INIT_
;-INT-70H-HANDLER-------
INT70_HAND	PROC	NEAR
		CMP	BYTE PTR CS:INT70_ACT,1
		JNZ	INT70_EX
		CLI
		PUSH	AX CX DX SI DS CS
		POP	DS
		CLD
		MOV	SI,WORD PTR DS:DSS_OFFTIM
		MOV	DX,P_SDAC	; USE THIS
		MOV	AL,3		; ON STEREO-IN-ONE
		OUT	DX,AL		; ONLY!
		MOV	DX,P_DAC
INT70_3:
		OUTSB
		CMP	BYTE PTR DS:COUNT,0
		JZ	INT70_2
		DEC	BYTE PTR DS:COUNT
INT70_2:
		CMP	SI,OFFSET DSS_BUF+BUF_LEN
		JNZ	INT70_1
		MOV	SI,OFFSET DSS_BUF
INT70_1:
		MOV	WORD PTR DS:DSS_OFFTIM,SI
		CMP	SI,WORD PTR DS:DSS_OFFCAB
		JNZ	INT70_EX1
		MOV	BYTE PTR DS:INT70_ACT,0
INT70_EX1:
		POP	DS SI DX CX AX
		STI
INT70_EX:
		PUSH	AX
INT70_4:
		MOV	AL,0CH
		OUT	70H,AL
		IN	AL,71H
		TEST	AL,40H
		JNZ	INT70_4
		MOV	AL,20H
		OUT	0A0H,AL
		OUT	20H,AL
		POP	AX
		IRET
INT70_ACT	DB	0
INT70_HAND	ENDP
;-CALLBACK-FUNCTION-----
CALLB_FUN	PROC	NEAR
		PUSH	BX DS CS
		POP	DS
		MOV	BL,BYTE PTR DS:DSS_BUFLEN
		CMP	DX,P_DATA
		JZ	SEND_DATA
		CMP	DX,P_STAT
		JZ	GET_STAT
		CMP	DX,P_CONT
		JZ	SEND_STROB
		POP	DS BX
		STC
		RETF
SEND_DATA:
		OR	CL,CL
		JZ	CALLB_EX
		CMP	BYTE PTR DS:COUNT,BL
		JG	CALLB_EX
		PUSH	DI
		MOV	DI,WORD PTR DS:DSS_OFFCAB
		MOV	BYTE PTR DS:[DI],AL
		POP	DI
		JMP	CALLB_EX
GET_STAT:
		OR	CL,CL
		JNZ	CALLB_EX
		CMP	BYTE PTR DS:COUNT,BL
		JG	NOT_READY
		MOV	AL,0
		JMP	CALLB_EX
NOT_READY:
		MOV	AL,40H
		JMP	CALLB_EX
SEND_STROB:
		OR	CL,CL
		JZ	CALLB_EX
		CMP	BYTE PTR DS:COUNT,BL
		JG	CALLB_EX
		TEST	AL,8
		JNZ	CALLB_EX
		INC	BYTE PTR DS:COUNT
		PUSH	AX
		MOV	AX,WORD PTR DS:DSS_OFFCAB
		INC	AX
		CMP	AX,OFFSET DSS_BUF+BUF_LEN
		JNZ	SEND_1
		MOV	AX,OFFSET DSS_BUF
SEND_1:
		MOV	WORD PTR DS:DSS_OFFCAB,AX
		CMP	BYTE PTR DS:INT70_ACT,1
		JZ	ALR_ACT
		MOV	BYTE PTR DS:INT70_ACT,1
ALR_ACT:
		POP	AX
CALLB_EX:
		POP	DS BX
		CLC
		RETF
DSS_BUFLEN	DB	BUF_LENR
DSS_OFFCAB	DW	OFFSET DSS_BUF
DSS_OFFTIM	DW	OFFSET DSS_BUF
COUNT		DB	0
DSS_BUF		DB	BUF_LEN DUP (80H)
CALLB_FUN	ENDP
;-INT-09H-HANDLER-------
INT09_HAND	PROC	NEAR
		PUSH	ES AX
		PUSH	40H
		POP	ES
		TEST	BYTE PTR ES:KB_FLAG,KB_MASK
		JZ	INT09_EX
		MOV	AH,BYTE PTR CS:DSS_BUFLEN
		IN	AL,60H
		CMP	AL,INC_KEY
		JZ	INC_BUF
		CMP	AL,DEC_KEY
		JNZ	INT09_EX
	;-DECREASE-BUF--
		CMP	AH,1
		JZ	SET_BUFL
		DEC	AH
		JMP	SET_BUFL
	;-INCREASE-BUF--
INC_BUF:
		CMP	AH,BUF_LEN-1
		JZ	SET_BUFL
		INC	AH
SET_BUFL:
		MOV	BYTE PTR CS:DSS_BUFLEN,AH
		PUSH	BX
		XOR	AL,AL
		XCHG	AL,AH
		MOV	BX,0B800H
		MOV	ES,BX
		MOV	BL,10
		DIV	BL
		ADD	AX,3030H
		MOV	BX,78*2
		MOV	BYTE PTR ES:[BX],AL
		MOV	BYTE PTR ES:[BX+1],TUNE_ATTR
		MOV	BYTE PTR ES:[BX+2],AH
		MOV	BYTE PTR ES:[BX+3],TUNE_ATTR
		IN	AL,61H
		MOV	AH,AL
		OR	AL,80H
		OUT	61H,AL
		XCHG	AL,AH
		OUT	61H,AL
		MOV	AL,20H
		OUT	20H,AL
		POP	BX AX ES
		IRET
INT09_EX:
		POP	AX ES
		DB	0EAH		; JMP FAR
INT09_OLD	DD	?
INT09_HAND	ENDP
;-GET-QEMM-API-ADDRESS--
INIT_		LABEL	NEAR
		MOV	DX,OFFSET LOGO
		CALL	FAST_EX
		MOV	AH,3FH
		MOV	CX,5145H	; 'QE'
		MOV	DX,4D4DH	; 'MM'
		INT	67H
		OR	AH,AH
		JZ	CONT_1
		MOV	DX,OFFSET ERR_1
		JMP	FAST_EX
CONT_1:
		MOV	WORD PTR DS:API_SEG,ES
		MOV	WORD PTR DS:API_OFF,DI
;-CHECK-QEMM-STATE------
		MOV	AH,0
		CALL	QEMM_API
		TEST	AL,1
		JZ	CONT_2
		MOV	DX,OFFSET ERR_2
		JMP	FAST_EX
CONT_2:
		TEST	AL,2
		JZ	CONT_3
		MOV	DX,OFFSET ERR_3
		JMP	FAST_EX
CONT_3:
		MOV	DX,OFFSET SUC_1
		CALL	FAST_EX
;-CHECK-PORTS-TRAP------
		MOV	CX,3
		MOV	SI,OFFSET PORT_LIST
CONT_6:
		LODSW
		XCHG	DX,AX
		MOV	BP,DX
		MOV	AX,1A08H
		CALL	QEMM_API
		OR	BL,BL
		JZ	CONT_5
		MOV	DX,OFFSET ERR_5
		JMP	FAST_EX
CONT_5:
;-TRAP-DSS-PORTS--------
		MOV	AX,1A09H
		MOV	DX,BP
		CALL	QEMM_API
		JNC	CONT_4
		MOV	DX,OFFSET ERR_4
		JMP	FAST_EX
CONT_4:
		LOOP	CONT_6
;-SET-CALLBACK-ADDRESS--
		MOV	AX,1A07H
		PUSH	CS
		POP	ES
		MOV	DI,OFFSET CALLB_FUN
		CALL	QEMM_API
;-SET-NEW-LPT2-ADDRESS--
		XOR	AX,AX
		MOV	ES,AX
		MOV	WORD PTR ES:P_NEST,P_DATA
;-SET-VECTORS-----------
		MOV	DX,OFFSET SUC_3
		CALL	FAST_EX
		MOV	AX,2570H
		MOV	DX,OFFSET INT70_HAND
		INT	21H
;-IRQ8-INABLE-----------
		CLI
		IN	AL,0A1H
		AND	AL,0FEH
		OUT	0A1H,AL
;-SET-REAL-TIMER-ACTIVE-
		MOV	AL,0BH
		OUT	70H,AL
		IN	AL,71H
		AND	AL,7FH
		OR	AL,40H
		PUSH	AX
		MOV	AL,0BH
		OUT	70H,AL
		POP	AX
		OUT	71H,AL
;-SET-REAL-TIMER-SPEED--
		MOV	AL,0AH
		OUT	70H,AL
		IN	AL,71H
		AND	AL,80H
		OR	AL,RTC_SPEED
		PUSH	AX
		MOV	AL,0AH
		OUT	70H,AL
		POP	AX
		OUT	71H,AL
		STI
;-CALCULATE-BUFFER-LEN--
		MOV	BL,BUF_LEN-1	; START VALUE
CA_BU_4:
		MOV	BYTE PTR DS:DSS_BUFLEN,BL
		MOV	DX,P_CONT
		MOV	AL,4
		OUT	DX,AL
		MOV	CX,BUF_LEN
CA_BU_1:
		MOV	DX,P_DATA
		MOV	AL,80H
		OUT	DX,AL
		PUSH	AX
		POP	AX
		MOV	AL,0CH
		MOV	DX,P_CONT
		OUT	DX,AL
		PUSH	AX
		POP	AX
		PUSH	AX
		POP	AX
		MOV	AL,04H
		MOV	DX,P_CONT
		OUT	DX,AL
		LOOP	CA_BU_1
		MOV	DX,P_STAT
		IN	AL,DX
		OR	AL,AL
		JNZ	CA_BU_2
		MOV	DX,P_CONT
		MOV	AL,0CH
		OUT	DX,AL
		DEC	BL
		JZ	CA_BU_2
CA_BU_3:
		CMP	BYTE PTR DS:COUNT,0
		JNZ	CA_BU_3
		JMP	CA_BU_4
CA_BU_2:
;-WRITE-BUFFER-LENGTH---
		XOR	BH,BH
		MOV	AL,10
		XCHG	BX,AX
		DIV	BL
		ADD	AX,3030H
		INT	29H
		XCHG	AL,AH
		INT	29H
		MOV	DX,OFFSET SUC_4
		CALL	FAST_EX
;-SET-INT-09H-HANDLER---
		SET_VEC	09H,INT09_HAND,INT09_OLD
;-LEAVE-TSR-------------
		MOV	DX,OFFSET SUC_2
		CALL	FAST_EX
		MOV	DX,OFFSET INIT_
		INT	27H
;-CALL-QEMM-API---------
QEMM_API:
		DB	09AH		; CALL FAR
API_OFF		DW	0
API_SEG		DW	0
		RETN
;-FAST-EXIT-------------
FAST_EX:
		MOV	AH,9
		INT	21H
		RETN
;-PROGRAM-DATA----------
PORT_LIST	DW	P_DATA,P_STAT,P_CONT
LOGO		DB	'DSS Emulator v0.05 by SkullC0DEr',CR,LF,'$'
ERR_1		DB	'QEMM Not installed!',CR,LF,'$'
ERR_2		DB	'QEMM Is turned off!',CR,LF,'$'
ERR_3		DB	'QEMM Is in AUTO mode!',CR,LF,'$'
ERR_4		DB	'Error while trapping ports!$',CR,LF,'$'
ERR_5		DB	'Port already trapped!',CR,LF,'$'
SUC_1		DB	'QEMM Is OK.',CR,LF,'$'
SUC_2		DB	'You now have real DSS on Lpt2!',CR,LF
		DB	'Key usage:',CR,LF
		DB	'Right_Shift+Grey_Minus to decrease buffer',CR,LF
		DB	'Right_Shift+Grey_Plus to increase buffer',CR,LF
		DB	'Exiting.',CR,LF,'$'
SUC_3		DB	'DSS Buffer length is now $'
SUC_4		DB	' Bytes.',CR,LF,'$'

CSEG		ENDS
		END	START
