/* ****************************************************************
 * ctscreen v 1.20 
 * 
 * (c) by Redaktion c't , Verlag Heinz Heise
 *
 * Written by A. Eschenburg
 *
 * ---------------------------------------------------------------
 * last change : 070598
 *****************************************************************/
import  java.awt.*;
import  java.applet.Applet;
import  java.awt.event.*;
import  java.awt.image.*;
import  java.util.*;
import  java.io.*;
import  java.net.*;

/* ****************************************************************
 * ctMenu
 *
 *
 */

class ctMenu extends PopupMenu {
  ctscreen mainapp;
  ctMenu(ctscreen ma) {
    super ();
      if (ma.getMainWindow().NoVariants>1) {
        add(ma.NPAGE);
        addSeparator();
    }
      ma.getMainWindow().addSecVariantMenu(this);
      add(ma.MCLOSE);
      addSeparator();
    for (int i=0;i<7;i++)
      add(ma.carr[i]);
    addSeparator();
    add(ma.HELP);
    addSeparator();
    add(ma.ZURUECK);
    mainapp=ma;
  }

  public void Init(int x, int y) {
    show(mainapp.getMainWindow(),x-5,y-5);
  }

}

/* ****************************************************************
 * ctMouseAction
 *
 *
 */

class ctMouseAction implements MouseListener {
  ctscreen mainapp;
  ctMenu Menu=null;

  ctMouseAction(ctscreen ma) {
    mainapp=ma;
  }


  public void mousePressed(MouseEvent e)
  { // wird aufgerufen sobald ein Mausknopf gedrckt wird.
    if (Menu==null) {
      // neues Men
      Menu=new ctMenu(mainapp); 
      // Event-Listener mitteilen
      Menu.addActionListener(new ctAction(mainapp));    
    }
    // Men an das Fenster anhngen
    mainapp.getMainWindow().add(Menu);                
    // Men auf der Mausposition darstellen
    Menu.Init(e.getX(),e.getY());                     
  }

// leerfun's die implementiert sein muessen
  public void mouseReleased(MouseEvent e) {}
  public void mouseClicked(MouseEvent e) {}
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}

}


/* ****************************************************************
 * ctAction
 *
 *
 */

class ctAction implements ActionListener {
  ctscreen mainapp;

  ctAction(ctscreen m) {
    mainapp=m;
  }

  public void actionPerformed(ActionEvent e)
  {
    if (e.getActionCommand()==mainapp.HELP) {
      mainapp.DisplayHelp(mainapp.getCurrentWindowIdx());
      return;
    }
    if (e.getActionCommand()==mainapp.NPAGE) {
    // nchste Variante des aktuellen Fensters
      mainapp.getMainWindow().SwapVariant(1);
      return;
    }
    if (e.getActionCommand()==mainapp.ZURUECK) {
    // Aktuelles fenster schliessen
      mainapp.removeDisplay();
      if (!mainapp.IsApplication()) {
        try {

          mainapp.getAppletContext().showDocument(
            new URL(mainapp.DocumentUrl.toString()+"#CTSCREEN")
                              );
        } catch (Exception ex) {
          return;
        }
      }
      return;
    }
    if (mainapp.ButtonPressed(e.getActionCommand())) return;
    mainapp.getMainWindow().checkSecVariantMenu(e.getActionCommand());
  }
}


/* ****************************************************************
 * ctFrameAction
 *
 *
 */

class ctFrameAction implements KeyListener, WindowListener {
  ctscreen mainapp;

  ctFrameAction(ctscreen m) {
    mainapp=m;
  }

  public void keyPressed(KeyEvent e) {

    if (mainapp.getCurrentWindowIdx()<0) return;
    switch (e.getKeyCode()) {
    case e.VK_LEFT:
      mainapp.getMainWindow().SwapVariant(1);
      e.consume();
    break;
    case e.VK_RIGHT:
      mainapp.getMainWindow().SwapVariant(-1);
      e.consume();
    break;
    case e.VK_PAGE_UP:
      if (mainapp.getCurrentWindowIdx()>0) {
        mainapp.SwapDisplay(mainapp.getCurrentWindowIdx()-1);
        e.consume();
        return;
      }
      mainapp.removeDisplay();
      e.consume();
    break;
    case e.VK_PAGE_DOWN:
      if ((mainapp.getCurrentWindowIdx()>=0) && (mainapp.getCurrentWindowIdx()<mainapp.MAXCARR)) {
        mainapp.SwapDisplay(mainapp.getCurrentWindowIdx()+1);
        e.consume();
        return;
      }
      mainapp.removeDisplay();
      e.consume();
    break;
    case e.VK_UP:
      mainapp.getMainWindow().SecVariants(1);
      e.consume();
    break;
    case e.VK_DOWN:
      mainapp.getMainWindow().SecVariants(-1);
      e.consume();
    break;
    case e.VK_ESCAPE:
      mainapp.removeDisplay();
      e.consume();
    break;
    case e.VK_F1:
        mainapp.DisplayHelp(mainapp.getCurrentWindowIdx());
    break;
  }
  }

  public void windowClosing(WindowEvent e)
  {
    mainapp.ButtonPressed(ctscreen.BEENDEN); // beenden button simulieren
  }

  public void keyReleased(KeyEvent e) {}
  public void keyTyped(KeyEvent e) {}
  public void windowOpened(WindowEvent e) {}
  public void windowClosed(WindowEvent e) {}
  public void windowIconified(WindowEvent e) {}
  public void windowDeiconified(WindowEvent e) {}
  public void windowActivated(WindowEvent e) {}
  public void windowDeactivated(WindowEvent e) {}

}

/* ****************************************************************
 * ctHelpWindow
 *
 *
 */

class ctHelpWindow extends Frame implements WindowListener, ActionListener {

  static final String CLOSE="Schliessen";
  static final String NEXT="Naechstes Thema";
  static final String PREV="Vorheriges Thema";
  static final String MAIN="Hauptfenster";

  TextArea tfield;
  int index;
  ctscreen mainapp;

  ctHelpWindow(int idx, ctscreen ma) {

    super("c't Monitor Test Program");
    tfield=new TextArea("",30,30,TextArea.SCROLLBARS_BOTH);
    tfield.setEditable(false);
    index=idx;
    mainapp=ma;
    MenuBar mb=new MenuBar();
    Menu m=new Menu("Datei",true);
    m.add(CLOSE);
    m.addActionListener(this);
    mb.add(m);

    m=new Menu("Themen",true);
    m.add(NEXT);
    m.add(PREV);
    m.addSeparator();
    for (int i=0;i<=ma.MAXCARR;i++)
      m.add(ma.carr[i]);
    m.addSeparator();
    m.add(MAIN);
    m.addActionListener(this);
    mb.add(m);

    setMenuBar(mb);

    add(tfield);
    this.setSize(500,300);
    this.addWindowListener(this);
  }
                                                 
  public void DisplayText(String name, int idx)
  {
    boolean FileFound;
    FileFound=true;
    char data[]=new char[65535];
    int n;

    index=idx;

    tfield.setText(name);
    this.setVisible(true);
  }
                                                 
  public void actionPerformed(ActionEvent e)
  {
    if (e.getActionCommand()==CLOSE)
    {
      setVisible(false);
      return;
    }
    if (e.getActionCommand()==NEXT)
    {
      mainapp.DisplayHelp(index+1);
      return;
    }
    if (e.getActionCommand()==PREV)
    {
      mainapp.DisplayHelp(index-1);
      return;
    }
    mainapp.DisplayHelp(e.getActionCommand());
  }

  public void windowClosing(WindowEvent e)
  {
    this.setVisible(false);
  }

  public void windowOpened(WindowEvent e) {}
  public void windowClosed(WindowEvent e) {}
  public void windowIconified(WindowEvent e) {}
  public void windowDeiconified(WindowEvent e) {}
  public void windowActivated(WindowEvent e) {}
  public void windowDeactivated(WindowEvent e) {}



}


/* ****************************************************************
 * TextCanvas
 *
 *
 */

class TextCanvas extends Canvas {
  String text;

  TextCanvas(String t)
  {
    super();
    text=t;
  }

  public void paint (Graphics g)
  {
    int x, y;
        Font font = g.getFont();
        FontMetrics fontMetrics = g.getFontMetrics();
        Dimension d=this.getSize();
        y=fontMetrics.getHeight();
        x=fontMetrics.stringWidth(text);
    g.setPaintMode();
    g.drawString(text,(d.width-x)/2,(d.height+y)/2);
  }
}

/* ****************************************************************
 * ctCheckBox
 *
 *
 */

class ctCheckbox extends Checkbox {

  int idx;
  ctCheckbox(int index, CheckboxGroup boxes, boolean  status)
  {
    super(ctscreen.cbarr[index],boxes,status);
    idx=index;
  }

  int getIndex() {
    return idx;
  }
}

/* ****************************************************************
 * imgcanvas
 *
 *
 */

class imgcanvas extends Canvas {

  Image theImage;
  imgcanvas(Image I) {
    super();
    theImage=I;
    setBackground(Color.white);
  }

  public void paint(Graphics g)
  {
    int x,y;
    x=(getSize().width-theImage.getWidth(this))/2;
    y=(getSize().height-theImage.getHeight(this))/2;
    g.drawImage(theImage,x,y,this);
  }
}


/* ****************************************************************
 * ctwindow
 *
 *
 */

class ctwindow extends Window {

static final String HLPTXT="Keine Hilfe Vorhanden";

  ctscreen mainapp; // Die Hauptklasse

  int Variant=0;    // Zhler fr die aktuelle Darstellung des Fensters
  int NoVariants=1; // Anzahl verschiedener Darstellungen dieses Fensters

  int wx,wy; // Breite und Hhe des Fensters.

  int NoSecondaries=1; // Anzahl mglicher Einstellungen des Zweitparameters.
  int SecondaryCounter=1; // Zhler fr zweiten Parameter bei der Fensterdarstellung.

  ctwindow(Frame f,ctscreen ma) {
    super(f);

    mainapp=ma;

    addMouseListener(new ctMouseAction(mainapp));
    addKeyListener(new ctFrameAction(mainapp));

    Variant=0;

  } // handle the constructor

  void setVariantNumber(int sw) {
    NoVariants=sw;
  }


  public void addSecVariantMenu(ctMenu m)
  {
  }


  public void checkSecVariantMenu(String caption)
  {
  }

  public void SecVariants(int dir)
  { // leere Funktion, wird vom ableitenden Klassen bei bedarf berladen
  }

  public void SwapVariant(int dir)
  {
    Variant=(NoVariants+Variant+dir) % NoVariants;
    InitVariant(Variant);
  }

  public void Init(int w, int h) {
    if (mainapp.IsApplication())
      setSize(w,h);
    else
      setSize(w,h+100);
    wx=w; wy=h;
    setVisible(true);
    setLocation(0,0);
    requestFocus();
  }


  void InitVariant(int sw) {}
  
  public void Uninitialize() {} 
  
  public void Tick() 
  {
  }

}


/* ****************************************************************
 * ctpumpbild
 *
 *
 */

class ctpumpbild extends ctwindow {

static final String HLPTXT="Pumpbild\n\n"+

"Das Pumpbild zeigt Schwchen im Hochspannungsteil des Monitors. Die\n"+
"abwechselnde Darstellung groer Schwarz- und Weiflchen sollte \n"+
"mglichst keinen Einflu auf Bildgre, -lage und -form haben. Bei \n"+
"schlechter Hochspannungsstabilisierung zuckt oder \"pumpt\" das Bild \n"+
"mehr oder weniger deutlich.\n"+

"Das Pumpbild verfgt ber zwei Varianten, die sich mit Pfeil-rechts \n"+
"und Pfeil-links umschalten lassen. Bei der einen Variante blinkt fast \n"+
"der gesamte Bildschirm, bei der anderen ist das mittlere Drittel \n"+
"jeweils invers zum oberen und unteren Drittel. Dabei zeigen sich \n"+
"Verzerrungen an dem die Bildbegrenzung markierenden Rahmen. Je \n"+
"strker dieser Rahmen verzerrt wird oder sich die Gesamtgre des \n"+
"Bild verndert, desto schlechter ist die Hochspannungsstabilisierung. \n"+
"Gute Gerte zeigen keine oder nur minimale Abweichungen.\n"+

"Die Bild-Auf-Taste zeigt das Fenster zur Beurteilung der Farbkonstanz, \n"+
"die Bild-Ab-Taste schliet das Testfenster. Auch \"Escape\" schliet das \n"+
"Testfenster und wechselt zum Hauptmen.";


  int timer=120;
  int pmode=0;
  int istime=0;

  static final String NEXT="  Hoehere Pumpfrequenz";
  static final String PREV="  Niedrigere Pumpfrequenz";

  ctpumpbild(Frame f,ctscreen mx) {
    super(f,mx);
    NoSecondaries=0;
    SecondaryCounter=0;
    setVariantNumber(2);
    setBackground(Color.black);
    timer=120;
  }

  public void InitVariant(int sw)
  {
    pmode=sw+1;
    this.repaint();
  }
   
  public void SecVariants(int dir)
  {
    timer =timer-(20*dir);
    if (timer<20) timer=20;
    if (timer>1000) timer = 1000;
  }

  public void addSecVariantMenu(ctMenu m)
  {
      m.add(NEXT);
      m.add(PREV);
      m.addSeparator();
  }

  public void checkSecVariantMenu(String caption)
  {
    if (caption==NEXT)
      SecVariants(1);
    if (caption==PREV)
      SecVariants(-1);
  }


  public void Tick()
  {
    istime++;
    if (istime>timer) {
      istime=0;
      pmode=-pmode;
      this.repaint();
    }
  }
  
  public void Init(int w, int h) {
    int x,y;
    float ratio;

    super.Init(w,h);
    pmode=-1;
  }

  public void paint(Graphics  g)
  {
    g.setColor(Color.white);
    g.drawLine(0,0,wx,0);
    g.drawLine(0,0,0,wy);
    g.drawLine(wx-1,0,wx-1,wy);
    g.drawLine(0,wy-1,wx,wy-1);
    switch (pmode) {
    case -1:
      g.setColor(Color.white);
      g.fillRect(5,5,wx-10,wy-10);
    break;
    case -2:
        g.setColor(Color.black);
      g.fillRect(5,5,wx-6,(wy-10)/3);
      g.fillRect(5,(wy-10)*2/3,wx-10,wy-5-((wy-10)*2/3));
      g.setColor(Color.white);
      g.fillRect(5,(wy-10)/3,wx-10,(wy-10)/3);
    break;
    case 1:
      g.setColor(Color.black);
      g.fillRect(5,5,wx-10,wy-10);
    break;
    case 2:
        g.setColor(Color.white);
      g.fillRect(5,5,wx-10,(wy-10)/3);
      g.fillRect(5,(wy-10)*2/3,wx-10,wy-5-((wy-10)*2/3));
      g.setColor(Color.black);
      g.fillRect(5,(wy-10)/3,wx-10,(wy-10)/3);
    break;
    default:
      g.setPaintMode();
      g.setColor(Color.black);
      g.drawString("Dieses Fenster wurde nicht korrekt initialisiert.",20,20);
    break;
    }
  }

}

/* ****************************************************************
 * ctmove
 *
 *
 */

class ctmove extends ctwindow {

static final String HLPTXT="Sprite\n\n"+

"Das sich bewegende Symbol zeigt auf LCD-Displays das nachleuchten auf.\n"+
"Bei guten Displays sollte es kaum eine Spur hinterlassen. Je lnger die\n"+
"Spur ist, desdo schlechter ist das Display geeignet, schnell wechselnde\n"+
"Bildinhalte gut darzustellen.\n"+

"Die Bild-Auf-Taste zeigt das Fenster zur Beurteilung der Farbkonstanz, \n"+
"die Bild-Ab-Taste schliet das Testfenster. Auch \"Escape\" schliet das \n"+
"Testfenster und wechselt zum Hauptmen.";


  int timer=30;
  int pmode=0;
  int speedX=2;
  int speedY=2;
  int sizeX;
  int sizeY;
  int px=0;
  int py=0;
  Image cross;
  
  static final String NEXT="  Hoehere Pumpfrequenz";
  static final String PREV="  Niedrigere Pumpfrequenz";

  ctmove(Frame f,ctscreen mx, Image vi) {
    super(f,mx);
    NoSecondaries=0;
    SecondaryCounter=0;
    setVariantNumber(1);
    setBackground(Color.black);
    px=wx/2;
    py=wy/2;
    cross=vi;
  }

  public void SecVariants(int dir)
  {
    timer =timer-(2*dir);
    if (timer<6) timer=6;
    if (timer>100) timer = 50;
    repaint();
  }

  public void addSecVariantMenu(ctMenu m)
  {
/*
      m.add(NEXT);
      m.add(PREV);
      m.addSeparator();
*/
  }

  public void checkSecVariantMenu(String caption)
  {
    if (caption==NEXT)
      SecVariants(1);
    if (caption==PREV)
      SecVariants(-1);
  }

  public int getspeed(long l)
  {
    switch ((int)l) {
      case 0 : return 0;
      case 1 : return 0;
      case 2 : return 1;
      case 3 : return -1;
      case 4 : return 2;
      case 5 : return -2;
      case 6 : return 3;
      case 7 : return -3;
      case 8 : return 3;
      case 9 : return -3;
      default : return 0;
   }
 }

  public int getspeedfor(long l)
  {
    switch ((int)l) {
      case 0 : return 3;
      case 1 : return 3;
      case 2 : return 3;
      case 3 : return 3;
      case 4 : return 2;
      case 5 : return 2;
      case 6 : return 1;
      case 7 : return 1;
      case 8 : return 0;
      case 9 : return 0;
      default : return 0;
   }
 }
                    
  public void Init(int w, int h) {
    int x,y;
    float ratio;

    super.Init(w,h);
    pmode=-1;
  }

  public void Tick()
  {
    this.repaint();
  }

  void InitVariant(int sw)
  {
  }

  public void update(Graphics g)
  {
    long temp;
    sizeX=cross.getWidth(this);
    sizeY=cross.getHeight(this);
        px=px+speedX;
        py=py+speedY;
        if (px<0) {
          px=0;
          speedX=-speedX;
          if (((System.currentTimeMillis()/1000) % 100)>50) {
            temp=(System.currentTimeMillis()/1000) % 9;
            speedY=getspeed(temp);
            speedX=getspeedfor(temp);
          }
        }
        if (px>wx-sizeX) {
          px=wx-sizeX;
          speedX=-speedX;
          if (((System.currentTimeMillis()/1000) % 100)>50) {    
            temp=(System.currentTimeMillis()/1000) % 9;
            speedY=getspeed(temp);
            speedX=-getspeedfor(temp);
          }
        }
        if (py<0) {
          py=0;
          speedY=-speedY;
          if (((System.currentTimeMillis()/1000) % 100)>50) {
            temp=(System.currentTimeMillis()/1000) % 9;
            speedX=getspeed(temp);
            speedY=getspeedfor(temp);
          }
        }
        if (py>wy-sizeY) {
          py=wy-sizeY;
          speedY=-speedY;
          if (((System.currentTimeMillis()/1000) % 100)>50) {
            temp=(System.currentTimeMillis()/1000) % 9;
            speedX=getspeed(temp);
            speedY=-getspeedfor(temp);
          }
        }
    g.drawImage(cross,px,py,this);
 }

  public void paint(Graphics  g)
  {
  }

}



/* ****************************************************************
 * ctaufloesung
 *
 *
 */

class ctaufloesung extends ctwindow { // Fenster fr Auflsung

static final String HLPTXT="Auflsung\n\n"+

"Anhand der parallelen schwarzen und weien Linien lt sich das \n"+
"Auflsungsvermgen des Monitors beurteilen. Dazu besitzt dieses \n"+
"Fenster 8 Varianten, die Sie mit Pfeil-rechts und Pfeil-links der \n"+
"Reihe nach whlen knnen. Die Varianten bestehen aus horizontalen \n"+
"und vertikalen Linien, einem Schachbrettmuster und einer geteilten \n"+
"Darstellung von Schachbrettmuster und vertikalen Linien- jeweils \n"+
"mit 1 und 2 Pixel Linienbreite.\n\n"+

"Die Darstellung der senkrechten Linien belastet die Videoelektronik \n"+
"aufs uerste. Dabei mssen die zwei-Pixel-Linien deutlich erkennbar \n"+
"sein, Ein-Pixel-Linien knnen bei blicherweise verwendeten \n"+
"Auflsungen schon deutlich verschwimmen. Je strker sie dieses tun, \n"+
"desto schlechter ist die Videoelektronik. Die horizontalen Linien \n"+
"dienen dem direkten Vergleich, da hier die Viedoelektronik weniger \n"+
"belastet wird - hier sollte eine scharfe Darstellung kein Problem \n"+
"sein. Die vier Varianten mit dem Schachbrettmuster zeigen eventuell \n"+
"auftretende Interferenzen zwischen dem Bild und der Lochmaske des \n"+
"Monitors (Moire-Effekt).\n\n"+

"Die Bild-Auf-Taste wechselt zum Geometrie-Fenster, die Bild-Ab-Taste\n"+
"fhrt zum Fenster fr die Beurteilung der Bildschrfe. \"Escape\"\n"+
"schliet das Testfenster und wechselt zum Hauptmen.\n";



  Color Linecolor=Color.white;
  Color Backcolor=Color.black;
  int spacing=1;
  int direction=ctaufloesung.HORIZONTAL;

  static final int HORIZONTAL=1;
  static final int VERTICAL=2;
  static final int CHECKERED=3;
  static final int HALF1=4;

  ctaufloesung(Frame f,ctscreen mx) {
    super(f,mx);

  }


  public void Init(int w, int h) {
    super.Init(w,h);
    setVariantNumber(8);
  }

  void InitVariant(int sw)
  {

    switch(sw) {
    case 0:
      direction=VERTICAL;
      spacing=1;
    break;
    case 2:
      direction=HORIZONTAL;
      spacing=1;
    break;
    case 1:
      direction=HORIZONTAL;
      spacing=2;
    break;
    case 3:
      direction=VERTICAL;
      spacing=2;
    break;
    case 4:
      direction=CHECKERED;
      spacing=1;
    break;
    case 5:
      direction=CHECKERED;
      spacing=2;
    break;
    case 6:
      direction=HALF1;
      spacing=1;
    break;
    case 7:
      direction=HALF1;
      spacing=2;
    break;
    }
    repaint();
  }

  void drawFullLine(int dir,int pos, int width, Graphics g)
  {
    if (dir==HORIZONTAL) {
      for (int i=0;i<width;i++)
        g.drawLine(0,pos*width+i,wx,pos*width+i);
    }
    if (dir==VERTICAL) {
      for (int i=0;i<width;i++)
        g.drawLine(pos*width+i,0,pos*width+i,wy);
    }
  }


  public void paint(Graphics  g)
  {
        int i;
        int nx,ny;

    g.setColor(Backcolor);
    g.setPaintMode();
    g.fillRect(0,0,wx,wy);

    g.setColor(Linecolor);
    nx=wx/2/spacing;
    ny=wy/2/spacing;

    switch (direction) {
    case VERTICAL :
      for (i=0;i<nx;i++)
        drawFullLine(direction,2*i,spacing,g);
    break;
    case HALF1 :
      for (i=0;i<nx;i++)
        drawFullLine(VERTICAL,2*i,spacing,g);
      g.setXORMode(Backcolor);
      for (i=ny/2;i<ny;i++)
        drawFullLine(HORIZONTAL,2*i,spacing,g);
    break;
    case HORIZONTAL :
      for (i=0;i<ny;i++)
        drawFullLine(direction,2*i,spacing,g);
    break;
    case CHECKERED :
      for (i=0;i<ny;i++)
        drawFullLine(HORIZONTAL,2*i,spacing,g);
      g.setXORMode(Backcolor);
      for (i=0;i<nx;i++)
        drawFullLine(VERTICAL,2*i,spacing,g);
    }

  }

}


/* ****************************************************************
 * ctgeometrie
 *
 *
 */

class ctgeometrie extends ctwindow {

static final String HLPTXT="Geometrie\n\n"+

"Am Raster und den Kreisen des dieses Testbildes erkennen Sie \n"+
"Geometriefehler. Justieren Sie den Monitor so, da mglichst \n"+
"geringe Fehler bleiben. Bei asymmetrischen Fehlern versuchen Sie \n"+
"zunchst, einen symmetrischen Fehler zu erzeugen, bevor sie diesen \n"+
"ausgleichen. Beginnen Sie mit Parallelogramm- und Trapezverzerrungen, \n"+
"erst danach Kissenbalance und -entzerrung. Als letztes nehmen Sie \n"+
"gegebenenfalls noch Linearitts- und Eckenkorrekturen vor.\n\n"+

"Die Tasten Pfeil-rechts und Pfeil-links wechseln \n"+
"zwischen dem weien und magentafarbenen Testgitter. \n"+
"Mit dem Magenta-Gitter knnen Sie Konvergenzfehler erkennen und \n"+
"(wenn mglich) wegregeln.\n\n"+

"Die Weite des dargestellten Testgitters verndern Sie mit den \n"+
"Pfeil-auf/Pfeil-ab Tasten. Ein rotes Kreuz in der Mitte des \n"+
"Bildschirms zeigt an, da das dargestellte Gitter nicht zur \n"+
"gewhlten Auflsung pat. Das Kreuz wird immer exakt in der \n"+
"Mitte des Bildes dargestellt, so da der Abstand zum Raster den \n"+
"Fehler bei der Gitterdarstellung zeigt.\n\n"+                                                 

"Die Bild-Auf-Taste zeigt das Fenster fr die Helligkeitseinstellung, \n"+
"die Bild-Ab-Taste fhrt zum Fenster fr die Beurteilung der Auflsung.\n"+
"\"Escape\" schliet das Testfenster und wechselt zum Hauptmen.\n";


  Color Linecolor=Color.white;
  Color Backcolor=Color.black;
  int nx,ny,ncc,cdsmall,cdlarge;
  boolean ratiook;

  static final String SPPAGE  ="  Feineres Gitter  ";
  static final String SNPAGE  ="  Groeberes Gitter  ";

  static final int HORIZONTAL=1;
  static final int VERTICAL=2;
  static final int CHECKERED=3;
  static final int GRID=4;
  static final int SLASH=5;
  static final int BACKSLASH=6;
  static final int DIAGONAL=7;

  ctgeometrie(Frame f,ctscreen mx) {
    super(f,mx);
    NoSecondaries=8;
    SecondaryCounter=4;
  }

  public void SecVariants(int dir)
  {
    SecondaryCounter-=dir;
    if (SecondaryCounter<4) SecondaryCounter=4;
    if (SecondaryCounter>NoSecondaries) SecondaryCounter=NoSecondaries;
    repaint();
  }

  public void addSecVariantMenu(ctMenu m)
  {
      m.add(ctgeometrie.SNPAGE);
      m.add(ctgeometrie.SPPAGE);
      m.addSeparator();
  }

  public void checkSecVariantMenu(String caption)
  {
    if (caption==SNPAGE)
      SecVariants(1);
    if (caption==SPPAGE)
      SecVariants(-1);
  }


  public void Init(int w, int h) {
    int x,y,i;
    float ratio;

    super.Init(w,h);
    setBackground(Color.black);
    setVariantNumber(5);
    ratio=wx/wy;
    ratiook=true;
    if (wx>wy) i=wy; else i=wx;

    for (;(((wx%i)+(wy%i)))!=0;i--);
    if (wx>wy)
      for (;(wy/i>16);i++);
    else
      for (;(wx/i>16);i++);
      
    if (i>5) {
      ratiook=true;
      nx=wx/i;
      ny=wy/i;
      SecondaryCounter=0;     
      do {
        SecondaryCounter++;
      }
      while (wx/(SecondaryCounter*nx)>64);
      if (SecondaryCounter<4) SecondaryCounter=4;
      if (SecondaryCounter>NoSecondaries) SecondaryCounter=NoSecondaries;
      return;
    }
    ratiook=false;
    nx=4;
    ny=3;
      for (SecondaryCounter=4;
        (wx/SecondaryCounter/nx)>64;
        SecondaryCounter++);
  }

  void InitVariant(int sw)
  {
    switch(sw) {
    case 0:
      Linecolor=Color.white;
      Backcolor=Color.black;
    break;                                               
    case 1:
      Linecolor=Color.magenta;
      Backcolor=Color.black;
    break;
    case 2:
      Linecolor=Color.black;
      Backcolor=Color.white;
    break;
    case 3:
      Linecolor=Color.black;
      Backcolor=Color.white;
    break;
    case 4:
      Linecolor=Color.white;
      Backcolor=Color.black;
    break;
    }
    repaint();
  }

  void drawCircle(int cx, int cy,int r, Graphics g,boolean center)
  {
    g.drawOval(cx-r,cy-r,r*2,r*2);
    if (r>100) r=100;
    if (!center) return;
    g.drawLine(cx-r,cy,cx+r,cy);
    g.drawLine(cx,cy-r,cx,cy+r);  
  }


  void drawHoriColorbar(int x1, int y1,int x2, int y2, Graphics g)
  {
  Color barcolor=Color.black;
  int q;
    q=(x2-x1)/6;  //Rundungsfehler! s.u.
    //Schwarz -> Rot
    for (int i=0;i<q;i++)  {
      barcolor=new Color(255*i/q,0,0);
      g.setColor(barcolor);
      g.drawLine(x1+i,y1,x1+i,y2);
    }
    //Rot -> Gelb
    for (int i=0;i<q;i++)  {
      barcolor=new Color(255,255*i/q,0);
      g.setColor(barcolor);
      g.drawLine(x1+i+q,y1,x1+i+q,y2);
    }
    //Gelb -> Grn
    for (int i=0;i<q;i++)  {
      barcolor=new Color(255-255*i/q,255,0);
      g.setColor(barcolor);
      g.drawLine(x1+i+2*q,y1,x1+i+2*q,y2);
    }
    //Grn -> Trkis
    for (int i=0;i<q;i++)  {
      barcolor=new Color(0,255,255*i/q);
      g.setColor(barcolor);
      g.drawLine(x1+i+3*q,y1,x1+i+3*q,y2);
    }
    //Trkis -> Blau
    for (int i=0;i<q;i++)  {
      barcolor=new Color(0,255-255*i/q,255);
      g.setColor(barcolor);
      g.drawLine(x1+i+4*q,y1,x1+i+4*q,y2);
    }
    //Blau -> Schwarz
    for (int i=0;i<q;i++)  {
      barcolor=new Color(0,0,255-255*i/q);
      g.setColor(barcolor);
      g.drawLine(x1+i+5*q,y1,x1+i+5*q,y2);
    }
    // Ausgleich von Rundungsfehlern:
    for (int i=6*q;i<=(x2-x1);i++) {
      g.setColor(Color.black);
      g.drawLine(x1+i,y1,x1+i,y2);
    }
  }
  void drawVertColorbar(int x1, int y1,int x2, int y2, Graphics g)
  {
  Color barcolor=Color.black;
  int q;
    q=(y2-y1)/6;
    //Schwarz -> Rot
    for (int i=0;i<q;i++)  {
      barcolor=new Color(255*i/q,0,0);
      g.setColor(barcolor);
      g.drawLine(x1,y1+i,x2,y1+i);
    }
    //Rot -> Gelb
    for (int i=0;i<q;i++)  {
      barcolor=new Color(255,255*i/q,0);
      g.setColor(barcolor);
      g.drawLine(x1,y1+i+q,x2,y1+i+q);
    }
    //Gelb -> Grn
    for (int i=0;i<q;i++)  {
      barcolor=new Color(255-255*i/q,255,0);
      g.setColor(barcolor);
      g.drawLine(x1,y1+i+2*q,x2,y1+i+2*q);
    }
    //Grn -> Trkis
    for (int i=0;i<q;i++)  {
      barcolor=new Color(0,255,255*i/q);
      g.setColor(barcolor);
      g.drawLine(x1,y1+i+3*q,x2,y1+i+3*q);
    }
    //Trkis -> Blau
    for (int i=0;i<q;i++)  {
      barcolor=new Color(0,255-255*i/q,255);
      g.setColor(barcolor);
      g.drawLine(x1,y1+i+4*q,x2,y1+i+4*q);
    }
    //Blau -> Schwarz
    for (int i=0;i<q;i++)  {
      barcolor=new Color(0,0,255-255*i/q);
      g.setColor(barcolor);
      g.drawLine(x1,y1+i+5*q,x2,y1+i+5*q);
    }
    // Ausgleich von Rundungsfehlern:
    for (int i=6*q;i<=(y2-y1);i++) {
      g.setColor(Color.black);
      g.drawLine(x1,y1+i,x2,y1+i);
    }
  }

  void drawSiemensstern(int x1, int y1, int x2, int y2, int mx, int my, int npix,Graphics g)
  {
  int dx,i;   
//    g.setPaintMode(XORPaint)
    dx=npix/8;
    for (i=-8;i<=8;i++) {
      g.drawLine(x1,my+i*dx,x2,my-i*dx);
      g.drawLine(mx+i*dx,y1,mx-i*dx,y2);
    }

  }

  void drawLinePattern(int x1, int y1, int x2, int y2, int width, int patterntype, boolean erase, Graphics g)
  // Linien-/Schachfeldbreite=width,
  // Fensterbreite = Hoehe = Vielfaches von 2*width
  {
  int x,y;

    switch(patterntype) {
    case HORIZONTAL:
      // horizontale Linien
      if (erase) {
        g.setColor(Linecolor);
        g.fillRect(x1,y1,x2-x1,y2-y1);
        g.setColor(Backcolor);
      }
      y=(y2-y1)/(2*width);
      for (int j=0;j<=y;j++)
      for (int i=0;i<width;i++) {
        g.drawLine(x1,y1+i+j*2*width,x2,y1+i+j*2*width);
      }
    break;
    case VERTICAL:
      // vertikale Linien
      if (erase) {
        g.setColor(Linecolor);
        g.fillRect(x1,y1,x2-x1,y2-y1);
        g.setColor(Backcolor);
      }
      x=(x2-x1)/(2*width);
      for (int j=0;j<=x;j++)
      for (int i=0;i<width;i++) {
        g.drawLine(x1+i+j*2*width,y1,x1+i+j*2*width,y2);
      }
    break;
    case CHECKERED :
      // Schachbrettmuster
      if (erase) {
        g.setColor(Linecolor);
        g.fillRect(x1,y1,x2-x1,y2-y1);
      }
      drawLinePattern(x1,y1,x2,y2,width,HORIZONTAL,erase,g);
      g.setXORMode(Linecolor);
      drawLinePattern(x1,y1,x2,y2,width,VERTICAL,false,g);
      g.setPaintMode();
    break;
    case GRID :
      // Gitter aus vert.& horiz. Linien
      drawLinePattern(x1,y1,x2,y2,width,HORIZONTAL,erase,g);
      drawLinePattern(x1,y1,x2,y2,width,VERTICAL  ,false,g);
    break;
    case SLASH:
      // schraege Linien
      if (erase) {
        g.setColor(Linecolor);
        g.fillRect(x1,y1,x2-x1,y2-y1);
      }
      g.setColor(Backcolor);
      for (int i=0;i<=(x2-x1);i=i+width)
        g.drawLine(x1+i,y1  ,x2  ,y2-i);
      for (int i=width;i<=(x2-x1);i=i+width)
        g.drawLine(x1  ,y1+i,x2-i,y2  );
    break;
    case BACKSLASH:
      // rckwrts-schraege Linien
      if (erase) {
        g.setColor(Linecolor);
        g.fillRect(x1,y1,x2-x1,y2-y1);
      }
      g.setColor(Backcolor);
      x=(x2-x1)/(2*width);
      for (int i=0;i<=(x2-x1);i=i+width)
        g.drawLine(x1  ,y2-i,x2-i,y1  );
      for (int i=width;i<=(x2-x1);i=i+width)
        g.drawLine(x1+i,y2  ,x2  ,y1+i);
    break;
    case DIAGONAL:
      // Gitter aus schraegen Linien
      drawLinePattern(x1,y1,x2,y2,width,SLASH    ,erase,g);
      drawLinePattern(x1,y1,x2,y2,width,BACKSLASH,false,g);
    break;
                } //switch
  }


  public void paint(Graphics  g)
  {
        int i,j,k,npix,nx1,ny1,mx,my;

        nx1=nx*SecondaryCounter;
        ny1=ny*SecondaryCounter;
  mx =wx/2;
  my =wy/2;

    npix=(wy)/ny1;
    g.setColor(Backcolor);
    g.setPaintMode();
    g.fillRect(0,0,wx,wy);
    g.setColor(Linecolor);
    for (i=-nx1/2;i<=(nx1/2);i++) {
      g.drawLine(mx+i*npix,0,mx+i*npix,wy);
    }
    for (j=-ny1/2;j<=(ny1/2);j++) {
      g.drawLine(0,my+j*npix,wx,my+j*npix);
    }
    g.drawLine(0,0,wx-1,0);
    g.drawLine(0,0,0,wy-1);
    g.drawLine(0,wy-1,wx-1,wy-1);
    g.drawLine(wx-1,0,wx-1,wy-1);
    if (Variant<3) {
      drawCircle(mx+(nx1*npix/2-3*npix/2),my+(ny1*npix/2-3*npix/2),npix,g,true);
      drawCircle(mx-(nx1*npix/2-3*npix/2),my+(ny1*npix/2-3*npix/2),npix,g,true);
      drawCircle(mx-(nx1*npix/2-3*npix/2),my-(ny1*npix/2-3*npix/2),npix,g,true);
      drawCircle(mx+(nx1*npix/2-3*npix/2),my-(ny1*npix/2-3*npix/2),npix,g,true);
    }
    else {
      drawCircle(   2*npix,   2*npix,npix,g,true);
      drawCircle(   2*npix,wy-2*npix,npix,g,true);
      drawCircle(wx-2*npix,   2*npix,npix,g,true);
      drawCircle(wx-2*npix,wy-2*npix,npix,g,true);
    }
    drawCircle(mx,my,npix,g,false);
    
    if (Variant<2)
      if (mx>my)
        drawCircle(mx,my,my-1,g,false);
      else
        drawCircle(mx,my,mx-1,g,false);
    else
      if (mx>my)
        drawCircle(mx,my,my-3,g,false);
      else
        drawCircle(mx,my,mx-3,g,false);
  

    if (wx%nx1+wy%ny1!=0) {
      g.setColor(Color.red);
      g.drawLine(mx-20,my,mx+20,my);
      g.drawLine(mx,my-20,mx,my+20);
      g.setColor(Linecolor);
    }
      

    if (Variant<3) return;
    drawSiemensstern(mx-3*npix,my+2*npix,mx+3*npix,my-2*npix,mx,my,npix,g);
    drawHoriColorbar(mx-4*npix+1,my+2*npix+1,mx+4*npix-1,my+3*npix-1,g);
    drawVertColorbar(mx+(-2+nx1/2)*npix-1,my-3*npix+1,mx+(-3+nx1/2)*npix+1,my+3*npix-1,g);
    i=npix/2;
    j=2*i;
    k=3*i;
    //  Muster in Bildschirmecken:
    drawLinePattern(   0,   0,   i,   i,1,CHECKERED ,true,g);
    drawLinePattern(wx-i,   0,  wx,   i,1,CHECKERED ,true,g);
    drawLinePattern(   0,wy-i,   i,  wy,1,CHECKERED ,true,g);
    drawLinePattern(wx-i,wy-i,  wx,  wy,1,CHECKERED ,true,g);
    drawLinePattern(   i,   0,   j,   i,1,VERTICAL  ,true,g);
    drawLinePattern(wx-j,   0,wx-i,   i,1,VERTICAL  ,true,g);
    drawLinePattern(   i,wy-i,   j,  wy,1,VERTICAL  ,true,g);
    drawLinePattern(wx-j,wy-i,wx-i,  wy,1,VERTICAL  ,true,g);
    drawLinePattern(   j,   0,   k,   i,2,VERTICAL  ,true,g);
    drawLinePattern(wx-k,   0,wx-j,   i,2,VERTICAL  ,true,g);
    drawLinePattern(   j,wy-i,   k,  wy,2,VERTICAL  ,true,g);
    drawLinePattern(wx-k,wy-i,wx-j,  wy,2,VERTICAL  ,true,g);
    drawLinePattern(   0,   i,   i,   j,1,HORIZONTAL,true,g);
    drawLinePattern(wx-i,   i,  wx,   j,1,HORIZONTAL,true,g);
    drawLinePattern(   0,wy-j,   i,wy-i,1,HORIZONTAL,true,g);
    drawLinePattern(wx-i,wy-j,  wx,wy-i,1,HORIZONTAL,true,g);
    drawLinePattern(   0,   j,   i,   k,2,HORIZONTAL,true,g);
    drawLinePattern(wx-i,   j,  wx,   k,2,HORIZONTAL,true,g);
    drawLinePattern(   0,wy-k,   i,wy-j,2,HORIZONTAL,true,g);
    drawLinePattern(wx-i,wy-k,  wx,wy-j,2,HORIZONTAL,true,g);
    //  die diversen Farbfelder
    g.setColor(Color.blue);
    g.fillRect(   i+1,   i+1,i-2,i-2);
    g.fillRect(wx-j+1,   i+1,i-2,i-2);
    g.fillRect(   i+1,wy-j+1,i-2,i-2);
    g.fillRect(wx-j+1,wy-j+1,i-2,i-2);
    g.setColor(Color.red);
    g.fillRect(   i+1,   j+1,i-2,i-2);
    g.fillRect(wx-j+1,   j+1,i-2,i-2);
    g.fillRect(   i+1,wy-k+1,i-2,i-2);
    g.fillRect(wx-j+1,wy-k+1,i-2,i-2);
    g.setColor(Color.green);
    g.fillRect(   j+1,   i+1,i-2,i-2);
    g.fillRect(wx-k+1,   i+1,i-2,i-2);
    g.fillRect(   j+1,wy-j+1,i-2,i-2);
    g.fillRect(wx-k+1,wy-j+1,i-2,i-2);
    g.setColor(Color.blue);
    g.fillRect(mx-2*npix+1,my-2*npix+1,j,i);
    g.setColor(Color.green);
    g.fillRect(mx  -npix+1,my-2*npix+1,j,i);
    g.setColor(Color.red);
    g.fillRect(mx       +1,my-2*npix+1,j,i);
    g.setColor(Color.yellow);
    g.fillRect(mx  +npix+1,my-2*npix+1,j,i);
    g.setColor(Color.cyan);
    g.fillRect(mx-2*npix+1,my+2*npix-i,j,i);
    g.setColor(Color.magenta);
    g.fillRect(mx  +npix+1,my+2*npix-i,j,i);
    g.setColor(Linecolor);
    // der "Muster-Rahmen":
    drawLinePattern(mx-4*npix+1,my-3*npix+1,mx-3*npix,my-2*npix,3,VERTICAL  ,true,g);
    drawLinePattern(mx-3*npix+1,my-3*npix+1,mx-2*npix,my-2*npix,2,VERTICAL  ,true,g);
    drawLinePattern(mx-2*npix+1,my-3*npix+1,mx-  npix,my-2*npix,1,VERTICAL  ,true,g);
    drawLinePattern(mx-  npix+1,my-3*npix+1,mx       ,my-2*npix,3,SLASH     ,true,g);
    drawLinePattern(mx       +1,my-3*npix+1,mx+  npix,my-2*npix,3,BACKSLASH ,true,g);
    drawLinePattern(mx+  npix+1,my-3*npix+1,mx+2*npix,my-2*npix,1,GRID      ,true,g);
    drawLinePattern(mx+2*npix+1,my-3*npix+1,mx+3*npix,my-2*npix,2,GRID      ,true,g);
    drawLinePattern(mx+3*npix+1,my-3*npix+1,mx+4*npix,my-2*npix,3,GRID      ,true,g);
    drawLinePattern(mx-4*npix+1,my-2*npix+1,mx-3*npix,my-  npix,4,SLASH     ,true,g);
    drawLinePattern(mx-4*npix+1,my-  npix+1,mx-3*npix,my       ,4,BACKSLASH ,true,g);
    drawLinePattern(mx-4*npix+1,my       +1,mx-3*npix,my+  npix,3,BACKSLASH ,true,g);
    drawLinePattern(mx-4*npix+1,my+  npix+1,mx-3*npix,my+2*npix,4,DIAGONAL  ,true,g);
    drawLinePattern(mx+3*npix+1,my-2*npix+1,mx+4*npix,my-  npix,3,HORIZONTAL,true,g);
    drawLinePattern(mx+3*npix+1,my-  npix+1,mx+4*npix,my       ,2,HORIZONTAL,true,g);
    drawLinePattern(mx+3*npix+1,my       +1,mx+4*npix,my+  npix,1,HORIZONTAL,true,g);
    drawLinePattern(mx+3*npix+1,my+  npix+1,mx+4*npix,my+2*npix,6,DIAGONAL  ,true,g);
    g.setColor(Linecolor);
    g.drawRect(0,0,wx-1,wy-1);
    g.drawRect(2,2,wx-5,wy-5);
    g.setColor(Backcolor);
    g.drawRect(1,1,wx-3,wy-3);
    if (wx%nx1+wy%ny1!=0) {
      g.setColor(Color.red);
      g.drawLine(mx-20,my,mx+20,my);
      g.drawLine(mx,my-20,mx,my+20);
      g.setColor(Linecolor);
    }



  }

}


/* ****************************************************************
 * ctkontrast
 *
 *
 */

class ctkontrast extends ctwindow { // Fenster fr Auflsung

static final String HLPTXT="Helligkeit/Kontrast\n\n"+

"Justieren Sie Helligkeit und Kontrast Ihres Monitors anhand der \n"+
"dargestellten Grauflchen: Regeln Sie zunchst bei mittlerer \n"+
"Helligkeit den Kontrast auf Maximum und dann gegebenenfalls wieder \n"+
"so weit zurck, bis alle \"Weistufen\" unterscheidbar sind. Bei \n"+
"modernen Monitoren ist das in der Regel auch mit maximalem Kontrast \n"+
"mglich. Stellen Sie dann die Helligkeit gerade so hoch ein,\n"+
"da die fnf dunklen Graustufen unterscheidbar sind, whrend \n"+
"der Hintergrund schwarz beleibt.\n\n"+

"Sollte das Muster in einem Rahmen in der Bildmitte dargestellt sein,\n"+
"so knnen Sie, falls das On-Screen-Men des Monitors die Graustufen \n"+
"verdeckt, das Testbild mit Hilfe der Pfeiltasten verschieben. \n"+
"Die Bild-Auf-Taste schliet das Fenster, die Bild-Ab-Taste schaltet \n"+
"auf das Testfenster fr die Geometrie-Einstellung um. \"Escape\" \n"+
"schliet das Testfenster und wechselt zum Hauptmen.\n";




  static final int NOCOL=5;
  static final int OFFS=10;
  static final String LINE1="Stellen Sie bei mittlerer Helligkeit den Kontrast so ein, dass Sie die 5 hellen";
  static final String LINE2="Graustufen gut unterscheiden Knnen. Justieren Sie nun die Helligkeit so, ";
  static final String LINE3="dass der Hintergrund schwarz ist, Sie aber die 5 Graustufen erkennen koennen.";

  Color[] greys= new Color[NOCOL];
  Color[] whites= new Color[NOCOL];
  int[] gpercent= new int[NOCOL];
  int[] wpercent= new int[NOCOL];

  Color Linecolor=Color.white;
  Color Backcolor=Color.black;
  int px; int py;
  int mx; int my;
  int fullscreen;

  ctkontrast(Frame f,ctscreen mx, int mm) {
    super(f,mx);
    fullscreen=mm;
  }

  public void SecVariants(int dir)
  {
    py=py-10*dir;
    if (py<0) py=0;
    if (py>my) py=my;
    repaint();
  }

  public void SwapVariant(int dir)
  {
    px=px-10*dir;
    if (px<0) px=0;
    if (px>mx) px=mx;
    repaint();
  }

  public void Init(int w, int h) {
      int j;
    super.Init(w,h);
    px=w/2-200;
    py=h/2-200;
    mx=w-400;
    my=h-400;
    setBackground(Color.black);
    for (int i=0;i<NOCOL;i++)
    {
      greys[i]=new Color((i+1)*OFFS,(i+1)*OFFS,(i+1)*OFFS);
      gpercent[i]=(100*i*OFFS/255);
      whites[i]=new Color(255-i*OFFS,255-i*OFFS,255-i*OFFS);
      wpercent[i]=100-(100*i*OFFS/255);
    }
  }

  public void paint(Graphics  g)
  {
    int i,npix;
    int nx,ny;
    int x, y;

    Font font = g.getFont();
    FontMetrics fontMetrics = g.getFontMetrics();
    Dimension d=this.getSize();
    y=fontMetrics.getHeight();
    x=fontMetrics.stringWidth(LINE1);
    
    if (fullscreen<1) {
      g.setColor(Linecolor);
      g.setPaintMode();
      if (py>3*y) {
        g.drawString(LINE1,(wx-x)/2,y);
        g.drawString(LINE2,(wx-x)/2,2*y);
        g.drawString(LINE3,(wx-x)/2,3*y);
      }
      else {
        g.drawString(LINE1,(wx-x)/2,wy-2*y);
        g.drawString(LINE2,(wx-x)/2,wy-y);
        g.drawString(LINE3,(wx-x)/2,wy);
      }
      g.drawLine(px,py,px+399,py+0);
      g.drawLine(px,py,px,py+399);
      g.drawLine(px,py+399,px+399,py+399);
      g.drawLine(px+399,py,px+399,py+399);
      nx=360/NOCOL;
      ny=(400-NOCOL*nx)/2;
      for (i=0;i<NOCOL;i++)
      {
        g.setColor(greys[i]);
        g.fillRect(px+ny+nx*i,py+20,nx,140);
        g.setColor(whites[NOCOL-i-1]);
        g.fillRect(px+ny+nx*i,py+240,nx,140);
      }
    } 
    else {
      for (i=0;i<NOCOL;i++) {
        g.setColor(greys[i]);
        g.fillRect(wx*i/NOCOL,0,wx*(i+1)/NOCOL,wy/2);
        g.setColor(whites[i]);
        g.fillRect(wx*i/NOCOL,wy/2,wx*(i+1)/NOCOL,wy);
      }
      g.setColor(Linecolor);
      g.setPaintMode();
      g.drawString(LINE1,(wx-x)/2,y);
      g.drawString(LINE2,(wx-x)/2,2*y);
      g.drawString(LINE3,(wx-x)/2,3*y);
    }

  }

}

/* ****************************************************************
 * ctfarbkontrast
 *
 *
 */

class ctfarbkontrast extends ctwindow { // Fenster fr Auflsung

static final String HLPTXT="Brillianz\n\n"+

"Die verschiedenen Farb- und Grauverlufe dienen dazu, die Brillianz\n"+
"der Darstellung zu zeigen. Bei optimal justiertem Bild sollten die \n"+
"Farbverlufe und Grauverlufe gleichmig sein.\n\n"+
"Bei den Grauabstufungen sollten auch die inneren Stufen noch erkennbar\n"+
"sein. Ist dies nicht der Fall, so sind Helligkeit und Kontrast nicht\n"+
"optimal eingestellt.\n\n"+

"Mit den Pfeiltasten wechseln Sie zwischen den verschiedenen Darstellungen,\n"+
"die Bild-Auf-Taste schaltet auf das Fenster fr die Justage von Helligkeit und\n"+
"Kontrast, die Bild-Ab-Taste auf das Testfenster fr die Geometrie-Einstellung.\n"+
"\"Escape\" schliet das Testfenster und wechselt zum Hauptmen.\n";




  static final int NOCOL=5;
  static final int OFFS=10;
  
  static final int MAXVAR=3;

  Color[] colors= new Color[2048];

  ctfarbkontrast(Frame f,ctscreen mx) {
    super(f,mx);
  }

  public void Init(int w, int h) {
      int j;
    super.Init(w,h);
    setBackground(Color.black);
    setVariantNumber(5);
  }
  
  void InitVariant(int sw)
  {
     this.repaint();
  }
                 
  public void paintKeil(Graphics gr,int x, int w, int rd, int gd, int bd)
  {
    int additor;
    int i;
    float red,green,blue;
    if (w>2048) w=2084;
    for (i=0;i<w;i++)
    {
      if (rd<0) red=(float)i/(float)(w-1); else red=(float)rd/256;
      if (gd<0) green=(float)i/(float)(w-1); else green=(float)gd/256;
      if (bd<0) blue= (float)i/(float)(w-1); else blue=(float)bd/256; 
      gr.setColor(new Color(red,green,blue));
       gr.drawLine(x+i,0,x+i,wy/4);
    }
    for (i=0;i<w;i++)
    {
      if (rd<0) red=(float)i/(float)(w-1); else red=(float)rd/256;
      if (gd<0) green=(float)i/(float)(w-1); else green=(float)gd/256;
      if (bd<0) blue= (float)i/(float)(w-1); else blue=(float)bd/256; 
      gr.setColor(new Color(red,green,blue));
       gr.drawLine(x+i,wy/4,x+i,wy/2);
    }
    for (i=0;i<w;i++)
    {
      if (rd<0) red=(float)i/(float)(w-1); else red=(float)rd/256;
      if (gd<0) green=(float)i/(float)(w-1); else green=(float)gd/256;
      if (bd<0) blue= (float)i/(float)(w-1); else blue=(float)bd/256; 
      gr.setColor(new Color(red,green,blue));
       gr.drawLine(x+i,wy/2,x+i,3*wy/4);
    }
    for (i=0;i<w;i++)
    {
      if (rd<0) red=(float)i/(float)(w-1); else red=(float)rd/256;
      if (gd<0) green=(float)i/(float)(w-1); else green=(float)gd/256;
      if (bd<0) blue= (float)i/(float)(w-1); else blue=(float)bd/256; 
      gr.setColor(new Color(red,green,blue));
       gr.drawLine(x+i,3*wy/4,x+i,wy);
    }
  }     
       
  public void paint(Graphics  g)
  {
    int i,npix;
    int nx,ny;
    int x, y;
    int additor;
    float red,green,blue;
    
    if (Variant==0) {                             
      paintKeil(g,0,wx/5,-1,0,0);
      paintKeil(g,wx/5,wx/5,0,-1,0);
      paintKeil(g,wx/5*2,wx/5,0,0,-1);
      paintKeil(g,wx/5*3,wx/5*2,-1,-1,-1);
    }
    if (Variant==1) {                             
      paintKeil(g,0,wx,-1,-1,-1);
    }
    if (Variant==2) if (wx>wy) {
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wy/2-i,wy/2-i,wy/2-i,wy/2+i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wy/2-i,wy/2-i,wx-(wy/2-i),wy/2-i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wx-(wy/2-i),wy/2-i,wx-(wy/2-i),wy/2+i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wx-(wy/2-i),wy/2+i,wy/2-i,wy/2+i);
      }
    }
    else {
      for (i=0;i<wx/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                           (float)i*2/(float)(wy-2),
                           (float)i*2/(float)(wy-2)));
        g.drawLine(wx/2-i,wx/2-i,wx/2-i,wy-wx/2+i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wx/2-i,wx/2-i,wx/2+i,wx/2-i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wx/2+i,wx/2-i,wx/2+i,wy-wx/2+i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wx/2+i,wy-wx/2+i,wx/2-i,wy-wx/2+i);
      }
    }
    if (Variant==3) if (wx>wy) {
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2),
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wy/2-i,wy/2-i,wy/2-i,wy/2+i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             0,
                             0));
        g.drawLine(wy/2-i,wy/2-i,wx-(wy/2-i),wy/2-i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color(0,
                             (float)i*2/(float)(wy-2),
                             0));
        g.drawLine(wx-(wy/2-i),wy/2-i,wx-(wy/2-i),wy/2+i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color(0,
                             0,
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wx-(wy/2-i),wy/2+i,wy/2-i,wy/2+i);
      }
    }
    else {
      for (i=0;i<wx/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                           (float)i*2/(float)(wy-2),
                           (float)i*2/(float)(wy-2)));
        g.drawLine(wx/2-i,wx/2-i,wx/2-i,wy-wx/2+i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color((float)i*2/(float)(wy-2),
                             0,
                             0));
        g.drawLine(wx/2-i,wx/2-i,wx/2+i,wx/2-i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color(0,
                             (float)i*2/(float)(wy-2),
                             0));
        g.drawLine(wx/2+i,wx/2-i,wx/2+i,wy-wx/2+i);
      }
      for (i=0;i<wy/2;i++) {
        g.setColor(new Color(0,
                             0,
                             (float)i*2/(float)(wy-2)));
        g.drawLine(wx/2+i,wy-wx/2+i,wx/2-i,wy-wx/2+i);
      }
    }
    if (Variant==4) 
    {
      additor=31;      
      if (wx<(additor+1)*20) additor=wx/21;
      if (wy<(additor+1)*20) additor=wy/21;
      for (i=0;i<=additor;i++) {
        g.setColor(new Color((float)(additor-i)/(float)additor,
                             (float)(additor-i)/(float)additor,
                             (float)(additor-i)/(float)additor)
                  );
        g.fillRect(i*10,i*10,wx-(i*20),wy-(i*20));
        g.setColor(Color.white);
        g.drawLine(i*10,i*10,i*10,i*10);
      }
    }  
      
  }

}



/* ****************************************************************
 * ctFarbflaechen
 *
 *
 */

class ctfarbflaechen extends ctwindow { // Fenster fr Farbflchen

static final String HLPTXT="Farbreinheit\n\n"+

"Diese einfarbigen Flchen erlauben es, die Gleichmigkeit der Farbdarstellung \n"+
"zu begutachten. Dazu knnen Sie mit Pfeil-rechts und Pfeil-links zwischen \n"+
"drei verschiedenen Graustufen sowie einem Weibild und je einem Rot- Grn- \n"+
"und Blaubild wechseln.\n\n"+

"Die Bild-Auf-Taste zeigt das Fenster zur Schrfebeurteilung, die \n"+
"Bild-Ab-Taste fhrt zum Pumpbild. \"Escape\" schliet das Testfenster \n"+
"und wechselt zum Hauptmen.\n";

  Color Areacolor=Color.white;
  int circles=0;

  ctfarbflaechen(Frame f,ctscreen mx) {
    super(f,mx);

  }


  public void Init(int w, int h) {
    super.Init(w,h);
    setVariantNumber(7);
  }

  public void SecVariants(int dir)
  {
    if (circles>0) 
      circles=0;
    else 
      circles=1;
    repaint();
  }


  void InitVariant(int sw)
  {

    switch(sw) {
    case 0:
      Areacolor=Color.white;
    break;
    case 1:
      Areacolor=Color.red;
    break;
    case 2:
      Areacolor=Color.green;
    break;
    case 3:
      Areacolor=Color.blue;
    break;
    case 4:
      Areacolor=Color.black;
    break;
    case 5:
      Areacolor=new Color(50,50,50);
    break;
    case 6:
      Areacolor=new Color(125,125,125);
    break;
    case 7:
      Areacolor=new Color(180,180,180);
    break;
    }
    repaint();
  }



  public void paint(Graphics  g)
  {
        int i,npix;
        int nx,ny;

    g.setColor(Areacolor);
    g.setPaintMode();
    g.fillRect(0,0,wx,wy);
    g.setColor(Color.black);
    if (circles<1) return;
    g.drawOval(wx/100*6,wx/100*6,wx/10,wx/10);
    g.drawOval(wx-(wx/100*16),wx/100*6,wx/10,wx/10);
    g.drawOval(wx-(wx/100*16),wy-(wx/100*16),wx/10,wx/10);
    g.drawOval(wx/100*6,wy-(wx/100*16),wx/10,wx/10);
    
    g.drawOval(wx/2-(wx/20),wx/100*12,wx/10,wx/10);
    g.drawOval(wx/2-(wx/20),wy-(wx/100*20),wx/10,wx/10);
    g.drawOval(wx/10,wy/2-(wx/20),wx/10,wx/10);
    g.drawOval(wx-(wx/100*20),wy/2-(wx/20),wx/10,wx/10);
    
    g.drawOval(wx/2-(wx/20),wy/2-(wx/20),wx/10,wx/10);
  }

}


/* ****************************************************************
 * ctschaerfe
 *
 *
 */

class ctschaerfe extends ctwindow {

static final String HLPTXT="Bildschrfe\n\n"+

"Zur Schrfebeurteilung dienen verschiedene kleine Schriften und ein \n"+
"spezielles Testmuster. Die Linien der Schriften sollen sich klar voneinander\n"+
"abheben: Je grauer die Zeichen erscheinen, desto schlechter ist der Monitor. \n"+
"Schlimmstenfalls gehen eng nebeneinander liegende Linien (etwa \"in\" \n"+
"oder im VESA-Testmuster) ununterscheidbar ineinander auf. Am \n"+
"uersten Rand und in den Ecken ist die Darstellung meist etwas  \n"+
"unschrfer - gute Bildschirme schaffen es aber, auch dort ordentlich \n"+
"zu fokussieren.\n\n"+

"Mit den Pfeil-rechts und Pfeil-links kann zwischen den drei Varianten\n"+
"Systemschrift, Textbitmap und Testmuster gewechselt werden. Bei der \n"+
"\"Systemschrift\" verndern Pfeil-auf und Pfeil-ab die Schriftgre.\n\n"+

"Die Bild-Auf-Taste stellt das Auflsungs-Fenster dar, die Bild-Ab-Taste\n"+
"fhrt zum Fenster fr die Beurteilung der Farbkonstanz. \"Escape\" schliet \n"+
"das Testfenster und wechselt zum Hauptmen.\n";

  Color Backcolor=Color.white;
  Color TestColor=Color.black;
  int fontsizeOffset=0;
  int testwind=1;
  Image VesaImage;
  Image TextImage;
  int invert=0;

  static final int TEXT=1;
  static final int VESA=2;
  static final int BMPTXT=3;

  ctschaerfe(Frame f,ctscreen mx, Image Vm, Image Tm) {
    super(f,mx);
    VesaImage=Vm;
    TextImage=Tm;
  }


  public void Init(int w, int h) {
    super.Init(w,h);
    setVariantNumber(3);
  }

  void InitVariant(int sw)
  {

    switch(sw) {
    case 0:
      testwind=TEXT;
    break;
    case 1:
      testwind=BMPTXT;
    break;
    case 2:
      testwind=VESA;
    break;
    }
    repaint();
  }

  public void SecVariants(int dir)
  { // leere Funktion, wird vom ableitenden Klassen bei bedarf berladen
    if (testwind==TEXT) {
      if (fontsizeOffset-dir>-5) fontsizeOffset-=dir;
      if (fontsizeOffset>20) fontsizeOffset=20;
    }
    else 
      invert=1;
    this.repaint();
    
  }

  public void update(Graphics g)
  {
    if (invert>0) {
      g.setXORMode(Color.black);
      g.setColor(Color.white);
      g.fillRect(0,0,wx,wy);
      invert=0;
      return;
    }
    paint(g);
  }

  public void paint(Graphics  g)
  {
        int i,j,jj;
        int nx,ny,wnx,wny;
        FontMetrics fontMetrics;
        Font font = g.getFont();
        String text;

    g.setColor(Backcolor);
    g.setPaintMode();
    g.fillRect(0,0,wx,wy);
    g.setColor(TestColor);

        switch(testwind) {

        case ctschaerfe.TEXT:
             g.setFont(new Font(font.getName(),
                   font.getStyle(),font.getSize() + fontsizeOffset));
             fontMetrics = g.getFontMetrics();
             ny=wy/(fontMetrics.getHeight()-3)+1;
             text=ctscreen.STDTEXT+String.valueOf(fontMetrics.getHeight())+" Pixel ";
             jj=fontMetrics.stringWidth(text);
             nx=wx/jj+1;

      g.setColor(Color.black);
      g.setPaintMode();
      for (i=0;i<nx+1;i++) for (j=0;j<ny/2+1;j++)
      {
              g.drawString(text,jj*i,(fontMetrics.getHeight()-3)*(2*j));
              g.drawString(text,jj*i-jj/2,(fontMetrics.getHeight()-3)*(2*j+1));
          }
        break;
        case ctschaerfe.VESA:
      wnx=VesaImage.getWidth(this);
      wny=VesaImage.getHeight(this);
          nx=wx/wnx;
          ny=wx/wny;
          i=0;j=0;
          for (i=0;i<=nx;i++) for (j=0;j<=ny;j++) {
        g.drawImage(VesaImage,i*wnx,j*wny,this);
          }
        break;
        case ctschaerfe.BMPTXT:
      wnx=TextImage.getWidth(this);
      wny=TextImage.getHeight(this);
          nx=wx/wnx;
          ny=wx/wny;
          i=0;j=0;
          for (i=0;i<=nx;i++) for (j=0;j<=ny;j++) {
        g.drawImage(TextImage,i*wnx,j*wny,this);
          }
        }

  }

}

/* ****************************************************************
 * ctscreen
 *
 *
 */


public class ctscreen extends Applet implements Runnable {
  Frame fx=new Frame("c't Monitor Test Programm");
  ctAction ml;
  ctFrameAction fl;
  int actw=-1;
  int sx=640;
  int sy=480;
  ctwindow TestWindow;
  CheckboxGroup boxes;
  Image Myimg;
  boolean isApplication=false;
  URL BaseUrl;
  URL DocumentUrl;
  ctHelpWindow HlpWnd=null;
  TextField breite,hoehe;
  TextCanvas t;
  Color bc;
  Thread kicker;
  Checkbox Lcd_Supp;

static final int MAXCARR=6;
static final String[] carr =  {"  Helligkeit/Kontrast  ",
        "  Graustufen/Brillianz  ",
        "  Geometrie  ",
        "  Aufloesung  ",
        "  Schaerfe  ",
        "  Farbreinheit  ",
        "  Pumpbild/Sprite  "};
static final String mainhelp="ctscreen";

static final String[] cbarr={" 640 x 480"," 800 x 600","1024 x 768",
        "1280 x 1024","1152 x 864","1600 x 1200",
        "   Auto   ","Benutzerdefiniert"};

static final int[][] scarr={{640,480},{800,600},{1024,768},
        {1280,1024},{1152,864},{1600,1200},{-1,-1},{-2,-2}};


static final String BEENDEN="  Beenden  ";
static final String MCLOSE="  Schliessen  ";
static final String ZURUECK="  Hauptmenue  ";
static final String NPAGE  ="  andere Variante  ";
static final String STDTEXT = "c't Monitortestprogramm, Systemschrift ";
static final String HELP = "  Hilfe  ";

          
  public ctscreen() {
  }
  
  protected  void  makebutton(String  name, GridBagLayout gridbag, GridBagConstraints  c)  {
    Button  button  =  new  Button(name);
    gridbag.setConstraints(button,  c);
    button.addActionListener(ml);
    button.addKeyListener(fl);
    add(button);
  }


  protected  void  makecbox(int idx, GridBagLayout gridbag, GridBagConstraints  c, boolean status)  {
    ctCheckbox  cb  =  new  ctCheckbox(idx, boxes, status);
    cb.setBackground(bc);
    gridbag.setConstraints(cb, c);
    add(cb);
  }

  protected void addFramer(GridBagLayout gridbag, GridBagConstraints c) {
    Canvas tf=new Canvas();
    gridbag.setConstraints(tf,  c);
    add(tf);
  }

  public synchronized void start() {
    kicker = new Thread(this);
    kicker.start();
  }


  public synchronized void stop() {
    try {
      if (kicker != null) {
      kicker.stop();
      }
    } catch (Exception e) {
    }
    kicker = null;
  }


  public void restart() {
    stop();
    start();
  }

  public void run() {
    Thread me = Thread.currentThread();
    long temp;
    me.setPriority(10);
    while (true) {
      if (kicker != me) {
          return;
      }
      if (TestWindow!=null) {
        TestWindow.Tick();
      }
      try {
          me.sleep(5);
      } catch (Exception e) {}

    }
  }



  public int getCurrentWindowIdx()
  {
    return actw;
  }

  public void removeDisplay()
  {
    if (actw<0) return;
    TestWindow.dispose();
    actw=-1;
  }



  public void DisplayHelp(int idx)
  {
    String hlptxt;
    if ((idx<-2) || (idx>MAXCARR)) return;


    if (HlpWnd==null) {
      HlpWnd=new ctHelpWindow(idx,this);
    }

    switch (idx) {    
      case -2: hlptxt="CtScreen V1.01.114\n\n"+
      "geschrieben von A. Eschenburg\n"+
      "mit freundlicher Untersttzung von\n"+
      "  Manfred  Agne (Testfenster Geometrie II)\n\n"+
      "(c) Verlag Heinz Heise GmbH\n"+
      "       Hannover, 11/97\n";                    
      break;
      case -1: hlptxt="Hauptfenster\n\n"+

      "Das Programm ctscreen erzeugt Testbilder fr die Einstellung \n"+
      "und Beurteilung von Monitoren. Nach dem Start erkennt das Programm \n"+
      "die aktuelle Bildschirm-Auflsung automatisch (Einstellung \"Auto\").\n"+
      "Falls dies nicht klappt, knnen Sie eine von sechs voreingestellten \n"+
      "Auflsungen whlen oder in der Einstellung \"benutzerdefiniert\" \n"+
      "von Hand angeben.\n\n"+

      "Die Testbilder sind in sechs Gruppen zusammengefat, die Sie \n"+
      "ber die entsprechenden Schaltflchen anwhlen knnen. Innerhalb der \n"+
      "Testbilder ruft ein Mausklick Pop-Up-Men auf, ber das Sie zu anderen \n"+
      "Testbildern gelangen oder andere Varianten des aktuellen Testbilds \n"+
      "aufrufen knnen. Letzteres ist auch per Pfeiltasten der Tastatur mglich. \n\n"+

      "Mit \"Escape\" gelangen Sie aus jedem Testbild wieder zum Hauptmen. ";
      break;
      case 0: hlptxt=ctkontrast.HLPTXT;
      break;
      case 1: hlptxt=ctfarbkontrast.HLPTXT;
      break;
      case 2: hlptxt=ctgeometrie.HLPTXT;
      break;
      case 3: hlptxt=ctaufloesung.HLPTXT;
      break;
      case 4: hlptxt=ctschaerfe.HLPTXT;
      break;
      case 5: hlptxt=ctfarbflaechen.HLPTXT;
      break;
      case 6: if (Lcd_Supp.getState())
                hlptxt=ctmove.HLPTXT;
              else
                hlptxt=ctpumpbild.HLPTXT;
      break;
      default : hlptxt="NO HELP";
    }

    HlpWnd.DisplayText(hlptxt,idx);
  }


  public void DisplayHelp(String Caption)
  {
    if (HlpWnd==null) {
      HlpWnd=new ctHelpWindow(0,this);
    }
    if (Caption=="")
      DisplayHelp(getCurrentWindowIdx());
    else
      for (int i=0;i<MAXCARR+1;i++) {
        if (Caption==carr[i]) {
          DisplayHelp(i);
          return;
        }
      }
  }


  public void SwapDisplay(int toDisplay)
  {
    ctwindow w=null;
    if (toDisplay==actw) return; // same window

    if ((toDisplay>0) || (toDisplay<MAXCARR)) {
      switch (toDisplay) {
        case 1: w=new ctfarbkontrast(fx,this);
        break;
        case 2: w=new ctgeometrie(fx,this);
        break;
        case 0: if (Lcd_Supp.getState())
                  w=new ctkontrast(fx,this,1);
                else      
                  w=new ctkontrast(fx,this,-1);
        break;
        case 3: w=new ctaufloesung(fx,this);
        break;
        case 4: if (IsApplication()) {
          w=new ctschaerfe(fx,this,
            Toolkit.getDefaultToolkit().getImage("vesa.gif"),
            Toolkit.getDefaultToolkit().getImage("text.gif"));
          }
          else try {

          w=new ctschaerfe(fx,this,

            this.getAppletContext().getImage(new URL(BaseUrl.toString()+"vesa.gif")),
            this.getAppletContext().getImage(new URL(BaseUrl.toString()+"text.gif")));
          } catch(Exception e) {}

        break;
        case 5: w=new ctfarbflaechen(fx,this);
        break;
        case 6: if (Lcd_Supp.getState()) {
                  if (IsApplication()) {
                    w=new ctmove(fx,this,Toolkit.getDefaultToolkit().getImage("kreuz.gif"));
                  }
                  else try {
                    w=new ctmove(fx,this,this.getAppletContext().getImage(new URL(BaseUrl.toString()+"kreuz.gif")));
                  } catch(Exception e) {}
                }
                else
                  w=new ctpumpbild(fx,this);

        break;
        default: w=new ctwindow(fx,this);
      }
      w.Init(sx,sy);
    } else w=null;
    if (actw>-1) {
      TestWindow.Uninitialize();
      TestWindow.dispose();
    }

    TestWindow=w;
    actw=toDisplay;
  }

  public void SwapVariant() {
    if (actw>-1)
      TestWindow.SwapVariant(1);
  }

    public boolean ButtonPressed(String caption) {
      int i=0;
        Checkbox b=boxes.getSelectedCheckbox();
      for (i=0;i<8;i++) {
        if (b.getLabel()==ctscreen.cbarr[i]) {
          sx=scarr[i][0];
          sy=scarr[i][1];
        }
      }
      if (sx==-1) {
      Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
      sx=d.width;
      sy=d.height;
        }
        if (sx==-2) {
          try {
            sx=Integer.parseInt(breite.getText());
          } catch(Exception ex) {
            return true;
          }
          try {
            sy=Integer.parseInt(hoehe.getText());
          } catch(Exception ex) {
            return true;
          }
        }

      for (i=0;i<7;i++)
        if (caption==ctscreen.carr[i]) {
          SwapDisplay(i);
          return true;
        }
      if (caption==ctscreen.BEENDEN)
      {
        this.destroy();
        fx.dispose();
        if (isApplication) System.exit(0);
        return true;
      }
      return false;
    }

  public void setFrame(Frame f) {
    fx=f;
  }

  public ctwindow getMainWindow() {
    return TestWindow;
  }

  public boolean IsApplication()
  {
    return isApplication;
  }

  public  void  init()  {
    ml=new ctAction(this);
    fl=new ctFrameAction(this);
    if (!IsApplication()) {

      BaseUrl=this.getCodeBase();
      DocumentUrl=getDocumentBase();
      if (DocumentUrl.toString().indexOf(BaseUrl.toString())!=0)
      return;
    }
    bc=fx.getBackground();

    GridBagLayout  gridbag  =  new  GridBagLayout();
    GridBagConstraints  c  =  new  GridBagConstraints();
    setLayout(gridbag);
    c.fill  =  GridBagConstraints.BOTH;
    c.weightx  =  1.0;
    boxes = new CheckboxGroup();


    imgcanvas w=null;
    if (IsApplication())
      w=new imgcanvas(Toolkit.getDefaultToolkit().getImage("ct.gif"));
    else
      try {
        w=new imgcanvas(this.getAppletContext().getImage(new URL(BaseUrl.toString()+"ct.gif")));
      } catch(Exception ex) {}

    c.gridwidth=1;
    c.gridheight=8;
    addFramer(gridbag, c);

    c.gridwidth  =  6;
    c.gridheight  =  4;
    gridbag.setConstraints(w,  c);
    add(w);

    c.gridwidth=1;
    addFramer(gridbag,c);

    c.gridheight =  1;
    makebutton(carr[0],  gridbag,  c);

    c.gridwidth  =  GridBagConstraints.REMAINDER;
    addFramer(gridbag, c);

    c.gridwidth =  4;
    makebutton(carr[1],  gridbag,  c);

    c.gridwidth  =  GridBagConstraints.REMAINDER;
    addFramer(gridbag, c);

    c.gridwidth =  4;
    makebutton(carr[2],  gridbag,  c);

    c.gridwidth  =  GridBagConstraints.REMAINDER;
    addFramer(gridbag, c);

    c.gridwidth =  4;
    makebutton(carr[3],  gridbag,  c);

    c.gridwidth  =  GridBagConstraints.REMAINDER;
    addFramer(gridbag, c);

    c.gridwidth =  3;
    makecbox(0,  gridbag,  c,false);

    makecbox(1,  gridbag,  c,false);
    c.gridwidth=1;
    addFramer(gridbag,c);

    c.gridwidth = 4;
    makebutton(carr[4],  gridbag,  c);

    c.gridwidth  =  GridBagConstraints.REMAINDER;
    addFramer(gridbag, c);

    c.gridwidth = 3;
    makecbox(2,  gridbag,  c,false);

    makecbox(3,  gridbag,  c,false);
    c.gridwidth=1;
    addFramer(gridbag,c);

    c.gridwidth = 4;
    makebutton(carr[5],  gridbag,  c);

    c.gridwidth  =  GridBagConstraints.REMAINDER;
    addFramer(gridbag, c);

    c.gridwidth = 3;
    makecbox(4,  gridbag,  c,false);

    makecbox(5,  gridbag,  c,false);
    c.gridwidth=1;
    addFramer(gridbag,c);

    c.gridwidth = 4;
    makebutton(carr[6],  gridbag,  c);
    c.gridwidth  =  GridBagConstraints.REMAINDER;

    addFramer(gridbag, c);

    c.gridwidth = 3;
    makecbox(6,  gridbag,  c,true);
    Lcd_Supp=new Checkbox("LCD Support",null,false);
    Lcd_Supp.setBackground(bc);
    gridbag.setConstraints(Lcd_Supp, c);
    add(Lcd_Supp);
    
    c.gridwidth=1;
    addFramer(gridbag,c);


    c.gridwidth  =  GridBagConstraints.REMAINDER;
    addFramer(gridbag, c);
    c.gridwidth=1;
    addFramer(gridbag,c);
    c.gridwidth=3;
    makecbox(7,  gridbag,  c,false);

    c.gridwidth  = 1;
    c.gridheight = 1;

    breite=new TextField("640",5);
    gridbag.setConstraints(breite,  c);
    add(breite);

    t=new TextCanvas("X");
    gridbag.setConstraints(t,  c);
    add(t);

    hoehe=new TextField("480",5);
    gridbag.setConstraints(hoehe,  c);
    add(hoehe);

    addFramer(gridbag,c);
    c.gridwidth = 4;
    if (isApplication) makebutton(ctscreen.BEENDEN,  gridbag,  c);


    c.gridwidth = GridBagConstraints.REMAINDER;
    addFramer(gridbag, c);

    c.gridheight=GridBagConstraints.REMAINDER;
    addFramer(gridbag, c);
    

  }

  public  static  void  main(String  args[])  {
    ctscreen  ex1  =  new  ctscreen();
    ex1.isApplication=true;

    ex1.init();
//     ex1.setSize(580,300);


    ex1.fx.add("Center",  ex1);
    ex1.fx.pack();

    ex1.fx.setVisible(true);
    ex1.fx.addKeyListener(new ctFrameAction(ex1));
    ex1.fx.addWindowListener(new ctFrameAction(ex1));
    ex1.fx.setSize(500,250);
    ex1.start();
  }
}

