                TITLE Mandel
                PAGE 66,132
     ; bei MASM 4.0 hier .8087 oder .287
.486p
Model flat, pascal
.CODE
             PUBLIC ITERASM87  ; Iteration FPU,  87-Mode
             PUBLIC ITERASM487 ; Iteration FPU, 487-Mode
             PUBLIC ITERASM487b; Iteration FPU, 487-Mode, CPU/FPU-Interl
comment #
            PUBLIC ITERASMK3D  ; Iteration; Single Precision 3Dnow!

#

             Locals

;  STACK-Layout:
            RET_ANZ  EQU 16          ; 16 Bytes auf STACK
IS          EQU     DWORD PTR [EBP+20]; Single Prec
RS          EQU     DWORD PTR [EBP+16]; Single Prec
GRENZE      EQU     WORD PTR  [EBP+12];
TIEFE       EQU     WORD PTR  [EBP+8]; globale Variable
RET_ADR     EQU     EBP+4            ;-------------
BP_SAVE     EQU     EBP+0            ; Save-Bereich
A           EQU     EBP-2            ; lokale Variable
B           EQU     EBP-4            ;

.8087
;---------------
iterasm87   PROC    NEAR            ;
            PUSH    EBP             ; Erhalte EBP
            MOV     EBP,ESP         ; Adressiere den Stack
            SUB     ESP,4           ; Platz fuer 2 Integer
;
;  Verwendung der Register:
;  AX = Funktionswert: Iterationen
;  BX = +Grenze
;  DX = -Grenze
;  CX = Tiefe
;  SS:EBP-> Stack  der CPU
;
            FINIT                          ; alles neu
            FLD    RS                      ; R laden
            FLD    IS                      ; L laden
            FLDZ                           ; A = 0
            FLDZ                           ; B = 0
            MOV     CX,TIEFE               ; CX = max Loopcount
            MOV     BX,GRENZE              ; BX = +GRENZE
            MOV     DX,BX
            NEG     DX                     ; DX = -GRENZE
            SUB     AX,AX                  ; AX = Funktionswert = 0
;
;   Quadriere (A + jB)**2 = A**2 - B**2 + j 2*A*B
;
@@ITER_2:   FLD     ST(1)           ; Kopiere A
            FMUL    ST(0),ST(0)     ; A**2

            FLD     ST(1)           ; Kopiere B
            FMUL    ST(0),ST(0)     ; B**2
            FSUB                    ; A**2 - B**2
;
            FADD    ST(0),ST(4)     ; A(n+1)=A**2 - B**2 + U
            FIST    WORD PTR [A]    ; Lege ab fuer Vergleich
            INC     AX              ; Funktionswert +1
;
            FXCH    ST(2)
            FMUL                    ; A*B
            FADD    ST(0),ST(0)     ; 2*A*B
            FADD    ST(0),ST(2)     ; B(n+1) = 2*A*B + V
            FIST    WORD PTR [B]    ; Lege ab fuer Vergleich
;
;  Sieh nach, ob A oder B > GRENZE ist
;
            CMP     [A],BX          ; A > +Grenze?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [A],DX          ; A < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            FWAIT                   ; Warte auf Ablage von B
            CMP     [B],BX          ; B > +Grenze ?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [B],DX          ; B < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            DEC     CX
            JNZ     @@ITER_2          ; A, B innerhalb +-Grenze
@@ITER_4:   FINIT
            MOV     ESP,EBP         ; Restore ESP
            POP     EBP             ;  und BP
            RET     RET_ANZ         ; Entferne Parameter
                ;---------------
iterasm87  ENDP
;  Same Procedure with .486p

.486p
;---------------
iterasm487 PROC    NEAR            ;
            PUSH    EBP              ; Erhalte EBP
            MOV     EBP,ESP           ; Adressiere den Stack
            SUB     ESP,4            ; Platz fuer 2 Integer
;
;  Verwendung der Register:
;  AX = Funktionswert: Iterationen
;  BX = +Grenze
;  DX = -Grenze
;  CX = Tiefe
;  SS:EBP-> Stack  der CPU
;
            FINIT                          ; alles neu
            FLD    RS                      ; R laden
            FLD    IS                      ; L laden
            FLDZ                           ; A = 0
            FLDZ                           ; B = 0
            MOV     CX,TIEFE               ; CX = max Loopcount
            MOV     BX,GRENZE              ; BX = +GRENZE
            MOV     DX,BX
            NEG     DX                     ; DX = -GRENZE
            SUB     AX,AX                  ; AX = Funktionswert = 0
;
;   Quadriere (A + jB)**2 = A**2 - B**2 + j 2*A*B
;
@@ITER_2:   FLD     ST(1)           ; Kopiere A
            FMUL    ST(0),ST(0)     ; A**2

            FLD     ST(1)           ; Kopiere B
            FMUL    ST(0),ST(0)     ; B**2
            FSUB                    ; A**2 - B**2
;
            FADD    ST(0),ST(4)     ; A(n+1)=A**2 - B**2 + U
            FIST    WORD PTR [A]    ; Lege ab fuer Vergleich
            INC     AX              ; Funktionswert +1
;
            FXCH    ST(2)
            FMUL                    ; A*B
            FADD    ST(0),ST(0)     ; 2*A*B
            FADD    ST(0),ST(2)     ; B(n+1) = 2*A*B + V
            FIST    WORD PTR [B]    ; Lege ab fuer Vergleich
;
;  Sieh nach, ob A oder B > GRENZE ist
;
            CMP     [A],BX          ; A > +Grenze?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [A],DX          ; A < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            CMP     [B],BX          ; B > +Grenze ?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [B],DX          ; B < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            DEC     CX
            JNZ     @@ITER_2          ; A, B innerhalb +-Grenze
@@ITER_4:   FINIT
            MOV     ESP,EBP           ; Restore ESP
            POP     EBP              ;  und EBP
            RET     RET_ANZ
iterasm487 ENDP


.486p   ; wie zuvor aber CPU und  FPU verschrnkt
;---------------
iterasm487b PROC    NEAR            ;
            PUSH    EBP              ; Erhalte EBP
            MOV     EBP,ESP           ; Adressiere den Stack
            SUB     ESP,4            ; Platz fuer 2 Integer
;
;  Verwendung der Register:
;  AX = Funktionswert: Iterationen
;  BX = +Grenze
;  DX = -Grenze
;  CX = Tiefe
;  SS:EBP-> Stack  der CPU
;
            FINIT                          ; alles neu
            FLD    RS                      ; R laden
            FLD    IS                      ; L laden
            FLDZ                           ; A = 0
            FLDZ                           ; B = 0
            MOV     CX,TIEFE               ; CX = max Loopcount
            MOV     BX,GRENZE              ; BX = +GRENZE
            MOV     DX,BX
            NEG     DX                     ; DX = -GRENZE
            SUB     AX,AX                  ; AX = Funktionswert = 0
;
;   Quadriere (A + jB)**2 = A**2 - B**2 + j 2*A*B
;
@@ITER_2:   FLD     ST(1)           ; Kopiere A
            FMUL    ST(0),ST(0)     ; A**2

            FLD     ST(1)           ; Kopiere B
            FMUL    ST(0),ST(0)     ; B**2
            FSUB                    ; A**2 - B**2
;
            FADD    ST(0),ST(4)     ; A(n+1)=A**2 - B**2 + U
            FIST    WORD PTR [A]    ; Lege ab fuer Vergleich
            INC     AX              ; Funktionswert +1
;
            CMP     [A],BX          ; A > +Grenze?
            JG      @@ITER_4          ;  Ja, fertig

            FXCH    ST(2)

            CMP     [A],DX          ; A < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig

            FMUL                    ; A*B
            FADD    ST(0),ST(0)     ; 2*A*B
            FADD    ST(0),ST(2)     ; B(n+1) = 2*A*B + V
            FIST    WORD PTR [B]    ; Lege ab fuer Vergleich
;
;  Sieh nach, ob A oder B > GRENZE ist
;
            CMP     [B],BX          ; B > +Grenze ?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [B],DX          ; B < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            DEC     CX
            JNZ    @@ITER_2          ; A, B innerhalb +-Grenze
@@ITER_4:   FINIT
            MOV     ESP,EBP           ; Restore ESP
            POP     EBP              ;  und EBP
            RET     RET_ANZ
iterasm487b ENDP

app_16Bit equ 1
include  ctmmxn.inc

;---------------
iterasmK3D  PROC    NEAR            ;
            PUSH    EBP              ; Erhalte EBP
            MOV     EBP,ESP           ; Adressiere den Stack
            SUB     ESP,32           ; Platz fuer 4 Dwords
;
;  Verwendung der Register:
;  AX = Funktionswert: Iterationen
;  BX = +Grenze
;  DX = -Grenze
;  CX = Tiefe
;  SS:EBP-> Stack  der CPU
             ;  STACK-Layout: (IM/RM vertauscht)

          mEB EQU [EBP-4]
          mEA EQU [EBP-8]
          iB  EQU [EBP-12]
          iA  EQU [EBP-16]
          NULL2 EQU [EBP-20]
          NULL  EQU [EBP-24]
          EINSM EQU [EBP-28]
          EINS  EQU [EBP-32]

            XOR     EAX,EAX
            MOV     NULL,EAX
            MOV     NULL2,EAX
            MOV     EAX,03F800000h   ;=1
            MOV     EINS,EAX
            MOV     EAX,0BF800000h   ;=-1
            MOV     EINSM,EAX
            FEMMS                   ; alles neu
comment #
            MOVQ    MM0,Null        ; A = 0 | B=0
            MOVQ    MM1,Eins        ; 1     | -1
            MOVQ    MM2,RS          ; R+L laden
            MOV     CX,TIEFE        ; CX = max Loopcount
            MOV     BX,GRENZE      ; BX = +GRENZE
            MOV     DX,BX
            NEG     DX             ; DX = -GRENZE
            MOV     EAX,32
            MOVD1   MM7,eax
            SUB     AX,AX           ; AX = Funktionswert = 0
;
;   Quadriere (A + jB)**2 = A**2 - B**2 + j 2*A*B
;   Entry   MM0                     ;A           | B
;           MM1                     ;1           | -1
;           MM2                     ;R           | I
;
@@ITER_2: ;  MOVQ    meA,MM0         ;meA=A       | B
          ;  MOVQ    MM3,MM0         ;MM3= A      | B
          ;  MOV     esi,meA         ;esi=A
          ;  XCHG    meB,esi         ;meA=A       | meB=A
          ;  MOV     meA,esi         ;meA=B       | meB=A
          ;  PFMUL   MM3,meA         ;MM3= A*B    | A*B


            MOVQ    MM3,MM0         ;MM3=A     | B
            MOVQ    MM4,MM0         ; oh weh
            PSLLQ   MM3,32          ; das Vertauschen ist
            PSRLQ   MM4,32          ; sehr mhsam ...
            POR     MM3,MM4         ;MM3=B      | A

            PFMUL   MM3,MM0         ;MM3= A*B    | A*B
            PFMUL   MM0,MM0         ;MM0= A**2   | B**2
            PFMUL   MM0,MM1         ;MM0= A**2   | -B**2
            PFACC   MM0,MM3         ;MM0= A**2 - B**2     | A*B+A*B
            PFADD   MM0,MM2         ;MM0= A**2 - B**2 + R | 2*A*B+I
                                    ;c:\ = A(n+1)              = B(n+1)
            PF2ID   MM4,MM0         ;iA = INT(A)  | iB = Int(B)
            MOVQ    iA,MM4
;  Sieh nach, ob A oder B > GRENZE ist
            INC     AX
            CMP     [iA],BX         ; A > +Grenze?
            JG      @@ITER_4        ;  Ja, fertig
            CMP     [iA],DX         ; A < -Grenze ?
            JL      @@ITER_4        ;  Ja, fertig
            CMP     [iB],BX         ; B > +Grenze ?
            JG      @@ITER_4        ;  Ja, fertig
            CMP     [iB],DX         ; B < -Grenze ?
            JL      @@ITER_4        ;  Ja, fertig
            DEC     CX
            JNZ    @@ITER_2        ; A, B innerhalb +-Grenze
#
@@ITER_4:   ;FEMMS
            MOV     ESP,EBP           ; Restore ESP
            POP     EBP              ;  und EBP
            RET     RET_ANZ         ; Entferne Parameter
                ;---------------
iterasmK3D  ENDP
            END
