// HDWIN.CPP contains the user interface code for HDINFO
// HDINFO.CPP contains the actual hardware analysis functions

// If you compile this, you will find that the background
// and button colours differ from mine.  This is due to the
// fact that I have edited the application palette (in APP.H)
// to colours which I prefer, and changed the coding of
// TButton::drawState().  The changes are only cosmetic.

#define Uses_TEventQueue
#define Uses_TEvent
#define Uses_TApplication
#define Uses_TKeys
#define Uses_TRect
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_TView
#define Uses_TWindow
#define Uses_TButton
#define Uses_MsgBox
#define Uses_TDialog

#include <tv.h>
#include <conio.h>
#include "hdinfo.h"

// hardware interface routines (in HDINFO.CPP)
extern unsigned secbuf[2][256];
extern void readcmos( void);
extern void writecmos( void);
extern int drive0, drive1;
extern void readdrives(void);

// prototypes for various functions in this unit
// all these do is display info
void doDrive0( void);
void doDrive1( void);
void ExitInstructions( void);
void printinfo( struct ideinfo *id);
void printnodrive( void);

// constant for menu commands
const int cmDrive0= 200;
const int cmDrive1 = 201;
const int cmAbout = 204;


class TInfoWindow : public TWindow
	{
	public:
		TInfoWindow( const TRect& r, const char *aTitle, short aNumber );
	};

TInfoWindow *InfoWindow;

TInfoWindow::TInfoWindow( const TRect& bounds, const char *aTitle,
				  short aNumber) :
			TWindow( bounds, aTitle, aNumber),
			TWindowInit( &TInfoWindow::initFrame )
	{
	// plain window with border - no controls at all
	flags = 0;
	options = 0;
	};

class TControlDialog: public TDialog
	// we could subclass TWindow instead of TDialog but we
	// would then need to create a new Palette to handle
	// buttons inserted on the Window (the button palette
	// entries extend beyond the normal window palette)
	{
	public:
		TControlDialog( const TRect& r, const char *aTitle);
		void handleEvent( TEvent& event );

		TButton *ButtonDrive0;
		TButton *ButtonDrive1;
		TButton *ButtonExit;
	};

TControlDialog::TControlDialog( const TRect& r, const char *aTitle):
	TDialog( r, aTitle),	TWindowInit( &TInfoWindow::initFrame )
	{
	flags = 0;
	ButtonDrive0 = new TButton( TRect(2, 2, 15, 4), "Drive ~C~", cmDrive0, bfDefault);
	insert( ButtonDrive0);
	ButtonDrive1 = new TButton( TRect(2, 4, 15, 6), "Drive ~D~", cmDrive1, bfNormal);
	insert( ButtonDrive1);
	ButtonExit = new TButton( TRect(2, 7, 15, 9), "E~x~it.",cmQuit,bfNormal);
	insert( ButtonExit);
	};

void TControlDialog::handleEvent( TEvent& event )
	// override default dialog box message handling
	{
	 int answer;

    TGroup::handleEvent(event);
	 if( event.what== evCommand )
		  switch (event.message.command)
				{
				case cmDrive0:						// Menu command cmDrive0
					ButtonDrive0->select();		// highlight the Drive 0 button
					doDrive0();						// print info for drive 0
					break;
				case cmDrive1:
					ButtonDrive1->select();		// as above for cmDrive0
					doDrive1();
					break;
				case cmQuit:
					ButtonExit->select();		// highlight the exit button
					answer = messageBoxRect( TRect( 31, 5, 64, 13), "Do you really want to Exit?", mfOKButton | mfCancelButton
												| mfConfirmation);
					if (answer == cmCancel)
						{
						clearEvent( event);		// if not exit
						ExitInstructions();		// redisplay exit instructions
						}
					break;
				case cmAbout:						// do some advertising
					messageBoxRect (TRect( 28, 4, 65, 13),
										"HDINFO - Hard Drive Information " \
										"Copyright (c) 1993 James Thorpe " \
										"CIS ID# 100035,101",
										mfOKButton | mfInformation );

					//	after the message box has been displayed
					// go back and redisplay the information which
					// lay underneath it.  ie. find which button
					// is highlighted and do what it requires

					if ((ButtonDrive0->state & sfSelected) != 0)
						doDrive0();
					if ((ButtonDrive1->state & sfSelected) != 0)
						doDrive1();
					if ((ButtonExit->state & sfSelected) != 0)
						ExitInstructions();
					break;
				}
	 // now handle keyboard input.
	 // arrow keys and tab key can be used to move
	 // between controls.
	 else if( event.what == evKeyDown )
			switch (event.keyDown.keyCode)
				 {
					 case  kbTab:
					 case  kbRight:
					 case  kbDown:
							// select the previous button
							selectNext(False);

							// print info matching highlighted button
							if ((ButtonDrive0->state & sfSelected) != 0)
								{
								event.what = evCommand;
								event.message.command = cmDrive0;
								handleEvent( event );
								}
							if ((ButtonDrive1->state & sfSelected) != 0)
								{
								event.what = evCommand;
								event.message.command = cmDrive1;
								handleEvent( event );
								}
							if ((ButtonExit->state & sfSelected) != 0)
								{
								ExitInstructions();
								}
						  break;
					 case  kbShiftTab:
					 case  kbLeft:
					 case  kbUp:
							// select the next button
							selectNext(True);

							// print info matching highlighted button
							if ((ButtonDrive0->state & sfSelected) != 0)
								{
								event.what = evCommand;
								event.message.command = cmDrive0;
								handleEvent( event );
								}
							if ((ButtonDrive1->state & sfSelected) != 0)
								{
								event.what = evCommand;
								event.message.command = cmDrive1;
								handleEvent( event );
								}
							if ((ButtonExit->state & sfSelected) != 0)
								ExitInstructions();
							break;
					 case kbEnter:
						if ((ButtonExit->state & sfSelected) != 0)
							{
							event.what = evCommand;
							event.message.command = cmQuit;
							handleEvent( event );
							break;
							} //if
				 } // switch
	 };


class TMyApp : public TApplication
	{
	public:
		TMyApp();
		static TStatusLine *initStatusLine( TRect r );
		static TMenuBar *initMenuBar( TRect r );
	};

TMyApp::TMyApp() : TProgInit( &TMyApp::initStatusLine,
						 &TMyApp::initMenuBar,
						 &TMyApp::initDeskTop )
	{
	InfoWindow = new TInfoWindow( TRect( 23, 1, 76, 21), NULL, 0);
	deskTop->insert(InfoWindow);
	TControlDialog *ControlDialog = new TControlDialog( TRect( 2, 4, 19, 14), NULL);
	deskTop->insert(ControlDialog);
	ControlDialog->ButtonDrive0->select();		// set highlight flag
	ControlDialog->ButtonDrive0->press();		// send message matching button so that
															// handleEvent() will then display the
															// data matching this button.
	};

TStatusLine *TMyApp::initStatusLine(TRect r)
	{
	// the status line dispatches a cmAbout broadcast
	// which brings up the About... dialog box
	r.a.y = r.b.y - 1;     // move top to 1 line above bottom
	return new TStatusLine( r,
		*new TStatusDef( 0, 0xFFFF ) +
			*new TStatusItem( "HDInfo version 1.2 - Copyright 1993 James Thorpe", 0, cmAbout, NULL ));
	};

TMenuBar *TMyApp::initMenuBar( TRect r )
	{
	r.b.y = r.a.y + 1;    // set bottom line 1 line below top line
	return new TMenuBar( r,
		*new TSubMenu( "~F~ile", kbAltF )+
			*new TMenuItem( "Drive ~C~", cmDrive0, 0, hcNoContext, "" )+
			*new TMenuItem( "Drive ~D~",  cmDrive1, 0, hcNoContext, "" )+
			newLine()+
			*new TMenuItem( "E~x~it", cmQuit, cmQuit, hcNoContext, "" )+
		*new TSubMenu( "~A~bout", kbAltO )+
			*new TMenuItem( "~A~bout HDINFO", cmAbout, 0, hcNoContext, "" ));
	};


int main( void)
	{
	readdrives();			// get info about hard drives
	TMyApp myApp;			// bring up user interface
	myApp.run();			// and display data
	return 0;
	}

// Herein start the utility routines which respond to the
// interface code above.  Even though we are using the
// CONIO screen output functions we still get the screen
// colours for each function from the TWindow palette.
// This should mean that we get a reasonable display
// on colour and mono monitors and that it is
// co-ordinated with the dialogs and windows.

void doDrive0( void)
// display information about drive 0
	{
	struct ideinfo *id = (struct ideinfo *)secbuf[0];
	TRect r = InfoWindow->getBounds();
	window( r.a.x+3, r.a.y+3, r.b.x-1, r.b.y);
	textattr( (char)InfoWindow->getColor( 0x0301));
	clrscr();
	textattr( (char)InfoWindow->getColor( 0x0304));
	cputs("      SPECIFICATIONS FOR HARD DISK DRIVE C.      \n\n\r");
	if (drive0 == 1)
		printinfo( id);
	else
		printnodrive();
	};

void doDrive1( void)
// display information about drive 1
	{
	struct ideinfo *id = (struct ideinfo *)secbuf[1];

	TRect r = InfoWindow->getBounds();
	window( r.a.x+3, r.a.y+3, r.b.x-1, r.b.y);
	textattr( (char)InfoWindow->getColor( 0x0301));
	clrscr();
	textattr( (char)InfoWindow->getColor( 0x0304));
	cputs("      SPECIFICATIONS FOR HARD DISK DRIVE D.      \n\n\r");
	if (drive1 == 1)
		printinfo( id);
	else
		printnodrive();
	};

char *cont_type[] = { "Not specified",
							"Single port, Single sector buffer",
							"Dual port, Multi-sector buffer",
							"Dual port, Multi-sector buffer with cache",
							"Not specified" };

void printinfo(struct ideinfo *id)
	// routine to print drive info
	// doDrive0() and doDrive1() collect their respective
	// parameters and come here to print them.
	{
	textattr( (char)InfoWindow->getColor( 0x0306));
	cputs(   "DRIVE INDENTIFICATION\n\r");
	textattr( (char)InfoWindow->getColor( 0x0302));
	cprintf( "Model:    %.38s\n\r", id->model);
	cprintf( "Firmware: %.8s\n\r", id->firmware);
	cprintf( "Serial #: %.20s\n\n\r", id->serial);
	textattr( (char)InfoWindow->getColor( 0x0306));
	cputs(   "DRIVE CONTROLLER DETAILS\n\r");
	textattr( (char)InfoWindow->getColor( 0x0302));
	cprintf( "Type:   %s\n\r", cont_type[id->contype]);
	cprintf( "Access: %u bit\n\n\r", id->dblword);
	textattr( (char)InfoWindow->getColor( 0x0306));
	cputs(   "DRIVE SPECIFICATIONS (According to:)\n\r");
	textattr( (char)InfoWindow->getColor( 0x0302));
	cprintf( "Drive: %#5u Cyls,%#3u Heads,%#3u Secs = %#8.2lfMb\n\r",
				 id->fixcyls, id->heads, id->sectors, id->capacity);
	cputs(   "BIOS:  ");
	if (id->biosheads != (unsigned)-1)
		cprintf( "%#5u Cyls,%#3u Heads,%#3u Secs = %#8.2lfMb\n\r",
				 id->bioscyls, id->biosheads, id->biossecs, id->bioscapacity);
	else
		cputs("The BIOS does not recognise this drive.\n\r");
	if( id->bioscapacity == id->capacity)
		{
		cputs( "\nThe current BIOS settings for this drive are\n\r" \
				 "optimum settings, and give 100% utilisation of\n\r" \
				 "the available physical disk space");
		}
	else
		{
		cprintf( "Theory:%#5u Cyls,%#3u Heads,%#3u Secs = %#8.2lfMb\n\r",
				 id->bestcyls, id->bestheads, id->bestsecs, id->capacity);
		cprintf( "\nThe theoretical BIOS settings will increase disk\n\r" \
					"capacity by %.2lfMb over current settings.", id->capacity - id->bioscapacity);
		};
	};

void printnodrive( void)
// if no drive available then print message to that effect.
	{
	textattr( (char)InfoWindow->getColor( 0x0306));
	cputs("\n\r" \
			"    Analysis of the hardware indicates that\n\r" \
			"    this drive is not installed.\n\n\r");
	textattr( (char)InfoWindow->getColor( 0x0302));
	cputs("    If this drive is installed then either\n\r" \
			"    the drive is not an IDE drive or, there\n\r" \
			"    is a fault in the drive hardware or\n\r" \
			"    in the cabling."
			);
	};

void ExitInstructions( void)
// tell the user to type ENTER to exit.
// Add a warning about changing the CMOS settings.
	{
	TRect r = InfoWindow->getBounds();
	window( r.a.x+3, r.a.y+3, r.b.x-1, r.b.y);
	textattr( (char)InfoWindow->getColor( 0x0301));
	clrscr();
	textattr( (char)InfoWindow->getColor( 0x0306));
	cputs("\n\n\n\n\n\r" \
			"              Type ENTER to Exit.\n\r" );
	textattr( (char)InfoWindow->getColor( 0x0302));
	cputs("\n\n\n\r" \
			"    WARNING: Do NOT alter the CMOS settings\n\r" \
			"    for a hard drive that is currently in use,\n\r" \
			"    unless you are prepared to reformat it and\n\r" \
			"    reinstall all your software.");
	};
