	 title	 ID386 -- Return 386 Component Identifier
	 page	 58,122
	 name	 ID386

COMMENT|		Module Specifications

Copyright:  (C) Copyright 1987-91 Qualitas, Inc.

Environment:  IBM PC, tested under DOS 3.30.

Segmentation:  Group PGROUP:
	       Stack   segment STACK, word-aligned,  stack,  class 'prog'
	       Program segment CODE,  word-aligned,  public, class 'prog'
	       Data    segment DATA,  dword-aligned, public, class 'data'
	       Tail    segment DTAIL, dword-aligned, public, class 'data'

Original code by:  Bob Smith, November, 1987.

Modifications by:

Who		 When		What
--------------------------------------------------------------------------------

Bob Smith	 9 Jan 90	Implement BIOS call to request information
Bob Smith	 9 Jan 90	Ensure A20 is disabled to force INT 06h
Bob Smith	21 Feb 90	Allow to be called from Virtual 8086 Mode
Bob Smith	 1 Nov 91	Handle BIOS bug of near vs. far jump

|

.386p
.xlist
	 include MISC.INC
	 include SYSID.INC
	 include BIOSCONF.INC
	 include PTR.INC
	 include CMOS.INC
	 include VERSION.INC
.list


PGROUP	 group	 STACK,CODE,DATA,DTAIL


BIOSDATA segment use16 at 40h	; Start BIOSDATA segment

	 org	 67h
IO_ROM_INIT dw	 ?		; Pointer to optional I/O ROM init routine
IO_ROM_SEG dw	 ?		; Pointer to I/O ROM segment

BIOSDATA ends			; End BIOSDATA segment


; The following segment both positions class 'prog' segments lower in
; memory than others so the first byte of the resulting .COM file is
; in the CODE segment, as well as satisfies the LINKer's need to have
; a stack segment.

STACK	 segment use16 word stack 'prog' ; Start STACK segment
STACK	 ends			; End STACK segment


DATA	 segment use16 dword public 'data' ; Start DATA segment
	 assume  ds:PGROUP

ifdef DEBUG
	 extrn	 IDT_DESC:qword
	 extrn	 IDT_DESC_LEN:abs
endif				; IFDEF DEBUG

	 public  RESETSTK_VEC,RESETSTK_OLD,LCLSTKZ_VEC
RESETSTK_VEC dd  00000000h	; Reset stack Seg:Off ending at 0:0
RESETSTK_OLD dw  6 dup (?)	; Save area for old reset stack contents
LCLSTKZ_VEC label dword 	; Seg:Off of local stack top
	 dw	 PGROUP:LCLSTKZ,? ; Define as two words because MASM doesn't
				; support OFFSET16

	 public  OLDGDTR,OLDIDTR,OLDCR0,OLDCR3
	 public  OLDDR0,OLDDR1,OLDDR2,OLDDR3,OLDDR6,OLDDR7
	 public  OLDTR,TOPMEM
OLDGDTR  df	 ?		; Save area for old GDTR
OLDIDTR  df	 ?		; ...		    IDTR
OLDCR0	 dd	 ?		; ...		    CR0
OLDCR3	 dd	 ?		; ...		    CR3
OLDDR0	 dd	 ?		; ...		    DR0
OLDDR1	 dd	 ?		; ...		    DR1
OLDDR2	 dd	 ?		; ...		    DR2
OLDDR3	 dd	 ?		; ...		    DR3
OLDDR6	 dd	 ?		; ...		    DR6
OLDDR7	 dd	 ?		; ...		    DR7
OLDTR	 dw	 ?		; ...		    TR
TOPMEM	 dw	 ?		; Target for read from FFEFFFF0

	 public  MOVE_TAB
	 align	 4		; Ensure GDT is dword-aligned
MOVE_TAB MDTE_STR <>		; BIOS block move DTE structure

	 public  REALIDTR
REALIDTR df	 4*100h-1	; Limit/base of real mode IDTR

ifdef DEBUG
	 public  PROTIDTR
PROTIDTR df	 ?		; Save area for prot mode IDTR
endif				; IFDEF DEBUG

	 public  COMPID_BIOS,COMPID_S0A,COMPID_I06
COMPID_BIOS dw	 ?		; Component ID, returned from BIOS
COMPID_S0A dw	 ?		; Component ID, returned from SHUT0A
COMPID_I06 dw	 ?		; ... INT 06h value (if any)

	 public  OLDINT06_VEC
OLDINT06_VEC dd  ?		; Save area for old INT 06h handler

	 public  INT06_PTR
INT06_PTR dd	 ?		; Save area for INT 06h caller's CS:IP

	 public  HEXTABLE
HEXTABLE db	 '0123456789ABCDEF' ; Hex translate table

	 public  NMIPORT,NMIENA,NMIDIS,NMIMASK
NMIPORT  dw	 @CMOS_CMD	; NMI clear I/O port
NMIENA	 db	 @CMOS_ENANMI	; ... enable value
NMIDIS	 db	 @CMOS_DISNMI	; ... disable value
NMIMASK  db	 mask $ATPAR	; ... clear mask

	 public  ROMINT_VEC,ROMINT_PTR,ROMINT_NUM
ROMINT_VEC dd	 ?		; Save area for old ROM INT handler
ROMINT_PTR dw	 ?		; Offset of local routine
ROMINT_NUM db	 ?		; Save area for old ROM INT number

	 public  INTA01,INTB01
INTA01	 db	 ?		; Save value of master IMR
INTB01	 db	 ?		; Save value of slave ...

	 public  SHUT_ORIG
SHUT_ORIG db	 ?		; Save area for original shutdown byte

	 public  LCL_FLAG
	 include ID3_LCL.INC
LCL_FLAG db	 0		; Local flags

	 public  MSG_COPY
MSG_COPY db	 '386ID    -- Version '
	 db	 VERS_H,'.',VERS_T,VERS_U
	 db	 ' (C) Copyright 1987-92 Qualitas, Inc.',CR,LF,EOS

	 public  MSG_OKID
MSG_OKID db	 'The component ID is '
MSG_OKID1 db	 '____ from ',EOS

	 public  MSG_INT06,MSG_SHUT0A,MSG_BIOS
MSG_INT06 db	 'the INT 06h handler ('
MSG_INT06SEG db  '____:'
MSG_INT06OFF db  '____).',CR,LF,EOS

MSG_SHUT0A db	 'the type 0Ah shutdown.',CR,LF,EOS
MSG_BIOS db	 'the BIOS.',CR,LF,EOS

	 public  MSG_NOT386,MSG_NOA20,MSG_NOFTB
MSG_NOT386 db	 BEL,'> The CPU is not an 80386 or later.',CR,LF,EOS
MSG_NOA20 db	 BEL,'> Unable to disable the A20 line.',CR,LF,EOS
MSG_NOFTB db	 BEL,'> This system does not have a fully-terminated bus,',CR,LF
	  db	     '    so we did not attempt system shutdown.',CR,LF,EOS

DATA	 ends			; End DATA segment


; The following segment serves to address the next available byte
; after the DATA segment.  This location may be used for any variable
; length data which extends beyond the program.

DTAIL	 segment use16 dword public 'data' ; Start DTAIL segment
	 assume  ds:PGROUP

	 public  LCLSTK,LCLSTKZ
LCLSTK	 label	 word		; Local stack
	 org	 LCLSTK+100h	; Skip over stack
LCLSTKZ  label	 word		; Return offset at top-of-stack

	 public  LOWGDT
LOWGDT	 label	 byte		; Low memory copy of GDT for TR search

DTAIL	 ends			; End DTAIL segment


CODE	 segment use16 word public 'prog' ; Start CODE segment
	 assume  cs:PGROUP

	 extrn	 GATEA20:near
	 extrn	 DEGATEA20:near
	 extrn	 PPI_S2K_K2S:near

.xlist
	 include PSP.INC	; Define & skip over PSP area for .COM program
.list
	 NPPROC  ID386 -- Return 386/486 Chip Identifiers
	 assume  ds:PGROUP,es:PGROUP,fs:nothing,gs:nothing,ss:PGROUP
COMMENT|

Determine 386/486 component identifier and revision level.

See the accompanying .DOC file for a complete description.

|

	 mov	 LCLSTKZ_VEC.VSEG,cs ; Setup segment for local stack

	 STROUT  MSG_COPY	; Display the flag

; Ensure we're on a 386/486 processor

	 call	 CHECK_CPUID	; Check it out
	 jnc	 short @F	; Jump if OK

	 jmp	 ID386_EXIT	; Jump if something went wrong
@@:
	 lss	 sp,LCLSTKZ_VEC ; Switch to local stack
	 assume  ss:nothing	; Tell the assembler about it

	 smsw	 ax		; Get low-order word of CR0

	 test	 ax,mask $PE	; Izit Protected Mode (actually Virtual 8086 Mode)?
	 jz	 short @F	; Jump if not

	 or	 LCL_FLAG,@LCL_VM ; Mark as Virtual 8086 Mode
@@:
	 mov	 ax,0C910h	; Major/minor function to get info
	 int	 15h		; Request BIOS services
	 jc	 short ID386_NOBIOS ; Jump if not supported

	 mov	 COMPID_BIOS,cx ; Save for later use
	 or	 LCL_FLAG,@LCL_BIOS ; Mark as coming from BIOS
ID386_NOBIOS:

; Check for fully-terminated bus at 4GB - 1MB - 16; that is,
; read in the first two bytes there and ensure that they are FF FF.
; If not, then the trick of resetting the system with A20 disabled
; will crash the system as we're relying upon generating an invalid
; opcode.

	 call	 CHECK_FTB	; Check for a fully-terminated bus
	 jnc	 short @F	; Jump if OK

	 STROUT  MSG_NOFTB	; Display error message

	 or	 LCL_FLAG,@LCL_XFTB ; Mark as not present
@@:

; Check for Virtual 8086 Mode -- if present, we need to setup several
; variables to allow us to return to that mode after system reset.

	 test	 LCL_FLAG,@LCL_VM ; Izit Virtual 8086 Mode?
	 jz	 short ID386_REGS ; Jump if not

COMMENT|

Some Virtual 8086 Mode handlers don't support reads of CR0 and CR3.
If they don't, they'll probably signal a General Protection Fault.
Unfortunately, in order to return to Virtual 8086 Mode we need this
information.  The value of CR0 can be obtained through a VCPI call,
but not CR3.

If you encounter a GP Fault here, disable your Virtual 8086 Mode
handler and retry.

|

	 mov	 eax,cr0	; Get current CR0
	 mov	 OLDCR0,eax	; Save to restore later

	 mov	 eax,cr3	; Get current CR3
	 mov	 OLDCR3,eax	; Save to restore later

	 SIDTD	 OLDIDTR	; Save to restore later
	 SGDTD	 OLDGDTR	; ...

; We would like to save the current Task Register, but there's no way
; we can ask the CPU because STR is a privileged instruction.  We'll find
; the value later on by searching through the GDT for the first busy 386 TSS.

	 mov	 FARCS,cs	; Save segment for real mode switch

ID386_REGS:
	 mov	 eax,dr0	; Save debug registers
	 mov	 OLDDR0,eax	; ...to restore later

	 mov	 eax,dr1	; Save debug registers
	 mov	 OLDDR1,eax	; ...to restore later

	 mov	 eax,dr2	; Save debug registers
	 mov	 OLDDR2,eax	; ...to restore later

	 mov	 eax,dr3	; Save debug registers
	 mov	 OLDDR3,eax	; ...to restore later

	 mov	 eax,dr6	; Save debug registers
	 mov	 OLDDR6,eax	; ...to restore later

	 mov	 eax,dr7	; Save debug registers
	 mov	 OLDDR7,eax	; ...to restore later

; Install our own INT 23h and 06h handlers

	 SETINT  23h,INT23	; Install our own Ctrl-Break handler
				; Note no need to save previous handler

	 GETINT  06h		; Get invalid opcode interrupt handler
	 assume  es:nothing	; Tell the assembler about it
				; Return with ES:BX ==> existing handler

	 mov	 OLDINT06_VEC.VOFF,bx ; Save to restore later
	 mov	 OLDINT06_VEC.VSEG,es ; ...

	 SETINT  06h,INT06	; Install our own Invalid Opcode handler

; Determine system type of XT, Micro Channel, or other

	 call	 CHECK_SYSID	; Check on it

	 push	 cs		; Setup ES again
	 pop	 es		; ...for data references
	 assume  es:PGROUP	; Tell the assembler about it

; Save contents of memory to use as reset stack

	 push	 ds		; Save for a moment

	 lds	 si,RESETSTK_VEC ; DS:SI ==> top of reset stack
	 assume  ds:nothing	; Tell the assembler about it

	 sub	 si,size RESETSTK_OLD ; Back off to start

	 lea	 di,RESETSTK_OLD ; ES:DI ==> local save area
	 mov	 cx,length RESETSTK_OLD ; CX = # words in ...
     rep movs	 RESETSTK_OLD[di],ds:[si].ELO ; Copy contents to local save area

	 pop	 ds		; Restore
	 assume  ds:PGROUP	; Tell the assembler about it

; Ensure A20 is disabled in order to force INT 06h exception
; unless we're in Virtual 8086 Mode or there's no FTB

	 cli			; Nobody move

	 test	 LCL_FLAG,@LCL_VM or @LCL_XFTB ; Izit Virtual 8086 Mode or no FTB?
	 jnz	 short @F	; Jump if so

	 call	 DEGATEA20	; Disable address line A20
	 jc	 near ptr ID386_NOA20 ; Jump if unable to disable
@@:

; Save value for the master and slave IMRs and disable both IMRs

	 call	 DISABLE_IMR	; Disable 'em

; Find INT xxh instruction in ROM at F000:8000 or above

	 call	 SET_ROMINT	; Put ROM INT instruction into IO_ROM_INIT

; Disable watchdog timer in case present

	 call	 DISABLE_WDT	; Disable it

; Save value of shutdown byte

	 mov	 al,@CMOS_SHUT	; Get index of shutdown byte (NMI enabled)
	 out	 @CMOS_CMD,al	; Tell it what index we're programming
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 in	 al,@CMOS_DATA	; Get from CMOS
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay

	 mov	 SHUT_ORIG,al	; Save to restore later

; Shutdown via type 0Ah first to reduce the chances that the BIOS will
; step on DX before we get to tuck it away.

; Set type 0Ah shutdown address

	 mov	 ROMINT_PTR,offset PGROUP:SHUT0A ; Set shutdown offset

	 push	 seg BIOSDATA	; Get the BIOS data segment
	 pop	 ds		; Address it
	 assume  ds:BIOSDATA	; Tell the assembler about it

	 test	 LCL_FLAG,@LCL_ROMINT ; Did we find ROM INT instruction?
	 jnz	 short @F	; Jump if so

	 mov	 IO_ROM_INIT,offset PGROUP:SHUT0A ; Set shutdown offset
	 mov	 IO_ROM_SEG,cs	; ...and segment
@@:

; Set shutdown flag 0Ah (JMP Dword ptr ... without interrupt initialization)
; Note interrupts still disabled

	 mov	 al,@CMOS_SHUT	; Get index of shutdown byte (NMI enabled)
	 out	 @CMOS_CMD,al	; Tell it what index we're programming
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 mov	 al,0Ah 	; Shutdown type
	 out	 @CMOS_DATA,al	; Put into CMOS
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay

	 call	 DISABLE_NMI	; Disable NMI

; Shutdown the processor -- note that this method might not work if we're
; in Virtual 8086 Mode and that handler traps system shutdown through
; this I/O port.

	 jmp	 SHUTDOWN	; Shutdown the processor


; Return from type 0Ah shutdown here
; Note interrupts still disabled

	 public  SHUT0A
SHUT0A:
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

	 lss	 sp,LCLSTKZ_VEC ; Switch to local stack
	 assume  ss:nothing	; Tell the assembler about it

	 push	 cs		; Setup DS for data references
	 pop	 ds		; ...
	 assume  ds:PGROUP	; Tell the assembler about it

	 mov	 COMPID_S0A,dx	; Save component ID (if it wasn't
				; clobbered by BIOS)

; Now shutdown via type 05h to get the 8259 re-initialized.

; If we were in Virtual 8086 Mode at the start, we couldn't disable
; A20 prior to the type 0Ah shutdown.  Now we're in real mode, so we
; can disable A20 this time to attempt to generate an Invalid Opcode
; unless there's no FTB.

	 test	 LCL_FLAG,@LCL_VM ; Izit Virtual 8086 Mode?
	 jz	 short @F	; Jump if not

	 test	 LCL_FLAG,@LCL_XFTB ; Izit no FTB?
	 jnz	 short @F	; Jump if so

	 call	 DEGATEA20	; Disable address line A20
@@:				; Ignore error return

; Set type 05h shutdown address

	 mov	 ROMINT_PTR,offset PGROUP:SHUT05 ; Set shutdown offset

	 push	 seg BIOSDATA	; Get the BIOS data segment
	 pop	 ds		; Address it
	 assume  ds:BIOSDATA	; Tell the assembler about it

	 test	 LCL_FLAG,@LCL_ROMINT ; Did we find ROM INT instruction?
	 jnz	 short @F	; Jump if so

	 mov	 IO_ROM_INIT,offset PGROUP:SHUT05 ; Set shutdown offset
	 mov	 IO_ROM_SEG,cs	; ...and segment
@@:

; Set shutdown flag 05h (JMP Dword ptr ... with interrupt initialization)
; Note interrupts still disabled

	 mov	 al,@CMOS_SHUT or @CMOS_NMIOFF ; Get index of shutdown byte (NMI disabled)
	 out	 @CMOS_CMD,al	; Tell it what index we're programming
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 mov	 al,05h 	; Shutdown type
	 out	 @CMOS_DATA,al	; Put into CMOS
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay

; Shutdown the processor

	 jmp	 SHUTDOWN	; Shutdown the processor


; Return from type 05h shutdown here
; Note interrupts still disabled

	 public  SHUT05
SHUT05:
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

	 lss	 sp,LCLSTKZ_VEC ; Switch to local stack
	 assume  ss:nothing	; Tell the assembler about it

	 push	 cs		; Setup DS for data references
	 pop	 ds		; ...
	 assume  ds:PGROUP	; Tell the assembler about it

; Restore original ROMINT address

	 test	 LCL_FLAG,@LCL_ROMINT ; Izit in effect?
	 jz	 short @F	; Jump if not

	 push	 0		; Get segment of interrupt vector table
	 pop	 es		; Address it
	 assume  es:nothing	; Tell the assembler about it

	 movzx	 eax,ROMINT_NUM ; Get the interrupt #
	 mov	 ebx,ROMINT_VEC ; Get the original interrupt handler
	 mov	 es:[eax*4],ebx ; Restore
@@:

; If we were in Virtual 8086 Mode, return there

	 test	 LCL_FLAG,@LCL_VM ; Izit Virtual 8086 Mode?
	 jz	 short SHUT05_XVM ; Jump if not

; Copy the original GDT to low memory and search through it to find
; the correct value for the Task Register (TR)

	 call	 FIND_TR	; Return old TR in AX
				; Ignore error return (what else can we do?)
	 mov	 OLDTR,ax	; Save to restore later

; Note that we're depending upon the system memory at our current linear
; address to be one-to-one with the corresponding physical memory.

	 LGDTD	 OLDGDTR	; Restore original value
	 LIDTD	 OLDIDTR	; Restore original value

	 mov	 eax,OLDCR3	; Get original value
	 mov	 cr3,eax	; Save original CR3

	 jmp	 short $+2	; Drain the PIQ

	 mov	 eax,OLDCR0	; Get original value
	 mov	 cr0,eax	; Save original CR0

	 jmp	 short $+2	; Drain the PIQ

; We're now in Protected Mode and relying upon the invisible
; descriptor caches for CS and SS

	 PUSHD	 0		; Clear the flags
	 popfd

	 ltr	 OLDTR		; Setup the Task Register

; Return to Virtual 8086 Mode

	 movzx	 ebp,sp 	; Save stack offset to restore later

	 PUSHD	 gs
	 PUSHD	 fs
	 PUSHD	 ds
	 PUSHD	 es
	 PUSHD	 ss		; Put return stack segment onto stack
	 push	 ebp		; Put returning eSP onto the stack

; EFL:	VM = 1, NT = 0, and IOPL = 3

	 push	 dword ptr ((mask $VM) or (11b shl $IOPL))

	 PUSHD	 cs		; Put return CS onto stack
	 push	 0		; Put high-order word of return EIP onto stack
	 push	 offset PGROUP:SHUT05_XVM ; ... low-order ...

	 iretd			; Enter Virtual 8086 Mode

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing ; Tell the assembler about it

SHUT05_XVM:

; Restore shutdown byte to original value

	 mov	 al,@CMOS_SHUT or @CMOS_NMIOFF ; Get index of shutdown byte (NMI disabled)
	 out	 @CMOS_CMD,al	; Tell it what index we're programming
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 mov	 al,SHUT_ORIG	; Get original value
	 out	 @CMOS_DATA,al	; Put into CMOS
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay

; Restore original master and slave IMRs

	 call	 ENABLE_IMR	; Enable 'em
	 call	 ENABLE_NMI	; Enable NMI

; Restore contents of memory used as reset stack

	 push	 cs		; Setup DS for data references
	 pop	 ds		; ...
	 assume  ds:PGROUP	; Tell the assembler about it

	 les	 di,RESETSTK_VEC ; ES:DI ==> top of reset stack
	 assume  es:nothing	; Tell the assembler about it

	 sub	 di,size RESETSTK_OLD ; Back off to start

	 lea	 si,RESETSTK_OLD ; DS:SI ==> local save area
	 mov	 cx,length RESETSTK_OLD ; CX = # words in ...
     rep movs	 es:[di].ELO,RESETSTK_OLD[si] ; Copy contents from local save area

	 sti			; Allow interrupts

; Restore original debug registers

	 mov	 eax,OLDDR0	; Get original value
	 mov	 dr0,eax	; Restore

	 mov	 eax,OLDDR1	; Get original value
	 mov	 dr1,eax	; Restore

	 mov	 eax,OLDDR2	; Get original value
	 mov	 dr2,eax	; Restore

	 mov	 eax,OLDDR3	; Get original value
	 mov	 dr3,eax	; Restore

	 mov	 eax,OLDDR6	; Get original value
	 mov	 dr6,eax	; Restore

	 mov	 eax,OLDDR7	; Get original value
	 mov	 dr7,eax	; Restore

; Restore original INT 06h handler

	 lds	 dx,OLDINT06_VEC ; DS:DX ==> previous handler
	 assume  ds:nothing	; Tell the assembler about it

	 SETINT  06h		; Restore old INT 06h handler

	 push	 cs		; Setup DS for data references
	 pop	 ds
	 assume  ds:PGROUP	; Tell the assembler about it

	 push	 cs		; Setup ES for data references
	 pop	 es
	 assume  es:PGROUP	; Tell the assembler about it

; Give the keyboard a kick in the pants (some BIOSs leave it disabled)

	 mov	 ah,@S2K_ENABLE ; Enable command
	 call	 PPI_S2K_K2S	; Send command AH to keyboard, response in AL
				; Ignore error return

; Display the component identifier

	 mov	 ax,COMPID_S0A	; Check value on returned from shutdown
	 lea	 di,MSG_OKID1	; ES:DI ==> output area
	 call	 FMT_WORD	; Convert the word in AX to hex at ES:DI

	 STROUT  MSG_OKID	; Display the chip ID
	 STROUT  MSG_SHUT0A	; ...from shutdown type 0Ah

	 test	 LCL_FLAG,@LCL_I06 ; Was INT 06h invoked?
	 jz	 short ID386_NOINT06  ; Jump if not

	 mov	 ax,COMPID_I06	; Check value returned from INT 06h handler
	 lea	 di,MSG_OKID1	; ES:DI ==> output area
	 call	 FMT_WORD	; Convert the word in AX to hex at ES:DI

	 STROUT  MSG_OKID	; Display the chip ID

	 lea	 di,MSG_INT06SEG ; ES:DI ==> save area
	 mov	 ax,INT06_PTR.VSEG ; Get INT 06h caller's segment
	 call	 FMT_WORD	; Convert the word in AX to hex at ES:DI

	 lea	 di,MSG_INT06OFF ; ES:DI ==> save area
	 mov	 ax,INT06_PTR.VOFF ; Get INT 06h caller's offset
	 call	 FMT_WORD	; Convert the word in AX to hex at ES:DI

	 STROUT  MSG_INT06	; The information came from INT 06h handler
ID386_NOINT06:
	 test	 LCL_FLAG,@LCL_BIOS ; Was BIOS called?
	 jz	 short ID386_EXIT ; Jump if not

	 mov	 ax,COMPID_BIOS ; Check value returned from BIOS
	 lea	 di,MSG_OKID1	; ES:DI ==> output area
	 call	 FMT_WORD	; Convert the word in AX to hex at ES:DI

	 STROUT  MSG_OKID	; Display the chip ID
	 STROUT  MSG_BIOS	; The information came from the BIOS

	 jmp	 short ID386_EXIT ; Join common exit code

ID386_NOA20:
	 STROUT  MSG_NOA20	; Tell 'em the bad news
ID386_EXIT:
	 mov	 ax,4C00h	; Return to DOS with zero return code
	 int	 21h		; Request DOS service

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

ID386	 endp			; End ID386 procedure
	 NPPROC  CHECK_SYSID -- Check on System Identity
	 assume  ds:PGROUP,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Check on system identity of XT, Micro Channel, or other.

|

	 REGSAVE <ax,bx,es>	; Save registers

; Determine whether or not the system is an XT

	 push	 seg BIOS_SEG	; Get segment of system ID
	 pop	 es		; Address it
	 assume  es:BIOS_SEG	; Tell the assembler about it

	 mov	 al,SYSID	; Get the system ID

	 cmp	 al,@SYS_PC	; Izit an original PC?
	 je	 short CHECK_SYSID_XT ; Yes, treat as an XT

	 cmp	 al,@SYS_XT	; Izit an original XT?
	 je	 short CHECK_SYSID_XT ; Yes, treat as an XT

	 cmp	 al,@SYS_XT2	; Izit an original XT/2?
	 jne	 short CHECK_SYSID_MC ; Jump if not
CHECK_SYSID_XT:
	 or	 LCL_FLAG,@LCL_XT ; Mark as an XT

	 mov	 NMIPORT,0A0h	; NMI clear I/O port
	 mov	 NMIENA,80h	; ... enable value
	 mov	 NMIDIS,00h	; ... disable value
	 mov	 NMIMASK,mask $XTPAR ; ... clear mask

	 jmp	 short CHECK_SYSID_EXIT ; Join common exit code

CHECK_SYSID_MC:
	 mov	 ah,0C0h	; Get code for BIOS configuration
	 int	 15h		; Request BIOS services
	 assume  es:nothing	; Tell the assembler about it
	 jc	 short CHECK_SYSID_NOMC ; Jump if function not available

	 cmp	 ah,0		; Ensure correct return code
	 jne	 short CHECK_SYSID_NOMC ; Jump if not

	 test	 es:[bx].CFG_PARMS,@CFG_MCA ; Izit Micro Channel?
	 jz	 short CHECK_SYSID_NOMC ; Jump if not

	 or	 LCL_FLAG,@LCL_MC ; Mark as Micro Channel
CHECK_SYSID_NOMC:
CHECK_SYSID_EXIT:
	 REGREST <es,bx,ax>	; Restore
	 assume  es:nothing	; Tell the assembler about it

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

CHECK_SYSID endp		; End CHECK_SYSID procedure
	 FPPROC  INT06 -- Invalid Opcode Handler
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Invalid opcode handler (INT 06h).

Save the value of DX, re-enable A20, and reset the system.

Note that SS = 0 upon entry from the reset.
SP technically is undefined, but we expect it to be set to zero
from just before the reset which is why RESETSTK_VEC.VOFF is zero.

|

INT06_STR struc

INT06_IP dw	 ?		; Caller's IP
INT06_CS dw	 ?		; ...	   CS
INT06_FL dw	 ?		; ...	   FL

INT06_STR ends

	 mov	 bp,sp		; Address the stack

	 push	 cs		; Setup DS for data references
	 pop	 ds		; Address it
	 assume  ds:PGROUP	; Tell the assembler about it

	 bts	 LCL_FLAG,$LCL_I06 ; Mark as saved
	 jc	 short INT06_IRET ; Jump if we've been here before

	 mov	 COMPID_I06,dx	; Save component ID

	 mov	 ax,[bp].INT06_IP ; Get caller's IP
	 mov	 INT06_PTR.VOFF,ax ; Save for later use

	 mov	 ax,[bp].INT06_CS ; Get caller's CS
	 mov	 INT06_PTR.VSEG,ax ; Save for later use

	 lss	 sp,LCLSTKZ_VEC ; Switch to local stack
	 assume  ss:nothing	; Tell the assembler about it

	 call	 GATEA20	; Enable address line A20
				; for extended memory access
				; Ignore error return

	 jmp	 SHUTDOWN	; Shutdown the processor

INT06_IRET:
	 iret			; Try again at F000:FFF0

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

INT06	 endp			; End INT06 procedure
	 FPPROC  INT23 -- Ctrl-Break Handler
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Ctrl-break interrupt handler.
Avoid user breaking out during critical sections.

|

	 iret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

INT23	 endp			; End INT23 procedure
	 NPPROC  CHECK_CPUID -- Check On CPU Identifier
	 assume  ds:PGROUP,es:PGROUP,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Ensure we're running on an 386/486 processor.
Note we must use only 8088 instructions here as well
as on return if CF=1.

On exit:

CF	 =	 0 if all went OK
	 =	 1 otherwise

|

	 REGSAVE <ax,dx>	; Save registers

; Distinguish 286 and later processors
; These CPUs handle PUSH SP differently from the earlier CPUs

	 push	 sp		; First test for earlier than a 286
	 pop	 ax

	 cmp	 ax,sp		; Same value?
	 jne	 short CHECK_CPUID_ERR ; No, it's too early

; Now distinguish 286 from 386/486
; Note that a 286 processor does not allow the IOPL bits to be set
; in the flags register from real mode

	 pushf			; Save flags for a moment

	 push	 mask $IOPL	; Place IOPL bits onto the stack
	 popf			; ...and then into flags

	 pushf			; Get flags back
	 pop	 ax

	 popf			; Restore original flags

	 test	 ax,mask $IOPL	; Any bits set?
	 jnz	 short CHECK_CPUID_EXIT ; Yes, so continue on (note CF=0)
CHECK_CPUID_ERR:
	 STROUT  MSG_NOT386	; Tell 'em the bad news

	 stc			; Indicate we have a problem
CHECK_CPUID_EXIT:
	 REGREST <dx,ax>	; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

CHECK_CPUID endp		; End CHECK_CPUID procedure
	 NPPROC  CHECK_FTB -- Check for Fully-terminated Bus
	 assume  ds:PGROUP,es:PGROUP,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Check for fully-terminated bus at 4GB - 1MB - 16; that is,
read in the first two bytes there and ensure that it's FF FF.
If not, then the trick of resetting the system with A20 disabled
will crash the system as we're relying upon generating an invalid
opcode.

On exit:

CF	 =	 1 if not fully-terminated
	 =	 0 if OK

|

	 REGSAVE <eax,ecx,si>	; Save registers

; Set up GDT entry for BIOS block move

	 mov	 eax,0FFEFFFF0h ; Get source base value
	 mov	 ecx,2-1	; ...	     limit in bytes
	 lea	 si,MOVE_TAB.MDTE_DS ; ES:SI ==> GDT entry
	 call	 SET_GDT	; Set GDT entry ES:SI to base EAX, limit ECX

; Setup BIOS block move destin DTE

	 xor	 eax,eax	; Clear entire register
	 mov	 ax,cs		; Copy current segment
	 shl	 eax,4-0	; Convert from paras to bytes
	 add	 eax,offset PGROUP:TOPMEM ; Plus offset of low memory destin
				; Use same previous limit
	 lea	 si,MOVE_TAB.MDTE_ES ; ES:SI ==> GDT entry
	 call	 SET_GDT	; Set GDT entry ES:SI to base EAX, limit ECX

; Perform the BIOS block move several times to ensure it's fully-terminated

	 mov	 cx,5		; An arbitrary count
CHECK_FTB_NEXT:
	 mov	 TOPMEM,0	; Put non-FFFF value there

	 push	 cx		; Save for a moment

	 lea	 si,MOVE_TAB	; ES:SI ==> block move descriptor tables
	 mov	 cx,1		; CX = # words to move
	 mov	 ah,87h 	; Function to move data to/from ext mem
	 int	 15h		; Request BIOS service

	 pop	 cx		; Restore

; As some BIOSes don't bother setting AH to zero upon successful return
; we don't bother checking it.  Instead, we test the data in TOPMEM; if
; it's FF FF, that's good enough for me.

	 cmp	 TOPMEM,0FFFFh	; Izit fully-terminated bus?
	 jne	 short CHECK_FTB_EXIT ; Jump if not (note CF=1)

	 loop	 CHECK_FTB_NEXT ; Jump if more checks
				; Fall through if done (note CF=0)
CHECK_FTB_EXIT:
	 REGREST <si,ecx,eax>	; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

CHECK_FTB endp			; End CHECK_FTB procedure
	 NPPROC  SHUTDOWN -- Shutdown the Processor
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Shutdown the processor.

|

	 lss	 sp,RESETSTK_VEC ; SS:SP ==> safe area for stack pushes
	 assume  ss:nothing	; Tell the assembler about it

	 mov	 al,@S2C_SHUT	; Shutdown by pulsing 8042 bits low
	 out	 @8042_ST,al	; Bye

	 hlt			; Stop the presses

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

SHUTDOWN endp			; End SHUTDOWN procedure
	 NPPROC  FIND_TR -- Find Old Task Register
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Find old value for the Task Register

Move the old GDT into low memory and search through it to
find the first busy 386 TSS.  The descriptor associated with
that TSS is then assumed to be the old TR.

This routine is called only if we started in PM; thus, OLDCR3
has been filled in as this is needed by BLOCKMOVE/GOPROT.

On exit:

CF	 =	 0 if all went OK
	 =	 1 if something went wrong
AX	 =	 old TR (if CF=0)

|

FIND_TR_STR struc

	 dw	 ?		; Caller's BP
FIND_TR_AX dw	 ?		; ...	   AX

FIND_TR_STR ends

	 push	 ax		; Save separately as return value

	 push	 bp		; Prepare to address the stack
	 mov	 bp,sp		; Hello, Mr. Stack

	 REGSAVE <eax,ecx,si,es> ; Save registers

	 push	 cs		; Setup ES for BIOS block move
	 pop	 es		; Address it
	 assume  es:PGROUP	; Tell the assembler about it

; Setup BIOS block move source DTE
; Note we're assuming that the GDT length is < 1MB

	 mov	 eax,OLDGDTR.DTR_BASE ; Get GDTR base value
	 movzx	 ecx,OLDGDTR.DTR_LIM ; ...	 limit

	 lea	 si,MOVE_TAB.MDTE_DS ; ES:SI ==> GDT entry
	 call	 SET_GDT	; Set GDT entry ES:SI to base EAX, limit ECX

; Setup BIOS block move destin DTE

	 xor	 eax,eax	; Clear entire register
	 mov	 ax,cs		; Copy current segment
	 shl	 eax,4-0	; Convert from paras to bytes
	 add	 eax,offset PGROUP:LOWGDT ; Plus offset of low memory GDT
				; Use same previous limit
	 lea	 si,MOVE_TAB.MDTE_ES ; ES:SI ==> GDT entry
	 call	 SET_GDT	; Set GDT entry ES:SI to base EAX, limit ECX

; Perform the BIOS block move
; Note we can't use the BIOS services as the Virtual 8086 Mode handler
; almost assuredly is trapping this call

	 lea	 si,MOVE_TAB	; ES:SI ==> block move descriptor tables
	 movzx	 ecx,OLDGDTR.DTR_LIM ; Get GDTR limit
	 inc	 ecx		; Convert from limit to length
	 shr	 ecx,1-0	; Convert from bytes to words
;;;;;;;; mov	 ah,87h 	; Function code for BIOS block move
;;;;;;;; int	 15h		; Request BIOS service
	 call	 BLOCKMOVE	; Perform the BIOS block move

	 cmp	 ah,0		; Any problems?
	 jne	 short FIND_TR_ERR ; Jump if so

; Search through the GDT looking for a busy 386 TSS

	 xor	 si,si		; Initialize index into LOWGDT
	 shr	 ecx,3-1	; Convert from words to qwords
FIND_TR_NEXT:
	 mov	 al,LOWGDT.DESC_ACCESS[si] ; Get the descriptor access code

	 cmp	 al,CPL0_BUSY3	; Izit a busy 386 TSS?
	 je	 short FIND_TR_FOUND ; Jump if so

	 add	 si,size DESC_STR ; Skip to next DTE

	 loop	 FIND_TR_NEXT	; Jump if more DTEs to search

; Oops, we didn't find a busy 386 TSS

	 jmp	 short FIND_TR_ERR ; Join common error code

FIND_TR_FOUND:
	 mov	 [bp].FIND_TR_AX,si ; Return as the old TR

; Clear the busy bit in the TSS and copy it back to the caller's GDT

	 and	 LOWGDT.DESC_ACCESS[si],not (mask $DS_BUSY) ; Clear busy bit

; Swap the source and destin DTEs for the rewrite

	 mov	 eax,MOVE_TAB.MDTE_DS.EDQLO ; Get low-order dword of source DTE
	 xchg	 eax,MOVE_TAB.MDTE_ES.EDQLO ; Swap with destin DTE
	 mov	 MOVE_TAB.MDTE_DS.EDQLO,eax ; Save back in source DTE

	 mov	 eax,MOVE_TAB.MDTE_DS.EDQHI ; Get high-order dword of source DTE
	 xchg	 eax,MOVE_TAB.MDTE_ES.EDQHI ; Swap with destin DTE
	 mov	 MOVE_TAB.MDTE_DS.EDQHI,eax ; Save back in source DTE

	 lea	 si,MOVE_TAB	; ES:SI ==> block move descriptor tables
	 movzx	 ecx,OLDGDTR.DTR_LIM ; ...	 limit
	 inc	 ecx		; Convert from limit to length
	 shr	 ecx,1-0	; Convert from bytes to words
;;;;;;;; mov	 ah,87h 	; Function code for BIOS block move
;;;;;;;; int	 15h		; Request BIOS service
	 call	 BLOCKMOVE	; Perform the BIOS block move

	 cmp	 ah,0		; Any problems?
	 je	 short FIND_TR_EXIT ; Jump if none (note CF=0)
FIND_TR_ERR:
	 stc			; Indicate something went wrong
FIND_TR_EXIT:
	 REGREST <es,si,ecx,eax> ; Restore
	 assume  es:nothing	; Tell the assembler about it

	 pop	 bp		; Restore

	 pop	 ax		; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

FIND_TR  endp			; End FIND_TR procedure
	 NPPROC  BLOCKMOVE -- BIOS Block Move
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Perform BIOS block move

On entry:

CX	 =	 # words to move
ES:SI	 ==>	 GDT
OLDCR3 is valid

On exit:

AH	 =	 00 if all went well
	 =	 03 if gate A20 failed

|

	 REGSAVE <cx,si,di,ds,es,fs,gs> ; Save registers

	 push	 cs		; Get our segment
	 pop	 ds		; Address it
	 assume  ds:PGROUP	; Tell the assembler about it

	 call	 GOPROT 	; Enter Protected Mode using move DTE at ES:SI
	 assume  ds:nothing,es:nothing ; Tell the assembler about it
	 assume  fs:nothing,gs:nothing ; Tell the assembler about it

	 cmp	 ah,0		; Check for correctness
	 jne	 short BLOCKMOVE_ERR ; Jump if not

; Perform the block move

	 xor	 si,si		; DS:SI ==> source data
	 xor	 di,di		; ES:DI ==> destin data
	 cld			; Direction flag upwards
     rep movsw			; Copy data as requested

	 call	 GOREAL 	; Switch back to real mode

	 mov	 ah,0		; Mark as successful
BLOCKMOVE_ERR:
	 REGREST <gs,fs,es,ds,di,si,cx> ; Restore
	 assume  ds:nothing,es:nothing ; Tell the assembler about it
	 assume  fs:nothing,gs:nothing ; Tell the assembler about it

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

BLOCKMOVE endp			; End BLOCKMOVE procedure
	 NPPROC  GOPROT -- Enter Protected Mode
	 assume  ds:PGROUP,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Switch from real to protected mode.

This routine is not a full Enter Protected Mode handler
as it assumes that the IMR has already been saved and disabled,
the 8259 is not re-programmed, and interrupts and NMI are ignored.
It also assumes a specific value for CR3.

On entry:

(BH,BL)  =	 (master, slave) 8259 bases
ES:SI	 ==>	 GDT
OLDCR3 is valid

On exit:

AH	 =	 00 if success
	 =	 03 if A20 failed

The rest of EAX is destroyed.

|

; * Disable interrupts

	 cli

; * Gate A20 on

	 mov	 ah,03h 	; Assume the worst
	 call	 GATEA20	; Enable address line A20
				; for extended memory access
	 jc	 near ptr GOPROT_EXIT ; Jump if this didn't succeed

; * Setup MDTE_BIOS entry

	 xor	 eax,eax	; Zero entire register
	 mov	 ax,cs		; Get current code segment
	 shl	 eax,4-0	; Convert from paras to bytes

	 mov	 es:[si].MDTE_BIOS.DESC_BASE01.EDD,eax
	 rol	 eax,8		; Rotate out the high-order byte
	 mov	 es:[si].MDTE_BIOS.DESC_BASE3,al
	 ror	 eax,8		; Rotate back
	 mov	 es:[si].MDTE_BIOS.DESC_SEGLM0,0FFFFh ; 64KB of code
	 mov	 es:[si].MDTE_BIOS.DESC_SEGLM1,0
	 mov	 es:[si].MDTE_BIOS.DESC_ACCESS,CPL0_CODE

; * Setup MDTE_SS entry

	 mov	 es:[si].MDTE_SS.DESC_BASE01.EDD,eax
	 rol	 eax,8		; Rotate out the high-order byte
	 mov	 es:[si].MDTE_SS.DESC_BASE3,al
	 ror	 eax,8		; Rotate back
	 mov	 es:[si].MDTE_SS.DESC_SEGLM0,0FFFFh ; 64KB of data
	 mov	 es:[si].MDTE_SS.DESC_SEGLM1,0
	 mov	 es:[si].MDTE_SS.DESC_ACCESS,CPL0_DATA

; * Setup MDTE_GDT entry

	 xor	 eax,eax	; Zero entire register
	 mov	 ax,es		; Get current extra data segment
	 shl	 eax,4-0	; Convert from paras to bytes
	 movzx	 esi,si 	; Clear high-order word
	 add	 eax,esi	; Add offset to base to get 32-bit address
	 mov	 es:[si].MDTE_GDT.DTR_BASE,eax ; Save as GDT base
	 mov	 es:[si].MDTE_GDT.DTR_LIM,(size MDTE_STR)-1 ; Save as GDT limit

ifdef DEBUG

; * Setup Protected Mode IDTR (for debugging only)

	 xor	 eax,eax	; Zero entire register
	 mov	 ax,cs		; Get current code segment
	 shl	 eax,4-0	; Convert from paras to bytes
	 add	 eax,offset PGROUP:IDT_DESC ; Plus offset to IDT descriptor table
	 mov	 PROTIDTR.DTR_BASE,eax ; Save as linear base address
	 mov	 PROTIDTR.DTR_LIM,IDT_DESC_LEN-1 ; Save as limit
endif				; IFDEF DEBUG

; * Load GDTR from MDTE_GDT

	 LGDTD	 es:[si].MDTE_GDT.EDF
ifdef DEBUG
	 LIDTD	 PROTIDTR	; Load up protected mode IDTR
endif				; IFDEF DEBUG

; * Ensure FS and GS are valid

	 xor	 ax,ax		; Dummy GDT entry
	 mov	 fs,ax		; Ensure valid
	 mov	 gs,ax		; ...

; * Setup old PDBR in case the GDT in extended memory is not one-to-one

	 mov	 eax,OLDCR3	; Get previous CR3
	 mov	 cr3,eax	; Tell the CPU about it

	 jmp	 short $+2	; Drain the PIQ

; * Enter protected mode and enable paging at the same time

	 mov	 eax,cr0	; Get current CR0
	 or	 eax,(mask $PG) or (mask $PE) ; Set paging and protected mode bits
	 mov	 cr0,eax	; Enter protected mode and enable paging

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing ; Tell the assembler about it

; Flush prefetch instruction queue to set access rights on CS

	 db	 @OPCOD_JMPF	; Opcode for immediate far jump
	 dw	 PGROUP:$+4,MDTE_BIOS ; ...to this offset and selector

; * Setup segment registers

	 mov	 ax,MDTE_DS	; Get DS selector
	 mov	 ds,ax
	 assume  ds:nothing	; Tell the assembler about it

	 mov	 ax,MDTE_ES	; Get ES selector
	 mov	 es,ax
	 assume  es:nothing	; Tell the assembler about it

	 mov	 ax,MDTE_SS	; Get SS selector
	 mov	 ss,ax
	 assume  ss:nothing	; Tell the assembler about it

	 mov	 ah,0		; Indicate success
GOPROT_EXIT:
	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

GOPROT	 endp			; End GOPROT procedure
	 NPPROC  GOREAL -- Enter Real Mode
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Enter real mode.

|

; It must be true that the linear and physical address for
; this page are identical

; Turn off paging

	 mov	 eax,cr0	; Get current CR0
	 and	 eax,not (mask $PG) ; Turn off PG
	 mov	 cr0,eax	; No more paging

; Flush the pre-fetch instruction queue after setting paging off

	 jmp	 short $+2	; Drain the PIQ

; Clear the PDBR

	 xor	 eax,eax	; Zero EAX to clear CR3
	 mov	 cr3,eax	; Flush paging translation lookaside buffer

; Flush the pre-fetch instruction queue after flushing page translation cache

	 jmp	 short $+2	; Drain the PIQ

; Load all data segment registers with 64KB selector in low memory

	 mov	 ax,MDTE_SS	; Use low memory stack selector

	 mov	 ds,ax
	 assume  ds:PGROUP	; Tell the assembler about it

	 mov	 es,ax
	 assume  es:PGROUP	; Tell the assembler about it

	 mov	 fs,ax
	 assume  fs:PGROUP	; Tell the assembler about it

	 mov	 gs,ax
	 assume  gs:PGROUP	; Tell the assembler about it

	 mov	 ss,ax
	 assume  ss:PGROUP	; Tell the assembler about it

; Load base and limit of IDT for real mode

	 LIDTD	 REALIDTR	; Reset IDT for real mode

; Exit protected mode

	 mov	 eax,cr0	; Get current CR0
	 and	 ax,not (mask $PE) ; Turn off PE bit
	 mov	 cr0,eax	; Exit protected mode

; Jump to real mode code to set access rights

	 public  FARCS
	 db	 @OPCOD_JMPF	; Opcode for immediate far jump
	 dw	 PGROUP:$+4	; ...to this offset
FARCS	 dw	 ?		; ...and segment
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing ; Tell the assembler about it

; Re-initialize segment registers

	 mov	 ax,cs
	 mov	 ds,ax
	 assume  ds:PGROUP	; Tell the assembler about it

	 mov	 es,ax
	 assume  es:PGROUP	; Tell the assembler about it

	 mov	 fs,ax
	 assume  fs:PGROUP	; Tell the assembler about it

	 mov	 gs,ax
	 assume  gs:PGROUP	; Tell the assembler about it

	 mov	 ss,ax
	 assume  ss:PGROUP	; Tell the assembler about it

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

GOREAL	 endp			; End GOREAL procedure
	 NPPROC  FMT_WORD -- Format AX to Hex at ES:DI
	 assume  ds:PGROUP,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Convert AX to hex at ES:DI

On entry:

AX	 =	 word to format
ES:DI	 ==>	 output save area

On exit:

ES:DI	 ==>	 (updated)

|

	 REGSAVE <ax,bx,cx,dx>	; Save registers

	 lea	 bx,HEXTABLE	; DS:BX ==> translate table
	 mov	 cx,4		; # hex digits in a word
	 mov	 dx,ax		; Copy to test
FMT_WORD1:
	 rol	 dx,4		; Copy the high-order digit
	 mov	 al,dl		; Copy to XLAT register
	 and	 al,0Fh 	; Isolate hex digit
	 xlat	 HEXTABLE	; Translate to ASCII
	 stosb			; Save into output area

	 loop	 FMT_WORD1	; Jump if more digits to convert

	 REGREST <dx,cx,bx,ax>	; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

FMT_WORD endp			; End FMT_WORD procedure
	 NPPROC  ENABLE_IMR -- Enable the 8259 Interrupt Mask Register
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Enable the 8259 interrupt mask register

|

	 REGSAVE <ax>		; Save register

	 mov	 al,INTA01	; Get original master interrupt mask
	 out	 @IMR,al	; Reset in master 8259

	 test	 LCL_FLAG,@LCL_XT ; Running on an XT?
	 jnz	 short ENABLE_IMR_EXIT ; Yes, so there's no slave controller

	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 mov	 al,INTB01	; Get original slave interrupt mask
	 out	 @IMR2,al	; Reset in slave 8259
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay
ENABLE_IMR_EXIT:
	 REGREST <ax>		; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

ENABLE_IMR endp 		; End ENABLE_IMR procedure
	 NPPROC  DISABLE_IMR -- Disable the 8259 Interrupt Mask Register
	 assume  ds:PGROUP,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Disable the 8259 interrupt mask register

This routine is called from real mode only.

|

	 REGSAVE <ax>		; Save register

	 in	 al,@IMR	; Get current value
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 mov	 INTA01,al	; Save to restore later

	 mov	 al,0FFh	; Disable all interrupts
	 out	 @IMR,al	; Send to 8259

	 test	 LCL_FLAG,@LCL_XT ; Running on an XT?
	 jnz	 short DISABLE_IMR_EXIT ; Yes, so there's no slave controller

	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 in	 al,@IMR2	; Get current value
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 mov	 INTB01,al	; Save to restore later

	 mov	 al,0FFh	; Disable all interrupts
	 out	 @IMR2,al	; Reset in slave 8259
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay
DISABLE_IMR_EXIT:
	 REGREST <ax>		; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

DISABLE_IMR endp		; End DISABLE_IMR procedure
	 NPPROC  OUTCMOS -- Out To CMOS, Conditional Read
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Out to CMOS, conditional read.

Note that this routine is bimodal.

This routine should not be interrupted between the OUT and IN.

|

	 pushf			; Save flags
	 cli			; Disallow interrupts

	 out	 dx,al		; Send to CMOS

	 cmp	 dx,@CMOS_CMD	; Izit an AT?
	 jne	 short @F	; Jump if not

	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 in	 al,@CMOS_DATA	; Ensure OUT is followed by IN
@@:
	 popf			; Restore flags

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

OUTCMOS  endp			; End OUTCMOS procedure
	 NPPROC  ENABLE_NMI -- Enable NMI, Clear Parity Latches
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Enable NMI, clear parity latches.

Note that this routine is bimodal.

|

	 pushf			; Save flags
	 cli			; Ensure interrupts disabled

	 REGSAVE <ax,dx>	; Save for a moment

; Clear the parity latches

	 call	 CLR_PARITY	; Clear any parity errors

; Enable the NMI latch

	 mov	 dx,NMIPORT	; Get NMI clear I/O port
	 mov	 al,NMIENA	; ...	  enable value
	 call	 OUTCMOS	; Out to CMOS, conditional read

	 REGREST <dx,ax>	; Restore
	 popf			; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

ENABLE_NMI endp 		; End ENABLE_NMI procedure
	 NPPROC  DISABLE_NMI -- Disable NMI
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Disable NMI

Note that this routine is bimodal.

|

	 pushf			; Save flags
	 cli			; Ensure interrupts disabled

	 REGSAVE <ax,dx>	; Save for a moment

; Disable NMI

	 mov	 dx,NMIPORT	; Get NMI clear I/O port
	 mov	 al,NMIDIS	; ...	  disable value
	 call	 OUTCMOS	; Out to CMOS, conditional read

	 REGREST <dx,ax>	; Restore
	 popf			; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

DISABLE_NMI endp		; End DISABLE_NMI procedure
	 NPPROC  CLR_PARITY -- Clear Parity Latches
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Clear the parity latches

Note that this routine is bimodal.

|

	 REGSAVE <ax>		; Save register

	 mov	 ah,NMIMASK	; Get parity mask
	 in	 al,@8255_B	; Get the parity latches
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 or	 al,ah		; Toggle parity check latches off
	 out	 @8255_B,al	; Tell the system about it
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay
	 jmp	 short $+2	; I/O delay

	 xor	 al,ah		; Toggle parity check latches on
	 out	 @8255_B,al	; Tell the system about it
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay
;;;;;;;; jmp	 short $+2	; I/O delay

	 REGREST <ax>		; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

CLR_PARITY endp 		; End CLR_PARITY procedure
	 NPPROC  DISABLE_WDT -- Disable Watchdog Timer
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Disable watchdog timer.
Unfortunately, there is no documented way of saving the current state
and restoring it later.

|

	 REGSAVE <ax>		; Save register

	 mov	 ax,0C300h	; Get major/minor function code to disable
	 int	 15h		; Request BIOS service

	 REGREST <ax>		; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

DISABLE_WDT endp		; End DISABLE_WDT procedure
	 NPPROC  SET_GDT -- Set GDT Entry
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Set GDT entry.

On entry:

ES:SI	 ==>	 GDT entry to set
EAX	 =	 base value
ECX	 =	 limit and flags

|

	 mov	 es:[si].DESC_BASE01.EDD,eax
	 rol	 eax,8		; Rotate out the high-order byte
	 mov	 es:[si].DESC_BASE3,al ; Save as base byte #3
	 ror	 eax,8		; Rotate back
	 mov	 es:[si].DESC_SEGLM0,cx ; Save as data limit
	 rol	 ecx,16 	; Swap high- and low-order words
	 mov	 es:[si].DESC_SEGLM1,cl ; Save size & flags
	 ror	 ecx,16 	; Swap back
	 mov	 es:[si].DESC_ACCESS,CPL0_DATA

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

SET_GDT  endp			; End SET_GDT procedure
	 FPPROC  ROMINT_FN -- Local ROM INT Instruction Routine
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Local ROM INT instruction routine

|

	 jmp	 ROMINT_PTR	; Join common code

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

ROMINT_FN endp			; End ROMINT_FN procedure
	 NPPROC  SET_ROMINT -- Put ROM INT Instruction into IO_ROM_INIT
	 assume  ds:PGROUP,es:PGROUP,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Find INT xxh in ROM at F000:8000 or higher and put its
address into IO_ROM_INIT.

We use this artifice as there are BIOSes which don't implement the
IO_ROM_INIT mechanism properly and use a JMP Near Ptr IO_ROM_INIT
instead of JMP Far Ptr IO_ROM_INIT.

If we don't find a suitable INT instruction, hope that the system
BIOS works correctly.

|

	 REGSAVE <eax,ecx,di,es> ; Save registers

@BIOS_SEG equ	 0F000h 	; Segment of system BIOS

	 push	 @BIOS_SEG	; Get segment of system BIOS
	 pop	 es		; Address it
	 assume  es:nothing	; Tell the assembler about it

	 mov	 di,0E000h	; Start here as some BIOSes might be cached
				; below this point
	 mov	 cx,di		; Get starting address
	 neg	 cx		; Subtract from 64KB to get remaining length
	 sub	 cx,16		; Less last paragraph in case it's cached
SET_ROMINT_NEXT:
	 jcxz	 SET_ROMINT_ERR ; Jump if nothing remains
	 mov	 al,@OPCOD_INT	; Get opcode for INT instruction
   repne scasb			; Search for it
	 jne	 short SET_ROMINT_ERR ; Jump if not found

	 movzx	 eax,es:[di].LO ; Get the interrupt #, and
				; zero extend to use as dword

; Filter out ones we don't want to mess with

	 cmp	 al,01h 	; Izit single-step?
	 je	 short SET_ROMINT_NEXT ; Jump if so

	 cmp	 al,03h 	; Izit single-skip?
	 je	 short SET_ROMINT_NEXT ; Jump if so

	 cmp	 al,06h 	; Izit invalid opcode?
	 je	 short SET_ROMINT_NEXT ; Jump if so

	 cmp	 al,08h 	; Izit below master PIC base?
	 jb	 short @F	; Jump if so

	 cmp	 al,08h+8	; Izit below master PIC end?
	 jb	 short SET_ROMINT_NEXT ; Jump if so
@@:
	 cmp	 al,70h 	; Izit below slave PIC base?
	 jb	 short @F	; Jump if so

	 cmp	 al,70h+8	; Izit below slave PIC end?
	 jb	 short SET_ROMINT_NEXT ; Jump if so
@@:
	 push	 0		; Get segment of interrupt vector table
	 pop	 es		; Address it
	 assume  es:nothing	; Tell the assembler about it

	 mov	 ROMINT_NUM,al	; Save for later use
	 mov	 cx,cs		; Get our code segment
	 shl	 ecx,16 	; Shift to high-order word
	 lea	 cx,ROMINT_FN	; Get offset of local handler
	 xchg	 ecx,es:[eax*4] ; Swap 'em
	 mov	 ROMINT_VEC,ecx ; Save to restore later

	 push	 seg BIOSDATA	; Get the BIOS data segment
	 pop	 es		; Address it
	 assume  es:BIOSDATA	; Tell the assembler about it

	 dec	 di		; Point back to INT instruction
	 mov	 IO_ROM_INIT,di ; Set shutdown offset
	 mov	 IO_ROM_SEG,@BIOS_SEG ; ...and segment

	 or	 LCL_FLAG,@LCL_ROMINT ; Mark as found
SET_ROMINT_ERR:
	 REGREST <es,di,ecx,eax> ; Restore
	 assume  es:nothing	; Tell the assembler about it

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

SET_ROMINT endp 		; End SET_ROMINT procedure

CODE	 ends			; End CODE segment

	 MEND	 ID386		; End 386ID module
