

NAME 

     lpr - insert files or standard input into queue for background printing



SYNOPSIS 

     command | lpr

     lpr [-v] [-h] [file  [-]...] [ < file ]



DESCRIPTION 

         LPR interprets the command line arguments as files to be passed to

     the print queue maintained by the DOS PRINT background printing

     utility.  Normal DOS wildcards may be specified, and "/" may be used as

     a directory separator in addition to "\".  The argument "-" is taken to

     be standard input (if redirected or piped) and is processed as a file

     argument at the appropriate point. If no file arguments are specified,

     stdin is assumed.  Standard input is handled by copying (text mode,

     stops at ^Z) to a temporary file with a name mask LPR???.$$$ created in

     a spool directory. This spool file is then passed to the print queue.

     This allows a print process to be the last stage in a pipeline, and

     still use the background printing services.  The location of the spool

     files may be specified by the environment variable SPOOLDIR.  The

     default is C:\SPOOL.  If an alternate drive is specified, the root

     directory must be explicitly given, e.g. for a ramdrive E: set

     spooldir=E:\



        When LPR processes stdin, it checks the contents of the spool

     directory for files matching the mask "LPR???.$$$", and also the

     print queue. Any old spool files not currently in the spool queue are

     automatically deleted.  A trailing formfeed in the input file is NOT

     copied over, since PRINT will add a formfeed after each file.  Apart

     from this, LPR does not examine the input file.



        Lpr checks for the existance of the print spooler in memory before

     attempting to pass files to it. Lpr will not print empty

     files, or read input directly from the terminal.



         Lpr communicates directly with PRINT via the DOS TSR multiplex

     interrupt 2F.  This is documented for DOS 3.x and above. Calls to 

     lpr may be freely mixed with calls to PRINT.



OPTIONS

    -v  verbose mode - lpr is more chatty about files added to the queue.

         Errors such as invalid file name, print queue full or spool

         directory full, are always displayed.

    -h  help - displays the copyright and usage messages and quits.

    -p  priority - place job(s) at the head of the print queue.



RETURN CODE

     0 - no errors

     1 - any errors in argument list

     2 - PRINT.COM not loaded, no further processing possible



FILES

     $SPOOLDIR/lpr???.$$$  - spool files



     $SPOOLDIR - environment variable indicating where to place the

     spool files.  The default is C:\SPOOL.



SEE ALSO

     lpq, MS-DOS manual entry for PRINT. Note in particular that the size

     of the print queue may be specified at load time with /Q:nn where nn

     may be in range 4-32 (default is 10).



BUGS

     The files are truncated at the first Control-Z (i.e. DOS ASCII mode),

     since PRINT will not handle characters beyond ^Z.  As far as I know the

     only way to get such a file to the printer is to open PRN directly in


     binary mode, or with COPY /B file PRN



REVISONS

     V 1.1 - fixed bug with specifying files in the root directory, or in

     the current (unspecified) directory of an alternate drive.  Also

     allowed for "/" in pathnames, and for "." and ".." in filespecs.



AUTHOR

     Richard Brittain (richard@calvin.spp.cornell.edu)

