

NAME

     lpq - display and manipulate the DOS print queue



SYNOPSIS

     lpq [-c n] [-p n] [-t] [-s] [-r] [-1] [-v] [-h]



DESCRIPTION

     lpq is a utility to display the files in the current print queue, along

     with the file size and a sequential job number in the queue. lpq can

     also manipulate the entries in the queue using the following options:

        -c n    Cancel the job number (n) from the queue, where the job

                number is obtained from the lpq output listing.  Multiple

                -c n may be specified.

        -p n    Priority to job (n).  lpq will move job (n) to the head of

                the queue and demote all other jobs by one place.

        -t      Terminate printing and remove all jobs from queue.

        -s      Suspend printing operation.  The current print job will

                complete, but no more will print until the queue is

                released. Print will consider the queue to have emptied,

                and the printer port will be available to other

                applications. The entries are still in the queue however

                and may be released by calling lpq with the -r option.

                May be specified along with other options.

        -r      Release the print queue suspended by the -s flag.

        -v      Verbose mode.  lpq is more chatty about it's activities.

        -h      Display brief help text and exit.

        -1      display the queue 1 file per line with no extraneous

                messages



        If any of the above options are given on the command line, lpq will

    perform the requested action and then display the print queue. If no

    arguments are given, lpq reports the current state of the print queue,

    with a job number and file size for each entry.  If the file was entered

    into the queue using lpr, the time of entry into the queue is also

    displayed.  If a file has been deleted while still in the queue, this is

    reported also. It is possible to delete a file in the queue and PRINT

    will not notice until it reaches the head of the queue since it does not

    have an open handle on the queued files.  Deleting the file currently

    printing will result in a file sharing violation if share is installed,

    but otherwise is allowed, and will result in termination of the print

    job.  Options are processed in the order given.  It is possible to

    specify more than one -c or -p on the command line.  The percentage printed

    (of the file currently printing) will also be displayed.  This is

    obtained by snooping in the system file table.



    lpq communicates directly with the print spooler by the TSR multiplex

    interrupt 2FH.  This is documented for DOS 3.x and later.  It might

    be possible to make it work with DOS 2.x since this used int 2F, but not

    in the same way.



SEE ALSO

    lpr, MS-DOS manual entry for PRINT



BUGS

    The file time displayed by lpq is actually stored in the unused bytes of

    the print queue entry, since few pathnames are actually this long (up to

    64 bytes). If the pathname is too long, the time is missing.  If the

    queue is loaded using "print" rather than lpr, it is possible that lpq

    might find a "time" which is invalid.  This should not cause problems

    beyond a bad time field in the lpq display.  The undocumented DOS service

    52H (get "list of lists") is used to find out the current file pointer

    position for the file handle used by print.com.  This should work for DOS

    2.x, 3.x, 4.x but is not guaranteed.



AUTHOR

    Richard Brittain  (richard@calvin.spp.cornell.edu)


