// LTransfer.cpp : implementation file
//

#include "stdafx.h"
#include <ftp4w.h>

#include "LFtp.h"
#include "LConnect.h"
#include "LTransfer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define EV_TRF (WM_USER+7)

/////////////////////////////////////////////////////////////////////////////
// LTransfer dialog


LTransfer::LTransfer(CWnd* pParent /*=NULL*/)
	: CDialog(LTransfer::IDD, pParent)
{
	//{{AFX_DATA_INIT(LTransfer)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	bInProgress = FALSE;
	lTransferred = 0;
}


void LTransfer::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(LTransfer)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(LTransfer, CDialog)
	//{{AFX_MSG_MAP(LTransfer)
	ON_WM_PAINT()
	ON_WM_CREATE()
    ON_MESSAGE(EV_TRF, OnEvTrf)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// LTransfer transfer progress

void LTransfer::Gauge()
{
char szProgress[32];
	wsprintf (szProgress, "%ld/%ld", lTransferred, FtpBytesToBeTransferred());
	SetDlgItemText (IDC_PROGRESS, szProgress);
} // Gauge

/////////////////////////////////////////////////////////////////////////////
// LTransfer message handlers

void LTransfer::OnCancel() 
{
	// TODO: Add extra cleanup here
	FtpAbort ();
	CDialog::OnCancel();
	DestroyWindow ();
}


void LTransfer::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	Gauge();	
}

int LTransfer::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (! pOpt->b_mThread)
	{
		bInProgress = TRUE;
		FtpSetAsynchronousMode ();
		int Rc;
		if (bUpload)  
			Rc = FtpSendFile (StrFile, StrFile, cType, TRUE, m_hWnd, EV_TRF);
		else          
			Rc = FtpRecvFile (StrFile, StrFile, cType, TRUE, m_hWnd, EV_TRF);
		if (Rc!=FTPERR_OK) 
		{char szErrStr [64];
			wsprintf (szErrStr, "Transfer Error: %d", Rc);
			AfxMessageBox (szErrStr);
		}
	}  // only a thread -> no connection
	else
	{
	}
	return 0;
}


// -----------------------------------------------
// Ftp4w has posted a message during the transfer
// if bEndOfTrf is TRUE, the transfer is done,
// otherwise we have to read the number of transferred bytes
// and to update the gauge.

LONG LTransfer::OnEvTrf (WPARAM bEndOfTrf, LPARAM lBytesTrans)
{
	lTransferred = lBytesTrans;
	Gauge();
	if (bEndOfTrf) 	
	{ 
		if (pOpt->m_bBeep) MessageBeep(-1);
	    DestroyWindow ();
	    FtpSetSynchronousMode ();
		bInProgress = FALSE;
	}
return 0;
}


