//
// Little FTP : main dialog, about dialog
// 
// LFtpDlg.cpp : implementation file
//


// C++ include files
#include "stdafx.h"
#include <ftp4w.h>   

#include "LFtp.h"
#include "LConnect.h"
#include "LTransfer.h"
#include "LFtpDlg.h"

BOOL StrReadLine (HFILE, LPSTR, UINT);
#define SizeOfTab(x)   (sizeof x / sizeof x[0])


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define WM_VERBOSESTRING   (WM_USER+3)

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	char szFtp4wVer[100];
	Ftp4wVer (szFtp4wVer, sizeof szFtp4wVer);
	SetDlgItemText (IDC_FTP4WVER, szFtp4wVer);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



/////////////////////////////////////////////////////////////////////////////
// CLFtpDlg dialog

CLFtpDlg::CLFtpDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLFtpDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLFtpDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	bConnected = FALSE;
}

void CLFtpDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLFtpDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLFtpDlg, CDialog)
	//{{AFX_MSG_MAP(CLFtpDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_CONNECT, OnConnect)
	ON_BN_CLICKED(ID_QUIT, OnQuit)
	ON_BN_CLICKED(ID_Refresh, OnRefresh)
	ON_LBN_DBLCLK(IDC_REMOTEDIR, OnDblclkRemotedir)
	ON_LBN_DBLCLK(IDC_LOCALDIR, OnDblclkLocaldir)
	ON_WM_CLOSE()
    ON_MESSAGE(WM_VERBOSESTRING, OnVerboseString)
	ON_BN_CLICKED(ID_ABORT, OnAbort)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLFtpDlg message handlers

BOOL CLFtpDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// inits Ftp4w
	int Rc = FtpInit (m_hWnd);
	if (Rc!=FTPERR_OK)
	{
		AfxMessageBox ("Error during FtpInit");
		return FALSE;
	}
	FtpSetVerboseMode (TRUE, m_hWnd, WM_VERBOSESTRING);
	
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// remember main items
	pcRemoteList = (CListBox *) GetDlgItem (IDC_REMOTEDIR);
	pcLocalList  = (CListBox *) GetDlgItem (IDC_LOCALDIR);

	// Show connect windows
	OnConnect ();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLFtpDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.
void CLFtpDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CLFtpDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// -------------
// OnConnect manages the toggle button Connect/Disconnect
void CLFtpDlg::OnConnect() 
{
int Rc;
	if (bConnected)
	{
		if (FtpCloseConnection () == FTPERR_OK)
			bConnected = FALSE;
	}
	else
	{
	   // call connection dialog box
		if (cConnect.DoModal ()==-1)  // cancel
		{
			PostQuitMessage (0);
			return;
		}
		// start connection 
		FtpSetPassiveMode(cConnect.Opt.m_bPassiveMode);
		FtpSetSynchronousMode ();
		Rc = FtpLogin (cConnect.Opt.m_szHost, cConnect.Opt.m_szUserName,
				  	   cConnect.Opt.m_szPassWord, 0, 0);
		bConnected = (Rc==FTPERR_OK);
		/* if bad user name, bad password... */
		if (!bConnected)  
			if (Rc>=2000)  AfxMessageBox (FtpErrorString(Rc));
			else           FtpCloseConnection ();
	}
	OnRefresh ();  // redisplay Window
}


void CLFtpDlg::OnQuit() 
{
	PostMessage (WM_CLOSE);
}


// --------------------
// Paint Dialog Window
void CLFtpDlg::OnRefresh() 
{
char szCWD [256];

	// change button status
	SetDlgItemText (ID_CONNECT, bConnected ? "Disconnect" : "Connect");
	SetWindowText ("Little Ftp.  Not Connected");

	// clear listboxes
	pcLocalList->ResetContent ();
	pcRemoteList->ResetContent ();
	if (! bConnected)	return;

	// change dialog caption
	SetWindowText (CString ("Little Ftp. Connected on ") + cConnect.Opt.m_szHost
				   + CString (" User ") + cConnect.Opt.m_szUserName);
	
	// refresh local list box 
	pcLocalList->Dir (DDL_READONLY | DDL_DRIVES | DDL_DIRECTORY, "*.*");
	GetCurrentDirectory (sizeof szCWD, szCWD);
	SetDlgItemText (IDC_LOCALCWD, szCWD);
	
	// get remote dir -> szCWD
	szCWD[0] = 0;
	FtpPWD (szCWD, sizeof szCWD);
	SetDlgItemText (IDC_REMOTECWD, szCWD);

	// get remote dir content,use check box in IDD_CONNECT:
	// szCWD used to create temp file name
	// if mask unused start dir with no file mask 
	// differs from "*.*"
	char szMask [32];
	GetTempPath (sizeof szCWD, szCWD);
	GetTempFileName (szCWD, "4w", 0, szCWD);
	GetDlgItemText(IDC_MASK, szMask, sizeof szMask);
	int Rc = FtpDir (szMask[0]==0 ? NULL: szMask, 
				     szCWD, cConnect.Opt.m_bLongDir, 0, 0);

	// for each line into this file add a string in list box
	if (Rc==FTPERR_OK)
	{int TextLength;
	  pcRemoteList->AddString ("<Parent Dir>");
	  char szDirLine[256];
	  HFILE hF = _lopen (szCWD, OF_READ);
	  while ( StrReadLine (hF, szDirLine, sizeof szDirLine) )
	  {
	    pcRemoteList->AddString (szDirLine);
		TextLength = pcRemoteList->GetDC()->GetTextExtent (szDirLine, lstrlen(szDirLine)).cx;
		if (TextLength> pcRemoteList->GetHorizontalExtent())
			pcRemoteList->SetHorizontalExtent(TextLength);
	  }
	  _lclose (hF);
	}
	// we could keep the file to create a small cache
	// but not in this sample
	unlink (szCWD);
}  // OnRefresh




// -----------
// Transfer a file
int CLFtpDlg::TransferFile (const CString &StrFile, char cType, BOOL bUpload)
{
int Ark=0;
  if (cConnect.Opt.m_bThread)
  {
    // search for a free CTransfer slot
    for (Ark=0 ; 
         Ark<SizeOfTab(tcTransfer) && tcTransfer[Ark].bInProgress ; 
		 Ark++);
    if (Ark>=SizeOfTab(tcTransfer))  return FALSE;  // 20 transfers in progress !!!
  }
  else  // can only open the first slot
  {
	if (tcTransfer[Ark].bInProgress)  return FALSE;
  }


  // copy file transfer parameters
  tcTransfer[Ark].bInProgress = TRUE;
  tcTransfer[Ark].bUpload = FALSE;
  tcTransfer[Ark].StrFile = StrFile;
  tcTransfer[Ark].cType   = TYPE_I;
  tcTransfer[Ark].pOpt    = & cConnect.Opt;
  // create file transfer window
  if (tcTransfer[Ark].Create (IDD_TRANSFER, this))
  {
	 // inits transfer
	 // display transfer window
	 tcTransfer[Ark].ShowWindow (SW_SHOW);
	 tcTransfer[Ark].UpdateWindow ();
  }  // Create window created
return TRUE;
}

// -----------
// Dbl click on the remote list -> Get the file
void CLFtpDlg::OnDblclkRemotedir() 
{
CString StrFile;
int		Rc;
	// First string: Parent Dir
    if (pcRemoteList->GetCurSel () == 0) 
	{
		FtpCDUP();
		OnRefresh ();
	}
	else
	{
	   pcRemoteList->GetText (pcRemoteList->GetCurSel (), StrFile);
	   // if long dir has been chosen, get last word (Unix format)
	   if (cConnect.Opt.m_bLongDir)
		   StrFile = StrFile.Mid (1+StrFile.ReverseFind(' '));
	   // since there is no standard way to know if StrFile is
	   // a directory or a file, we try a CWD. If command refused
	   // we try to get it
	   Rc = FtpCWD (StrFile);
	   if (Rc == FTPERR_OK)	 OnRefresh ();
	   else			   	     TransferFile (StrFile, TYPE_I, FALSE);
	} // first line not selected

}


// -----------
// Dbl click on the local list -> Put the file
void CLFtpDlg::OnDblclkLocaldir() 
{
CString StrFile;
int		Rc;
char szCWD [256];

  pcLocalList->GetText (pcLocalList->GetCurSel (), StrFile);
  // if it inclosed by [], it is a directory
  if (StrFile.Right(1) == "]"  && StrFile.Left(1) == "[")
  {
	SetCurrentDirectory (StrFile.Mid(1, StrFile.GetLength()-2));
    // refresh only local list box 
    pcLocalList->Dir (DDL_READONLY | DDL_DRIVES | DDL_DIRECTORY, "*.*");
    GetCurrentDirectory (sizeof szCWD, szCWD);
    SetDlgItemText (IDC_LOCALCWD, szCWD);
  }
  else
  {
    Rc=FtpSendFile (StrFile, StrFile, TYPE_I, FALSE, 0, 0);
    if (Rc!=FTPERR_OK)   AfxMessageBox (FtpErrorString (Rc));
  }

}


// -----------
// Quit the application. Do not forget to call FtpRelease
void CLFtpDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	FtpCloseConnection ();	bConnected = FALSE;
	FtpRelease ();
	CDialog::OnClose();
}

// -----------
// Each time a string come from the server, we add it into
// a list box. 100 lines are kept into this listbox.
LONG CLFtpDlg::OnVerboseString (WPARAM, LPARAM szVerboseString)
{
UINT NbItems;
   SendDlgItemMessage (IDC_LOGFTP, LB_ADDSTRING, 0, szVerboseString);
   NbItems = SendDlgItemMessage (IDC_LOGFTP, LB_GETCOUNT);
   if (NbItems>100)   
	   SendDlgItemMessage (IDC_LOGFTP, LB_DELETESTRING, 0);
   SendDlgItemMessage (IDC_LOGFTP, LB_SETTOPINDEX, NbItems-2);
return FALSE;
} /* szVerboseString */


// -----------
// A file transfer is to be cancelled
void CLFtpDlg::OnAbort() 
{
	FtpAbort ();	
}
