/* **************************************************************
 *
 *
 *      C W  
 * 
 *  This program must be compiled with the model 'Large'
 * **************************************************************** */


/* To be defined if you are using a firewall   */
/* #define FIREWALL_TYPE  FTP4W_FWUSERNOLOGON  */


#define  STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ftp4w.h>
#include "cw.h"


LPSTR HOST_NAME(void);
LPSTR USER_NAME(void); 
LPSTR PASSWD_NAME(void) ;
LPSTR REM_HOSTNAME(void); 
LPSTR REM_USERNAME(void); 
LPSTR REM_PASSWD(void) ;
LPSTR LOCALFILE_NAME(void) ;
LPSTR REMOTEFILE_NAME(void); 
LPSTR REMOTE_DIR(void) ;
LPSTR NEWREMOTEFILE_NAME(void) ;
LPSTR REMOTE_DIR(void) ;


#ifdef _WIN32
#  define _export
#endif

#define  INIFILE_NAME   "CW.ini" /* name of ini file */
#define  LOG_FILE       "c:\\ftp4w.log"


/* user's defined messages */
#define  FTP_LOGGED          (WM_USER + 48)
#define  FTP_DIR             (WM_USER + 51)
#define  FTP_DIRLINEPERLINE  (WM_USER + 52)
#define  FTP_FILETRANSFERED  (WM_USER + 54)
#define  CW_VERBOSE          (WM_USER + 57)
#define  CW_BEGIN            (WM_USER + 60)
#define  CW_QUITAPP          (WM_USER + 63)
#define  SHORT_DIR            FALSE       

#define  IsOptOn(x) (GetMenuState (GetMenu(hWnd),x,MF_BYCOMMAND)==MF_CHECKED)



#define         szAPPLICATION     "CW_MAIN"

HINSTANCE       hInst;             /* hInstance of application     */
HWND            hwnd;              /* hWnd of main window          */
BOOL            FirstEmission;
BOOL            bFileTransfer=FALSE; /* TRUE->data transfer in progress */
char            szQuoteCmd[128];     /* Quote Command */
HFILE           hLogFile=HFILE_ERROR; /* Log File */


/* in main2 : gauge window */
void SetXmitBytes (LONG lBytes, LONG lTotalBytes);
void DeleteXferWindow (void);
void CreateXferWindow(void);
void SetXferWindowText (LPSTR lpStr);
int nCwRegisterClasses(void);
int nCwUnregisterClasses(void);
/* in main2 : scroller window */
void DoPrintf  (LPSTR szFormat, ...);
void Ecris     (LPSTR szFormat, ...);
void DoAddLine (LPSTR szLine);                           

void TpDoWmClose (HWND hWnd);
void TpDoWmPaint (HWND hWnd);
void TpDoWmScroll (HWND hWnd, int nScroll, WPARAM wParam, LPARAM lParam);
void TpDoWmSize (HWND hWnd);
void TpDoWmCreate (HWND hWnd);

/* in this file */
BOOL InitApplication (HINSTANCE hInstance);
BOOL InitInstance (HINSTANCE hInstance, int nCmdShow);


/* identifiant du Thread */
DWORD far Ftp4wIdentThread()
{
  return 45ul;
} // Ftp4wIdentThread


/* different system names */
char *szSyst[] = { "Dos", "Windows", 
                   "Unix", "VMS", "CMS", "OS2", NULL };



long FileSize (LPSTR szFile)
{
HFILE hF;
long FS;
  hF = _lopen (szFile, 0);
  if (hF==HFILE_ERROR)  return 0;
  FS = _llseek (hF, 0, SEEK_END);
  _lclose (hF);
return FS;
} /* FileSize */

//*******************************************************************
LRESULT CALLBACK _export CBQuoteDlg (HWND hWndDlg, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
   if (message==WM_INITDIALOG)
    {  
      SetDlgItemText (hWndDlg, IDC_QUOTECMD, szQuoteCmd);
      SetFocus (GetDlgItem (hWndDlg, IDC_QUOTECMD));
    }
   if (message==WM_COMMAND)
    {
      switch (wParam)
        {
          case IDOK : GetDlgItemText (hWndDlg, IDC_QUOTECMD, 
                                     szQuoteCmd, sizeof szQuoteCmd);
                      EndDialog (hWndDlg, 0);
                      break;
          case IDCANCEL : EndDialog (hWndDlg, -1);
        }
    }
return FALSE;     
} /* CBQuoteDlgf */                    



/* ---------------------- */
/* A function for FtpMGet */
/* ---------------------- */
BOOL CALLBACK MGetShow (LPSTR szRemoteFile, LPSTR szLocalFile, int Rc)
{
char szBuf7 [256];
static int R2;
  if (Rc==FTPERR_ENDOFDATA)
    {
      wsprintf (szBuf7, "Get File <%s> ?", szRemoteFile);
      R2 = MessageBox (NULL, szBuf7, "CW : MGet", MB_YESNOCANCEL);
      return R2==IDYES;
    } 
return R2!=IDCANCEL;
} /* MGetShow */



//*******************************************************************
LRESULT CALLBACK _export MainWndProc (HWND hWnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
static char szBuf[10240];
static char szWinDir[145], szExecCmd [256];
int         Rc;
LPSTR       p, q;
HFILE       hF, hFile;
FARPROC     lpfnQuoteDlg;

static HFILE hZ;

    switch (message)
    {
       case WM_CREATE :
          hwnd = hWnd;
          TpDoWmCreate (hWnd);
          nCwRegisterClasses();
          PostMessage (hWnd, CW_BEGIN, 0, 0);
          break;  
      case WM_SIZE :
          if (! IsIconic(hWnd))   TpDoWmSize (hWnd);
          break;    
      case WM_VSCROLL:
          TpDoWmScroll (hWnd, SB_VERT, wParam, lParam);
          break;;
       case WM_HSCROLL: 
          TpDoWmScroll (hWnd, SB_HORZ, wParam, lParam);
          break;
      case WM_PAINT :
          if (!IsIconic (hWnd))   TpDoWmPaint (hWnd);
          break;


          
   /* ---------------------------------------------------------- */

       case CW_BEGIN :

 DoAddLine ("----------------------------------------------------------------");
#ifdef FRANCAIS
          DoAddLine ("Exemple de Programme utilisant FTP4W.DLL");
          DoAddLine ("Les paramtres (nom du distant, nom d'utilisateur,...)");
          DoAddLine ("doivent tre entrs dans le fichier CW.INI ");
          DoAddLine ("comme le montre le fichier donn sur la disquette.");
          DoAddLine (" ");
          DoAddLine ("Ce fichier doit tre copi dans le rpertoire de Windows");
          DoAddLine ("Pour l'diter, utiliser la commande Options/Edit INI");
#else
          DoAddLine ("Sample program For FTP4W.DLL By Ph. Jounin");
          DoAddLine ("Host description and file names must be defined");
          DoAddLine ("in the file CW.INI as shown in the INI file");
          DoAddLine ("provided in the package FTP4W.ZIP.");
          DoAddLine (" ");
          DoAddLine ("Please report bugs and disfonctionments to");
          DoAddLine ("           ark@ifh.sncf.fr");
 #endif /* langues */
 DoAddLine ("----------------------------------------------------------------");

          /* add version information */
          Rc = Ftp4wVer (szBuf, sizeof szBuf);
          Ecris ("Version %d.%02X", HIBYTE (Rc), LOBYTE(Rc));
          DoAddLine (szBuf);   
 DoAddLine ("----------------------------------------------------------------");

          /* initialize FTP sesson */  
          Rc = FtpMtInit(hWnd, Ftp4wIdentThread);
          if (Rc!= FTPERR_OK)   
                Ecris ("FtpInit failed !\nError Code %d", Rc);
          else
             {
                FtpSetDefaultTimeOut (30);       /* new Timeout : 30 seconds */
                FtpSetNewDelay(10);
             }
          break;

      case WM_CLOSE : 
           DeleteXferWindow ();
           FtpLocalClose ();
           if (FtpRelease()!=FTPERR_OK) 
               { 
                 SetTimer (hWnd, 1, 500l, 0);
                 return FALSE; 
               }
           else
             {  
                TpDoWmClose(hWnd);
                DestroyWindow (hWnd);
                PostQuitMessage (0);
             }
            break;
            
      case WM_TIMER :
           KillTimer (hWnd, 1);
           FtpRelease ();
           TpDoWmClose(hWnd);
           DestroyWindow (hWnd);
           PostQuitMessage (0);
           break; 

      case WM_QUERYENDSESSION :
          FtpLocalClose ();
          FtpRelease ();
          TpDoWmClose(hWnd);
          DeleteXferWindow ();
          break;

      /* --------------------- */
      /* asynchronous Messages */
      /* --------------------- */
      case CW_VERBOSE :
          Ecris ((LPSTR) lParam);
          break;

      case FTP_LOGGED :
          Ecris ("Asynchronous Login returns %d -> <%s>", 
                (int) lParam, FtpErrorString ((int) lParam) );
          break;

          /* Ftp4w sends a message each time an entry has been received */
          /* lParam points on this entry, wParam is FALSE               */
          /* If wParam is TRUE, the directory is finished, one gets the */
          /* the return code of the function.                           */
      case FTP_DIRLINEPERLINE :
          if (! wParam)  DoAddLine ((LPSTR) lParam);
          else  Ecris ("----> FtpDir Returns %d -> <%s>", 
                (int) lParam, FtpErrorString ((int) lParam) );
          break;

          /* Dir asynchrone : The dir file has been received */  
      case FTP_DIR :
          Ecris ("Dir returns %d", (int) lParam);
          Ecris ("-------");
          hF = _lopen ("$$dir$$.tmp", 0);
          _lread (hF, szBuf, sizeof szBuf);
          _lclose (hF);
          for (p=szBuf ; (q=strchr (p,'\r')) !=NULL ; p=q+2 )
              {  *q=0;
                  DoAddLine (p); }
          Ecris ("-------");
          unlink ("$$dir$$.tmp");
          break;


       case FTP_FILETRANSFERED :
          if (wParam)
            {
               DeleteXferWindow ();
               Ecris ("Asynchronous transfer returns %d ->  <%s>", 
                    (int) lParam, FtpErrorString ((int) lParam) );
               bFileTransfer = FALSE;
            }
          else
            {
               SetXmitBytes (lParam, FtpBytesToBeTransferred ());
            }  
          break;
                

      /* --------------------- */
      /*     M   E   N   U     */
      /* --------------------- */
      case  WM_COMMAND :
        switch (wParam)
         {

           case  CW_ABOUT :
               Ftp4wVer (szBuf, sizeof szBuf);
               Ecris (szBuf);
               break;
                       
           case  CW_CONNECT :
               Ecris ("--- Connection on %s  ---", HOST_NAME () );
#              ifdef FIREWALL_TYPE
               Rc = FtpFirewallLogin ( HOST_NAME (), 
                                       USER_NAME (), 
                                       PASSWD_NAME (),
                                       REM_HOSTNAME(),
                                       REM_USERNAME(),
                                       REM_PASSWD (),
                                       FIREWALL_TYPE,
                                       hWnd, FTP_LOGGED);
#              else               
               Rc = FtpLogin ( HOST_NAME (), 
                               USER_NAME (), 
                               PASSWD_NAME (),
                               hWnd, FTP_LOGGED);
#endif                               
               Ecris ("Function returns %d", Rc);                              
               break;

 
           case CW_RCVAPPEND :
           case CW_RECV :
               Ecris ("Remote %s -> Local %s",REMOTEFILE_NAME (),LOCALFILE_NAME ());
               bFileTransfer = TRUE;
               if (IsOptOn(CW_GAUGE))
                 {
                    CreateXferWindow ();
                    SetXferWindowText (LOCALFILE_NAME());
                 }
               if (wParam==CW_RCVAPPEND)
                    Rc = FtpAppendToLocalFile ( REMOTEFILE_NAME (),
                                  LOCALFILE_NAME (),
                                  IsOptOn(CW_BINARY) ? TYPE_I : TYPE_A, 
                                  IsOptOn(CW_GAUGE),
                                  hWnd, 
                                  FTP_FILETRANSFERED);
               else                                   
                    Rc = FtpRecvFile ( REMOTEFILE_NAME (),
                                  LOCALFILE_NAME (),
                                  IsOptOn(CW_BINARY) ? TYPE_I : TYPE_A, 
                                  IsOptOn(CW_GAUGE),
                                  hWnd, 
                                  FTP_FILETRANSFERED);
               if (! IsOptOn (CW_SYNC) )
                 {       
                    Ecris ("Taille %ld", FtpBytesToBeTransferred () );
                    Ecris ("Async Recv returns %d %s", Rc, 
                            Rc==0 ? "-> Cmd in progress" : "-> Cmd terminated");
                    if (Rc!=0) bFileTransfer=FALSE;
                 }
               else  
                {
                    DeleteXferWindow ();
                    Ecris ("Recv returns %d", Rc);
                    bFileTransfer = FALSE;
                }
               break;

        


           case CW_APPEND :
           case CW_SEND :
               Ecris ("Local %s -> Remote %s",LOCALFILE_NAME (),REMOTEFILE_NAME ());
               bFileTransfer = TRUE;
               if (IsOptOn(CW_GAUGE))
                 {
                    CreateXferWindow ();
                    SetXferWindowText (LOCALFILE_NAME());
                 }
               if (wParam==CW_APPEND)
                  Rc = FtpAppendToRemoteFile ( LOCALFILE_NAME (),
                                               REMOTEFILE_NAME (),
                                               IsOptOn(CW_BINARY)?TYPE_I:TYPE_A,
                                               IsOptOn(CW_GAUGE),
                                               hWnd, 
                                              (LPARAM) FTP_FILETRANSFERED);
               else  
                  Rc = FtpSendFile ( LOCALFILE_NAME (),
                                     REMOTEFILE_NAME (),
                                     IsOptOn(CW_BINARY) ? TYPE_I : TYPE_A, 
                                     IsOptOn(CW_GAUGE),
                                     hWnd, 
                                    (LPARAM) FTP_FILETRANSFERED);
               if (! IsOptOn (CW_SYNC) )
                 {       
                    Ecris ("Taille %ld", FtpBytesToBeTransferred () );
                    Ecris ("Async Send returns %d %s", Rc, 
                            Rc==0 ? "-> Cmd in progress" : "-> Cmd terminated");
                    if (Rc!=0)       bFileTransfer = FALSE;
                 }
               else
                 {
                    DeleteXferWindow ();
                    Ecris ("Send returns %d", Rc);
                    bFileTransfer = FALSE;
                 }
               break;


           case CW_RCVRESTART :
               Ecris ("Local %s -> Remote %s",LOCALFILE_NAME (),REMOTEFILE_NAME ());
               bFileTransfer = TRUE;
               if (IsOptOn(CW_GAUGE))
                 {
                    CreateXferWindow ();
                    SetXferWindowText (LOCALFILE_NAME());
                 }
               hFile = _lcreat (LOCALFILE_NAME (), 0);
                    Rc = FtpRestartRecvFile ( REMOTEFILE_NAME (),
                                  hFile,
                                  IsOptOn(CW_BINARY) ? TYPE_I : TYPE_A, 
                                  IsOptOn(CW_GAUGE),
                                  100l,
                                  hWnd, 
                                  FTP_FILETRANSFERED);
               if (! IsOptOn (CW_SYNC) )
                 {       
                    Ecris ("Taille %ld", FtpBytesToBeTransferred () );
                    Ecris ("Async Recv returns %d %s", Rc, 
                            Rc==0 ? "-> Cmd in progress" : "-> Cmd terminated");
                    if (Rc!=0) bFileTransfer=FALSE;
                 }
               else  
                {
                    DeleteXferWindow ();
                    Ecris ("Recv returns %d", Rc);
                    bFileTransfer = FALSE;
                }
               break;

#ifdef TEST_FOR_DATACONNECTION
           case CW_RECVTEXT :
               Rc = FtpOpenDataConnection ("/tmp/Z", 
                                    FTP4W_GET_FROM_SERVER, 'A');
               Ecris ("OpenDataconnection returns %d", Rc);
               do 
                 {
                    Ark = sizeof szBuf;
                    memset (szBuf, 0, sizeof szBuf);
                    Rc = FtpRecvThroughDataConnection (szBuf, & Ark);
                    Ecris ("RecvThrough returns %d -> %d bytes", Rc, Ark);
                    if (Rc==FTPERR_OK)  Ecris ("<%s>", szBuf);
                 }
               while (Rc==FTPERR_OK);
               Rc = FtpCloseDataConnection ();
               Ecris ("CloseDataconnection returns %d", Rc);
               break;
#endif /* TEST_FOR_DATACONNECTION */

           case CW_RECVDIR :
               Rc = FtpMGet ("*.*", TYPE_I, FALSE, MGetShow);
               Ecris ("FtpMGet returns %d", Rc);
               break;
                                    
               

           case CW_SHORTDIR :
           case CW_LONGDIR :
               Rc=FtpDir (NULL, "$$dir$$.tmp",wParam==CW_LONGDIR,hWnd,FTP_DIR);
               if (Rc!=FTPERR_OK || IsOptOn(CW_SYNC))  
                        PostMessage (hWnd, FTP_DIR, TRUE, Rc);
               break;

           case CW_SHORTDIR_LL :
           case CW_LONGDIR_LL :
               if (IsOptOn (CW_SYNC))  
                    DoAddLine ("You MUST be in Asynchronous Mode");
               else     
                 {
                   Rc=FtpDir (NULL, NULL,wParam==CW_LONGDIR_LL,hWnd,FTP_DIRLINEPERLINE);
                   Ecris ("FtpDir returns %d", Rc);
                 }
               break;

           case CW_CWD :
              Rc = FtpCWD (REMOTE_DIR ());
              Ecris ("CWD returns %d", Rc);
              break;

           case CW_CDUP :
              Rc = FtpCDUP ();
              Ecris ("CDUP returns %d", Rc);
              break;

           case CW_PWD :
              Rc = FtpPWD (szBuf, sizeof szBuf);
              if (Rc==FTPERR_OK)  Ecris ("Current dir : %s", szBuf);
              else                Ecris ("FtpPWD returns %d", Rc);
              break;

           case CW_RMD :
              Rc = FtpRMD (REMOTE_DIR ());
              Ecris ("ftpRMD returns %d", Rc);
              break;

           case CW_MKD :
              Rc = FtpMKD (REMOTE_DIR (), szBuf, sizeof szBuf);
              /* szBuf should be the name of the created dir */
              if (Rc==FTPERR_OK  && szBuf[0]!=0)  
                        Ecris ("Dir %s Has been created", szBuf);
              else      Ecris ("FtpMKD returns %d", Rc);
              break;


           case CW_DELETE :
              Rc = FtpDeleteFile (REMOTEFILE_NAME ());
              Ecris ("FtpDelete returns %d", Rc);
              break;
            
           case CW_SYST :
              Rc = FtpSyst (szSyst);
              Ecris ("System returns %d -> %s", 
                      Rc, Rc>=1000 ? 
                          Rc==FTPERR_SYSTUNKNOWN ? "Unknown" :"Error" : 
                          szSyst[Rc]);
              break;

           case CW_RENAME :
              Rc = FtpRenameFile (REMOTEFILE_NAME (), NEWREMOTEFILE_NAME ());
              Ecris ("Rename returns %d", Rc);
              break;

           case CW_FLUSH :
              Rc = FtpFlush ();
              Ecris ("Flush returns %d", Rc);
              break;

           case CW_QUOTE :
              lpfnQuoteDlg = MakeProcInstance ((FARPROC) CBQuoteDlg, hInst);
              if (DialogBox(hInst, "QuoteDlg", hWnd, (DLGPROC)lpfnQuoteDlg)==0)
                {
                    Ecris ("QUOTE %s", szQuoteCmd);
                    Rc=FtpQuote (szQuoteCmd, NULL, 0);
                    Ecris ("Quote returns %d", Rc);
                 }
              FreeProcInstance (lpfnQuoteDlg);
              break;


           case CW_ABORT :
              Ecris ("Abort");
              FtpAbort ();
              break;  


           case CW_DISCONNECT : 
               if (bFileTransfer)
                  {
                     Ecris ("File transfer in progress, can not close session");
                  }
               else
                  {
                     Rc = FtpCloseConnection ();
                     Ecris ("FtpCloseConnection returns %d", Rc);
                  }
               break;


           case CW_QUIT : 
                PostMessage (hWnd, WM_CLOSE, 0, 0l);
                break;
                                     
           case CW_SYNC : 
               if (bFileTransfer)
                 {
                   MessageBox (NULL, "Can not change now", "CW_MAIN", MB_OK);
                 }
               else
                 {
                   if (! IsOptOn (CW_SYNC))
                      {
                          CheckMenuItem (GetMenu (hWnd), CW_SYNC, 
                                         MF_BYCOMMAND  | MF_CHECKED);
                          FtpSetSynchronousMode ();
                       }
                   else   
                      {
                          CheckMenuItem (GetMenu (hWnd), CW_SYNC, 
                                         MF_BYCOMMAND  | MF_UNCHECKED);
                          FtpSetAsynchronousMode ();
                       }
                 }
               break;      
                     
           case CW_SETVERB :
               if (IsOptOn (CW_SETVERB))
                   
                 {                
                   CheckMenuItem (GetMenu (hWnd), CW_SETVERB, 
                                  MF_BYCOMMAND  | MF_UNCHECKED);
                   FtpSetVerboseMode (FALSE, hWnd, CW_VERBOSE);
                 }
               else
                 {                
                   CheckMenuItem (GetMenu (hWnd), CW_SETVERB, 
                                  MF_BYCOMMAND  | MF_CHECKED);
                   FtpSetVerboseMode (TRUE, hWnd, CW_VERBOSE);
                 }
               break; 


           case CW_GAUGE :
               CheckMenuItem (GetMenu (hWnd), CW_GAUGE, MF_BYCOMMAND  | 
                              IsOptOn(CW_GAUGE) ? MF_UNCHECKED : MF_CHECKED); 
               /* pause (for display) each 3 frames if gauge is on */
               if IsOptOn(CW_GAUGE)   FtpSetNewSlices(3, 1);
               else                   FtpSetNewSlices(10, 3);
               break; 


           case CW_LOG :
               CheckMenuItem (GetMenu (hWnd), CW_LOG, MF_BYCOMMAND  | 
                              IsOptOn(CW_LOG) ? MF_UNCHECKED : MF_CHECKED); 
               if IsOptOn(CW_LOG)   hLogFile =  _lcreat (LOG_FILE, 0);
               else                 
                    {
                      _lclose (hLogFile); 
                      hLogFile = HFILE_ERROR;
                    }
               FtpLogTo (hLogFile);
               break; 
                
                
           case CW_BINARY :
               CheckMenuItem (GetMenu (hWnd), CW_BINARY, MF_BYCOMMAND  | 
                              IsOptOn(CW_BINARY) ? MF_UNCHECKED : MF_CHECKED);
               break; 
                
                
           case CW_PASSIVE :
               CheckMenuItem (GetMenu (hWnd), CW_PASSIVE, MF_BYCOMMAND  | 
                              IsOptOn(CW_PASSIVE) ? MF_UNCHECKED : MF_CHECKED);
               FtpSetPassiveMode (IsOptOn (CW_PASSIVE));
               break; 
                
          case CW_EDITINI :
               GetWindowsDirectory (szWinDir, sizeof szWinDir);
               wsprintf (szExecCmd, "NotePad %s\\%s", szWinDir, INIFILE_NAME);
               WinExec (szExecCmd, SW_SHOW);
               break;
                
            } /* WM_COMMAND */
    }
return DefWindowProc(hWnd, message, wParam, lParam);
} /* Boucle Windows */




/* ******************************************************************* */
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                        LPSTR lpszCmdLine, int nCmdShow)
{
MSG   msg;

    hInst = hInstance;       /* save for use by window procs */
    FirstEmission = (hPrevInstance==NULL);

    // Go init this application
    if (    !hPrevInstance  &&  !InitApplication(hInstance) )
        return   FALSE;      /* Exits if unable to initialize */
    if (!InitInstance(hInstance, nCmdShow))   return FALSE;

    /* Get and dispatch messages for this applicaton.*/
    while (GetMessage(&msg, NULL, 0, 0))
      {
        TranslateMessage(&msg);
        DispatchMessage(&msg);                  
      }
    UnregisterClass (szAPPLICATION, hInstance);  
    nCwRegisterClasses();
   _lclose (hLogFile); 
return  msg.wParam;
} /* WinMain */


/* ******************************************************************* */

BOOL InitApplication (HINSTANCE hInstance)
{
WNDCLASS wndClass;

     wndClass.lpszClassName = szAPPLICATION;
     wndClass.lpszMenuName  = szAPPLICATION;
     wndClass.hInstance     = hInstance;
     wndClass.lpfnWndProc   = MainWndProc;
     wndClass.hCursor       = LoadCursor(hInstance, IDC_ARROW);
     wndClass.hIcon         = LoadIcon  (hInstance, "CW_MAIN");
     wndClass.hbrBackground = (HBRUSH) (1 + COLOR_WINDOW);
     wndClass.style         = CS_VREDRAW | CS_HREDRAW;
     wndClass.cbClsExtra    = 0;
     wndClass.cbWndExtra    = 0;
   // Register the class
return  RegisterClass (&wndClass);
}  /* InitApplication */
      
      


BOOL InitInstance (HINSTANCE hInstance, int nCmdShow)
{
HWND       hWnd;

    hWnd = CreateWindow(
                    szAPPLICATION,     // window class name
                    szAPPLICATION,     // window title
                    WS_OVERLAPPEDWINDOW | WS_HSCROLL | WM_VSCROLL | WS_VISIBLE,
                    CW_USEDEFAULT,          // x - same as dialog box
                    CW_USEDEFAULT,          // y
                    490,                     // cx
                    250,                     // cy
                    NULL,                    // no parent for this window
                    NULL,                    // use the class menu
                    hInstance,               // who created this window
                    NULL                     // no parms to pass on
          );
    if (hWnd==0)  return FALSE;
    ShowWindow (hWnd, nCmdShow);
    UpdateWindow (hWnd);
return TRUE;
}  /* InitInstance */




/* ------------------------------ */
/* Get informations from INI file */
/* ------------------------------ */
LPSTR HOST_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Connect", "Host", "", szBuf,256, INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field Host not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  
                        

LPSTR USER_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Connect", "User", "", szBuf,256, INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field User not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  


LPSTR PASSWD_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Connect", "PassWd", "", szBuf,256, INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field PassWd not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  
                        

LPSTR REM_HOSTNAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Connect", "RemHost", "", szBuf,256, INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field RemHost not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  
                        

LPSTR REM_USERNAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Connect", "RemUser", "", szBuf,256, INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field RemUser not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  


LPSTR REM_PASSWD(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Connect", "RemPass", "", szBuf,256, INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field RemPass not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  


LPSTR LOCALFILE_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Transfer", "LocalFile", "",szBuf,256,INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field LocalFile not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  
                        
                        
LPSTR REMOTEFILE_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Transfer", "RemoteFile", "",szBuf,256,INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field RemoteFile not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  


LPSTR NEWREMOTEFILE_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Rename", "NewRemoteFile", "",szBuf,256,INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field NewRemoteFile not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  


LPSTR REMOTE_DIR(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Directory", "HostDir", "", szBuf,256, INIFILE_NAME);
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field HostDir not defined in Cw.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  


