
/* **************************************************************
 *
 *
 *      C W   :    P r o c e d u r e s
 * 
 *
 * **************************************************************** */



#include <windows.h>
#include <windowsx.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


extern HINSTANCE       hInst;             
extern HWND            hwnd;


/* **************************************************************
 *    G a u g e
 *             B y     Santanu Lahiri (winFTP)
 * **************************************************************/


static LONG lTotalBytes=0;
static DWORD lFileSize=0;
static LONG lXferBytes=0;
static int  nPercentXfer;
static HWND hWndXfer=NULL;
static LPSTR szXferWnd = "XferWindow";


HPEN hPenDark;
HPEN hPenLight;
HBRUSH  hbrGray1;
int  nWndx=10;                // the x axis multiplier
int  nWndy=15;                // the y axis multiplier



LRESULT CALLBACK WndXferProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);


int nCwUnregisterClasses(void)
{
  UnregisterClass (szXferWnd, hInst);
return 0;
}


int nCwRegisterClasses(void)
{
WNDCLASS   wc;    // struct to define a window class

  hbrGray1 = CreateSolidBrush (RGB (192,192,192));
  memset(&wc, 0x00, sizeof(wc));
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInst;
  wc.hCursor = LoadCursor ((HINSTANCE) NULL, IDC_ARROW);
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = WndXferProc;
  wc.hIcon         = LoadIcon (hInst, IDI_APPLICATION);
  wc.hbrBackground = hbrGray1;
  wc.lpszMenuName  = NULL;      /* Menu Name is App Name */
  wc.lpszClassName = szXferWnd; /* Class Name is App Name */
  if (RegisterClass (&wc)==0) return -1;
return 0;
}


void CreateButtonPens()
{
  hPenDark  = CreatePen (PS_SOLID, 1, RGB (128,128,128));
  hPenLight = CreatePen (PS_SOLID, 1, RGB (224,224,224));
}

void DeleteButtonPens()
{
  DeleteObject (hPenDark);
  DeleteObject (hPenLight);
}


void BoxIt (HDC hDC, int left, int top, int width, int height, BOOL flag)
{
  POINT Pt;
  HPEN hPenOld;
  
  hPenOld = SelectObject (hDC, flag? hPenDark : hPenLight);
  MoveToEx (hDC, (left*nWndx)/4, ((top+height)*nWndy)/8, &Pt);
  LineTo (hDC, (left*nWndx)/4, (top*nWndy)/8);
  LineTo (hDC, ((left+width)*nWndx)/4, (top*nWndy)/8);
  if (flag) SelectObject (hDC,hPenLight); 
  else SelectObject (hDC,hPenDark);
  LineTo (hDC, ((left+width)*nWndx)/4, ((top+height)*nWndy)/8);
  LineTo (hDC, (left*nWndx)/4, ((top+height)*nWndy)/8);
  SelectObject (hDC, hPenOld);
}


void PaintXfer (HDC hDC)
{
  RECT rc;
  char szBuf[10];

  CreateButtonPens();
  SelectObject (hDC, GetStockObject (WHITE_BRUSH));
  Rectangle (hDC, (nWndx*20)/4, (nWndy*10)/8, (nWndx*122)/4, (nWndy*20)/8);
  rc.left = (nWndx*21)/4;  rc.right = (nWndx*(nPercentXfer+21))/4;
  rc.top  = (nWndy*11)/8;  rc.bottom= (nWndy*19)/8;
  FillRect (hDC, &rc, GetStockObject (GRAY_BRUSH));
  rc.right = (nWndx*121)/4;
  SetBkMode (hDC, TRANSPARENT);
  wsprintf (szBuf, "%d%%", nPercentXfer);
  DrawText (hDC, szBuf, lstrlen (szBuf), &rc, DT_CENTER | DT_VCENTER);
  SetBkMode (hDC, OPAQUE);
  BoxIt (hDC, 18, 8, 106, 14, FALSE);
  DeleteButtonPens();
}



void OnPaintXfer (HWND hWnd)
{
  HDC hDC;
  PAINTSTRUCT ps;
  
  hDC = BeginPaint (hWnd, &ps);
  PaintXfer (hDC);
  EndPaint (hWnd, &ps);
}

void SetXmitBytes (LONG lBytes, LONG lTotal)
{
  int nOld;
  
  lXferBytes = lBytes;
  if (lTotalBytes==0)  lTotalBytes = lTotal;
  if ((lTotalBytes==0)||(hWndXfer==NULL)) return;
  nOld = nPercentXfer;
  nPercentXfer = (int) ((lBytes*100)/lTotalBytes);
  if (nOld!=nPercentXfer) 
  {
    HDC hDC;
  
    hDC = GetDC (hWndXfer);
    PaintXfer (hDC);
    ReleaseDC (hWndXfer, hDC);
  }
}



LRESULT CALLBACK WndXferProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  switch (Msg)
  {
    case WM_GETMINMAXINFO: 
    {
      MINMAXINFO FAR *lpmmi=(MINMAXINFO FAR *) lParam;
      lpmmi->ptMaxSize.x = (nWndx*140)/4;
      lpmmi->ptMaxSize.y = (nWndy*45)/8;
      lpmmi->ptMaxTrackSize.x = (nWndx*140)/4;
      lpmmi->ptMaxTrackSize.y = (nWndy*45)/8;
      lpmmi->ptMinTrackSize.x = (nWndx*140)/4;
      lpmmi->ptMinTrackSize.y = (nWndy*45)/8;
    } break;
    case WM_PAINT: OnPaintXfer (hWnd); return 0L;
  }
  return (LRESULT) DefWindowProc (hWnd, Msg, wParam, lParam);
}


void CreateXferWindow()
{
  if (hWndXfer!=NULL) return;
  hWndXfer = CreateWindowEx ( WS_EX_TOPMOST, 
       szXferWnd, "",  WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_CAPTION,
       CW_USEDEFAULT, CW_USEDEFAULT, (nWndx*140)/4, (nWndy*40)/8, (HWND) NULL, 
       (HMENU) NULL, hInst,  NULL);
  if (hWndXfer==NULL) MessageBeep (65535u);
  lTotalBytes = 0L;
  lXferBytes  = 0L;
  nPercentXfer = 0L;
}


void DeleteXferWindow()
{
  if (hWndXfer==NULL) return;
  DestroyWindow (hWndXfer);
  lTotalBytes  = lXferBytes = 0l;
  nPercentXfer = 0;
  hWndXfer = NULL;
}

void SetXferWindowText (LPSTR lpStr)
{
  SetWindowText (hWndXfer, lpStr);
}

void SetXferTotalBytes (LONG Total)
{
  lTotalBytes = Total;
}


/* **************************************************************
 *    S c r o l l e r 
 * **************************************************************/







#ifdef GLOBAL_ALLOC
#  define Calloc(n,s)  (void far *)GlobalAllocPtr(GMEM_SHARE | GMEM_ZEROINIT,n*s)
#  define Free(p)                 GlobalFreePtr (p)
#else
#  define Calloc(n,s)  (void *) (LocalLock (LocalAlloc (LPTR, n*s)))
#  define Free(p)      (LocalUnlock (LocalPtrHandle(p)), LocalFree (LocalPtrHandle(p)) )
#  define LocalPtrHandle(p) ( (LOCALHANDLE) LOWORD((void far *)p) )
#endif
#define MEMORY_ERROR()   \
{ MessageBox (hScrollWnd, "Can not allocate memory !!","Error",MB_OK); return; }
#define SHORT int
#define TP_LEFTMARGIN       15      /* 15 pixels left to the left */

/* ------------------------------------------------------- */
/*        Prototypes et variables communs au module        */
/* ------------------------------------------------------- */
static void TpGetCharDimension (HWND hWnd, int *pxChar, int *pyChar);
static int  TpGetLinesOnScreen (HWND hWnd);
static int  TpGetCharsOnScreen (HWND hWnd);
static int  TpGetNewVertScrollRange (HWND hWnd, int nNombreLignes);
static int  TpGetNewHorzScrollRange (HWND hWnd, int nNombreLignes);

void DoAddLine (LPSTR szBuf);
void TpDoPaint(HWND hWnd);

static char **lpMsg=NULL;  /* tableau sur les pointeurs de chaines     */
static int    nCurMsg;     /* nombre de messages dans le tableau lpMsg */
static int    nMaxMsg=200; /* nombre maximum de lignes                 */
static HWND   hScrollWnd;  /* handle de fenetre scroller (TpWmCreate)  */

/* ------------------------------------------------------- */
/*          Affichage d'un texte a l'ecran                 */
/* ------------------------------------------------------- */
/* Attention : Pas de test de debordement                  */


#include <stdarg.h>

int Ecris(LPSTR szFormat,...)
{
va_list vaArgs;
static char szBuf[256];
   va_start(vaArgs,szFormat);
   if (vsprintf (szBuf,szFormat,vaArgs)!=EOF) DoAddLine (szBuf);
   va_end(vaArgs);
return 0;
} /* Ecris */


/*la meme .... */
int DoPrintf (LPSTR szFormat,...)
{
va_list vaArgs;
static char szBuf[256];
   va_start(vaArgs,szFormat);
   if (vsprintf (szBuf,szFormat,vaArgs)!=EOF) DoAddLine (szBuf);
   va_end(vaArgs);
return 0;
} /* DoPrintf */


/* Ajout d'une ligne dans le scroller */
void DoAddLine (LPSTR lpBuf)
{
LPSTR lp;
int   nScrollPos;
  /* added in some error checking to try to eliminate GPFs */
  if (lpBuf==NULL || lpBuf[0]==0)   return;
  if (lpMsg==NULL)
    {
      lpMsg = Calloc (nMaxMsg, sizeof (LPSTR));
      nCurMsg = 0;
      if (lpMsg==NULL)   MEMORY_ERROR();
    }
  if (nCurMsg>=nMaxMsg)
    {
      Free (lpMsg[0]);
      memmove (lpMsg, lpMsg+1, (nMaxMsg-1)*sizeof (LPSTR));
      nCurMsg = nMaxMsg-1;
    }
  lp = lpMsg[nCurMsg] = Calloc (lstrlen (lpBuf) + 1, 1);
  if (lp!=NULL) 
  {
     nCurMsg++;
     lstrcpy (lp, lpBuf);
     nScrollPos = TpGetNewVertScrollRange (hScrollWnd, nCurMsg);
     /* changement des scrollers */
     SetScrollRange (hScrollWnd, SB_VERT, 0, nScrollPos, FALSE);
     SetScrollPos   (hScrollWnd, SB_VERT, nScrollPos, TRUE);
     SetScrollRange (hScrollWnd, SB_HORZ, 0, 
                    TpGetNewHorzScrollRange (hScrollWnd, nCurMsg), FALSE);
     InvalidateRect (hScrollWnd, NULL, TRUE);
  }  /* lp not NULL */
  else  MEMORY_ERROR();
} /* DoAddLine */



/* ----------------------------------------------------------- */
/* Petites fonctions de calcul                                 */
/* ----------------------------------------------------------- */

/* Donne la dimension en pixels d'un caractere */
static void TpGetCharDimension (HWND hWnd, int *pxChar, int *pyChar)
{ 
TEXTMETRIC tm;
HDC   hDC;
  /* computes yChar */
  hDC = GetDC (hWnd);
  GetTextMetrics (hDC, &tm);
  ReleaseDC (hWnd, hDC);
  /* Choisir sa methode de calcul: */  
  /* *pxChar = tm.tmMaxCharWidth;  */
  /* *pxChar = tm.tmAveCharWidth;  */
  *pxChar = (tm.tmAveCharWidth + tm.tmMaxCharWidth) / 2; 
  *pyChar = tm.tmHeight + tm.tmExternalLeading;
  if (*pyChar==0)  *pyChar=8;  /* si pas de police definie */
  if (*pxChar==0)  *pxChar=8;  /* si pas de police definie */
} /* TpGetCharDimension */


/* Donne le nombres de lignes que l'ecran peut afficher */
static int TpGetLinesOnScreen (HWND hWnd)
{
RECT  rect;
int   yChar, xChar;
  /* computes character size */
  TpGetCharDimension (hWnd, & xChar, & yChar);
  GetClientRect (hWnd, &rect);
return   (rect.bottom - rect.top) / yChar ;
} /* TpGetLinesOnScreen */


/* Donne le nombres de caracteres que l'ecran peut afficher */
static int TpGetCharsOnScreen (HWND hWnd)
{
RECT  rect;
int   yChar, xChar;
  /* computes character size */
  TpGetCharDimension (hWnd, & xChar, & yChar);
  GetClientRect (hWnd, &rect);
return   (rect.right - rect.left - TP_LEFTMARGIN) / xChar ;
} /* TpGetCharsOnScreen */


/* Calcule le maximum du scroller vertical (de 0 a ...) */
static int TpGetNewVertScrollRange (HWND hWnd, int nNombreLignes)
{
return max (nNombreLignes - TpGetLinesOnScreen (hWnd), 0);
} /* TpGetNewVertScrollRange */


/* Calcule le maximum du scroller horizontal (de 0 a ...) */
static int TpGetNewHorzScrollRange (HWND hWnd, int nNombreLignes)
{
int   nMaxLen=1;
int   Ark;
  /* computes character size */
  if (lpMsg!=NULL)
      for (Ark=0 ;  Ark<nNombreLignes ; Ark++)
         if (lpMsg[Ark] != NULL   &&  lstrlen (lpMsg[Ark])>nMaxLen)
            nMaxLen = lstrlen (lpMsg[Ark]);
return max (1, nMaxLen - TpGetCharsOnScreen (hWnd));
} /* TpGetNewHorzScrollRange */


/* ----------------------------------------------------------- */
/* Gestion des Messages de la fentre de Scroll                */
/* ----------------------------------------------------------- */

/* reception de message WM_CREATE -> inits + sauvegarde de hWnd */
void TpDoWmCreate (HWND hWnd)
{
  /* Gestion de la fentre scroller */
  SetScrollPos (hWnd, SB_VERT, 0, TRUE);
  SetScrollRange (hWnd, SB_VERT, 0, 1, TRUE);
  SetScrollPos (hWnd, SB_HORZ, 0, TRUE);
  SetScrollRange (hWnd, SB_HORZ, 0, 1, TRUE);
  ShowScrollBar (hWnd, SB_BOTH, FALSE);
  hScrollWnd = hWnd;
} /* TpDoWmCreate */


/* Reception de message WM_SIZE -> redefinition du scroller */
void TpDoWmSize (HWND hWnd)
{
int nScrollPos;
  nScrollPos = min (GetScrollPos (hWnd, SB_VERT), nCurMsg);
  /* Compute the scroll bar maximum and position */
  SetScrollRange (hWnd, SB_VERT, 0, 
                  TpGetNewVertScrollRange(hWnd,nCurMsg), FALSE);
  SetScrollPos (hWnd, SB_VERT, nScrollPos, FALSE);
  SetScrollRange (hWnd, SB_HORZ, 0, 
                  TpGetNewHorzScrollRange(hWnd,nCurMsg), FALSE);
  SetScrollPos (hWnd, SB_VERT, 0, FALSE);
  /* Force the whole thing to repaint */
  InvalidateRect(hWnd, NULL, TRUE);
} /* TpDoWmSize */


/* WM_VSCROLL ou WM_HSCROLL-> deplacement dans la fenetre */
void TpDoWmScroll (HWND hWnd, int nScroll, WPARAM wParam, LPARAM lParam)
{
SHORT nScrollInc;
SHORT nScrollPos;
SHORT nScrollMin;
SHORT nScrollMax;
SHORT yChar, xChar;

  TpGetCharDimension (hWnd, & xChar, & yChar);
  /* Get the current position */
  nScrollPos = GetScrollPos (hWnd, nScroll);
  GetScrollRange (hWnd, nScroll, &nScrollMin, &nScrollMax);
  /* Decode the various forms of scrolling */
  switch (wParam)
    {
      case SB_TOP:
          nScrollInc = -nScrollPos;
          break;
      case SB_BOTTOM:
          nScrollInc = nScrollMax - nScrollPos;
          break;
      case SB_LINEUP:
          nScrollInc = -1;
          break;
      case SB_LINEDOWN:
          nScrollInc = 1;
          break;
      case SB_PAGEUP:
          nScrollInc = -min((nScrollPos-nScrollMin), TpGetLinesOnScreen(hWnd));
          break;
      case SB_PAGEDOWN:
          nScrollInc = min ((nScrollMax-nScrollPos), TpGetLinesOnScreen(hWnd));
          break;
      case SB_THUMBTRACK:
          nScrollInc = LOWORD(lParam) - nScrollPos;
          break;
      default:
          nScrollInc = 0;
          break;
    } /* switch wParam */
  /* Now do the scroll if range has not been excedeed */
  if (nScrollPos+nScrollInc<=nScrollMax  &&  nScrollPos+nScrollInc>=0)
    {
      if (nScroll==SB_VERT)   
                ScrollWindow (hWnd, 0, -yChar * nScrollInc, NULL, NULL);
      if (nScroll==SB_HORZ)   
                ScrollWindow (hWnd, -xChar * nScrollInc, 0, NULL, NULL);
      SetScrollPos (hWnd, nScroll, nScrollPos + nScrollInc, TRUE);
      UpdateWindow (hWnd);
    }
   else MessageBeep ((unsigned) -1);
}  /* TpDoWmScroll */


/* reception de WM_CLOSE -> liberation memoire */
void TpDoWmClose (HWND hWnd)
{
int nI;
  if (lpMsg!=NULL) 
  {
    for (nI=0; nI<nMaxMsg; nI++) 
    {
      if (lpMsg[nI]!=NULL) Free (lpMsg[nI]);
      lpMsg[nI] = NULL;
    }
    Free (lpMsg);
    lpMsg=NULL;
  }
  nCurMsg = 0;
  SetScrollPos (hWnd, SB_HORZ, 0, TRUE);
  SetScrollPos (hWnd, SB_VERT, 0, TRUE);
  SetScrollRange (hWnd, SB_HORZ, 0, 1, TRUE);
  SetScrollRange (hWnd, SB_VERT, 0, 1, TRUE);
  hScrollWnd = NULL;
} /* TpDoWmClose */


/* Reception d'un message WM_PAINT -> Dessin de la fenetre */
void TpDoWmPaint(HWND hWnd)
{
PAINTSTRUCT ps;
SHORT nScrollPos;
SHORT nStart;
SHORT nEnd;
HFONT hFont;
HFONT hOldFont;
SHORT       nHorzPos;
SHORT       nPos;
SHORT       yChar, xChar;
static BOOL bVertScrollBar=FALSE;
static BOOL bHorzScrollBar=FALSE;
BOOL        bTotaliteALEcran;

  /* calculs preliminaires : on affiche de nStart a nEnd */
  BeginPaint(hWnd, &ps);
  /* Get a font to use */
  hFont = GetStockObject (ANSI_VAR_FONT);
  hOldFont = SelectObject (ps.hdc, hFont);

  SetBkMode(ps.hdc, TRANSPARENT);
  nScrollPos = GetScrollPos (hWnd, SB_VERT);
  TpGetCharDimension (hWnd, & xChar, & yChar);
  nStart = max (0, nScrollPos);
  nEnd   = min (nCurMsg, nScrollPos + TpGetLinesOnScreen (hWnd));
  nHorzPos = GetScrollPos (hWnd, SB_HORZ) * xChar;

  /* doit on afficher ou supprimer le scrollbar */
  bTotaliteALEcran = (nStart==0  &&  nEnd==nCurMsg);
  if (bVertScrollBar &&  bTotaliteALEcran)
     ShowScrollBar (hWnd, SB_VERT, bVertScrollBar=FALSE);
  else if (! bVertScrollBar &&  ! bTotaliteALEcran)
     ShowScrollBar (hWnd, SB_VERT, bVertScrollBar=TRUE);

  bTotaliteALEcran = (TpGetNewHorzScrollRange(hWnd, nCurMsg)==1);
  if (bHorzScrollBar &&  bTotaliteALEcran)   
     ShowScrollBar (hWnd, SB_HORZ, bHorzScrollBar=FALSE);
  else if (! bHorzScrollBar &&  ! bTotaliteALEcran)
     ShowScrollBar (hWnd, SB_HORZ, bHorzScrollBar=TRUE);

  /* Loop through and draw all lines */
  if (lpMsg!=NULL)
     for (nPos=0 ;  nStart < nEnd ; ++nStart, nPos+=yChar)
       if (lpMsg[nStart]!=NULL) 
         {
           TextOut (ps.hdc, TP_LEFTMARGIN-nHorzPos, nPos, 
                    lpMsg[nStart], lstrlen (lpMsg[nStart])); 
         }
            
  /* Delete the font that is no longer needed */
  DeleteObject (SelectObject (ps.hdc, hOldFont));
  EndPaint(hWnd, &ps);
} /* TpDoWmPaint */


