
/* *************************************************************** */
/*                                                                 */
/*                                                                 */
/*                                                                 */
/*    FTP4W.DLL  (Version 2.6)                                     */
/*                                                                 */
/*                                                                 */
/*                                   By Ph. Jounin (SNCF 71-26-12) */
/*                                        Internet ark@ifh.sncf.fr */
/*                                            Copyright SNCF 94-96 */
/* *************************************************************** */


#ifndef _FTP4W_API_

#include <winsock.h>

#ifdef __cplusplus  
extern "C" {            /* Assume C declarations for C++ */   
#endif  /* __cplusplus */   

#ifdef DEBUG
#  define  FTP_DATABUFFER  256                 /* slown down the transfer */
#else
#  define  FTP_DATABUFFER  4096 /* a good value for X25/Ethernet/Token Ring */
#endif



/* ----------------------------------------------------------- */

/* ASCII or binary transfer */
#define   TYPE_A        'A'
#define   TYPE_I        'I'
#define   TYPE_L8       'L'
#define   TYPE_DEFAULT   0
                          
/* actions requested by user */
#define   FTP4W_STORE_ON_SERVER   65
#define   FTP4W_APPEND_ON_SERVER  87
#define   FTP4W_GET_FROM_SERVER   223

/* Firewall Types */
#define   FTP4W_FWSITE             100
#define   FTP4W_FWPROXY            103
#define   FTP4W_FWUSERWITHLOGON    106
#define   FTP4W_FWUSERNOLOGON      109

                          
/* ----------------------------------------------------------- */
/*              Return codes of FTP functions                  */
/* ----------------------------------------------------------- */
/* success */
#define  FTPERR_OK                    0 /* succesful function                */
/* OK but waits for further parameters */
#define  FTPERR_ENTERPASSWORD         1 /* userid need a password            */
#define  FTPERR_ENTERACCOUNT          2 /* user/pass OK but account required */
#define  FTPERR_ACCOUNTNEEDED         2 /* user/pass OK but account required */
#define  FTPERR_RESTARTOK             3 /* Restart command successful        */
#define  FTPERR_ENDOFDATA             4  /* server has closed the data-conn   */
#define  FTPERR_CANCELBYUSER         -1 /* Transfer aborted by user FtpAbort */
/* user's or programmer's Errors  */
#define  FTPERR_INVALIDPARAMETER   1000 /* Error in parameters               */
#define  FTPERR_SESSIONUSED        1001 /* User has already a FTP session    */
#define  FTPERR_NOTINITIALIZED     1002 /* FtpInit has not been call         */
#define  FTPERR_NOTCONNECTED       1003 /* User is not connected to a server */
#define  FTPERR_CANTOPENFILE       1004 /* can not open specified file       */
#define  FTPERR_CANTOPENLOCALFILE  FTPERR_CANTOPENFILE
#define  FTPERR_CANTWRITE          1005 /* can't write into file (disk full?)*/
#define  FTPERR_NOACTIVESESSION    1006 /* FtpRelease without FtpInit        */
#define  FTPERR_STILLCONNECTED     1007 /* FtpRelease without any Close      */
#define  FTPERR_SERVERCANTEXECUTE  1008 /* file action not taken             */
#define  FTPERR_LOGINREFUSED       1009 /* Server rejects usrid/passwd       */
#define  FTPERR_NOREMOTEFILE       1010 /* server can not open file          */
#define  FTPERR_TRANSFERREFUSED    1011 /* Host refused the transfer         */
#define  FTPERR_WINSOCKNOTUSABLE   1012 /* A winsock.DLL ver 1.1 is required */
#define  FTPERR_CANTCLOSE          1013 /* Close failed (cmd is in progress) */
#define  FTPERR_FILELOCKED         1014 /* temporary error during FtpDelete  */
#define  FTPERR_FWLOGINREFUSED     1015 /* Firewallrejects usrid/passwd      */
#define  FTPERR_ASYNCMODE          1016 /* FtpMGet only in synchronous mode  */
/* TCP errors */
#define  FTPERR_UNKNOWNHOST        2001 /* can not resolve host adress       */
#define  FTPERR_NOREPLY            2002 /* host does not send an answer      */
#define  FTPERR_CANTCONNECT        2003 /* Error during connection           */
#define  FTPERR_CONNECTREJECTED    2004 /* host has no FTP server            */
#define  FTPERR_SENDREFUSED        2005 /* can't send data (network down)    */
#define  FTPERR_DATACONNECTION     2006 /* connection on data-port failed    */
#define  FTPERR_TIMEOUT            2007 /* timeout occured                   */
#define  FTPERR_FWCANTCONNECT      2008 /* Error during connection with FW   */
#define  FTPERR_FWCONNECTREJECTED  2009 /* Firewall has no FTP server        */
/* FTP server errors */
#define  FTPERR_UNEXPECTEDANSWER   3001  /* answer was not expected          */
#define  FTPERR_CANNOTCHANGETYPE   3002  /* host rejects the TYPE command    */
#define  FTPERR_CMDNOTIMPLEMENTED  3003  /* host recognize but can't exec cmd*/
#define  FTPERR_PWDBADFMT          3004  /* PWD cmd OK, but answer has no "  */
#define  FTPERR_PASVCMDNOTIMPL     3005  /* Server don't support passive mode*/
/* Resource errors */
#define  FTPERR_CANTCREATEWINDOW   5002  /* Insufficent free resources       */
#define  FTPERR_INSMEMORY          5003  /* Insuffisent Heap memory          */
#define  FTPERR_CANTCREATESOCKET   5004  /* no more socket                   */
#define  FTPERR_CANTBINDSOCKET     5005  /* bind is not succesful            */
#define  FTPERR_SYSTUNKNOWN        5006  /* host system not in the list      */

/* ----------------------------------------------------------- */
struct S_FtpData
{
   SOCKET   ctrl_socket;    /* control stream       init INVALID_SOCKET */
   SOCKET   data_socket;    /* data stream          init INVALID_SOCKET */
   char     cType;          /* type (ASCII/binary)  init TYPE_A         */
   BOOL     bVerbose;       /* verbose mode         init FALSE          */ 
   BOOL     bPassif;        /* VRAI -> mode passif                      */ 
   unsigned short nPort;    /* connexion Port       init FTP_DEFPORT    */
   unsigned nTimeOut;       /* TimeOut in seconds   init FTP_DEFTIMEOUT */
   HFILE    hLogFile;       /* Log file                                 */ 
   char     szInBuf [2048]; /* incoming Buffer                          */
   struct sockaddr_in saSockAddr;   /* not used anymore */
   struct sockaddr_in saAcceptAddr; /* not used anymore */
}; /* struct S_FtpData */


struct S_FileTrf 
{
   HFILE    hf;         /* handle of the file which is being transfered */
   unsigned nCount;     /* number of writes/reads made on a file        */
   unsigned nAsyncAlone;/* pause each N frame in Async mode  (Def 40)   */
   unsigned nAsyncMulti;/* Idem but more than one FTP sssion (Def 10)   */
   unsigned nDelay;     /* time of the pause in milliseconds            */
   BOOL     bAborted;   /* data transfer has been canceled              */
   char     szBuf[FTP_DATABUFFER]; /* Data buffer                       */
   BOOL     bNotify;    /* application receives a msg each data packet  */
   BOOL     bAsyncMode; /* synchronous or asynchronous Mode             */
   LONG     lPos;       /* Bytes transfered                             */
   LONG     lTotal;     /* bytes to be transfered                       */
}; /* struct S_FileTrf */

struct S_Msg
{
   HWND          hParentWnd;        /* window which the msg is to be passed   */
   UINT          nCompletedMessage; /* msg to be sent at end of the function  */
};  /* struct S_Msg */


struct S_Verbose
{
   HWND          hVerboseWnd;  /* window which the message is to be passed    */
   UINT          nVerboseMsg;  /* msg to be sent each time a line is received */
};

/* global structure */
struct S_ProcData
{  
   /* task data */
   HTASK      hTask;              /* Task Id                              */
   HWND       hFtpWnd;            /* Handle of the internal window        */
   HWND       hParentWnd;         /* handle given to the FtpInit function */
   HINSTANCE  hInstance;          /* Task Instance                        */
   BOOL       bRelease;           /* FtpRelease has been called           */

   /* Mesasge information */
   struct S_Msg      Msg;      
   struct S_Verbose  VMsg;      
                                                               
   /* File information */
   struct S_FileTrf  File;  

   /* Ftp information */
   struct S_FtpData   ftp;

   /* Linked list */
   struct S_ProcData far *Next;
   struct S_ProcData far *Prev;
}; /* struct S_ProcData */

typedef struct S_ProcData far * LPProcData;
typedef struct S_FtpData far *  LPFtpData;



/* **************************************************************** */
/*                                                                  */
/*                    P R O T O T Y P E S                           */
/*                                                                  */
/* **************************************************************** */

/* Utilities functions */
LPProcData PASCAL FAR  FtpDataPtr (void);
LPSTR PASCAL FAR  FtpBufferPtr (void);
LPSTR PASCAL FAR  FtpErrorString (int Rc);
int PASCAL FAR WEP (int nType);
int PASCAL FAR Ftp4wVer (LPSTR szVerStr, int nStrSize);

/* change default parameters */
int  PASCAL FAR FtpSetVerboseMode (BOOL bVerboseMode, HWND hVerboseWnd, UINT wMsg);
long PASCAL FAR FtpBytesTransferred (void);
long PASCAL FAR FtpBytesToBeTransferred(void);
void PASCAL FAR FtpSetDefaultTimeOut (int nTo_in_sec);
void PASCAL FAR FtpSetDefaultPort(int nDefPort);
void PASCAL FAR FtpSetAsynchronousMode(void);
void PASCAL FAR FtpSetSynchronousMode(void);
BOOL PASCAL FAR FtpIsAsynchronousMode(void);   
void PASCAL FAR FtpSetNewDelay(int x); 
void PASCAL FAR FtpSetNewSlices(int x,int y) ;
void PASCAL FAR FtpSetPassiveMode (BOOL bPassive);
void PASCAL FAR FtpLogTo (HFILE hLogFile);
/* mispelled functions - only for backwards compatibilty */
long PASCAL FAR FtpBytesTransfered (void);
long PASCAL FAR FtpBytesToBeTransfered(void);

/* Init functions */
int PASCAL FAR FtpRelease (void);
int PASCAL FAR FtpInit (HWND hParentWnd);
int PASCAL FAR FtpFlush (void);

/* Connection */
int PASCAL FAR FtpLogin (LPSTR szHost, LPSTR szUser, LPSTR szPasswd,
                         HWND hParentWnd, UINT wMsg);
int PASCAL FAR FtpOpenConnection (LPSTR szHost);
int PASCAL FAR FtpCloseConnection (void);
int PASCAL FAR FtpLocalClose (void);

/* authentification */
int PASCAL FAR  FtpSendUserName (LPSTR szUserName);
int PASCAL FAR  FtpSendPasswd (LPSTR szPasswd);
int PASCAL FAR  FtpSendAccount (LPSTR szAccount);

/* commands */
int PASCAL FAR FtpHelp   (LPSTR szArg, LPSTR szBuf, UINT uBufSize);
int PASCAL FAR FtpDeleteFile (LPSTR szRemoteFile);
int PASCAL FAR FtpRenameFile (LPSTR szFrom, LPSTR szTo);
int PASCAL FAR FtpQuote  (LPSTR szCmd, LPSTR szReplyBuf, UINT uBufSize);
int PASCAL FAR FtpSyst   (LPSTR FAR *szSystemStr);
int PASCAL FAR FtpSetType(char cType);
int PASCAL FAR FtpCWD    (LPSTR szPath);
int PASCAL FAR FtpCDUP   (void);
int PASCAL FAR FtpPWD    (LPSTR szBuf, UINT uBufSize);
int PASCAL FAR FtpMKD    (LPSTR szPath, LPSTR szFullDir, UINT uBufSize);
int PASCAL FAR FtpRMD    (LPSTR szPath);

/* file transfer */
int PASCAL FAR FtpAbort (void);
int PASCAL FAR FtpSendFile (LPSTR szLocal, LPSTR szRemote, char cType, 
                            BOOL bNotify, HWND hParentWnd, UINT wMsg);
int PASCAL FAR FtpAppendToRemoteFile (LPSTR szLocal, LPSTR szRemote,char cType,
                            BOOL bNotify, HWND hParentWnd, UINT wMsg);
int PASCAL FAR FtpRecvFile (LPSTR szRemote, LPSTR szLocal, char cType, 
                            BOOL bNotify, HWND hParentWnd, UINT wMsg);
int PASCAL FAR FtpAppendToLocalFile (LPSTR szLocal, LPSTR szRemote,char cType,
                            BOOL bNotify, HWND hParentWnd, UINT wMsg);
DWORD PASCAL FAR FtpGetFileSize (void);
int PASCAL FAR FtpMGet (LPSTR szFilter, char cType, BOOL bNotify,
                 BOOL (CALLBACK *f) (LPSTR szRemFile, LPSTR szLocalFile, int Rc) );

int PASCAL FAR FtpRestart (long lByteCount);
int PASCAL FAR FtpRestartSendFile (HFILE hLocal, LPSTR szRemote, char cType, 
                            BOOL bNotify, long lByteCount,
                            HWND hParentWnd, UINT wMsg);
int PASCAL FAR FtpRestartRecvFile (LPSTR szRemote, HFILE hLocal, char cType, 
                            BOOL bNotify, long lByteCount,
                            HWND hParentWnd, UINT wMsg);


/* Directory */
int PASCAL FAR FtpDir (LPSTR szDef, LPSTR szLocalFile,
                       BOOL  bLongDir, HWND  hParentWnd, UINT wMsg);

/* Advanced function */
int PASCAL FAR FtpOpenDataConnection (LPSTR szRemote,int nAction,char cType);
int PASCAL FAR FtpRecvThroughDataConnection (LPSTR szBuf,
                                            unsigned int far *lpBufSize);
int PASCAL FAR FtpSendThroughDataConnection(LPSTR szBuf,unsigned int uBufSize);
int PASCAL FAR FtpCloseDataConnection (void);

/* Firewall function */
int PASCAL FAR FtpFirewallLogin(LPSTR szFWHost, LPSTR szFWUser, LPSTR szFWPass,
                                LPSTR szRemHost,LPSTR szRemUser,LPSTR szRemPass,
                                int nFirewallType,
                                HWND hParentWnd, UINT wMsg);
int PASCAL FAR IntFtpGetAnswerCode ();


/* _______________________________________________________________ */

#ifdef __cplusplus     
}  /* End of extern "C" */   
#endif /* ifdef __cplusplus */  

#define _FTP4W_API_ loaded
#endif /* ifndef FTP4W_API */

