
/* **************************************************************
 *
 *
 *      C W   :    P r o c e d u r e s
 * 
 *
 * **************************************************************** */



#include <windows.h>
#include <windowsx.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


extern HINSTANCE       hInst;             
extern HWND            hwnd;


/* **************************************************************
 *    G a u g e
 *             B y     Santanu Lahiri (winFTP)
 * **************************************************************/


static LONG lTotalBytes=0;
static DWORD lFileSize=0;
static LONG lXferBytes=0;
static int  nPercentXfer;
static HWND hWndXfer=NULL;
static LPSTR szXferWnd = "XferWindow";


HPEN hPenDark;
HPEN hPenLight;
HBRUSH  hbrGray1;
int  nWndx=10;                // the x axis multiplier
int  nWndy=15;                // the y axis multiplier



LRESULT CALLBACK WndXferProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);


int nCwUnregisterClasses(void)
{
  UnregisterClass (szXferWnd, hInst);
return 0;
}


int nCwRegisterClasses(void)
{
WNDCLASS   wc;    // struct to define a window class

  hbrGray1 = CreateSolidBrush (RGB (192,192,192));
  memset(&wc, 0x00, sizeof(wc));
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInst;
  wc.hCursor = LoadCursor ((HINSTANCE) NULL, IDC_ARROW);
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = WndXferProc;
  wc.hIcon         = LoadIcon (hInst, IDI_APPLICATION);
  wc.hbrBackground = hbrGray1;
  wc.lpszMenuName  = NULL;      /* Menu Name is App Name */
  wc.lpszClassName = szXferWnd; /* Class Name is App Name */
  if (RegisterClass (&wc)==0) return -1;
return 0;
}


void CreateButtonPens()
{
  hPenDark  = CreatePen (PS_SOLID, 1, RGB (128,128,128));
  hPenLight = CreatePen (PS_SOLID, 1, RGB (224,224,224));
}

void DeleteButtonPens()
{
  DeleteObject (hPenDark);
  DeleteObject (hPenLight);
}


void BoxIt (HDC hDC, int left, int top, int width, int height, BOOL flag)
{
  POINT Pt;
  HPEN hPenOld;
  
  hPenOld = SelectObject (hDC, flag? hPenDark : hPenLight);
  MoveToEx (hDC, (left*nWndx)/4, ((top+height)*nWndy)/8, &Pt);
  LineTo (hDC, (left*nWndx)/4, (top*nWndy)/8);
  LineTo (hDC, ((left+width)*nWndx)/4, (top*nWndy)/8);
  if (flag) SelectObject (hDC,hPenLight); 
  else SelectObject (hDC,hPenDark);
  LineTo (hDC, ((left+width)*nWndx)/4, ((top+height)*nWndy)/8);
  LineTo (hDC, (left*nWndx)/4, ((top+height)*nWndy)/8);
  SelectObject (hDC, hPenOld);
}


void PaintXfer (HDC hDC)
{
  RECT rc;
  char szBuf[10];

  CreateButtonPens();
  SelectObject (hDC, GetStockObject (WHITE_BRUSH));
  Rectangle (hDC, (nWndx*20)/4, (nWndy*10)/8, (nWndx*122)/4, (nWndy*20)/8);
  rc.left = (nWndx*21)/4;  rc.right = (nWndx*(nPercentXfer+21))/4;
  rc.top  = (nWndy*11)/8;  rc.bottom= (nWndy*19)/8;
  FillRect (hDC, &rc, GetStockObject (GRAY_BRUSH));
  rc.right = (nWndx*121)/4;
  SetBkMode (hDC, TRANSPARENT);
  wsprintf (szBuf, "%d%%", nPercentXfer);
  DrawText (hDC, szBuf, lstrlen (szBuf), &rc, DT_CENTER | DT_VCENTER);
  SetBkMode (hDC, OPAQUE);
  BoxIt (hDC, 18, 8, 106, 14, FALSE);
  DeleteButtonPens();
}



void OnPaintXfer (HWND hWnd)
{
  HDC hDC;
  PAINTSTRUCT ps;
  
  hDC = BeginPaint (hWnd, &ps);
  PaintXfer (hDC);
  EndPaint (hWnd, &ps);
}

void SetXmitBytes (LONG lBytes, LONG lTotal)
{
  int nOld;
  
  lXferBytes = lBytes;
  if (lTotalBytes==0)  lTotalBytes = lTotal;
  if ((lTotalBytes==0)||(hWndXfer==NULL)) return;
  nOld = nPercentXfer;
  nPercentXfer = (int) ((lBytes*100)/lTotalBytes);
  if (nOld!=nPercentXfer) 
  {
    HDC hDC;
  
    hDC = GetDC (hWndXfer);
    PaintXfer (hDC);
    ReleaseDC (hWndXfer, hDC);
  }
}



LRESULT CALLBACK WndXferProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  switch (Msg)
  {
    case WM_GETMINMAXINFO: 
    {
      MINMAXINFO FAR *lpmmi=(MINMAXINFO FAR *) lParam;
      lpmmi->ptMaxSize.x = (nWndx*140)/4;
      lpmmi->ptMaxSize.y = (nWndy*45)/8;
      lpmmi->ptMaxTrackSize.x = (nWndx*140)/4;
      lpmmi->ptMaxTrackSize.y = (nWndy*45)/8;
      lpmmi->ptMinTrackSize.x = (nWndx*140)/4;
      lpmmi->ptMinTrackSize.y = (nWndy*45)/8;
    } break;
    case WM_PAINT: OnPaintXfer (hWnd); return 0L;
  }
  return (LRESULT) DefWindowProc (hWnd, Msg, wParam, lParam);
}


void CreateXferWindow()
{
  if (hWndXfer!=NULL) return;
  hWndXfer = CreateWindowEx ( WS_EX_TOPMOST, 
       szXferWnd, "",  WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_CAPTION,
       CW_USEDEFAULT, CW_USEDEFAULT, (nWndx*140)/4, (nWndy*40)/8, (HWND) NULL, 
       (HMENU) NULL, hInst,  NULL);
  if (hWndXfer==NULL) MessageBeep (65535u);
  lTotalBytes = 0L;
  lXferBytes  = 0L;
  nPercentXfer = 0L;
}


void DeleteXferWindow()
{
  if (hWndXfer==NULL) return;
  DestroyWindow (hWndXfer);
  lTotalBytes  = lXferBytes = 0l;
  nPercentXfer = 0;
  hWndXfer = NULL;
}

void SetXferWindowText (LPSTR lpStr)
{
  SetWindowText (hWndXfer, lpStr);
}

void SetXferTotalBytes (LONG Total)
{
  lTotalBytes = Total;
}


/* **************************************************************
 *    S c r o l l e r 
 * **************************************************************/

extern int  nHorzSiz, nVertSiz;
extern int  nVertPos, nHorzPos;           // scroll pos for debug window
extern int  nHorzMax, nCurMsg;
extern int  nMaxMsg;
extern int  nHorzTab;


// static HWND hWndViewMsg = (HWND) NULL;
static LPSTR * lpMsg;
static LPSTR szNoMem   = "Unable to allocate memory!";
static LPSTR szZoomErr = "Unable to allocate memory!";
static BOOL bZoomFlag=FALSE;
static BOOL bNewMessage=FALSE;



void DoAddLine (LPSTR lpBuf)
{
LPSTR lp;

  // added in some error checking to try to eliminate GPFs
  if (lpBuf==NULL || lpBuf[0]==0)   return;
  if (lpMsg==NULL)
    {
      lpMsg = (LPSTR *) GlobalAllocPtr (GHND, nMaxMsg * sizeof (LPSTR));
      nCurMsg = 0;
      if (lpMsg==NULL) 
        {
          MessageBox (hwnd, szNoMem, szZoomErr, MB_OK);
          return;
        }
    }
  if (nCurMsg>=nMaxMsg)
    {
      GlobalFreePtr (lpMsg[0]);
      memmove (lpMsg, lpMsg+1, (nMaxMsg-1)*sizeof (LPSTR));
      nCurMsg = nMaxMsg-1;
    }
  lp = lpMsg[nCurMsg] = (LPSTR) GlobalAllocPtr (GHND, lstrlen (lpBuf) + 5);
  if (lp!=NULL) 
    {
      HDC hDC;
      SIZE siz;
      
      lstrcpy (lp, lpBuf);
      hDC = GetDC (hwnd);
      GetTextExtentPoint (hDC, lp, lstrlen (lp), &siz);
      ReleaseDC (hwnd, hDC);
      nHorzMax = nHorzMax > siz.cx ? nHorzMax : siz.cx ;
      SetScrollRange (hwnd, SB_HORZ, 0, nHorzMax, TRUE);
      SetScrollRange (hwnd, SB_VERT, 0, nCurMsg, TRUE);
      InvalidateRect (hwnd, NULL, TRUE);
      nCurMsg++;
      bNewMessage = TRUE;
    }  /* lp not NULL */
    else 
    {
      MessageBox (hwnd, szNoMem, szZoomErr, MB_OK);
      return;
    } /* no more memory */
} /* DoAddLine */


//*************************************************************************
//*************************************************************************
void ReleaseDisplayMem()
{
int nI;
  if (lpMsg!=NULL) 
  {
    for (nI=0; nI<nMaxMsg; nI++) 
    {
      if (lpMsg[nI]!=NULL) GlobalFreePtr (lpMsg[nI]);
      lpMsg[nI] = NULL;
    }
  }
  nCurMsg = nVertPos = nHorzPos = nHorzMax = 0;
  SetScrollPos (hwnd, SB_HORZ, 0, TRUE);
  SetScrollPos (hwnd, SB_VERT, 0, TRUE);
  SetScrollRange (hwnd, SB_HORZ, 0, 1, TRUE);
  SetScrollRange (hwnd, SB_VERT, 0, 1, TRUE);
} /* ReleaseDisplayMemory */


//*************************************************************************
void DoPaint(HWND hWnd)
{
HDC         hDC;
PAINTSTRUCT ps;
int         nI, nRows, nLine, nPos, nHt;
RECT        rRect;
TEXTMETRIC  tm;

  memset (& ps, 0, sizeof ps);  
  hDC = BeginPaint (hWnd, &ps);
  SelectObject (hDC, GetStockObject (ANSI_VAR_FONT));
  // Included as the background is not a pure color
  SetBkMode(hDC, TRANSPARENT);
  GetTextMetrics (hDC,&tm);
  nHt = tm.tmHeight + tm.tmExternalLeading;
  GetClientRect (hWnd, &rRect);
  nHorzSiz = rRect.right;
  nVertSiz = nRows = rRect.bottom/nHt;

  if (    nCurMsg>nRows+nVertPos  && bNewMessage)
           nVertPos = nLine = nCurMsg-nRows;
  else     nLine=nVertPos;

  if (lpMsg!=NULL)
  {
    for (nI=nPos=0; (nI<nRows) && (nLine<nCurMsg); nI++, nLine++, nPos+=nHt) 
    {
      if (lpMsg[nLine]!=NULL) 
      {
        TextOut (hDC, 20-nHorzPos, nPos, lpMsg[nLine], lstrlen (lpMsg[nLine]));
      }
    }
  }
  EndPaint(hWnd, &ps);
  bNewMessage=FALSE;
} /* DoPaint */



int Ecris(const char *szFormat,...)
{
va_list     vaArgs;
static char szBuf[512];
char       *p, *q;

   va_start(vaArgs,szFormat);
   if (vsprintf (szBuf,szFormat,vaArgs)!=EOF) 
     {
        for (q=p=szBuf ;  *p!=0 ; p++)
         {
           if (*p=='\r')   if (*(p+1)=='\n')  *p=0;
           if (*p=='\n')   
                {
                 *p=0;
                  DoAddLine (q);
                  q=p+1;
                }
         }
        DoAddLine (q);
     }
   va_end(vaArgs);
return 0;
} /* Ecris */




