//
//	                                                            
//	Source File:	CLASSYWS.cpp
//	Purpose:	Application used to test the CWINSOCK class definitions                                   
//	Date:		9 November 1993
//	Version:	Alpha                 
//	Developer:	Michael J. Baldwin, GENISYS Comm, Inc.                                                            
//		
//	The enclosed C++ definitions and software is copyrighted by GENISYS Comm, and is
//	hereby released into the public domain.  It may be freely used by others if 
//	the following notice is included in each source code and header file:
//
//	"Copywrite 1993, GENISYS Comm, Inc."
//
//	Please provide suggesting, improvements, etc. to the author (baldwin@GENISYS.com)
//	and we will modify this definition as warranted.
//
//

#define STRICT
#pragma warning (disable:4706 4355)  
#include <afx.h>
#include <afxwin.h>
#include <windows.h>
#include "cwinsock.hpp"
#include "classyws.hpp"

/****************************************************
 * Application globals defined here
 ****************************************************/
 
CWinsockApp WinsockApp;	// application instance

#define EDIT_ID 1

CWinsockApp::CWinsockApp()
	{
	}
	
BOOL CWinsockApp::InitInstance()
	{
	m_pMainWnd=new CWinsockWnd();
	if (m_pMainWnd)
		{
		m_pMainWnd->ShowWindow(m_nCmdShow);
		m_pMainWnd->UpdateWindow();
		return TRUE;
		}
	
	// window initialization failed
	return FALSE;
	}

CWinsockApp::~CWinsockApp()
	{
	}

// define message map for CWinsockWnd
BEGIN_MESSAGE_MAP(CWinsockWnd,CFrameWnd)
	ON_WM_SIZE()
END_MESSAGE_MAP()

// Define CWinsockWnd
CWinsockWnd::CWinsockWnd() : Winsock(NetEventHandler, this)  
	{
	// create main fram window
	Create (NULL, "WINSOCK With Class");  
			
	RECT rect={0,0,0,0};
		
	// create the display window too
	EditWnd.Create (WS_CHILD|WS_VISIBLE|ES_MULTILINE|
		ES_NOHIDESEL|WS_VSCROLL|WS_HSCROLL|ES_AUTOVSCROLL,
		rect, this, EDIT_ID);
		
	// set font to non-proportional
	//CFont * pFont=CFont::FromHandle((HFONT)GetStockObject(SYSTEM_FIXED_FONT));
	//EditWnd.GetDC()->SelectObject(pFont);
	
	EditWnd.SetReadOnly();
	
	// print out winsock stack information
	char Msg[120];
	Print("");
	Print("      CWinsock Classy Demonstration, version Alpha");
	Print("");
	if (Winsock.Data.szDescription)
   	{
   	Winsock.Data.szDescription[WSADESCRIPTION_LEN]=NULL;
		_snprintf(Msg,sizeof(Msg),"  WINSOCK interface: %s",Winsock.Data.szDescription);
		// send back description
		Print(Msg);
      }
	if (Winsock.Data.szSystemStatus)
   	{
   	Winsock.Data.szSystemStatus[WSASYS_STATUS_LEN]=NULL;
		_snprintf(Msg,sizeof(Msg),"  System Status: %s",Winsock.Data.szSystemStatus);
		// send back description
		Print(Msg);
		}
	_snprintf(Msg,sizeof(Msg),"  Windows Sockets Version %d.%d",
		LOBYTE(Winsock.Data.wVersion),HIBYTE(Winsock.Data.wVersion));
	Print(Msg);
	_snprintf(Msg,sizeof(Msg),"  Max UDP datagram size allowed by vendor is %d bytes.",Winsock.Data.iMaxUdpDg);
	if (Winsock.Data.iMaxUdpDg)
		Print(Msg);
	_snprintf(Msg,sizeof(Msg),"  Max number of open sockets allowed by vendor is %d.",Winsock.Data.iMaxSockets);
	if (Winsock.Data.iMaxSockets)
		Print(Msg);
	Print("");
	Print(" GENISYS Comm releases this demo into the public domain");
	Print("       Read the enclosed CWINSOCK.WRI for more information");
	Print("                    Author: Michael Baldwin");
	}

// Define CWinsockWnd destructor
CWinsockWnd::~CWinsockWnd()
	{
	}
	
// callback function from CWinsock object	
void CALLBACK CWinsockWnd::NetEventHandler (WPARAM wParam, LPARAM lParam)
	{
	}
	
// message handlers for CWinsockWnd start here
void CWinsockWnd::Print (LPSTR str)
	{
	int Lines=EditWnd.GetLineCount();
	if (Lines>400)
   	EditWnd.SetWindowText ("");
	EditWnd.SetSel (32000, 32000);
	EditWnd.ReplaceSel (str);
	EditWnd.ReplaceSel ((LPSTR)"\r\n");
	}

void CWinsockWnd::OnSize(UINT ntype, int cx, int cy)
	{
	if (ntype==SIZE_RESTORED || ntype==SIZE_MAXIMIZED)
		EditWnd.MoveWindow(0,0,cx,cy,TRUE);
	}
 