/*
 *  Shangjie - here is some code from the Gopher Server which should be helpful.
 */

#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

int ReadGopherConfigInfo(void);

#define MAXEXTENSIONLENGTH           10
#define MAXNOEXTENSIONS              128
#define GOPHERDEFAULTFILETYPEKEY    "DefaultFileType"
#define GOPHERSERVERKEY             "GOPHERS\\Parameters"
#define EXTENSIONMAPKEY             "ExtensionMapping" /* Subkey for extension mappings */
#define DEFAULTDEFAULTFILETYPE      '0'
#define DEFAULTGOPHERTYPES    {                 \
    {'0',"TXT"},    /* Text file */             \
    {'5',"ZIP"},    /* Binary archive */        \
    {'5',"ARC"},    /* Binary archive */        \
    {'6',"UUE"},    /* UUencoded */             \
    {'7',"SRC"},    /* WAIS index */            \
    {'9',"EXE"},    /* Binary */                \
    {'9',"DLL"},    /* Binary */                \
    {'g',"GIF"},    /* GIF image */             \
    {'I',"BMP"},    /* Windows bitmap */        \
    {'s',"AU"},     /* Sound */                 \
    {'h',"HTM"},    /* HTML */                  \
    {'h',"HTML"},   /* HTML */                  \
    {'\0',""}       /* Marks end of table */    \
}

/* Gopher type table entry */
typedef struct _FileTypeMap {
    char    GopherType;
    char    FileExtension[MAXEXTENSIONLENGTH];
} tFileTypeMap;


char DefaultFileType = DEFAULTDEFAULTFILETYPE; /* For unrecognised file extensions */
tFileTypeMap FileTypeTable[MAXNOEXTENSIONS] = DEFAULTGOPHERTYPES;


/*
 *  Return a pointer to the extension in the supplied file name.
 */
static char *GetFileNameExtension(FileName) 
char *FileName;
{
    int i;

    i = strlen(FileName)-1;
    while (i>0) {
        if (FileName[i]=='.') break;
        if (FileName[i]=='\\') break;
        i--;
    }
    if (i==0 || FileName[i]=='\\') {
        /* No dot in the name, so point at the '\0' at the end of the name. */
        return &(FileName[strlen(FileName)]);
    } else {
        /* Found file extension */
        return &(FileName[i+1]);
    }
}


/*
 *  Given the name of a file, look up the extension in the FileTypeTable
 *  and return the corresponding Gopher file type character.
 */
char FileTypeFromTable(FileName) 
LPSTR FileName;
{
    LPSTR pExt;
    int i;

    /* Get filename extension */
    pExt = GetFileNameExtension(FileName);
    
    /* Set up the table */
    ReadGopherConfigInfo();
        
    /* Look through the table for the type to use */
    i = 0;
    while (FileTypeTable[i].GopherType!='\0') {
        if (stricmp(pExt,FileTypeTable[i].FileExtension)==0)
            return FileTypeTable[i].GopherType;
        i++;
    }

    /* Not found in table, so use the default */
    return DefaultFileType;
}


/*
 *  This function reads the file type configuration information from the Registry
 */
int ReadGopherConfigInfo(void) 
{
    LONG lResult;
    int index;
    DWORD dwSize;
    DWORD dwSizeExt;
    HKEY hkGopherServer;
    HKEY hkExtensionMapping;
    char KeyName[100];

     
    /* Open the HKEY_LOCAL_MACHINE \System\CurrentControlSet\Services\GOPHERS\Parameters key */
    strncpy(KeyName,"SYSTEM\\CurrentControlSet\\Services\\",sizeof(KeyName));
    strncat(KeyName,GOPHERSERVERKEY,sizeof(KeyName));
    lResult = RegOpenKeyEx(
                HKEY_LOCAL_MACHINE,
                KeyName,
                0,
                KEY_READ,
                &hkGopherServer);
    if (lResult!=0) {
        /* No key - we'll use the defaults */
        return 0;
    }

    /* Get DefaultFileType */
    dwSize = sizeof(DefaultFileType);
    lResult = RegQueryValueEx(
                hkGopherServer,
                GOPHERDEFAULTFILETYPEKEY,
                NULL,
                NULL,
                &DefaultFileType,
                &dwSize);
    if (lResult!=0 || DefaultFileType=='\0') {
        /* Not found, so ensure we're using the default value */
        DefaultFileType = DEFAULTDEFAULTFILETYPE;
    }

    /* Now the rest of the table */
    lResult = RegOpenKeyEx(hkGopherServer,EXTENSIONMAPKEY,0,KEY_READ,&hkExtensionMapping);
    if (lResult==0) {
        /* Opened the key successfully - load the table. */
        index = 0;
        while (index<MAXNOEXTENSIONS-1) {
            dwSizeExt = MAXEXTENSIONLENGTH;
            dwSize = 1;
            lResult = RegEnumValue(
                            hkExtensionMapping,
                            index,
                            FileTypeTable[index].FileExtension,
                            &dwSizeExt,
                            NULL,
                            NULL,
                            &(FileTypeTable[index].GopherType),
                            &dwSize);
            if (lResult!=0) break;
            index++;
        }
        /* Tie off the table */
        FileTypeTable[index].GopherType = '\0';
        FileTypeTable[index].FileExtension[0] = '\0';
        /* Close the key */
        RegCloseKey(hkExtensionMapping);
    }

    /* Close the registry */
    RegCloseKey(hkGopherServer);

    return 0;
}

