/* WIDE AREA INFORMATION SERVER SOFTWARE        
   No guarantees or restrictions.  See the readme file for the full standard 
   disclaimer.  
   4.14.90      Harry Morris, morris@think.com
*/

/* Copyright (c) CNIDR (see ../COPYRIGHT) */


#ifndef lint
static char *RCSid = "$Header: /usr/users/freewais/FreeWAIS-0.1/ir/ustubs.c,v 1.1 1993/02/16 15:05:35 freewais Exp $";
#endif

/* Change log:
 * $Log: ustubs.c,v $
 * Revision 1.1  1993/02/16  15:05:35  freewais
 * Initial revision
 *
 * Revision 1.4  92/05/06  17:35:13  jonathan
 * Modified some #if's for NeXT and Mach.
 * 
 * Revision 1.3  92/03/06  11:08:49  jonathan
 * fixed incompatible return type error in HP version of getwd.  Thanks to
 * cshotton@oac.hsc.uth.tmc.edu.
 * 
 * Revision 1.2  92/02/12  13:54:29  jonathan
 * Added "$Log" so RCS will put the log message in the header
 * 
 * 
*/

/*----------------------------------------------------------------------*/
/* stubs for silly non-ansi c compilers                                 */
/*----------------------------------------------------------------------*/

#include "ustubs.h"
#include "cutil.h" /* for substrcmp and NULL */


#ifdef WIN32
#include <string.h>

char *bcopy(src, dest, len)
char *dest, *src;
int len;
{
  return((char*)memmove(dest, src, len));
}
#endif

/*----------------------------------------------------------------------*/
/* believe it or not, HP does not have bzero or bcopy                   */

#ifdef hpux

void bzero(ptr, len)
char *ptr;
int len;
{
  long count;
  for (count = 0; count < len; count++){
    *(char*)(ptr + count) = 0;
    }
}

char *bcopy(src, dest, len)
char *dest, *src;
int len;
{
  return((char*)memmove(dest, src, len));
}

char *getwd(pathname)
char *pathname;
{
  return((char*)getcwd(pathname, MAX_FILENAME_LEN));
}

#endif 

#ifdef SYSV
#include <prototypes.h> /* may be XENIX dependent! */
char *
getwd(pathname)
char *pathname;
{
  return(getcwd(pathname, MAX_FILENAME_LEN));
}
#endif /* def SYSV */

/*----------------------------------------------------------------------*/

#ifndef ANSI_LIKE   /* memmove is an ANSI function not defined by K&R */
#ifndef hpux /* but HP defines it */
void*
memmove(str1,str2,n)
void* str1;
void* str2;
size_t n;
{
#ifdef M_XENIX
  memcpy((char*)str2,(char*)str1,(long)n); /* hope it works! */
#else /* ndef M_XENIX */
  bcopy((char*)str2,(char*)str1,(long)n);
#endif /* ndef M_XENIX */
  return(str1);
}
#endif /* ndef hpux */

#else /* ansi is defined */

#ifdef __GNUC__ /* we are ansi like, are we gcc */

#if !(defined(NeXT) || defined(Mach)) /* and we are not on a next ! */

void*
memmove(str1,str2,n)
void* str1;
void* str2;
size_t n;
{
  bcopy((char*)str2,(char*)str1,(long)n);
  return(str1);
}

#endif /* not NeXT or Mach */

#endif /* __GNUC__ */

#endif /* else ndef ANSI_LIKE */

/*----------------------------------------------------------------------*/

#ifndef ANSI_LIKE  

/* atoi is not defined k&r. copied from the book */
long atol(s)
char *s;
{
  long i, n, sign;
  for(i=0; s[i]==' ' || s[i]== 'n' || s[i]=='t'; i++)
    ;                           /* skip white space */
  sign = 1;
  if (s[i] == '+' || s[i] == '-')
    sign = (s[i++]=='+') ? 1 : -1;
  for (n=0; s[i] >= '0' && s[i] <= '9'; i++)
    n= 10 * n + s[i] - '0';
  return(sign * n);
}

/*----------------------------------------------------------------------*/

char *strstr(src,sub)
char *src;
char *sub;
{
  /* this is a poor implementation until the ANSI version catches on */
  char *ptr;
  for(ptr = src; (long)ptr <= (long)src + strlen(src) - strlen(sub); ptr++){
    if(substrcmp(ptr, sub))
      return(ptr);
  }
  return(NULL);
}

/*----------------------------------------------------------------------*/

int remove(filename)
char *filename;
{
  return(unlink(filename));
}

/*----------------------------------------------------------------------*/

#endif /* ndef ANSI_LIKE */


