///////////////////////////////////////////////////////////////////////////////
//
// Module:		tnnet.cpp
//
// Contents:	telnet network processing
//
// Product:		telnet
//
// Revisions:	02.Apr.1995	igor.milavec@uni-lj.si
//					Original code
//
///////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include "ansiprsr.h"
#include "tnnet.h"

class TTelnetParser: public TANSIParser {
	HANDLE hConsole;
	SOCKET Socket;
protected:

	virtual int ConWriteString(char* pszString, int cbString);
	virtual void ConClearScreen();
	virtual void ConClearEOScreen();
	virtual void ConClearBOScreen();
	virtual void ConClearLine();
	virtual void ConClearEOLine();
	virtual void ConClearBOLine();
	virtual void ConSetCursorPosition(int x, int y);
	virtual void ConMoveCursorPosition(int x, int y);
	virtual void ConSetExtendedMode(int iFunction, BOOL bEnable);
	virtual int NetWriteString(char* pszString, int cbString);

	int ConGetCursorX();
	int ConGetCursorY();
public:
	TTelnetParser(HANDLE hConsole, SOCKET Socket);
};

TTelnetParser::TTelnetParser(HANDLE hConsole, SOCKET Socket):
	hConsole(hConsole), Socket(Socket)
{
}

int TTelnetParser::ConWriteString(char* pszString, int cbString)
{
	DWORD Result;
	WriteConsole(hConsole, pszString, cbString, &Result, 0);
	return Result;
}

void TTelnetParser::ConClearScreen()
{
	DWORD dwWritten;
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return;

	COORD Coord = {ConsoleInfo.srWindow.Left, ConsoleInfo.srWindow.Top};
	FillConsoleOutputCharacter(hConsole, ' ',
		(DWORD)(ConsoleInfo.srWindow.Right - ConsoleInfo.srWindow.Left)*
		(DWORD)(ConsoleInfo.srWindow.Bottom - ConsoleInfo.srWindow.Top),
		Coord, &dwWritten);
}

void TTelnetParser::ConClearEOScreen()
{
	DWORD dwWritten;
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return;

	COORD Coord = {ConsoleInfo.srWindow.Left,
		ConsoleInfo.srWindow.Top + (short)(ConGetCursorY() + 1)};
	FillConsoleOutputCharacter(hConsole, ' ',
		(DWORD)(ConsoleInfo.srWindow.Right - ConsoleInfo.srWindow.Left)*
		(DWORD)(ConsoleInfo.srWindow.Bottom - ConsoleInfo.srWindow.Top - ConGetCursorY()),
		Coord, &dwWritten);

	ConClearEOLine();
}

void TTelnetParser::ConClearBOScreen()
{
	DWORD dwWritten;
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return;

	COORD Coord = {ConsoleInfo.srWindow.Left, ConsoleInfo.srWindow.Top};
	FillConsoleOutputCharacter(hConsole, ' ',
		(DWORD)(ConsoleInfo.srWindow.Right - ConsoleInfo.srWindow.Left)*
		(DWORD)(ConsoleInfo.srWindow.Bottom - ConsoleInfo.srWindow.Top - ConGetCursorY() - 1),
		Coord, &dwWritten);

	ConClearBOLine();
}

void TTelnetParser::ConClearLine()
{
	DWORD dwWritten;
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return;

	COORD Coord = {
		ConsoleInfo.srWindow.Left,
		(short)(ConsoleInfo.srWindow.Top + ConGetCursorY())};
	FillConsoleOutputCharacter(hConsole, ' ',
		(DWORD)(ConsoleInfo.srWindow.Right - ConsoleInfo.srWindow.Left),
		Coord, &dwWritten);
}

void TTelnetParser::ConClearEOLine()
{
	DWORD dwWritten;
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return;

	COORD Coord = {
		(short)(ConsoleInfo.srWindow.Left + ConGetCursorX()),
		(short)(ConsoleInfo.srWindow.Top + ConGetCursorY())};
	FillConsoleOutputCharacter(hConsole, ' ',
		(DWORD)(ConsoleInfo.srWindow.Right - ConGetCursorX()),
		Coord, &dwWritten);
}

void TTelnetParser::ConClearBOLine()
{
	DWORD dwWritten;
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return;

	COORD Coord = {
		ConsoleInfo.srWindow.Left,
		(short)(ConsoleInfo.srWindow.Top + ConGetCursorY())};
	FillConsoleOutputCharacter(hConsole, ' ',
		(DWORD)(ConGetCursorX()),
		Coord, &dwWritten);
}

void TTelnetParser::ConSetCursorPosition(int x, int y)
{
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return;

	COORD Coord = {
		(short)(ConsoleInfo.srWindow.Left + x),
		(short)(ConsoleInfo.srWindow.Top + y)};

	SetConsoleCursorPosition(hConsole, Coord);
}

int TTelnetParser::ConGetCursorX()
{
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return 0;

	return ConsoleInfo.dwCursorPosition.X - ConsoleInfo.srWindow.Left;
}

int TTelnetParser::ConGetCursorY()
{
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return 0;

	return ConsoleInfo.dwCursorPosition.Y - ConsoleInfo.srWindow.Top;
}

void TTelnetParser::ConMoveCursorPosition(int x, int y)
{
	CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
	if (!GetConsoleScreenBufferInfo(hConsole, &ConsoleInfo))
		return;

	COORD Coord = {
		(short)(ConsoleInfo.dwCursorPosition.X + x),
		(short)(ConsoleInfo.dwCursorPosition.Y + y)};

	SetConsoleCursorPosition(hConsole, Coord);
}

void TTelnetParser::ConSetExtendedMode(int iFunction, BOOL bEnable)
{
	// Probably should do something here...
}

int TTelnetParser::NetWriteString(char* pszString, int cbString)
{
	send(Socket, pszString, cbString, 0);
	return cbString;
}


DWORD telProcessNetwork(LPVOID pvParams)
{
	TelThreadParams* pParams = (TelThreadParams*)pvParams;
	SOCKET Socket = pParams->Socket;
	TTelnetParser Parser(GetStdHandle(STD_OUTPUT_HANDLE), Socket);

	const DWORD dwBuffer = 1024;
	char szBuffer[dwBuffer];
	char* pszHead = szBuffer;
	char* pszTail = szBuffer;

	while (1) {

		int Result = recv(Socket, pszTail, (szBuffer + dwBuffer) - pszTail, 0);
		if ((Result <= 0) || ( Result > dwBuffer))
			break;

		pszTail += Result;

		char* pszNewHead = pszHead;
		do {
			pszHead = pszNewHead;
			pszNewHead = Parser.ParseBuffer(pszHead, pszTail);
		} while ((pszNewHead != pszHead) && (pszNewHead < pszTail));
		pszHead = pszNewHead;

		// When we reach the end of the buffer, move contents to the
		// beginning of the buffer to get free space at the end.
		if (pszTail == (szBuffer + dwBuffer)) {
			MoveMemory(szBuffer, pszHead, pszTail - pszHead);
			pszTail = szBuffer + (pszTail - pszHead);
			pszHead = szBuffer;
		}
	}

	printf("\nConnection terminated by remote.\n");
	SetEvent(pParams->hExit);
	return 0;
}

