///////////////////////////////////////////////////////////////////////////////
//
// Module:		telnet.cpp
//
// Contents:	error reporting
//
// Product:		telnet
//
// Revisions:	02.Apr.1995	igor.milavec@uni-lj.si
//					Original code
//
///////////////////////////////////////////////////////////////////////////////

#include "tnerror.h"
#include <time.h>
#include <stdio.h>
#include <stdarg.h>


int printm(LPTSTR szModule, BOOL fSystem, DWORD dwMessageId, ...)
{
	int Result = 0;

	HMODULE hModule = 0;
	if (szModule)
		hModule = LoadLibrary(szModule);

	va_list Ellipsis;
	va_start(Ellipsis, dwMessageId);

	LPTSTR pszMessage = 0;
	DWORD dwMessage = FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
		(fSystem? FORMAT_MESSAGE_FROM_SYSTEM: FORMAT_MESSAGE_FROM_HMODULE),
		hModule, dwMessageId, LANG_USER_DEFAULT,
		(LPTSTR)&pszMessage, 128, &Ellipsis);

	va_end(Ellipsis);

	if (szModule)
		FreeLibrary(hModule);

	if (dwMessage) {

		Result = printf(pszMessage);
		LocalFree(pszMessage);
	}

	return Result;
}


void LogErrorConsole(LPTSTR szError)
{
	DWORD dwLastError = GetLastError();

	const int cbLastError = 1024;
	TCHAR szLastError[cbLastError];
	FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, 0, dwLastError, LANG_USER_DEFAULT,
		szLastError, cbLastError, 0);

	LPTSTR lpszStrings[2];
	lpszStrings[0] = szError;
	lpszStrings[1] = szLastError;

	const int cbErrorString = 1024;
	TCHAR szErrorString[cbErrorString];
	FormatMessage(FORMAT_MESSAGE_FROM_HMODULE| FORMAT_MESSAGE_ARGUMENT_ARRAY,
		0, MSG_ERROR, LANG_USER_DEFAULT,
		szErrorString, cbErrorString, (LPTSTR*)lpszStrings);

	time_t dwTime;
	time(&dwTime);
	char* szTime = ctime(&dwTime);
	szTime[19] = 0;

	printf("E %s %s", szTime + 11, szErrorString);
}
