///////////////////////////////////////////////////////////////////////////////
//
// Module:		tncon.cpp
//
// Contents:	telnet console processing
//
// Product:		telnet
//
// Revisions:	02.Apr.1995	igor.milavec@uni-lj.si
//					Original code
//				01.Jul.1996	igor.milavec@l-sol.si
//					Added support for redirected input
//
///////////////////////////////////////////////////////////////////////////////

#include "tncon.h"

#include <stdio.h>

void telProcessConsole(TelThreadParams* pParams)
{
	BOOL fIsRedirected = TRUE;
	HANDLE hConsole = GetStdHandle(STD_INPUT_HANDLE);

	// Check if the input is redirected
	// !!! Ugly patch: the documentation does not guarantee this value...
	fIsRedirected = hConsole != (HANDLE)3;

	if (!fIsRedirected) {
		// Direct console input - use ReadConsoleInput()
		SetConsoleMode(hConsole, 0);

		const DWORD nHandle = 2;
		HANDLE hHandle[nHandle] = {hConsole, pParams->hExit};

		for (;;) {
			DWORD dwInput;
			switch (WaitForMultipleObjects(nHandle, hHandle, FALSE, INFINITE)) {
			  case WAIT_OBJECT_0: {

				INPUT_RECORD InputRecord;
				ReadConsoleInput(hConsole, &InputRecord, 1, &dwInput);
				switch (InputRecord.EventType) {
				  case KEY_EVENT:
					if (InputRecord.Event.KeyEvent.bKeyDown) {
						if (InputRecord.Event.KeyEvent.uChar.AsciiChar)
							send(pParams->Socket, &InputRecord.Event.KeyEvent.uChar.AsciiChar, 1, 0);
					}
					break;
				}
				break;
			  }

			  default:
				return;
			}
		}
	}
	else {
		// Redirected input - use ReadFile()
		const DWORD nHandle = 2;
		HANDLE hHandle[nHandle] = {pParams->hExit, hConsole};

		for (;;) {
			switch (WaitForMultipleObjects(nHandle, hHandle, FALSE, INFINITE)) {
			  case WAIT_OBJECT_0 + 1: {

				char cBuffer;
				DWORD dwBuffer;
				if (ReadFile(hConsole, &cBuffer, 1, &dwBuffer, 0)) {
					if (cBuffer == (char)255)
						Sleep(1000);
					else
						send(pParams->Socket, &cBuffer, 1, 0);
				}
				else
					return;
				break;
			  }

			  default:
				return;
			}
		}
	}
}
