///////////////////////////////////////////////////////////////////////////////
//
// Module:		telnet.cpp
//
// Contents:	telnet main program
//
// Product:		telnet
//
// Revisions:	02.Apr.1995	igor.milavec@uni-lj.si
//					Original code
//				25.Aug.1996	igor.milavec@l-sol.si
//					Added destination port selection
//
///////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "telnet.h"
#include "tnnet.h"
#include "tncon.h"
#include "tnerror.h"


// Structure to hold parsed command line parameters.
struct TelParams {
	char* szHost;
	short sPort;
};


void telSetConsoleTitle(TelParams& Parameters)
{
	char szTitle[128];
	wsprintf(szTitle, "Telnet - %s", Parameters.szHost);
	SetConsoleTitle(szTitle);
}


SOCKET telConnect(TelParams& Parameters)
{
	printm(0, FALSE, MSG_TRYING);

	SOCKET Socket = socket(AF_INET, SOCK_STREAM, 0);

	SOCKADDR_IN SockAddr;
	SockAddr.sin_port = htons(Parameters.sPort);
	SockAddr.sin_family = AF_INET;
	SockAddr.sin_addr.s_addr = inet_addr(Parameters.szHost);

	// Were we given host name?
	if (SockAddr.sin_addr.s_addr == INADDR_NONE) {

		// Resolve host name to IP address.
		hostent* pHostEnt = gethostbyname(Parameters.szHost);
		if (!pHostEnt)
			return INVALID_SOCKET;

		SockAddr.sin_addr.s_addr = *(DWORD*)pHostEnt->h_addr;
	}

	if (connect(Socket, (sockaddr*)&SockAddr, sizeof(SockAddr)))
		return INVALID_SOCKET;

	printm(0, FALSE, MSG_CONNECTED, Parameters.szHost);

	return Socket;
}


void telDisconnect(SOCKET Socket)
{
	closesocket(Socket);
}

short telGetPortNumber(char* pszPort)
{
	short sResult = atoi(pszPort);
	if (sResult)
		return sResult;

	servent* pseService = getservbyname(pszPort, 0);
	if (pseService)
		return ntohs(pseService->s_port);

	return 0;
}

BOOL telProcessParameters(TelParams& Parameters, int ArgC, char* ArgV[])
{
	if (ArgC < 2)
		return FALSE;

	Parameters.szHost = ArgV[1];
	Parameters.sPort = 23;

	// tel host port syntax
	if (ArgC >= 3)
		Parameters.sPort = telGetPortNumber(ArgV[2]);

	// tel host:port syntax
	char* pszPort = strchr(Parameters.szHost, ':');
	if (pszPort) {
		Parameters.sPort = telGetPortNumber(pszPort + 1);
		*pszPort = 0;
	}

	if (!Parameters.sPort)
		return FALSE;

	return TRUE;
}


int main(int ArgC, char* ArgV[])
{
	WSADATA WsaData;
	if (WSAStartup(MAKEWORD(1, 1), &WsaData)) {
		DWORD dwLastError = GetLastError();
		printm(0, FALSE, MSG_ERROR, "WSAStartup()");
		printm(0, TRUE, dwLastError);
		return 1;
	}

	TelParams Parameters;
	if (!telProcessParameters(Parameters, ArgC, ArgV)) {
		printm(0, FALSE, MSG_USAGE, ArgV[0]);
		return 1;
	}

	telSetConsoleTitle(Parameters);

	SOCKET Socket = telConnect(Parameters);
	if (Socket == INVALID_SOCKET) {
		printm(0, FALSE, 0xC0000000 + GetLastError());
		return 2;
	}

	TelThreadParams ThreadParams = {Socket, CreateEvent(0, TRUE, FALSE, 0)};

	DWORD idThread;
	HANDLE hThread = CreateThread(0, 0,
		(LPTHREAD_START_ROUTINE)telProcessNetwork,
		(LPVOID)&ThreadParams, 0, &idThread);
	if (hThread) {
		CloseHandle(hThread);
	}

	telProcessConsole(&ThreadParams);

	telDisconnect(Socket);

	WSACleanup();
	return 0;
}
