
ns_register_proc GET  /NS/DescribeTable DescribeTable

proc DescribeTable {conn ignore} {

    if {[ns_conn urlc $conn] != 3} {
	ns_returnerror $conn 500 "Missing table name"
	return
    }

    set table [lindex [ns_conn urlv $conn] 2]

    if {![ns_table exists $table]} {
	ns_returnerror $conn 500 "Table $table does not exist"
	return
    }

    set output "<HTML><HEAD><TITLE>Table Description</TITLE></HEAD><BODY>
<IMG SRC=\"[ns_info location]/NS/Asset/naviserv.gif\"><H3>Table $table:</H3><BR>\n"

    set size [ns_column count $table]

    for {set i 0} {$i < $size} {incr i} {
	append output "<STRONG>[ns_column name $table $i]:</STRONG> [ns_column valuebyindex $table $i column_type]<BR>\n"
    }

    append output "</BODY></HTML>\n"

    ns_return $conn 200 text/html $output
}
