#ifndef NSTYPES_H
#define NSTYPES_H

/* $Id: nstypes.h,v 1.8 1995/05/20 23:19:26 jimbo Exp $ */

/*
 * NsdInfo - Information about the running server.
 */
typedef struct {
    char           *name;
    char           *version;
    int             uid;
    char           *host;
    int		    port;
    char           *location;
    char           *home;
    char           *pageroot;
    char	   *config;
    char           *directoryFile;
    char           *userMapdir;
    int		    foreground;
#ifdef WIN32
    char	   *serviceName;
#endif
} NsdInfo;

/*
 *   Ns_Sets structures.
 */
typedef struct {
	char *name;
	char *value;
} Ns_SetField;

typedef struct {
	char *name;
	int	size;
	int	maxSize;
	Ns_SetField *fields;
} Ns_Set;


/*
 *   Ns_DStrings structure.
 */
typedef struct {
    char           *string;
    int             length;
    int             spaceAvl;
    char            staticSpace[NS_DSTRING_STATIC_SIZE];
} Ns_DString;


/*
 *  NaviServer client connection types and structures.
 */
typedef void    (Ns_Callback) (void *context);
typedef enum {
    ReadOk,
    WriteOk,
    Exception
}               Ns_When;
typedef enum {
    AcceptingConnections,
    ReadingRequest,
    ReadingHeaders,
    ReadingContent,
    RunWait,
    WritingHeaders,
    WritingContent,
    FlushingOutput,
    Forked,
    Active,
    Idle
}               Ns_ConnState;
typedef struct {
    char           *line;
    char           *method;
    char           *protocol;
    char           *host;
    unsigned short  port;
    char           *url;
    char           *query;
    int             urlc;
    char          **urlv;
    double          version;
}               Ns_Request;
#ifndef NS_SOCKET
#define NS_SOCKET int
#endif
typedef struct Ns_Conn {
    struct Ns_Conn *next;
    Ns_Callback    *callback;
    Ns_When         when;
    time_t          waitTime;
    unsigned long   connId;
    Ns_Request     *request;
    char           *authData;
    char           *authUser;
    char           *authPasswd;
    int		    authCheck;
    char            peerAddr[16];
    Ns_Set         *headers;
    Ns_Set         *form;
    Ns_Set         *errors;
    int             returnStatus;
    unsigned int    returnLength;
    NS_SOCKET	    socket;
    Ns_DString      inputBuf;
    size_t          headerLength;
    char           *content;
    size_t          contentLength;
    char           *inputType;
    char           *outputType;
    Ns_DString      outputBuf;
    int             outputPending;
    size_t          bytesSent;
    Ns_ConnState    state;
    void           *context;
    unsigned int    returnHeaders:1;
    unsigned int    deadSocket:1;
} Ns_Conn;

typedef void   *Ns_OpContext;
typedef void    (Ns_OpProc) (Ns_OpContext context, Ns_Conn *conn);
typedef void    (Ns_OpDeleteProc) (Ns_OpContext context);
typedef void    *Ns_ProcHandle;
typedef void    (Ns_TraceProc) (void *context, Ns_Conn *conn);

/*
 * NaviServer log severity type.
 */
typedef enum {
    Notice, Warning, Error, Fatal, Bug
}               Ns_LogSeverity;


/*
 *  The NaviServer database structures.
 */ 
typedef struct {
    void           *connection;
    int             verbose;
    char            resultId[20];
    Ns_Set         *row;
    Ns_Set         *errors;
    void           *context;
    void           *alerts;
} Ns_DbHandle;

typedef struct {
    Ns_Set         *info;
    int             ncolumns;
    Ns_Set        **columns;
}               Ns_DbTableInfo;


typedef int     (Ns_CheckUrlProc) (char *method, char *url, char *authuser, char *authpasswd);

#endif		/* NSTYPES_H */
