/*
 * Write disk test program
 */

#include <stdio.h>

int disk_fd;  /* File descriptor for diskette */

#define Read_Write   2
#define start_block  2
#define end_block    250
#define ERROR        (-1)
#define BLKSIZE      512

main(argc, argv)
  int argc;
  char *argv[];
{
  long block_num;
  char block[BLKSIZE];
  long *block_ptr;
  int i;

  pflinit();
  if ((disk_fd = open(argv[1], Read_Write)) != ERROR)
  {
    for (block_num = start_block;  block_num < end_block;  block_num++)
    {
      block_ptr = block;
      for (i = 0;  i < BLKSIZE;  i += (sizeof (long)))
        *block_ptr++ = block_num;
      lseek(disk_fd, block_num*512L, 0);
      if (write(disk_fd, block, BLKSIZE) == ERROR)
      {
        fprintf(stderr, "Error writing block %ld: %d\n", block_num, errno);
      }
    }
  } else
  {
    fprintf(stderr, "Can''t open disk\n");
  }
}
