#include <stdio.h>

#define Read_Write        2   /* Read-Write File Mode */
#define Timer        0xE240L  /* MC146818 Time/Date */
#define ERROR            -1
#define LINESIZE         80

struct time_vector
       { int   year;
         int   month;
         int   day;
         int   day_of_week;
         int   hour;
         int   minute;
         int   second;
       };

struct TD_vector
       { char TD_Seconds;
         char TD_S_Alarm;
         char TD_Minutes;
         char TD_M_Alarm;
         char TD_Hours;
         char TD_H_Alarm;
         char TD_Day_of_week;
         char TD_Date;
         char TD_Month;
         char TD_Year;
         char TD_Reg_A;
         char TD_Reg_B;
         char TD_Reg_C;
         char TD_Reg_D;
       };
#define Set_Time       0x80   /* Set Time */
#define UIP_flag       0x80   /* Update in progress */
#define VDT_flag       0x80   /* Time/Date is Valid */
#define A_Control      0x10   /* Register A control setting */
#define B_Control      0x07   /* Register B control setting */

#define abort          exit(255)
#define Usage          "usage: ++ set_tod [+s]\n"

main(argc, argv)
  int argc;
  char *argv[];
{
  struct time_vector cur_time;
  int tod;
  char *param;

  if ((argc == 1) || (argc == 2))
  {
    if ((tod = open("/dev/tod", Read_Write)) == ERROR)
    {
      fprintf(stderr, "Can't open '/dev/tod' - aborted\n");
      abort;
    }
    if (argc == 2)
    { /* Validate format */
      param = argv[1];
      if ((*param++ != '+') || (*param++ != 's'))
      {
        fprintf(stderr, Usage);
        abort;
      }
    }
    if ((argc == 2) || (read_time(tod, &cur_time) == 0))
    {
      fetch_time(&cur_time);
      set_tod(tod, &cur_time);
    }
    set_time(&cur_time);
  } else
  {
    fprintf(stderr, Usage);
    abort;
  }
}

read_time(tod, cur_time)
  int tod;
  struct time_vector *cur_time;
{
  struct TD_vector TD_vec;
  if(lseek(tod, Timer, 0) != ERROR)
  {
    if(read(tod, &TD_vec, sizeof(struct TD_vector)) != ERROR)
    {
      if ((TD_vec.TD_Reg_D & VDT_flag) == VDT_flag)
      { /* Time is Valid - set up structure */
        cur_time->year =        TD_vec.TD_Year;
        cur_time->month =       TD_vec.TD_Month;
        cur_time->day =         TD_vec.TD_Date;
        cur_time->day_of_week = TD_vec.TD_Day_of_week;
        cur_time->hour =        TD_vec.TD_Hours;
        cur_time->minute =      TD_vec.TD_Minutes;
        cur_time->second =      TD_vec.TD_Seconds;
        return(1);
      } else
      {
        return(0);
      }
    }
  } else
  {
    fprintf(stderr, "Error seeking in '/dev/tod'\n");
    abort;
  }
}

fetch_time(cur_time)
  struct time_vector *cur_time;
{

  fprintf(stderr, "Enter current time:\n");
  cur_time->year        = get_int("Year",                     0, 99);
  cur_time->month       = get_int("Month",                    1, 12);
  cur_time->day         = get_int("Day",                      1, 31);
  cur_time->day_of_week = get_int("Day of week (Sunday = 1)", 1,  7);
  cur_time->hour        = get_int("Hour",                     0, 23);
  cur_time->minute      = get_int("Minute",                   0, 59);
  cur_time->second      = get_int("Second",                   0, 59);
}

get_int(prompt, min, max)
  char *prompt;
  int min, max;
{
  char inline[LINESIZE];
  char *fgets();
  int need_response = 0;
  int value;

  while (need_response == 0)
  {
    fprintf(stderr, "  %s? ", prompt);
    value = atoi(fgets(inline, LINESIZE, stdin));
    if ((value >= min) && (value <= max))
    {
      need_response = 1;
    } else
    {
      fprintf(stderr, "** Illegal value, must be in range %d..%d\n",
              min, max);
    }
  }
  return(value);
}

set_tod(tod, cur_time)
  int tod;
  struct time_vector *cur_time;
{
  struct TD_vector TD_vec;

  fprintf(stderr, "Setting current time\n");
  if (lseek(tod, Timer, 0) == ERROR)
  {
    fprintf(stderr, "Error seeking to TIMER\n");
    abort;
  }
  TD_vec.TD_Reg_B       = Set_Time;
  if (write(tod, &TD_vec, sizeof(struct TD_vector)) == ERROR)
  {
    fprintf(stderr, "Error turning on SET bit\n");
    abort;
  }
  TD_vec.TD_Year        = cur_time->year;
  TD_vec.TD_Month       = cur_time->month;
  TD_vec.TD_Date        = cur_time->day;
  TD_vec.TD_Day_of_week = cur_time->day_of_week;
  TD_vec.TD_Hours       = cur_time->hour;
  TD_vec.TD_Minutes     = cur_time->minute;
  TD_vec.TD_Seconds     = cur_time->second;
  TD_vec.TD_S_Alarm     = 0; /* Disable alarms */
  TD_vec.TD_M_Alarm     = 0;
  TD_vec.TD_H_Alarm     = 0;
  TD_vec.TD_Reg_A       = A_Control;
  TD_vec.TD_Reg_B       = B_Control;
  TD_vec.TD_Reg_C       = 0;
  TD_vec.TD_Reg_D       = 0;
  if (lseek(tod, Timer, 0) == ERROR)
  {
    fprintf(stderr, "Error seeking to TIMER\n");
    abort;
  }
  if (write(tod, &TD_vec, sizeof(struct TD_vector)) == ERROR)
  {
    fprintf(stderr, "Error writing new time (in MC146818)\n");
    abort;
  }
}

set_time(cur_time)
  struct time_vector *cur_time;
{
  char date_cmd[255];

  sprintf(date_cmd, "date %d-%d-%d %d:%d:%d",
                    cur_time->month,
                    cur_time->day,
                    cur_time->year,
                    cur_time->hour,
                    cur_time->minute,
                    cur_time->second);
  system(date_cmd);
}
