 ttl UniFLEX Disk Format Program
 sttl Get Disk Characteristics (interactively)
 opt nol
 lib sysdef
 lib DNT
 opt lis
 pag
 text
*
* getparams
*
* Prompt the user for the entire set of parameters
* for the disk being formatted.  This happens if
* the "+P" option was specified or if an invalid
* model name was given on the command line.
*
 global getparams
getparams pshs d,x,y,u save registers
 tst Get_parms need to get parameters?
 beq 99f no - exit
 ldx #X_parms yes - set up a fake DNT entry
 stx diskindex
 ldd #$FF00 set up for configurable Winchester
 std disktype
 ldy #Get_pm0 get number of cylinders
 jsr Get_int
 std DNTcyl,x
 ldy #Get_pm1 get number of heads
 jsr Get_int
 std DNTheads,x
 ldy #Get_pm2 reduced write cylinder
 jsr Get_int
 std DNTbrw,x
 ldy #Get_pm3 write precomp cylinder
 jsr Get_int
 std DNTbwp,x
 jsr Get_srt get seek rate specification
 tfr b,a set up seek rate
 anda #$0F
 sta DNTtype+1,x
 andb #$F0 set up imbedded servo indicator
 stb DNTtype+2,x
99 puls d,x,y,u,pc return
*
 data
X_parms fcc 'Unknown?'
 fdb 0 Cylinders
 fdb 0 Heads
 fdb 17 Sectors/Track
 fdb 0 Begin Reduced Write
 fdb 0 Begin Write Precomp
 fcb $FF Disk type
 fcb 0 Seek rate
 fcb 0 Imbedded Servo Indicator
 fcb 0 ** spare **
 fdb 0 Additional space required

Get_pm0 fcc 'Number of Cylinders? ',0
Get_pm1 fcc 'Number of Heads? ',0
Get_pm2 fcc 'Cylinder to Begin Reduced Write? ',0
Get_pm3 fcc 'Cylinder to Begin Write Precompensation? ',0
*
 text

*
* Get_int
*
* Prompt the user and read a decimal integer from the
* terminal.
*    (Y) - Prompt string
*    jsr Get_int
*    (D) - Value
* If an illegal value is entered, the prompt is re-issued.
*
Get_int pshs x,y,u save registers
00 lbsr prt_msg print message (in Y)
 ldd #2
 sys ind,Get_ir read response
 bcs 00b re-do on any error
 cmpd #1 also on no data entered
 bls 00b
 ldx #Get_irb scan buffer
35 lda ,x skip over any leading spaces
 cmpa #'
 bne 40f
 leax 1,x
 bra 35b
40 ldd #0
 pshs d save temp result
50 ldb ,x+ get next character
 cmpb #$0D end of number?
 beq 70f yes - exit
 cmpb #'0 check for legal digit
 blo 60f jump if not legal
 cmpb #'9
 bhi 60f
 andb #$0F strip ascii junk
 clra set up 16 bit value
 pshs d save value
 ldd 2,s compute Val := Val * 10 + Digit
 lslb
 rola
 pshs d
 lslb
 rola
 lslb
 rola
 addd ,s++
 addd ,s++
 std 0,s replace new value
 bra 50b
60 leas 2,s clean up stack
 ldd #2 -- Illegal number, try again
 sys ind,Get_ie
 bra 00b do it all again
70 puls d get computed value
99 puls x,y,u,pc
*
 data
Get_ir fcb read ** for reading response **
 fdb Get_irb
 fdb 80
Get_irb rzb 80 response buffer
*
Get_ie fcb write
 fdb Get_iem,Get_ies
Get_iem fcc '-- Illegal decimal number, try again',$d
Get_ies equ *-Get_iem
 text

*
* Get_srt - Obtain the "seek rate" value for the drive
*   jsr Get_srt
*   (B) - Seek Rate value
*
Get_srt pshs x,y,u save registers
 ldy #Get_sm0 Print stepping rate table
 bsr prt_msg
00 ldy #Get_sm1 seek rate
 jsr Get_int
 cmpd #9 legal response?
 ble 10f yes - jump
 ldy #Get_sm2 illegal response!
 bsr prt_msg
 bra 00b
10 jsr get_YN check for buffered seeks
 fdb Get_sm3
 fdb 0
 bne 99f jump if no
 orb #$10 set imbedded servo bit
99 puls x,y,u,pc return
*
 data
*
Get_sm0 fcc 'Drive Seek (stepping) rate/type?'
 fcc $d,' 0 -   3 ms, unbuffered'
 fcc $d,' 1 -  ST 506 compatible'
 fcc $d,' 2 -  Tandon fast step'
 fcc $d,' 3 -  Texas Instruments fast step'
 fcc $d,' 4 - 200 us, buffered'
 fcc $d,' 5 -  70 us, buffered'
 fcc $d,' 6 -  30 us, buffered'
 fcc $d,' 7 -  15 us, buffered'
 fcc $d,' 8 -  Olivetti 561 (2 ms)'
 fcc $d,' 9 -  Olivetti 562 (1.1 ms)'
 fcb 0
Get_sm1 fcc $d,$d,'Stepping Rate? ',0
Get_sm2 fcc 'Illegal stepping rate - please chose from table above',0
Get_sm3 fcb write
 fdb 00f,01f-00f
00 fcc 'Does drive have "imbedded servo information" (y/n)? '
01
 text

*
* prt_msg - Print a message
*   Y - Message address, null terminated
*   jsr prt_msg
*
prt_msg pshs d,x,y,u save registers
 sty Get_iwa set up write block
 ldd #0
10 tst ,y+ find end of string
 beq 20f
 addd #1 bump counter
 bra 10b
20 std Get_iws set up size string
30 ldd #2 read/write from terminal
 sys ind,Get_iw print prompt
99 puls d,x,y,u,pc return
*
 data
Get_iw fcb write ** for writing prompt **
Get_iwa fdb 0 ** Prompt address **
Get_iws fdb 0 ** Prompt size **
*
