/*=========================================================================

	ATOC trigraph module

=========================================================================*/

#include <stdio.h>
#include "atoc.h"


/*-------------------------------------------------------------------------
trigraph( s ) replaces any trigraphs with their standard equivalents.
-------------------------------------------------------------------------*/
trigraph( s )
char *s;
{
	static struct {			/* trigraph table */
		char *tg;		/* trigraph sequence */
		char *std;		/* standard character */
	} table[] = {
		{ "??=", "#" },
		{ "??(", "[" },
		{ "??/", "\\" },
		{ "??)", "]" },
		{ "??'", "^" },
		{ "??<", "{" },
		{ "??!", "|" },
		{ "??>", "}" },
		{ "??-", "~" },
		{ NULL, NULL },
	};
	char *cp, *strstr();
	int i;

	if ( trigraphflag )
		for ( cp = s; ( cp = strstr( cp, "??" ) ) != NULL; ++cp )
			for ( i = 0; table[ i ].tg; ++i )
				if ( strncmp( cp, table[ i ].tg, 3 ) == 0 )
				{
					strcpy( cp, cp + 3 );
					strins( cp, table[ i ].std );
					break;
				}
}
/*=======================================================================*/
