/*=========================================================================

	ATOC standard macro module

=========================================================================*/

#include <stdio.h>
#include "atoc.h"


/*-------------------------------------------------------------------------
stdmacro( s ) replaces any variable standard macros.
-------------------------------------------------------------------------*/
stdmacro( s )
char *s;
{
	char *cp, temp[ 80 ], *strstr();

	if ( ( cp = strstr( s, "__FILE__" ) ) != NULL )
	{
		strcpy( cp, cp + 8 );
		strcpy( temp, "\"" );
		strcat( temp, filename );
		strcat( temp, "\"" );
		strins( cp, temp );
	}

	if ( ( cp = strstr( s, "__LINE__" ) ) != NULL )
	{
		strcpy( cp, cp + 8 );
		sprintf( temp, "%d", linenumber );
		strins( cp, temp );
	}

	if ( ( cp = strstr( s, "__DATE__" ) ) != NULL )
	{
		strcpy( cp, cp + 8 );
		strcpy( temp, "\"" );
		strcat( temp, compiledate );
		strcat( temp, "\"" );
		strins( cp, temp );
	}

	if ( ( cp = strstr( s, "__TIME__" ) ) != NULL )
	{
		strcpy( cp, cp + 8 );
		strcpy( temp, "\"" );
		strcat( temp, compiletime );
		strcat( temp, "\"" );
		strins( cp, temp );
	}
}
/*=======================================================================*/
