/*=========================================================================

	ATOC main module

=========================================================================*/

#define MAIN_MODULE
#include <stdio.h>
#include <time.h>
#include "atoc.h"


/*-------------------------------------------------------------------------
main program
-------------------------------------------------------------------------*/
main( argc, argv )
int argc;
char *argv[];
{
	FILE *fi, *fo;
	int i, j;

	printf( "ATOC %s, by Mike Rejsa\n", VERSION );
	exitcode = 0;

	options( &argc, argv );
	if ( argc >= 2 && argc <= 3 )
	{
		if ( ( fi = fopen( argv[ 1 ], "r" ) ) != NULL )
		{
			if ( argc == 3 )
				fo = fopen( argv[ 2 ], "w" );
			else fo = stdout;
			if ( fo != NULL )
			{
				get_filename( argv[ 1 ] );
				get_timedate();
				fprintf( fo, "/* ANSI to K&R translation by ATOC %s, by Mike Rejsa */\n", VERSION );
				atoc( fi, fo );
				if ( argc == 3 )
				{
					fclose( fo );
					if ( exitcode != 0 )
						unlink( argv[ 2 ] );
				}
			}
			else
			{
				if ( argc == 3 )
					printf( "Can't open file \"%s\"\n", argv[ 2 ] );
				else printf( "stdout == NULL!\n" ); /* exercise in futility... */
				exitcode = 1;
			}
			fclose( fi );
		}
		else
		{
			printf( "Can't open file \"%s\"\n", argv[ 1 ] );
			exitcode = 1;
		}
	}
	else
	{
		printf( "ANSI C to K&R C translator\n" );
		printf( "Usage: ATOC [-e] [-i] [-il] [-v] infile [ outfile ]\n" );
		printf( "         -e   Don't convert enumerations\n" );
		printf( "         -i   Include #include files inline\n" );
		printf( "         -il  Only include \"local\" #include files inline\n" );
		printf( "         -t   Don't convert trigraphs\n" );
		printf( "         -v   Don't convert voids\n" );
		exitcode = 1;
	}

	exit( exitcode );
}
/*-------------------------------------------------------------------------
get_filename( s ) extracts the base filename from s and puts it into
filename[] as a quoted string.
-------------------------------------------------------------------------*/
PRIVATE get_filename( s )
char *s;
{
	char *cp, *strchr(), *strrchr();

	if ( ( cp = strrchr( s, '\\' ) ) != NULL )
		++cp;
	else if ( ( cp = strchr( s, ':' ) ) != NULL )
		++cp;
	else cp = s;
	strcpy( filename, cp );
}
/*-------------------------------------------------------------------------
get_timedate() sets global compile time and date strings.
-------------------------------------------------------------------------*/
PRIVATE get_timedate()
{
	long int t;
	struct tm *ts;
	static char *mname[] = {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
		NULL
	};

	time( &t );
	ts = localtime( &t );
	sprintf( compiledate, "%s %02d %04d",
	  mname[ ts->tm_mon ], ts->tm_mday, ts->tm_year + 1900 );
	sprintf( compiletime, "%02d:%02d:%02d",
	  ts->tm_hour, ts->tm_min, ts->tm_sec );
}
/*-------------------------------------------------------------------------
options( argc, argv ) handles command line options.
-------------------------------------------------------------------------*/
PRIVATE options( argc, argv )
int *argc;
char *argv[];
{
	int x;

	enumflag = TRUE;
	includeflag = FALSE;
	localonlyflag = FALSE;
	trigraphflag = TRUE;
	voidflag = TRUE;
	for ( x = 1; x < *argc; )
		if ( argv[ x ][ 0 ] == '-' )
			switch( tolower( argv[ x ][ 1 ] ) )
			{
				case 'e':
					enumflag = FALSE;
					rmarg( argc, argv, x );
					break;
				case 'i':
					includeflag = TRUE;
					if ( tolower( argv[ x ][ 2 ] ) == 'l' )
						localonlyflag = TRUE;
					rmarg( argc, argv, x );
					break;
				case 't':
					trigraphflag = FALSE;
					rmarg( argc, argv, x );
					break;
				case 'v':
					voidflag = FALSE;
					rmarg( argc, argv, x );
					break;
				default:
					++x;
					break;
			}
		else ++x;
}
/*-------------------------------------------------------------------------
rmarg( argc, argv, x ) removes an argument from the argument list.
-------------------------------------------------------------------------*/
PRIVATE rmarg( argc, argv, x )
int *argc;
char *argv[];
int x;
{
	for ( ; x < *argc; ++x )
		argv[ x ] = argv[ x + 1 ];
	--*argc;
}
/*=======================================================================*/
