/*=========================================================================

	ATOC labels module

=========================================================================*/

#include <stdio.h>
#include <ctype.h>
#include "atoc.h"


/*-------------------------------------------------------------------------
labels( s ) searches for goto labels, and makes sure they carry a statement
on the same line.
-------------------------------------------------------------------------*/
labels( s )
char *s;
{
	char *cp, *strchr();

	if ( strchr( s, ':' ) != NULL )
	{
		/* find first non-whitespace character on line */
		for ( cp = s; *cp && isspace( *cp ); ++cp )
			;
		if ( isid( *cp ) )
			if ( strncmp( cp, "default", 7 ) != 0 )
			{
				/* bypass possible label */
				for ( ; *cp && isid( *cp ); ++cp )
					;
				/* bypass possible whitespace after label */
				for ( ; *cp && isspace( *cp ); ++cp )
					;
				/* MUST be colon - can't be another identifier, etc. */
				if ( *cp == ':' )
				{
					for ( ++cp; *cp; ++cp )
						if ( ! isspace( *cp ) )
							return;
					strcat( s, " ;" ); /* make null statement */
				}
			}
	}
}
/*=======================================================================*/
