/*=========================================================================

	ATOC keywords module

=========================================================================*/

#include <stdio.h>
#include <ctype.h>
#include "atoc.h"


/*-------------------------------------------------------------------------
keywords( fo, s ) handles ANSI keywords that do not exist in K&R C.
-------------------------------------------------------------------------*/
keywords( fo, s )
FILE *fo;
char *s;
{
	char *cp, *ep, *strstr();

	/* remove const keyword */
	for ( cp = s; ( cp = strstr( cp, "const" ) ) != NULL; ++cp )
		if ( cp == s || ! isid( *( cp - 1 ) ) )
			if ( ! isid( *( cp + 5 ) ) )
			{
				for ( ep = cp + 5; *ep; ++ep )
					if ( ! isspace( *ep ) )
						break;
				strcpy( cp, ep );
			}

	/* translate enums into defines and ints */
	if ( enumflag )
		for ( cp = s; ( cp = strstr( cp, "enum" ) ) != NULL; ++cp )
			if ( cp == s || ! isid( *( cp - 1 ) ) )
				if ( ! isid( *( cp + 4 ) ) )
					enumeration( fo, s );

	/* remove signed keyword */
	for ( cp = s; ( cp = strstr( cp, "signed" ) ) != NULL; ++cp )
		if ( cp == s || ! isid( *( cp - 1 ) ) )
			if ( ! isid( *( cp + 6 ) ) )
			{
				for ( ep = cp + 6; *ep; ++ep )
					if ( ! isspace( *ep ) )
						break;
				strcpy( cp, ep );
			}


	/* translate void into int */
	for ( cp = s; ( cp = strstr( cp, "void" ) ) != NULL; ++cp )
		if ( cp == s || ! isid( *( cp - 1 ) ) )
			if ( ! isid( *( cp + 4 ) ) )
			{
				if ( fplist( s, cp ) )			/* if func parm list */
					strcpy( cp, cp + 4 );		/* always remove */
				else if ( voidflag )			/* else if altering void */
				{
					strcpy( cp, cp + 4 );		/* remove */
					strins( cp, "int" );		/* replace with "int" */
				}
			}

	/* remove volatile keyword */
	for ( cp = s; ( cp = strstr( cp, "volatile" ) ) != NULL; ++cp )
		if ( cp == s || ! isid( *( cp - 1 ) ) )
			if ( ! isid( *( cp + 8 ) ) )
			{
				for ( ep = cp + 8; *ep; ++ep )
					if ( ! isspace( *ep ) )
						break;
				strcpy( cp, ep );
			}
}
/*-------------------------------------------------------------------------
enumeration( s ) translates enumeration variables into #defines and ints.
-------------------------------------------------------------------------*/
PRIVATE enumeration( fo, s )
FILE *fo;
char *s;
{
	char *ekw, *end, *mem, *memend, *var;
	char *p, *p2, name[ 80 ], *strchr(), *strstr();
	int n;

	/* find "enum" keyword */
	ekw = strstr( s, "enum" );

	/* find equal sign, semicolon, or end of line */
	/* (ignore equal signs within member list, tho...) */
	for ( end = ekw + 5; *end; ++end )
		if ( *end == '{' )
		{
			/* member list, bypass it */
			for ( ++end; *end; ++end )
				if ( *end == '}' )
					break;
			if ( *end == '\0' )
			{
				/* we only handle one-liner's */
				warning( "Multi-line enum not converted" );
				return;
			}
		}
		else if ( *end == '=' )
			break;
		else if ( *end == ';' )
			break;

	/* find any list of member definitions */
	for ( mem = ekw + 5; mem < end; ++mem )
		if ( *mem == '{' )
			break;
	if ( mem < end )
	{
		for ( memend = mem + 1; memend < end; ++memend )
			if ( *memend == '}' )
				break;
		if ( memend >= end )
		{
			/* we only handle one-liner's */
			warning( "Multi-line enum not converted" );
			return;
		}
	}
	else mem = memend = NULL;

	/* output any member names as #defines */
	if ( mem && memend )
	{
		for ( p = mem + 1, n = 0; p < memend; ++n )
		{
			/* bypass spaces */
			while ( p < memend && ! isid( *p ) )
				++p;
			if ( p < memend )
			{
				/* get enum member name into name[] */
				for ( p2 = name; p < memend && isid( *p ); )
					*p2++ = *p++;
				*p2 = '\0';
				/* position to end of name, handle '=' if found */
				for ( ; p < memend && *p != ','; ++p )
					if ( *p == '=' )
					{
						++p;
						while ( p < memend && isspace( *p ) )
							++p;
						if ( isdigit( *p ) )
							n = atoi( p );
					}
				if ( p < memend )
					++p;
				/* output as #define */
				fprintf( fo, "#define %s %d\n", name, n );
			}
		}
	}

	/* find any variable or typedef name */
	if ( memend )
	{
		/* comes right after member list */
		var = memend + 1;
	}
	else
	{
		/* bypass tag (should be there if no member list) */
		var = ekw + 5;
		/* bypass spaces */
		while ( var < end && ! isid( *var ) )
			++var;
		/* bypass tag */
		while ( var < end && isid( *var ) )
			++var;
	}
	/* bypass spaces before variable or typedef name */
	while ( var < end && ! isid( *var ) )
		++var;

	/* if variable or typedef name, make "enum [tag]" into "int" */
	if ( var < end )
	{
		strcpy( ekw, "int " );
		strcat( s, var );
	}
	/* else clear out line */
	else *s = '\0';
}
/*-------------------------------------------------------------------------
fplist( s, v ) looks to see if the "void" at v is a void function parameter
list. If so, return TRUE, else FALSE.
-------------------------------------------------------------------------*/
PRIVATE int fplist( s, v )
char *s, *v;
{
	char *pc, *sc;

	if ( v > s )
	{
		/* find first previous non-space char */
		for ( pc = v - 1; pc > s; --pc )
			if ( ! isspace( *pc ) )
				break;

		/* find first subsequent non-space char */
		for ( sc = v + 4; *sc; ++sc )
			if ( ! isspace( *sc ) )
				break;

		/* do we have empty parens? */
		/* this also detects (void)i - wrong but hopefully uncommon */
		if ( *pc == '(' && *sc == ')' )
			return( TRUE );
	}
	return( FALSE );
}
/*=======================================================================*/
