/*========================================================================

	ATOC getline() module

=========================================================================*/

#include <stdio.h>
#include "atoc.h"


/*-------------------------------------------------------------------------
getline( f, s ) gets a line from the file and puts it into s. \r\n is not
put into s. Returns TRUE if ok or FALSE if EOF.
-------------------------------------------------------------------------*/
int getline( f, s )
FILE *f;
char *s;
{
	char *cp;
	int c;

	cp = s;

	while ( ( c = getc( f ) ) != EOF )
		switch( c )
		{
			case '\r':
			case 0x1A:
				break;
			case '\n':
				*cp = '\0';
				return( TRUE );
			default:
				if ( cp < &s[ MAXLINELENGTH - 1 ] )
					*cp++ = c;
				break;
		}

	*cp = '\0';
	if ( cp > s )
		return( TRUE );
	else return( FALSE );
}
/*=======================================================================*/
