/*=========================================================================

	ATOC constants module

=========================================================================*/

#include <stdio.h>
#include <ctype.h>
#include "atoc.h"


/*-------------------------------------------------------------------------
constant( s ) removes or modifies certain ANSI constants that do not exist
in K&R C.
-------------------------------------------------------------------------*/
constant( s )
char *s;
{
	char *cp, temp[ 8 ], *strstr();
	int v, value;

	for ( cp = s; ( cp = strstr( cp, "\\?" ) ) != NULL; ++cp )
	{
		*cp = '?';
		strcpy( cp + 1, cp + 2 );
	}

	for ( cp = s; ( cp = strstr( cp, "\\x" ) ) != NULL; ++cp )
	{
		/* find value and number of places of hex constant */
		value = 0;
		if ( ( v = hexval( *( cp + 2 ) ) ) != -1 )
		{
			value = v;
			if ( ( v = hexval( *( cp + 3 ) ) ) != -1 )
			{
				value = value * 16 + v;
				v = 4;
			}
			else v = 3;
		}
		else v = 2;

		/* remove constant */
		strcpy( cp, cp + v );

		/* redo value as octal */
		temp[ 0 ] = '\\';
		temp[ 1 ] = ( value >> 6 & 0x03 ) + '0';
		temp[ 2 ] = ( value >> 3 & 0x07 ) + '0';
		temp[ 3 ] = ( value      & 0x07 ) + '0';
		temp[ 4 ] = '\0';
		strins( cp, temp );
	}

	for ( cp = s; ( cp = strstr( s, "\\a" ) ) != NULL; ++cp )
	{
		strcpy( cp, cp + 2 );
#ifdef ASCII
		strins( cp, "\\007" );
#endif
#ifdef EBCDIC
		strins( cp, "\\057" );
#endif
	}

	for ( cp = s; ( cp = strstr( s, "\\v" ) ) != NULL; ++cp )
	{
		strcpy( cp, cp + 2 );
#ifdef ASCII
		strins( cp, "\\013" );
#endif
#ifdef EBCDIC
		strins( cp, "\\013" );
#endif
	}
}
/*-------------------------------------------------------------------------
hexval( c ) returns the hex digit value of c, or -1 if it's not one.
-------------------------------------------------------------------------*/
PRIVATE int hexval( c )
char c;
{
	static char set[] = { "0123456789ABCDEF" };
	int i;

	c = toupper( c );
	for ( i = 0; set[ i ]; ++i )
		if ( c == set[ i ] )
			return( i );

	return( -1 );
}
/*=======================================================================*/
