/*=========================================================================

	ATOC automatic aggregates module

=========================================================================*/

#include <stdio.h>
#include <ctype.h>
#include "atoc.h"


/**/	/* this version assumes that white space on the left margin means */
/**/	/* you are inside a function. This may be adequate given the other */
/**/	/* parameters we search for. */
/**/	/* Also, it only knows about standard types - typedef'd objects */
/**/	/* are not recognized. */


/*-------------------------------------------------------------------------
autoaggregates( s ) handles initialized automatic aggregates by making
them static. This function is called after keywords(), so ANSI type
modifiers like const and volatile are removed already, and enums are
already converted to ints.
-------------------------------------------------------------------------*/
autoaggregates( s )
char *s;
{
	char *cp, *c1, *c2, *strchr();

	/* if inside a function */
	if ( isspace( s[ 0 ] ) )
	{
		/* find first non-space char */
		for ( cp = s; *cp; ++cp )
			if ( ! isspace( *cp ) )
				break;

		/* see if its a data type */
		if ( *cp && istype( cp ) )
		{
			/* see if its an aggregate */
			c1 = strchr( s, '[' );
			c2 = strchr( s, ']' );
			if ( ( c1 && c2 && c2 > c1 )
			  || strncmp( cp, "struct", 6 ) == 0
			  || strncmp( cp, "union", 5 ) == 0 )
			{
				/* see if its initialized */
				if ( strchr( s, '=' ) )
				{
					/* remove "auto" if there */
					if ( strncmp( cp, "auto", 4 ) == 0 )
						strcpy( cp, cp + 5 );
					/* make static */
					strins( cp, "static " );
				}
			}
		}
	}
}
/*-------------------------------------------------------------------------
istype( s ) returns TRUE if s is pointing at a recognized data type, or
FALSE if not. Note that certain keywords are omitted because in our current
context (looking for initialized automatic aggregates) they would not be
what we are looking for.

	Omitted		Reason
	--------	--------------------
	extern		Can't be fixed here
	register	Can't have a register aggregate
	static		Nothing to do - already static!
-------------------------------------------------------------------------*/
PRIVATE int istype( s )
char *s;
{
	static char *types[] = {
		"auto", "char", "double", "int", "float",
		"long", "short", "struct", "union", "unsigned",
		NULL
	};
	int i;

	for ( i = 0; types[ i ]; ++i )
		if ( strncmp( s, types[ i ], strlen( types[ i ] ) ) == 0 )
			return( TRUE );
	return( FALSE );
}
/*=======================================================================*/
