/*=========================================================================

	ATOC atoc module

=========================================================================*/

#include <stdio.h>
#include "atoc.h"


/*-------------------------------------------------------------------------
atoc( fi, fo ) is the top level atoc function.
-------------------------------------------------------------------------*/
atoc( fi, fo )
FILE *fi, *fo;
{
	decflag = FALSE;
	endifcount = 0;
	for ( linenumber = 1; getline( fi, buffer ); ++linenumber )
	{
		if ( strlen( buffer ) )
		{
			comment( buffer );
			preprocessor( fo, buffer );
			keywords( fo, buffer );
			autoaggregates( buffer ); /* must be after keywords() */
			labels( buffer );
			stdmacro( buffer );
			trigraph( buffer );
			constant( buffer ); /* must be after trigraph() */
			function( buffer ); /* must be after comment(), keywords() */
		}
		fprintf( fo, "%s\n", buffer );
		if ( decflag )
		{
			declarations( fo );
			decflag = FALSE;
		}
		if ( exitcode )
			return;
	}

	if ( ! endif_stack_empty() )
	{
		error( "Not enough #endif(s)" );
		exitcode = 1;
		return;
	}
}
/*=======================================================================*/
