/*
    Wn: A Server for the HTTP
    File: wn/cgi.c
    Version 1.14.1
    Version 1.14.4 / patches ::lev /
    
    Copyright (C) 1996  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "../config.h"
#include <stdio.h>
#include <string.h>
#include "wn.h"
#include "cgi.h"
#ifdef OS9
#include <errno.h>
#endif

extern char	*malloc();

#ifdef PATCH4
static void mymemcpy();
#endif

static CGI_data	*cgip = NULL;

static char	cgi_content_type[SMALLLEN];

/*
 * sendcgi( ip)  Open pipe from "ip->filepath" command
 * and send output using CGI standards
 */

void
sendcgi( ip)
Request	*ip;
{
#ifndef FORBID_CGI
	FILE	*fp;

	register char	*cp, *cp2, *cp3;
	int		n,
			m,
			fdfp,
			fdstdout;

	long	bytecount = 0;

	char	command[MIDLEN],
		location[MIDLEN],
		cgibuf[BUFFSIZE],
		buf[BIGLEN];

	exec_ok( ip);


	location[0] = '\0';
	*ip->length = '\0';  /* Don't send length of script!! */

	cgi_env( ip, FALSE);  /* Full CGI environment */

	mystrncpy( command, ip->filepath, MIDLEN);
	mystrncpy( buf, ip->filepath, MIDLEN);
	cp = strrchr( buf, '/');
	*cp = '\0';
	if ( chdir( buf) != 0  )
		logerr( "Can't chdir for exec to", buf);

	if ( (inheadp->method == POST) && (*inheadp->tmpfile != '\0')) {
#ifdef OS9
		strcat( command, "<");
#else
		strcat( command, " < ");
#endif
		strcat( command, inheadp->tmpfile);
	}

	if ( !*ip->query || (strchr( ip->query, '=') != NULL)) {
		/* '=' in query so don't use on command line */
		if ((fp = popen( command, "r")) == (FILE *) NULL ) {
			senderr( SERV_ERR, ERRMSG55, ip->filepath);
			unlink( inheadp->tmpfile);
			exit( 2);
		}
	} else { /* no '=' means its an isindex */
		www_unescape( ip->query, ' ');
		if ( (fp = safer_popen( ip->filepath, ip->query))
					== (FILE *) NULL )
			if ( (fp = popen( command, "r")) 
						== (FILE *) NULL ) {
				senderr( SERV_ERR, ERRMSG55, ip->filepath);
				unlink( inheadp->tmpfile);
				exit( 2);
			}
	}

	fdfp = fileno( fp);
	fdstdout = fileno( stdout);

	if ( ip->type == RTYPE_NPH_CGI) {  /* CGI handles headers */
		while ( (n = read( fdfp, cgibuf, BUFFSIZE )) > 0) {
			cp = cgibuf;
			while ( (m = write( fdstdout, cp, n)) < n) {
				if ( m <= 0) {
#ifdef OS9
					if(errno == ENOTCONN)  
						goto error;
#endif					
					logerr( ERRMSG75, "sendcgi");
					break;
				}
				bytecount += m;
				cp += m;
				n -= m;
			}
			bytecount += n;

			if ( bytecount >= CGI_BYTECHUNK) {
				alarm( TRANSACTION_TIMEOUT);
				bytecount = 0;
			}
		}
		if ( n < 0 )
			logerr( ERRMSG76, "");
#ifdef OS9
	error:
#endif	
			
		pclose( fp);
		writelog( ip, LOGMSG7, ip->filepath);
		unlink( inheadp->tmpfile);
		return;
	}

	/* It's a standard CGI, not an nph-CGI.  We do headers */

	if ( (n = read( fdfp, cgibuf, BUFFSIZE )) <= 0 ) {
		senderr( SERV_ERR, ERRMSG76, "");
		pclose( fp);
		wn_cleanup();
		exit( 2);
	}

	cp2 = cgibuf;

#ifdef OS9
#ifdef PATCH4
	while (TRUE) {
        if ( ( cp3 = strchr ( cp2, '\l')) == NULL) {
            /* not all headers have been read; read more */
            n -= (cp2 - cgibuf);
			mymemcpy ( cgibuf, cp2, n);
			m = read ( fdfp, cgibuf + n, BUFFSIZE - n );
			if ( m == 0 ) {
				senderr (SERV_ERR, ERRMSG104, "");
				pclose (fp);
				wn_cleanup();
				exit(2);
			}
			else
				n += m;
			cp2 = cgibuf;
			continue;
		}
#else
	while ( ( cp3 = strchr( cp2, '\l')) != NULL) {
#endif /* PATCH4 */
		if (cp3 > cgibuf && cp3[-1] == '\n')
#else
	while ( ( cp3 = strchr( cp2, '\n')) != NULL) {
		if (cp3 > cgibuf && cp3[-1] == '\r')
#endif
			cp3[-1] = '\0';
		*cp3++ = '\0';
		if ( *cp2 == '\0' ) { 	/* blank line: end of header */
			cp2 = cp3;
			n -= (cp2 - cgibuf);
			break;
		}

		if ( strncasecmp( "Content-type:", cp2, 13) == 0) {
			cp = cp2 + 13;
			while ( isspace( *cp))
				cp++;
			mystrncpy( cgi_content_type, cp, SMALLLEN);
			ip->content_type = cgi_content_type;
		}
		else if ( (strncasecmp("Location:", cp2, 9) == 0)) {
			cp = cp2 + 9;
			while ( isspace( *cp))
				cp++;
			mystrncpy( location, cp, MIDLEN);
		}
		else if ( (strncasecmp("Status:", cp2, 7) == 0)) {
			cp = cp2 + 7;
			while ( isspace( *cp))
				cp++;
			mystrncpy( outheadp->status, cp, SMALLLEN);
		}
		else if ( (strncasecmp("Expires:", cp2, 8) == 0)) {
			mystrncpy( outheadp->expires, cp, SMALLLEN - 2);
#ifdef OS9
			strcat( outheadp->expires, "\r\l");
#else
			strcat( outheadp->expires, "\r\n");
#endif
		}
		else {
			if ( strlen(cp2) + strlen(outheadp->list) < BIGLEN ) {
				strcat( outheadp->list, cp2);
#ifdef OS9
				strcat( outheadp->list, "\r\l");
#else
				strcat( outheadp->list, "\r\n");
#endif
			}
			else {
				senderr( SERV_ERR, ERRMSG56, "");
				unlink( inheadp->tmpfile);
				pclose( fp);
				exit( 2);
			}

		}
		cp2 = cp3;
	}

	if ( !*location) {

		http_prolog( );
#ifdef PATCH4
		while ( (m = write( fdstdout, cp2, n)) < n) {
			if ( m <= 0) {
				logerr( ERRMSG75, "sendcgi");
				break;
			}
			bytecount += m;
			cp2 += m;
			n -= m;
		}
#else
		if ( write( fdstdout, cp2, n ) != n)
			logerr( ERRMSG75, "");
#endif
		bytecount += n;

		while ( (n = read( fdfp, cgibuf, BUFFSIZE )) > 0) {
			cp = cgibuf;
		while ( (m = write( fdstdout, cp, n)) < n) {
				if ( m <= 0) {
#ifdef OS9
					if(errno == ENOTCONN) 
						goto error_h;
#endif						
					logerr( ERRMSG75, "sendcgi");
					break;
				}
				bytecount += m;
				cp += m;
				n -= m;
			}
			bytecount += n;

			if ( bytecount >= CGI_BYTECHUNK) {
				alarm( TRANSACTION_TIMEOUT);
				bytecount = 0;
			}
		}
		if ( n < 0 )
			logerr( ERRMSG76, "");
#ifdef OS9
	error_h:
#endif
		pclose( fp);
		writelog( ip, LOGMSG8, ip->filepath);
		unlink( inheadp->tmpfile);
		return;  /* to end of process_url */
	}
	else {
		writelog( ip, LOGMSG9, location);
		sprintf( ip->request, "CGI redirect to %s", location);
		dolocation( location, ip);
		pclose( fp);
		unlink( inheadp->tmpfile);
		return; /* to end of process_url */
	}
#endif
}

/*
 * cgi_env( ip, auth) Create environment variables required for CGI.
 * Also WN_ROOT and WN_DIR_PATH.  If auth = TRUE then only do a 
 * small subset of the variables for authentication.  Don't do
 * HTTP_AUTHORIZATION unless auth = TRUE.
 */

#ifdef PATCH4
static void
mymemcpy( p1, p2, n)
	char *p1, *p2;
	int n;
{
	while ( n > 0 ) {
		n--;
		*p1++ = *p2++;
	}
}
#endif

void
cgi_env( ip, auth)
Request	*ip;
int	auth;
{
	register char	*cp;

	if ( cgip == NULL) {
		if ((cgip = (CGI_data *) malloc(sizeof (CGI_data))) == NULL ) {
			senderr( SERV_ERR, ERRMSG55, ERRMSG64);
			exit(2);
		}
	}
	
	strcpy( cgip->method, "REQUEST_METHOD=");
	switch ( inheadp->method) {
	case GET:
		strcat( cgip->method, "GET");
		break;
	case POST:
		strcat( cgip->method, "POST");
		strcpy( cgip->postfile, "HTTP_POST_FILE=");
		mystrncat( cgip->postfile, inheadp->tmpfile, SMALLLEN);
		putenv( cgip->postfile);
		break;
	default:
		break;
	}
	putenv( cgip->method);

	strcpy( cgip->raddr, "REMOTE_ADDR=");
	mystrncat( cgip->raddr, remaddr, TINYLEN);
	putenv( cgip->raddr);

	strcpy( cgip->dirpath, "WN_DIR_PATH=");
	mystrncat( cgip->dirpath, ip->cachepath, SMALLLEN);
	if ( (cp = strrchr( cgip->dirpath, '/')) != NULL )
		*cp = '\0';
	putenv( cgip->dirpath);


	/* End of auth set of CGI variables */
	if ( auth)
		return;

	strcpy( cgip->dataroot, "WN_ROOT=");
	strcat( cgip->dataroot, ip->rootdir);
	putenv( cgip->dataroot);

	if ( !*remotehost )	/* Get remote hostname if not already done */
		get_remote_info( );

	strcpy( cgip->rhost, "REMOTE_HOST=");
	mystrncat( cgip->rhost, remotehost, MAXHOSTNAMELEN);
	putenv( cgip->rhost);

	if ( *(ip->query)) {
		strcpy( cgip->query, "QUERY_STRING=");
		mystrncat( cgip->query, ip->query, MIDLEN);
		putenv( cgip->query);
	}

	strcpy( cgip->serv_protocol, "SERVER_PROTOCOL=");
	switch ( inheadp->protocol) {
	case HTTP0_9:
		strcat(cgip->serv_protocol, "HTTP/0.9");
		break;
	case HTTP1_0:
		strcat( cgip->serv_protocol, "HTTP/1.0");
		break;
	}

	putenv( cgip->serv_protocol);

	if ( *(ip->pathinfo) ) {
		strcpy( cgip->pathinfo, "PATH_INFO=");
		mystrncat( cgip->pathinfo, ip->pathinfo, MIDLEN);
		putenv( cgip->pathinfo);
	}

	strcpy( cgip->tpath, "PATH_TRANSLATED=");
	strcat( cgip->tpath, ip->rootdir);
	mystrncat( cgip->tpath,	ip->pathinfo, MIDLEN);
	putenv( cgip->tpath);

	strcpy( cgip->scrname, "SCRIPT_NAME=");
	cp = ip->filepath + strlen( ip->rootdir);
	mystrncat( cgip->scrname, cp, MIDLEN);
	putenv( cgip->scrname);

	strcpy( cgip->lochost, "SERVER_NAME=");
	strcat( cgip->lochost, hostname);
	putenv( cgip->lochost);

	sprintf( cgip->lport,"SERVER_PORT=%d", port);
	putenv( cgip->lport);

	putenv("GATEWAY_INTERFACE=CGI/1.1");
	
	if ( *(inheadp->content) ) {
		strcpy( cgip->content, "CONTENT_TYPE=");
		mystrncat( cgip->content, inheadp->content, SMALLLEN);
		putenv( cgip->content);
	}

	if ( *(inheadp->length) ) {
		strcpy( cgip->length, "CONTENT_LENGTH=");
		mystrncat( cgip->length, inheadp->length, SMALLLEN);
		putenv( cgip->length);
	}

	if ( *(this_conp->authuser)) {
		strcpy( cgip->ruser, "REMOTE_USER=");
		mystrncat( cgip->ruser, this_conp->authuser, SMALLLEN);
		putenv( cgip->ruser);
	}

	strcpy( cgip->servsoft, "SERVER_SOFTWARE=");
	strcat( cgip->servsoft, VERSION);
	putenv( cgip->servsoft);

	if ( *(inheadp->accept) ) {
		strcpy( cgip->http_accept, "HTTP_ACCEPT=");
		mystrncat( cgip->http_accept, inheadp->accept, ACCEPTLEN);
		putenv( cgip->http_accept);
	}

	if ( *(inheadp->cookie) ) {
		strcpy( cgip->http_cookie, "HTTP_COOKIE=");
		mystrncat( cgip->http_cookie, inheadp->cookie, ACCEPTLEN);
		putenv( cgip->http_cookie);
	}

	if ( *(this_conp->rfc931name)) {
		strcpy( cgip->rident, "REMOTE_IDENT=");
		mystrncat( cgip->rident, this_conp->rfc931name, SMALLLEN);
		putenv( cgip->rident);
	}

	if ( *(inheadp->referrer) ) {
		strcpy( cgip->http_referrer, "HTTP_REFERER=");
		mystrncat( cgip->http_referrer, inheadp->referrer, MIDLEN);
		putenv( cgip->http_referrer);
	}
	if ( *(inheadp->ua) ) {
		strcpy( cgip->http_ua, "HTTP_USER_AGENT=");
		mystrncat( cgip->http_ua, inheadp->ua, SMALLLEN);
		putenv( cgip->http_ua);
	}

	if ( *(inheadp->from) ) {
		strcpy( cgip->http_from, "HTTP_FROM=");
		mystrncat( cgip->http_from, inheadp->from, SMALLLEN);
		putenv( cgip->http_from);
	}

	if ( *(inheadp->host_head) ) {
		strcpy( cgip->http_myhost, "HTTP_HOST=");
		mystrncat( cgip->http_myhost, inheadp->host_head, SMALLLEN);
		putenv( cgip->http_myhost);
	}
}


