/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  stat(), fstat()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

/*
 * Change History:
 *
 * 09/05/94 R.Wilcke, ESRF: 
 *          add "case" for DT_PIPE (treat similar to DT_RBF);
 *	    declare argument of getdtablesize() to void.
 * 10/05/94 R.Wilcke, ESRF: 
 *          add "case" for DT_SOCK (treat similar to DT_SCF);
 *	    add "default" to return buff->st_mode = 0 to mark unknown devices.
 */

/*
 
$Header: /h0/LIBS/OS9LIB/RCS/stat.c_v 2.0 92/05/31 23:49:13 jl Exp $
$Revision: 2.0 $
$Author: jl $
$Date: 92/05/31 23:49:13 $
$Source: /h0/LIBS/OS9LIB/RCS/stat.c_v $

*/

#define PATCHLEVEL 2

#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <stat.h>
#include <sgstat.h>
#include <sg_codes.h>

/*
 * f s t a t
 */
int fstat(int fd, struct stat *buff)
{

   struct fildes ftmp;
   struct tm ttmp;
   struct sgbuf fopt;

   if(_gs_opt(fd, &fopt) == ERROR)
      return ERROR;

   switch(fopt.sg_class) {

      case DT_RBF: 
      case DT_PIPE:   
         if(_gs_gfd(fd, &ftmp, sizeof(struct fildes)) == ERROR)
            return ERROR;

         ttmp.tm_year  = (int)ftmp.fd_date[0];
         ttmp.tm_mon   = (int)ftmp.fd_date[1] - 1;
         ttmp.tm_mday  = (int)ftmp.fd_date[2];   
         ttmp.tm_hour  = (int)ftmp.fd_date[3];
         ttmp.tm_min   = (int)ftmp.fd_date[4];
         ttmp.tm_sec   = 0;
         ttmp.tm_isdst = -1;

         buff->st_atime = buff->st_mtime = mktime(&ttmp);

         ttmp.tm_year  = (int)ftmp.fd_dcr[0];
         ttmp.tm_mon   = (int)ftmp.fd_dcr[1] - 1;
         ttmp.tm_mday  = (int)ftmp.fd_dcr[2];   
         ttmp.tm_hour  = ttmp.tm_min = ttmp.tm_sec = 0;
         ttmp.tm_isdst = -1;
  
         buff->st_ctime = mktime(&ttmp);

         memcpy((char *)&(buff->st_size), (char *)ftmp.fd_fsize, sizeof(long));

         buff->st_uid = ftmp.fd_own[1];
         buff->st_gid = ftmp.fd_own[0];

         buff->st_ino = fopt.sg_fdpsn;
         buff->st_dev = fopt.sg_dvt;

         buff->st_nlink = ftmp.fd_link;

         if(ftmp.fd_att & S_IFDIR)
            buff->st_mode = (unsigned char)ftmp.fd_att;
         else if(fopt.sg_class == DT_RBF)
            buff->st_mode = (unsigned char)ftmp.fd_att | S_IFREG;
         else
            buff->st_mode = (unsigned char)ftmp.fd_att | S_IFIFO;

         break;

      case DT_SCF:   
      case DT_SOCK:   
         buff->st_atime = buff->st_mtime = buff->st_ctime = 0;

         buff->st_size  = 1;
         buff->st_uid   = 0;
         buff->st_gid   = 0;

         buff->st_ino   = 0;
         buff->st_dev   = 0;

         buff->st_nlink = 0;

         if(fopt.sg_class == DT_SCF)
            buff->st_mode = (unsigned char)077 | S_IFCHR;
         else
            buff->st_mode = (unsigned char)077 | S_IFSOCK;

         break;

      default:   
         buff->st_mode = 0;
   }

   return(OK);
}

/*
 * s t a t
 */
 
int stat(char *filename, struct stat *buff)
{
   int i, ret;

   if ((i = open(filename, 0)) == ERROR)
      if ((i = open(filename, S_IFDIR)) == ERROR)
         return(ERROR);

   ret = fstat(i, buff);

   close(i);

   return(ret);
}

/*
 * g e t d t a b l e s i z e
 */
 
int getdtablesize(void)
{
   return(_NFILE);
}


