/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  popen(), xpopen(), pclose(), shell(), xshell()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

/*

$Header: /h0/LIBS/OS9LIB/RCS/popen.c_v 2.0 92/05/31 23:48:03 jl Exp $
$Revision: 2.0 $
$Author: jl $
$Date: 92/05/31 23:48:03 $
$Source: /h0/LIBS/OS9LIB/RCS/popen.c_v $

*/

/*
 * Change History:
 *
 * 06/06/94 R.Wilcke, ESRF: 
 *	    translate comments from German to English;
 *	    changed type of function pclose() from "unsigned int" to "int" to
 *	    correspond to POSIX.2
 */

#define PATCHLEVEL 2

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <modes.h>
#include <errno.h>

extern char **environ;

extern char *findmod(const char *, const char *);
extern int getargs(char *, char ***); 

struct pid_stat {
  int used;
  int pid;
  int status;
} ;

static int pids[_NFILE] = { 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0 };

int _popen_secure = 1;
int _shell_secure = 0;

/*
 * c h e c k _ s h e l l
 *
 * check for valid shells
 */

static char *check_shell(void)
{
   char *shell, *cp, *cp2, *cp3, val_shell[50];
  
   errno = E_FNA;

   if((shell = getenv("SHELL")) == NULL)
      return 0;
   errno = 0;
   return shell;
}

/* 
 * p o p e n
 */
FILE *popen(const char *name, const char *mode)
{
   int fd = 0,
       fd2, fdsav, pid;
   static char *argv[] = {NULL, NULL, NULL};
   char cmd[200];
   char cmd_path[200];
   char *cp;
   char *shell;
   
   if (_popen_secure)
      if(!(shell = check_shell()))
         return(NULL);

   cp = (char *)name;

   while(*cp == ' ')
      cp++;
      
   strcpy(cmd_path, (const char *) cp);

   if(cp = index(cmd_path, ' '))
      *cp++ = '\0';

#if 0      
   strcpy(cmd, "ex ");
#else
   strcpy(cmd, " ");
#endif   
   strcat(cmd, (char const *) findmod(cmd_path, cmd_path));

   if(cp) {
      strcat(cmd, " "); 
      strcat(cmd, cp);
   }

   argv[1] = cmd;

/*
 * mode can be "r" (stdout) or "w" (stdin)
 */
 
   switch(mode[0]) {
      case 'w':
         fd = 0;
         break;
      case 'r':
         fd = 1;
         break;
   }

   if(fd == 1)
      fflush(stdout);

   fdsav = dup(fd);   /* save value of path stdin or stdout */
   close(fd);         /* close stdin or stdout */
 
   creat("/pipe", S_IWRITE+S_IREAD);
#if 0
   argv[0] = findmod("shell", "SYSTEM.SHELL");
#endif
   argv[0] = shell;

   pid = os9exec(os9forkc, (char *)argv[0], (char **)argv, (char **)environ,
      0, 0, 3);

   fd2 = dup(fd);      /* duplicate 0 or 1 */
   close(fd);          /* close 0 or 1 */

   dup(fdsav);        /* restore old value for path 0 or 1 */
   close(fdsav);      /* remove path that saved the old value of stdin/stdout */

   if(pid > 0) {
      pids[fd2] = pid;
      return(fdopen(fd2, mode));
   } else {
      close(fd2);
      return NULL;
   }
}


/*
 * x p o p e n
 */

FILE *xpopen(char *name, char *mode)
{
   int fd = 0,
       fd2, fdsav, pid;
   char **argv;
   char cmd_name[200];
   
   if(_popen_secure)
      if(!check_shell())
         return NULL;

   strcpy(cmd_name, name);

   if(getargs(cmd_name, &argv) == -1)
      return NULL;

/*
 * mode can be "r" (stdout) or "w" (stdin)
 */
 
   switch(mode[0]) {
      case 'w':
         fd = 0;
         break;

      case 'r':
         fd = 1;
         break;
   }

   if(fd && fileno(stdout) == 1)
      fflush(stdout);

   fdsav = dup(fd);
   close(fd);

   creat("/pipe", S_IWRITE+S_IREAD);
   pid = os9exec((*os9forkc),
      (char *)findmod((const char *)argv[0], (const char *)argv[0]),
      argv, (char **)environ, (unsigned int)0, (short)0, (short)3);
   free((char *)argv);
   
   fd2 = dup(fd);
   close(fd);

   dup(fdsav);
   close(fdsav);

   if(pid > 0) {
      pids[fd2] = pid;
      return(fdopen(fd2, mode));
   } else {
      close(fd2);
      return(NULL);
   }
}

/*
 * p c l o s e
 */

int pclose(FILE *fp)
{
   unsigned int status;
   int pid, fd, i;

   fd = fileno(fp);

   if(pids[fd] == 0)
      return ERROR;

   fflush(fp);
   fclose(fp);

   while((pid = wait(&status)) != ERROR)
      if(pid == pids[fd])
         break;
      else
         for(i = 0; i < _NFILE; i++)
            if(pids[i] == pid) {
               pids[i] = 0;
               break;
            }

   if(pid == ERROR)
      status = ERROR;

   pids[fd] = 0;

   return(status);
}


/*
 * s h e l l 
 */

int shell(char *name)
{
   static char *argv[] = {NULL, NULL, NULL };
   char cmd[200], cmd_path[200];
   char *cp;
   int pid;
   unsigned int status;

   if(_shell_secure)
      if(!check_shell())
         return ERROR;

   cp = name;

   while(*cp == ' ')
      cp++;

   strcpy(cmd_path, cp);

   if(cp = index(cmd_path, ' '))
      *cp++ = '\0';

   strcpy(cmd, "ex ");
   strcat(cmd, findmod(cmd_path, cmd_path));

   if(cp) {
      strcat(cmd, " ");
      strcat(cmd, name+(cp-cmd_path));
   }

   argv[1] = cmd;

   argv[0] = findmod("shell", "SYSTEM.SHELL");
   if((pid = os9exec(os9forkc, argv[0], argv, environ, 0, 0, 3)) == ERROR)
      return(-1);


   while(wait(&status) != pid)
      ;
  
   if(status &= 0x0ffff) {
      errno = status;
      return ERROR;
   } else
      return OK;
}

/*
 * x s h e l l
 */
 
int xshell(char *name)
{
   register int pid;
   unsigned int status;
   char **argv;
   char cmd_name[256];

   if(_shell_secure)
      if(!check_shell())
         return ERROR;

   strcpy(cmd_name, name);
   if(getargs(cmd_name, &argv) == -1)
      return ERROR;

   if((pid = os9exec(os9forkc, findmod(argv[0], argv[0]), argv, environ, 
      0, 0, 3)) == ERROR) {
      free((char *) argv);
      return ERROR;
   }

   free((char *) argv);

   while(wait(&status) != pid) ;

   if(status &= 0x0ffff) {
      errno = status;
      return ERROR;
   } else
      return OK;
}
