/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  isatty(), isapipe()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

/*

$Header: /h0/LIBS/OS9LIB/RCS/isatty.c_v 2.1 92/08/04 00:14:29 jl Exp $
$Revision: 2.1 $
$Author: jl $
$Date: 92/08/04 00:14:29 $
$Source: /h0/LIBS/OS9LIB/RCS/isatty.c_v $

*/

#define PATCHLEVEL 3

#include <stdio.h>
#include <sgstat.h>
#include <sg_codes.h>

/*
 * i s w h a t
 */

static int iswhat( int path )
{
	struct sgbuf opt;

	if (_gs_opt(path, &opt) == ERROR)
		return ERROR;

	return(opt.sg_class);
}

/*
 * i s a t t y
 */
int isatty(int path)
{
	int t;
  
	if ((t = iswhat(path)) == ERROR)
		return FALSE;

	return(t == DT_SCF);
}


/*
 * i s a p i p e
 */

int isapipe( int path )
{
	int t;
  
	if ((t = iswhat(path)) == ERROR)
		return FALSE;
	
	return(t == DT_PIPE);
}


