/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  getargs()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

/*

$Header: /h0/LIBS/OS9LIB/RCS/getargs.c_v 2.0 92/05/31 23:46:38 jl Exp $
$Revision: 2.0 $
$Author: jl $
$Date: 92/05/31 23:46:38 $
$Source: /h0/LIBS/OS9LIB/RCS/getargs.c_v $

*/

#define PATCHLEVEL 2

#include <stdio.h>
#include <stdlib.h>

#define sp _sp

/*
 * g e t a r g s
 */

int getargs(char *s, char ***args)
{
  	int  i;
	char *sp;
	char qchar;
	int  argsnum;
  
	i = 0;  argsnum = 40;

	if ((*args = (char **) malloc(argsnum * sizeof(char *))) == NULL)
	    return ERROR;

	while (TRUE) {
		if (i >= argsnum-1) {
			argsnum += 40;
			if ((*args = (char **) realloc((char *) *args, argsnum * sizeof(char *))) == NULL)
				return ERROR;
		}

		while (*s == ' ' || *s == '\t')
			++s;

		if (*s == '\n' || *s == '\0')
			break;

		(*args)[i++] = sp = s;
		qchar = 0;

		while (*s != '\0' && *s != '\n') {
			if (qchar == 0 && (*s == ' ' || *s == '\t')) {
				++s;
				break;
			}

			switch (*s) {
				case '"':
				case '\'':
					if (qchar == *s) {
						qchar = 0;
						++s;
						break;
					}

					if (qchar)
						*sp++ = *s++;
					else
						qchar = *s++;
					break;

				default:
					*sp++ = *s++;
					break;
			}
		}
		*sp++ = 0;
	}
	(*args)[i] = NULL;

	return(i);
}
