/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  _bootdrive(), ddfopen()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

/*

$Header: /h0/LIBS/OS9LIB/RCS/bootdrv.c_v 2.0 92/05/31 23:45:42 jl Exp $
$Revision: 2.0 $
$Author: jl $
$Date: 92/05/31 23:45:42 $
$Source: /h0/LIBS/OS9LIB/RCS/bootdrv.c_v $

*/

#define PATCHLEVEL 2

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <module.h>

/*
 * _ b o o t d r i v e
 */
 
char *_bootdrive( void )
{
	static char drv[33];
	short *init_mod;
	char  *drive;
	
	if ( (init_mod = (short *) modlink("init", mktypelang(MT_SYSTEM, ML_ANY))) < (short *) 0)
		return(NULL);

	if (drive = (char *) init_mod + *(init_mod + 0x20))
		strcpy(drv, drive);
	else {
		munlink((mod_exec *) init_mod);
		return(NULL);
	}

	munlink((mod_exec *) init_mod);
	return(drv);
}

/*
 * d d f o p e n
 */
 
FILE *ddfopen(const char *fn, char *fname, const char *mode, int boot)
{
	FILE *fp;
	const char *drv;

	if (!boot) {
		strcpy(fname, "/dd/");
		strcat(fname, fn);

		if (fp = fopen((const char *) fname, mode))
			return(fp);
	}

	if (drv = _bootdrive()) {
		strcpy(fname, drv);
		strcat(fname, "/");
		strcat(fname, fn);

		return(fopen((const char *) fname, mode));
	}

	return(NULL);

}
